/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.AttributeGroup;
import oracle.ide.net.URLPath;

public class Options {
    private URL _sourceDir;
    private boolean _generateAttrDefaultValues = false;
    private boolean _generateModelGroups = false;
    private String _classPath = null;
    private Set<String> _skipNSs = new HashSet<String>();
    private Set<String> _treatAsSimple = new HashSet<String>();
    private Map<String, String> _typeMapping = new HashMap<String, String>();
    private Map<String, Set<String>> _enumOverrides = new HashMap<String, Set<String>>();
    private Map<AttributeDef, AttributeGroup> _attrMap = null;

    public void reset() {
        this._skipNSs.clear();
        this._treatAsSimple.clear();
        this._typeMapping.clear();
        this._enumOverrides.clear();
        this._generateAttrDefaultValues = false;
        this._generateModelGroups = false;
        this._attrMap = null;
    }

    public void addSkipNamespace(String namespace) {
        this._skipNSs.add(namespace);
    }

    public void setSourceDirectory(URL sourceDir) {
        this._sourceDir = sourceDir;
    }

    public void setClassPath(String classPath) {
        this._classPath = classPath;
    }

    public void setGenerateAttrDefaultValues(boolean generateAttrDefaultValues) {
        this._generateAttrDefaultValues = generateAttrDefaultValues;
    }

    public void setGenerateModelGroups(boolean generateModelGroups) {
        this._generateModelGroups = generateModelGroups;
    }

    public void setAttributeGroupMap(Map<AttributeDef, AttributeGroup> attrMap) {
        this._attrMap = attrMap;
    }

    public URL getSourceDirectory() {
        return this._sourceDir;
    }

    public boolean skipNamespace(String namespace) {
        return this._skipNSs.contains(namespace);
    }

    public void addTreatAsSimple(String type) {
        this._treatAsSimple.add(type);
    }

    public boolean treatAsSimple(String type) {
        return this._treatAsSimple.contains(type);
    }

    public void addTypeMapping(String fromType, String toType) {
        this._typeMapping.put(fromType, toType);
    }

    public boolean isTypeMapping(String type) {
        return this._typeMapping.containsKey(type);
    }

    public String getTypeMapping(String fromType) {
        if (this._typeMapping.containsKey(fromType)) {
            return this._typeMapping.get(fromType);
        }
        return fromType;
    }

    public Map<AttributeDef, AttributeGroup> getAttributeGroupMap() {
        return this._attrMap;
    }

    public void addEnumOverride(String enumType, Set<String> values) {
        this._enumOverrides.put(enumType, values);
    }

    public boolean hasEnumOverride(String enumType) {
        return this._enumOverrides.containsKey(enumType);
    }

    public Set<String> getEnumOverride(String enumType) {
        return this._enumOverrides.get(enumType);
    }

    public URLPath getClassPath() {
        URLPath path = new URLPath();
        if (this._classPath != null) {
            path.add(URLPath.newURLPathFromString((String)this._classPath));
        }
        return path;
    }

    public boolean generateAttrDefaultValues() {
        return this._generateAttrDefaultValues;
    }

    public boolean generateModelGroups() {
        return this._generateModelGroups;
    }
}

