/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.beanmodel.apigeneration.NameUtil;
import oracle.bali.xml.beanmodel.apigeneration.Options;
import oracle.bali.xml.beanmodel.metadata.XmlBeanModelMetadataConstants;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.AttributeGroup;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;

public final class GenerationUtils {
    public static String getTypeName(Type type, Options options, MetadataEvaluator mdEvaluator) throws Exception {
        return GenerationUtils.getTypeName(type, "", "", options, mdEvaluator);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getTypeName(Type type, String name, String parentClass, Options options, MetadataEvaluator mdEvaluator) throws Exception {
        Object typeName = null;
        if (TypeUtils.isSimpleType((Type)type)) {
            SimpleType simpleType = (SimpleType)type;
            SimpleTypeInfo info = GenerationUtils.getSimpleTypeInfo(simpleType, name);
            String subClassParent = type.getName() == null ? parentClass : null;
            typeName = GenerationUtils.getSimpleTypeName(simpleType, info, subClassParent, mdEvaluator);
            return options.getTypeMapping((String)typeName);
        }
        typeName = type.getName();
        if (typeName == null) {
            if (parentClass != null) {
                typeName = parentClass + "." + GenerationUtils.getValidTypeName(name);
                if (!options.isTypeMapping((String)typeName)) return GenerationUtils.getValidTypeName(name);
                return options.getTypeMapping((String)typeName);
            }
            typeName = name;
        } else if (GenerationUtils.isGlobalAnyType(type)) {
            return "oracle.bali.xml.beanmodel.XmlBaseType";
        }
        typeName = GenerationUtils.getClassName(type.getTargetNamespace(), GenerationUtils.getValidTypeName((String)typeName), mdEvaluator);
        return options.getTypeMapping((String)typeName);
    }

    public static String getSimpleTypeName(SimpleType type, SimpleTypeInfo info, String parentClass, MetadataEvaluator mdEvaluator) throws Exception {
        switch (type.getVariety()) {
            case 1: {
                Object typeName = "java.util.List";
                String itemTypeName = info != null ? info.getFullyQualfiedName(parentClass, mdEvaluator) : GenerationUtils.getSimpleTypeName(type.getListItemType(), null, null, mdEvaluator);
                typeName = (String)typeName + "<" + itemTypeName + ">";
                return typeName;
            }
            case 2: {
                String unionTypeName = null;
                List memberTypes = type.getUnionMemberTypes();
                for (SimpleType memberType : memberTypes) {
                    String memberTypeName = GenerationUtils.getSimpleTypeName(memberType, info, parentClass, mdEvaluator);
                    if (unionTypeName == null) {
                        unionTypeName = memberTypeName;
                        continue;
                    }
                    if (unionTypeName.equals(memberTypeName)) continue;
                    return "java.lang.String";
                }
                if (unionTypeName == null) {
                    return "java.lang.String";
                }
                return unionTypeName;
            }
        }
        if (info != null) {
            return info.getFullyQualfiedName(parentClass, mdEvaluator);
        }
        Class clazz = JavaTypeManager.getInstance().getJavaClass(type);
        return clazz.getName();
    }

    public static String getEnumConstantName(Set<String> enumConstants, String name) {
        int i = 1;
        Object tempName = name;
        while (enumConstants.contains(tempName)) {
            tempName = name + i;
            ++i;
        }
        return tempName;
    }

    public static String getQuotedString(String value) {
        return "\"" + value + "\"";
    }

    public static String getMemberString(String value) {
        return "_" + value;
    }

    public static String getClassName(String packageName, String typeName) {
        return packageName + "." + typeName;
    }

    public static String getClassName(String ns, String typeName, MetadataEvaluator evaluator) {
        String packageName = GenerationUtils.getPackageFromNamespace(ns, evaluator);
        return GenerationUtils.getClassName(packageName, typeName);
    }

    public static String getPackageFromNamespace(String ns, MetadataEvaluator evaluator) {
        XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)ns);
        String ldn = (String)evaluator.getMetadataItem((Object)nsKey, (Object)XmlBeanModelMetadataConstants.GRAMMAR_PACKAGENAME, null);
        return ldn != null ? ldn : NameUtil.getPackageFromNamespace(ns);
    }

    public static String getBeanRegistryName(String ns, MetadataEvaluator evaluator) {
        XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)ns);
        String ldn = (String)evaluator.getMetadataItem((Object)nsKey, (Object)XmlBeanModelMetadataConstants.GRAMMAR_BEANREGISTORYNAME, null);
        return ldn != null ? ldn : "BeanRegistry";
    }

    public static URL getJavaFileUrl(URL sourceDir, String pkg, String tn) throws Exception {
        String url = sourceDir.toExternalForm();
        pkg = pkg.replace(".", "/");
        return new URL(url.concat("/" + pkg + "/" + tn + ".java"));
    }

    public static boolean isGlobalAnyType(Type type) {
        return "http://www.w3.org/2001/XMLSchema".equals(type.getTargetNamespace()) && "anyType".equals(type.getName());
    }

    public static Collection<ContentGroup> getGlobalGroups(Grammar grammar) {
        return grammar.getContentGroups();
    }

    public static Collection<AttributeGroup> getGlobalAttrGroups(Grammar grammar) {
        return grammar.getAttributeGroups();
    }

    public static Collection<Type> getGlobalTypes(Grammar grammar) {
        return grammar.getTypes();
    }

    public static Collection<ElementDef> getRootElementDefs(Grammar grammar) {
        return grammar.getElementDefs();
    }

    public static Collection<AttributeDef> getRootAttributeDefs(Grammar grammar) {
        return grammar.getAttributeDefs();
    }

    public static SimpleTypeInfo getSimpleTypeInfo(SimpleType type) throws Exception {
        return GenerationUtils.getSimpleTypeInfo(type, null);
    }

    public static SimpleTypeInfo getSimpleTypeInfo(SimpleType type, String anonTypeName) throws Exception {
        Object typeName;
        Object object = typeName = type.getName() == null ? anonTypeName : type.getName();
        if (typeName != null) {
            typeName = GenerationUtils.getValidTypeName((String)typeName);
        }
        String namespace = type.getTargetNamespace();
        switch (type.getVariety()) {
            case 1: {
                SimpleTypeInfo listTypeInfo = GenerationUtils.getSimpleTypeInfo(type.getListItemType());
                if (listTypeInfo == null) break;
                if (listTypeInfo.getName() != null) {
                    return listTypeInfo;
                }
                if (typeName != null) {
                    typeName = (String)typeName + "ItemEnum";
                }
                return new SimpleTypeInfo((String)typeName, namespace, listTypeInfo.getEnumValues(), "ItemEnum");
            }
            case 2: {
                HashSet<String> enumValues = new HashSet<String>();
                String suffix = null;
                List memberTypes = type.getUnionMemberTypes();
                for (SimpleType memberType : memberTypes) {
                    SimpleTypeInfo memberTypeInfo = GenerationUtils.getSimpleTypeInfo(memberType);
                    if (memberTypeInfo == null || memberTypeInfo.getName() != null) {
                        return null;
                    }
                    if (suffix == null) {
                        suffix = memberTypeInfo.getSuffix();
                    } else if (!suffix.equals(memberTypeInfo.getSuffix())) {
                        return null;
                    }
                    enumValues.addAll(memberTypeInfo.getEnumValues());
                }
                if (enumValues.isEmpty()) break;
                if (typeName != null) {
                    typeName = (String)typeName + suffix;
                }
                return new SimpleTypeInfo((String)typeName, namespace, enumValues, suffix);
            }
            default: {
                if (!AttributeValueUtils.containsEnumerations((SimpleType)type)) break;
                SimpleType baseType = type.getBuiltInBaseType();
                Class clazz = JavaTypeManager.getInstance().getJavaClass(baseType);
                if (!"java.lang.String".equals(clazz.getName())) break;
                if (typeName != null) {
                    typeName = (String)typeName + "Enum";
                }
                return new SimpleTypeInfo((String)typeName, namespace, AttributeValueUtils.getAttributeValues((SimpleType)type), "Enum");
            }
        }
        return null;
    }

    public static Collection<Particle> getParticlesForType(ComplexType complexType) {
        ArrayList<Particle> particles = new ArrayList<Particle>();
        Type baseType = complexType.getBaseType();
        if (complexType.getDerivationMethod() == 1 && !GenerationUtils.isGlobalAnyType(baseType)) {
            return particles;
        }
        Collection<Object> baseParticles = Collections.emptyList();
        if (TypeUtils.isComplexType((Type)baseType) && complexType.getDerivationMethod() == 0) {
            baseParticles = ((ComplexType)baseType).getContentGroup().getComponents();
        }
        ContentGroup contentGroup = complexType.getContentGroup();
        if (baseParticles.isEmpty()) {
            return Collections.singletonList(contentGroup);
        }
        Collection components = contentGroup.getComponents();
        for (Particle particle : components) {
            if (baseParticles.contains(particle) || !(particle instanceof ContentGroup)) continue;
            Collection subParticles = ((ContentGroup)particle).getComponents();
            for (Particle subParticle : subParticles) {
                if (baseParticles.contains(subParticle)) continue;
                particles.add(subParticle);
            }
        }
        return particles;
    }

    public static Collection<AttributeDef> getAttributeDefsForType(ComplexType complexType) {
        ArrayList<AttributeDef> attributes = new ArrayList<AttributeDef>();
        Type baseType = complexType.getBaseType();
        if (complexType.getDerivationMethod() == 1 && !GenerationUtils.isGlobalAnyType(baseType)) {
            return attributes;
        }
        Collection<Object> baseAttributeDefs = Collections.emptyList();
        if (TypeUtils.isComplexType((Type)baseType) && complexType.getDerivationMethod() == 0) {
            baseAttributeDefs = ((ComplexType)baseType).getAttributeDefs();
        }
        Collection attributeDefs = complexType.getAttributeDefs();
        for (AttributeDef attribute : attributeDefs) {
            if (baseAttributeDefs.contains(attribute)) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public static String getValidIdentifierName(String name) {
        name = NameUtil.lowerCamelCase(name);
        name = NameUtil.nonJavaKeyword(name);
        return name;
    }

    public static String getValidTypeName(String name) {
        name = NameUtil.upperCamelCase(name);
        name = NameUtil.nonJavaCommonClassName(name);
        return name;
    }

    public static String getValidMethodName(String name) {
        if ((name = NameUtil.upperCamelCase(name)).equals("Class")) {
            name = "Clazz";
        }
        return name;
    }

    public static class SimpleTypeInfo {
        private final String _name;
        private final String _namespace;
        private final String _suffix;
        private final Set<String> _enumValues;

        public SimpleTypeInfo(String name, String namespace, Set<String> enumValues, String suffix) {
            this._name = name;
            this._namespace = namespace;
            this._enumValues = enumValues;
            this._suffix = suffix;
        }

        public String getName() {
            return this._name;
        }

        public String getFullyQualfiedName(String parentClass, MetadataEvaluator evaluator) {
            if (parentClass != null) {
                return parentClass + "." + this._name;
            }
            return GenerationUtils.getClassName(this._namespace, this._name, evaluator);
        }

        public String getSuffix() {
            return this._suffix;
        }

        public Set<String> getEnumValues() {
            return this._enumValues;
        }
    }
}

