/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.util;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;

public class ClassLoaderUtils {
    private static Method _sGetContextClassLoader;

    public static Class loadClass(String string) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(string, null);
    }

    public static URL getResource(String string) {
        return ClassLoaderUtils.getResource(string, null);
    }

    public static InputStream getResourceAsStream(String string) {
        return ClassLoaderUtils.getResourceAsStream(string, null);
    }

    public static Class loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader2 = ClassLoaderUtils.getContextClassLoader();
            if (classLoader2 != null) {
                clazz = classLoader2.loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        }
        return clazz;
    }

    public static URL getResource(String string, ClassLoader classLoader) {
        URL uRL = null;
        ClassLoader classLoader2 = ClassLoaderUtils.getContextClassLoader();
        if (classLoader2 != null) {
            uRL = classLoader2.getResource(string);
        }
        if (uRL == null) {
            uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    public static InputStream getResourceAsStream(String string, ClassLoader classLoader) {
        InputStream inputStream = null;
        ClassLoader classLoader2 = ClassLoaderUtils.getContextClassLoader();
        if (classLoader2 != null) {
            inputStream = classLoader2.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        if (_sGetContextClassLoader != null) {
            Thread thread = Thread.currentThread();
            try {
                classLoader = (ClassLoader)_sGetContextClassLoader.invoke((Object)thread, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classLoader;
    }

    private ClassLoaderUtils() {
    }

    static {
        try {
            _sGetContextClassLoader = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            _sGetContextClassLoader = null;
        }
    }
}

