/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.thread;

public class Timer
implements Runnable {
    private Thread _thread;
    private long _delay;
    private long _expirationTime;
    private Runnable _target;
    private boolean _killed;
    private boolean _scheduled;
    private boolean _cancelled;
    private boolean _sleeping;
    private boolean _firing;
    private boolean _daemon;
    private String _name;
    private static int _sInstanceCounter;
    private static final long THREAD_FUDGE_FACTOR = 10L;

    public Timer(Runnable runnable) {
        this._init(runnable, this.getDefaultName());
    }

    public Timer(Runnable runnable, String string) {
        this._init(runnable, string);
    }

    public Timer(Runnable runnable, long l) {
        this(runnable);
        this.schedule(l);
    }

    public synchronized void schedule(long l) {
        long l2 = this._expirationTime;
        this.setDelay(l);
        this._expirationTime = System.currentTimeMillis() + l;
        if (!this._isSleeping() || l2 > this._expirationTime) {
            if (!this._thread.isAlive()) {
                this._thread.start();
            } else if (this.isScheduled() && this._thread != Thread.currentThread()) {
                this.cancel();
            }
        }
        this._setScheduled(true);
        this.notify();
    }

    public boolean isScheduled() {
        return this._scheduled;
    }

    public synchronized long getDelay() {
        return this._delay;
    }

    public synchronized void setDelay(long l) {
        this._delay = l;
    }

    public synchronized long getMillisSinceExpired() {
        return System.currentTimeMillis() - this._expirationTime;
    }

    public synchronized void cancel() {
        boolean bl = this.isScheduled();
        this._setScheduled(false);
        if (this._firing) {
            this._cancelled = true;
            return;
        }
        this._setSleeping(false);
        if (this._thread.isAlive() && bl) {
            this._thread.interrupt();
        }
    }

    public synchronized void kill() {
        this._killed = true;
        this._cancelled = true;
        this.notifyAll();
        this._thread = null;
    }

    public boolean isKilled() {
        return this._killed;
    }

    public void setName(String string) {
        this._name = string;
        this._thread.setName(string);
    }

    public String getName() {
        return this._name;
    }

    public void setDaemon(boolean bl) {
        this._thread.setDaemon(bl);
        this._daemon = bl;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setPriority(int n) {
        this._thread.setPriority(n);
    }

    public int getPriority() {
        return this._thread.getPriority();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this._killed) {
                try {
                    long l;
                    this._waitTilScheduled();
                    if (this._killed) continue;
                    while ((l = -this.getMillisSinceExpired()) > 0L) {
                        this._setSleeping(true);
                        this.accurateSleep(l);
                        this._setSleeping(false);
                    }
                    this.doRun();
                    this._cancelled = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
        catch (ThreadDeath threadDeath) {
            this.kill();
            throw threadDeath;
        }
    }

    protected void accurateSleep(long l) throws InterruptedException {
        if (l > 10L) {
            Thread.sleep(l - 10L);
        } else {
            while (this.getMillisSinceExpired() < 0L) {
                Thread.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() {
        boolean bl;
        Timer timer = this;
        synchronized (timer) {
            this._setScheduled(false);
            this._firing = true;
            bl = this._killed;
        }
        if (!bl) {
            try {
                this._target.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._firing = false;
    }

    protected synchronized boolean wasCancelledDuringRun() {
        return this._cancelled || this._thread == null;
    }

    protected String getDefaultName() {
        return "EWT-Timer" + _sInstanceCounter++;
    }

    protected void finalize() throws Throwable {
        this.kill();
        super.finalize();
    }

    private synchronized void _waitTilScheduled() throws InterruptedException {
        while (!this.isScheduled() && !this._killed) {
            this.wait();
        }
    }

    private void _setScheduled(boolean bl) {
        this._scheduled = bl;
    }

    private boolean _isSleeping() {
        return this._sleeping;
    }

    private synchronized void _setSleeping(boolean bl) {
        this._sleeping = bl;
    }

    private void _init(Runnable runnable, String string) {
        this._name = string;
        this._thread = new Thread((Runnable)this, string);
        this._target = runnable;
    }
}

