/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.mysql3;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.mysql3.BlackMessages;
import oracle.dbtools.migration.workbench.mysql3.MySQLCaptureQueries;
import oracle.dbtools.migration.workbench.mysql3.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.mysql3.MySQLConstraintExtractor;
import oracle.dbtools.migration.workbench.mysql3.MySQLMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.mysql.MySQLConstraintDetails;

public class MySQLCapturer
extends AbstractOnlineCapturer {
    public static final String MY_LANGUAGE_ID = "MySQL";
    private static final String CAPTURE_SCHEMAS_QUERY = "SHOW DATABASES";
    private static final String CAPTURE_TABLES_QUERY = "SHOW TABLES FROM `${schema}`";
    private static final String CAPTURE_COLUMNS_QUERY = "SHOW FULL COLUMNS FROM `${schema}`.`${table}`";
    protected static final String CAPTURE_INDEX_QUERY = "SHOW INDEX FROM `${schema}`.`${table}`";
    private static final String CAPTURE_CONSTRAINT_QUERY = "SHOW CREATE TABLE `${schema}`.`${table}`";
    private static final String CAPTURE_USERS_QUERY = "SELECT * FROM mysql.user";
    protected static final String PRIMARY_KEY_INDICATOR = "PRI";
    protected static final String ENUM_DATA_TYPE = "ENUM";
    protected static final String SET_DATA_TYPE = "SET";
    private static MySQLCaptureQueries s_captureQueries;
    private String[] m_captureColumn = new String[]{BlackMessages.getString("MySQLCapturer.10"), BlackMessages.getString("MySQLCapturer.11"), BlackMessages.getString("MySQLCapturer.12"), BlackMessages.getString("MySQLCapturer.13"), BlackMessages.getString("MySQLCapturer.14"), BlackMessages.getString("MySQLCapturer.15"), BlackMessages.getString("MySQLCapturer.16")};
    protected int m_minorVersion;
    protected int m_majorVersion;
    private String m_modelName;
    private Logger m_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");

    public MySQLCapturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new MySQLCaptureQueries();
        }
        return s_captureQueries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        if (captureContext.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, string, "");
            captureContext.getAudience().fireListeners(captureEvent);
            return;
        }
        try {
            if (string.equals("MD_SCHEMAS")) {
                this.captureSchemas(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_TABLES")) {
                this.captureTables(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_CATALOGS")) {
                this.storeDefaultCatalog(captureContext);
                return;
            }
            if (string.equals("MD_USERS")) {
                this.captureUsers(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_COLUMNS")) {
                this.captureColumnDetails(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_INDEXES")) {
                this.captureIndexForTable(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_INDEX_DETAILS")) return;
            if (string.equals("MD_CONSTRAINTS")) {
                this.captureConstraintForTable(captureContext, migrationObjectFilter);
                return;
            }
            if (!string.equals("MD_CONSTRAINT_DETAILS")) return;
        }
        catch (SQLException sQLException) {
            throw new CaptureException((Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTables(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_TABLES_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_TABLES");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string = resultSet.getString(1))) continue;
                QueryCapture.processTableRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected void processFilter(MigrationObjectFilter migrationObjectFilter, StringBuffer stringBuffer, HashSet<String> hashSet, String string) {
        String[] stringArray;
        if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals(string)) {
            throw new IllegalArgumentException(BlackMessages.getString("MySQLCapturer.18") + migrationObjectFilter.getObjectType());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
            stringBuffer = stringBuffer.append(" ").append(migrationObjectFilter.getWhereClause());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
            stringArray = migrationObjectFilter.getObjectNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                hashSet.add(string2);
            }
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 0 && migrationObjectFilter.getSelectedDatabaseListString() != null && (stringArray = migrationObjectFilter.getSelectedDatabaseListString().replaceAll("'+", "").split(",")) != null) {
            for (String string3 : stringArray) {
                hashSet.add(string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchemas(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_SCHEMAS_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_SCHEMAS");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next()) {
                String string;
                if (migrationObjectFilter != null && (migrationObjectFilter.getFilterType() == 1 || migrationObjectFilter.getFilterType() == 0) && !hashSet.contains(string = resultSet.getString(1)) || resultSet.getString(1).equalsIgnoreCase("information_schema") || resultSet.getString(1).equalsIgnoreCase("mysql")) continue;
                QueryCapture.processSchemaRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected void captureUsers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        try {
            CloseableResultSet closeableResultSet = null;
            CaptureAudience captureAudience = captureContext.getAudience();
            String string = captureContext.applyToSQLString("${schema}");
            StringBuffer stringBuffer = new StringBuffer("SELECT * FROM mysql.db WHERE Db = '" + string + "'");
            CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet2.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                StringBuffer stringBuffer2 = new StringBuffer("SELECT * FROM mysql.user WHERE USER ='" + resultSet.getString(3) + "'");
                String string2 = resultSet.getString(1);
                closeableResultSet = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet2 = closeableResultSet.getResultSet();
                while (resultSet2.next()) {
                    DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                    if (resultSet2.getString(2) == null || resultSet2.getString(2).length() <= 0 || !string2.equals(resultSet2.getString(1))) continue;
                    MdUser mdUser = new MdUser(dBObjectId, resultSet2.getString(2));
                    mdUser.setPassword(resultSet2.getString(3));
                    CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), mdUser.getUsername());
                    captureAudience.fireListeners(captureEvent);
                    mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
                    captureEvent.setEventId(4);
                    captureAudience.fireListeners(captureEvent);
                    this.createUserPrivilegeDetails(captureContext, mdUser, resultSet2);
                }
            }
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
            if (closeableResultSet2 != null) {
                closeableResultSet2.close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Could Not Capture User - " + sQLException.getLocalizedMessage(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    protected void createUserPrivilegeDetails(CaptureContext captureContext, MdUser mdUser, ResultSet resultSet) {
        try {
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string = resultSet.getString(14);
            for (int i = 1; i <= 26; ++i) {
                if (!resultSet.getString(i + 3).equals("Y") || i == 11) continue;
                String string2 = resultSet.getMetaData().getColumnName(i + 3);
                String string3 = this.getOracleSpecificPrivilege(this.getPrivilege(string2));
                boolean bl = false;
                if (string3.length() == 0) {
                    string3 = this.getPrivilege(string2);
                    bl = true;
                }
                MdPrivilege mdPrivilege = new MdPrivilege(dBObjectId, " ", "MD_USERS", string3, new ClobHelper(" "));
                mdPrivilege.setPrivelegeObjectId(mdUser.getKey());
                if (string.equals("Y")) {
                    mdPrivilege.setAdminOption("Y");
                } else {
                    mdPrivilege.setAdminOption("N");
                }
                if (bl) {
                    mdPrivilege.addProperty(new AdditionalProperty(MySQLMigrationAddinArb.getString("MySQL_PRIVILEGE"), string3), dBObjectId2);
                }
                CaptureEvent captureEvent = new CaptureEvent(3, "USER PRIVILEGE", resultSet.getString(2));
                captureContext.getAudience().fireListeners(captureEvent);
                mdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)mdPrivilege);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(mdUser.getKey());
                mdUserPrivilege.setPrivilegeId(mdPrivilege.getKey());
                mdUserPrivilege = (MdUserPrivilege)this.getStorer().storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    protected String getOracleSpecificPrivilege(String string) {
        if (string.equalsIgnoreCase("Select")) {
            return "SELECT";
        }
        if (string.equalsIgnoreCase("Insert")) {
            return "INSERT";
        }
        if (string.equalsIgnoreCase("Update")) {
            return "UPDATE";
        }
        if (string.equalsIgnoreCase("References")) {
            return "REFERENCES";
        }
        if (string.equalsIgnoreCase("Delete")) {
            return "DELETE";
        }
        if (string.equalsIgnoreCase("Alter")) {
            return "ALTER";
        }
        if (string.equalsIgnoreCase("Index")) {
            return "INDEX";
        }
        return "";
    }

    private String getPrivilege(String string) {
        String string2 = string.substring(0, string.lastIndexOf("_priv"));
        return string2;
    }

    protected void captureColumnDetails(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        CaptureAudience captureAudience = captureContext.getAudience();
        Object object = null;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_COLUMNS_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_COLUMNS");
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        int n = 1;
        this.m_minorVersion = this.getDataBaseMinorVersion(this.m_sourceConnection);
        this.m_majorVersion = this.m_sourceConnection.getMetaData().getDatabaseMajorVersion();
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
        while (resultSet.next()) {
            String string;
            String string2;
            String[] stringArray;
            if (captureContext.shouldCancel()) {
                stringArray = new CaptureEvent(-1, "COLUMN", "");
                captureContext.getAudience().fireListeners((CaptureEvent)stringArray);
                closeableResultSet.close();
                return;
            }
            String string3 = resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_FIELD_COLUMN_HEADER")));
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string3)) continue;
            stringArray = null;
            boolean bl = false;
            String string4 = resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_TYPE_COLUMN_HEADER")));
            MySQLColumnHelper mySQLColumnHelper = new MySQLColumnHelper(string4);
            String string5 = mySQLColumnHelper.getDataTypeName();
            if ((string5.equals(ENUM_DATA_TYPE) || string5.equals(SET_DATA_TYPE)) && (stringArray = this.getAllValues(string4)) != null) {
                object = string5.equals(ENUM_DATA_TYPE) ? new MdEnumColumn(dBObjectId2, string3, Integer.valueOf(n++), stringArray, dBObjectId) : new MdSetColumn(dBObjectId2, string3, Integer.valueOf(n++), stringArray, dBObjectId);
                bl = true;
            }
            if ((string2 = resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_EXTRA_COLUMN_HEADER")))).equals("auto_increment") && !bl) {
                string = captureContext.applyToSQLString("${schema}");
                String string6 = captureContext.applyToSQLString("${table}");
                String string7 = "SELECT MAX(`" + string3 + "`) FROM `" + string + "`.`" + string6 + "`";
                CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string7, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet2 = closeableResultSet2.getResultSet();
                long l = 0L;
                while (resultSet2.next()) {
                    l = resultSet2.getLong(1);
                }
                closeableResultSet2.close();
                object = new MdIdentityColumn(dBObjectId2, string3, Integer.valueOf(n++), 0L, 1L, l, dBObjectId);
                bl = true;
            }
            if (!bl) {
                object = new MdColumn(dBObjectId2, string3, Integer.valueOf(n++));
            }
            if (string2 != null && string2.trim().length() > 0) {
                object.addProperty(new AdditionalProperty("EXTRA", string2), dBObjectId);
            }
            object.setColumnType(string5);
            object.setPrecision(Integer.valueOf(mySQLColumnHelper.getPrecision()));
            if (mySQLColumnHelper.hasPrecisionAndScale()) {
                object.setScale(Integer.valueOf(mySQLColumnHelper.getScale()));
            }
            if (resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_NULL_COLUMN_HEADER"))).equalsIgnoreCase("YES")) {
                object.setNullable("Y");
            } else {
                object.setNullable("N");
            }
            String string8 = resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_KEY_COLUMN_HEADER")));
            if (string8.equals(PRIMARY_KEY_INDICATOR)) {
                // empty if block
            }
            object.setDefaultValue(resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_DEFAULT_COLUMN_HEADER"))));
            if (this.m_majorVersion == 4 && this.m_minorVersion >= 1 && (string = resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_COMMENT_COLUMN_HEADER")))) != null && string.length() > 0) {
                object.setComments(string);
            }
            string = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), object.getColumnName());
            captureAudience.fireListeners((CaptureEvent)string);
            object = (MdColumn)this.getStorer().storeObject((PersistableObject)object);
            string.setEventId(4);
            captureAudience.fireListeners((CaptureEvent)string);
            String string9 = resultSet.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString("MySQL_PRIVILEGES_COLUMN_HEADER")));
            if (string9 == null || string9.trim().length() <= 0) continue;
            this.captureColumnPrivilege(string9, captureContext, (MdColumn)object);
        }
        closeableResultSet.close();
    }

    protected int getDataBaseMinorVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseMinorVersion();
    }

    protected int getColumnCaptureInfo(String string) {
        for (int i = 0; i < this.m_captureColumn.length; ++i) {
            if (!this.m_captureColumn[i].equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        return 1;
    }

    protected void captureColumnPrivilege(String string, CaptureContext captureContext, MdColumn mdColumn) throws PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2 == null) continue;
            MdPrivilege mdPrivilege = new MdPrivilege(dBObjectId, " ", "MD_COLUMNS", string2, new ClobHelper(" "));
            mdPrivilege.setPrivelegeObjectId(mdColumn.getKey());
            CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN PRIVILEGE", string2);
            captureContext.getAudience().fireListeners(captureEvent);
            mdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)mdPrivilege);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    protected String[] getAllValues(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "'");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3.equals(",")) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void captureIndexForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_INDEX_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_INDEXES");
        CloseableResultSet closeableResultSet = null;
        closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        boolean bl2 = bl = !resultSet.next();
        while (!bl) {
            MdConstraint mdConstraint;
            String string;
            int n = 1;
            if (captureContext.shouldCancel()) {
                string = new CaptureEvent(-1, "INDEX", "");
                captureContext.getAudience().fireListeners((CaptureEvent)string);
                closeableResultSet.close();
                return;
            }
            string = resultSet.getString(3);
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string)) {
                bl = !resultSet.next();
                continue;
            }
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
            int n2 = resultSet.getInt(2);
            String string2 = captureContext.applyToSQLString("${schema}");
            String string3 = "SHOW COLUMNS FROM `" + string2 + "`.`" + resultSet.getString(1) + "`";
            CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string3, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet2 = closeableResultSet2.getResultSet();
            String string4 = "";
            while (resultSet2.next()) {
                if (!resultSet2.getString(1).equals(resultSet.getString(5))) continue;
                string4 = resultSet2.getString(4);
                break;
            }
            closeableResultSet2.close();
            if (string4.startsWith(PRIMARY_KEY_INDICATOR) && n2 == 0 && resultSet.getString(3).equals("PRIMARY")) {
                mdConstraint = this.createPrimaryIndexConstraint(captureContext, resultSet.getString(3), dBObjectId);
                do {
                    this.createPrimaryIndexConstraintDetails(captureContext, mdConstraint, resultSet.getString(5), n++, dBObjectId);
                } while (!(bl = !resultSet.next()) && resultSet.getString(3).equals(mdConstraint.getObjectName()));
                continue;
            }
            MdIndexe mdIndexe = new MdIndexe(dBObjectId);
            mdIndexe.setIndexName(resultSet.getString(3));
            if (n2 == 0) {
                mdIndexe.setIndexType("UNIQUE");
            } else {
                mdIndexe.setIndexType("NON_UNIQUE");
            }
            mdConstraint = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
            captureContext.getAudience().fireListeners((CaptureEvent)mdConstraint);
            mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
            mdConstraint.setEventId(4);
            captureContext.getAudience().fireListeners((CaptureEvent)mdConstraint);
            do {
                this.createIndexDetails(captureContext, mdIndexe, resultSet, n++);
            } while (!(bl = !resultSet.next()) && resultSet.getString(3).equals(mdIndexe.getIndexName()));
        }
        closeableResultSet.close();
    }

    protected MdConstraint createPrimaryIndexConstraint(CaptureContext captureContext, String string, DBObjectId dBObjectId) throws SQLException, PersistenceException {
        MdConstraint mdConstraint = new MdConstraint(dBObjectId, MY_LANGUAGE_ID);
        mdConstraint.setName(string);
        mdConstraint.setConstraintType("PK");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), string);
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        return mdConstraint;
    }

    protected void createPrimaryIndexConstraintDetails(CaptureContext captureContext, MdConstraint mdConstraint, String string, int n, DBObjectId dBObjectId) throws PersistenceException, SQLException {
        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(1));
        DBObjectId dBObjectId2 = this.getStorer().getPersistenceUtility().getIdForColumn(dBObjectId, string);
        mdConstraintDetail.setColumnId(dBObjectId2);
        mdConstraintDetail.setRefFlag("N");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    protected void createIndexDetails(CaptureContext captureContext, MdIndexe mdIndexe, ResultSet resultSet, int n) throws PersistenceException, SQLException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), persistenceUtility.getIdForColumn(mdIndexe.getTableId(), resultSet.getString(5)), Integer.valueOf(n));
        int n2 = resultSet.getInt(8);
        if (!resultSet.wasNull()) {
            mdIndexDetail.setIndexPortion(Integer.valueOf(n2));
        }
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    protected void captureConstraintForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)CAPTURE_CONSTRAINT_QUERY, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        resultSet.next();
        this.processContraintRow(captureContext, closeableResultSet, migrationObjectFilter);
        if (closeableResultSet != null) {
            closeableResultSet.close();
        }
    }

    private void processContraintRow(CaptureContext captureContext, CloseableResultSet closeableResultSet, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        MySQLConstraintDetails[] mySQLConstraintDetailsArray;
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
        ResultSet resultSet = closeableResultSet.getResultSet();
        String string = resultSet.getString(2);
        MySQLConstraintExtractor mySQLConstraintExtractor = new MySQLConstraintExtractor(string);
        for (MySQLConstraintDetails mySQLConstraintDetails : mySQLConstraintDetailsArray = mySQLConstraintExtractor.getConstraintDetails()) {
            Object object;
            if (captureContext.shouldCancel()) {
                object = new CaptureEvent(-1, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), "");
                captureContext.getAudience().fireListeners((CaptureEvent)object);
                closeableResultSet.close();
                return;
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                object = new HashSet();
                this.processFilter(migrationObjectFilter, new StringBuffer(), (HashSet<String>)object, "MD_CONSTRAINTS");
                if (!((HashSet)object).contains(mySQLConstraintDetails.getName())) {
                    continue;
                }
            } else if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                this.m_logger.log(Level.SEVERE, BlackMessages.getString("MySQLCapturer.9"), new Object[]{BlackMessages.getString("MySQLCapturer.72")});
                throw new UnsupportedOperationException(BlackMessages.getString("MySQLCapturer.8"));
            }
            MdConstraint mdConstraint = new MdConstraint(dBObjectId2, MY_LANGUAGE_ID);
            mdConstraint.setConstraintType("FOREIGN KEY");
            mdConstraint.setName(mySQLConstraintDetails.getName());
            object = null;
            try {
                object = persistenceUtility.getIdForTable(dBObjectId, mySQLConstraintDetails.getReferencedTableName());
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable((String)persistenceException.getMessage(), (String)(BlackMessages.getString("MySQLCapturer.7") + mySQLConstraintDetails.getName()), (Throwable)persistenceException);
            }
            if (object == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, MessageFormat.format(BlackMessages.getString("MySQLCapturer.75"), mySQLConstraintDetails.getName(), mySQLConstraintDetails.getReferencedTableName()));
                continue;
            }
            mdConstraint.setReftableId((DBObjectId)object);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
            int n = this.createConstraintDetails(dBObjectId2, mdConstraint, mySQLConstraintDetails.getColumnNames(), "N", 1, captureContext);
            this.createConstraintDetails((DBObjectId)object, mdConstraint, mySQLConstraintDetails.getReferencedColumnNames(), "Y", n, captureContext);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    protected int createConstraintDetails(DBObjectId dBObjectId, MdConstraint mdConstraint, String[] stringArray, String string, int n, CaptureContext captureContext) throws PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        int n2 = n;
        for (String string2 : stringArray) {
            MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n2++));
            DBObjectId dBObjectId2 = persistenceUtility.getIdForColumn(dBObjectId, string2);
            mdConstraintDetail.setColumnId(dBObjectId2);
            mdConstraintDetail.setRefFlag(string);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        return n2;
    }

    protected void storeDefaultCatalog(CaptureContext captureContext) throws PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdCatalog mdCatalog = new MdCatalog(dBObjectId);
        mdCatalog.setDummyFlag("Y");
        mdCatalog.setCatalogName(MY_LANGUAGE_ID);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), MY_LANGUAGE_ID);
        captureContext.getAudience().fireListeners(captureEvent);
        mdCatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                String string2 = databaseMetaData.getUserName();
                String[] stringArray2 = string2.split("@");
                this.m_modelName = stringArray2[0] + "@" + stringArray[2] + ":" + this.m_sourceConnection.getCatalog() + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                this.m_logger.log(Level.SEVERE, BlackMessages.getString("MySQLCapturer.85"), new Object[]{BlackMessages.getString("MySQLCapturer.86")});
                throw new CaptureException((Throwable)sQLException);
            }
        }
        return this.m_modelName;
    }

    public String putInViewPrefix(String object, String string) {
        if (object == null) {
            return null;
        }
        if (!((String)object).trim().split("\n")[0].toLowerCase().startsWith("create")) {
            object = "CREATE VIEW `" + string + "` AS " + (String)object;
        }
        return object;
    }
}

