/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.jpub.reflect.Server;
import sqlj.runtime.ref.DefaultContext;

public class RObject
implements Serializable {
    private static int LOCAL_VALUE = 0;
    private static int REMOTE_METHOD = 1;
    private static int REMOTE_DECLARED_METHOD = 2;
    private static int REMOTE_FIELD = 3;
    private static int REMOTE_DECLARED_FIELD = 4;
    private static int REMOTE_CONSTRUCTOR = 5;
    private static int REMOTE_DECLARED_CONSTRUCTOR = 6;
    private static int REMOTE_INSTANCE = 10;
    private static int REMOTE_SET_FIELD = 11;
    private static int REMOTE_SET_DECLARED_FIELD = 12;
    private static int REMOTE_ARRAY_SUBSCRIPT = 13;
    private static int REMOTE_ARRAY = 14;
    private int m_whatIsIt;
    private boolean m_recurse;
    private String m_declaringClass;
    private String m_name;
    private String m_signature;
    private Object m_instance;
    private Object m_index;
    private Object[] m_args;
    private transient Object m_value;
    private transient boolean m_isEvaluated;
    private transient DefaultContext m_ctx;

    String getDeclaringClass() {
        return this.m_declaringClass;
    }

    String getName() {
        return this.m_name;
    }

    String getSignature() {
        return this.m_signature;
    }

    RObject(Object value, boolean dummy1, boolean dummy2) {
        this.m_value = value;
        this.m_whatIsIt = LOCAL_VALUE;
    }

    RObject(DefaultContext ctx, String className, String fieldName, Object inst, boolean isDeclared) {
        this.m_ctx = ctx;
        this.m_declaringClass = className;
        this.m_whatIsIt = isDeclared ? REMOTE_DECLARED_FIELD : REMOTE_FIELD;
        this.m_name = fieldName;
        this.m_instance = inst;
        this.m_recurse = this.m_instance != null && this.m_instance instanceof RObject;
    }

    RObject(DefaultContext ctx, String className, String fieldName, Object inst, Object value, boolean isDeclared) {
        this.m_ctx = ctx;
        this.m_declaringClass = className;
        this.m_whatIsIt = isDeclared ? REMOTE_SET_DECLARED_FIELD : REMOTE_SET_FIELD;
        this.m_name = fieldName;
        this.m_instance = inst;
        this.m_index = value;
        this.m_recurse = this.m_instance != null && this.m_instance instanceof RObject || this.m_index != null && this.m_index instanceof RObject;
    }

    RObject(DefaultContext ctx, String className, String methodName, String sig, Object[] args, Object inst, boolean isDeclared) {
        this.m_ctx = ctx;
        this.m_declaringClass = className;
        this.m_whatIsIt = isDeclared ? REMOTE_DECLARED_METHOD : REMOTE_METHOD;
        this.m_name = methodName;
        this.m_signature = sig;
        this.m_args = args;
        this.m_instance = inst;
        this.m_recurse = this.m_instance != null && this.m_instance instanceof RObject;
        for (int i = 0; !this.m_recurse && i < this.m_args.length; ++i) {
            if (this.m_args[i] == null || !(this.m_args[i] instanceof RObject)) continue;
            this.m_recurse = true;
            break;
        }
    }

    RObject(DefaultContext ctx, String klass, boolean dummy) {
        this.m_ctx = ctx;
        this.m_whatIsIt = REMOTE_INSTANCE;
        this.m_name = klass;
    }

    RObject(DefaultContext ctx, String className, String sig, Object[] args, boolean isDeclared) {
        this.m_ctx = ctx;
        this.m_declaringClass = className;
        this.m_whatIsIt = isDeclared ? REMOTE_DECLARED_CONSTRUCTOR : REMOTE_CONSTRUCTOR;
        this.m_signature = sig;
        this.m_args = args;
        for (int i = 0; i < this.m_args.length; ++i) {
            if (this.m_args[i] == null || !(this.m_args[i] instanceof RObject)) continue;
            this.m_recurse = true;
            break;
        }
    }

    RObject(DefaultContext ctx, String className, Object index, Object inst) {
        this.m_ctx = ctx;
        this.m_declaringClass = className;
        this.m_whatIsIt = REMOTE_ARRAY_SUBSCRIPT;
        this.m_index = index;
        this.m_instance = inst;
        this.m_recurse = this.m_index != null && this.m_index instanceof RObject || this.m_instance != null && this.m_instance instanceof RObject;
    }

    RObject(DefaultContext ctx, Object[] args) {
        this.m_ctx = ctx;
        this.m_whatIsIt = REMOTE_ARRAY;
        this.m_args = args;
        for (int i = 0; i < this.m_args.length; ++i) {
            if (this.m_args[i] == null || !(this.m_args[i] instanceof RObject)) continue;
            this.m_recurse = true;
            break;
        }
    }

    public boolean isValue() {
        return this.m_whatIsIt == LOCAL_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate() throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.m_whatIsIt != LOCAL_VALUE) {
            if (this.m_ctx != null) {
                try {
                    byte[] ca;
                    byte[] ba = Server.serialize(this);
                    CallableStatement stmt = null;
                    try {
                        stmt = this.m_ctx.getConnection().prepareCall("BEGIN :1 := SYS.SQLJUTL2.EVALUATE(:2); END;");
                        stmt.setBytes(2, ba);
                        stmt.registerOutParameter(1, -3);
                        stmt.executeUpdate();
                        ca = stmt.getBytes(1);
                    }
                    finally {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Exception _) {}
                    }
                    System.out.println("Request = " + ba.length + " bytes. Return = " + ca.length + " bytes.");
                    this.m_value = Server.deserialize(ca);
                }
                catch (SQLException se) {
                    this.m_value = se;
                }
                catch (IOException ioe) {
                    this.m_value = ioe;
                }
            } else if (this.m_whatIsIt == REMOTE_METHOD || this.m_whatIsIt == REMOTE_DECLARED_METHOD) {
                Method m;
                Method method = m = this.m_whatIsIt == REMOTE_METHOD ? Server.getMethod(this.m_declaringClass, this.m_name, this.m_signature) : Server.getDeclaredMethod(this.m_declaringClass, this.m_name, this.m_signature);
                if (this.m_recurse) {
                    if (this.m_instance != null && this.m_instance instanceof RObject) {
                        this.m_instance = ((RObject)this.m_instance).evaluate();
                    }
                    for (int i = 0; i < this.m_args.length; ++i) {
                        if (this.m_args[i] == null || !(this.m_args[i] instanceof RObject)) continue;
                        this.m_args[i] = ((RObject)this.m_args[i]).evaluate();
                    }
                }
                this.m_value = m.invoke(this.m_instance, this.m_args);
                this.m_isEvaluated = true;
            } else if (this.m_whatIsIt == REMOTE_FIELD || this.m_whatIsIt == REMOTE_DECLARED_FIELD) {
                Field f;
                Field field = f = this.m_whatIsIt == REMOTE_FIELD ? Server.getField(this.m_declaringClass, this.m_name) : Server.getDeclaredField(this.m_declaringClass, this.m_name);
                if (this.m_recurse && this.m_instance != null && this.m_instance instanceof RObject) {
                    this.m_instance = ((RObject)this.m_instance).evaluate();
                }
                this.m_value = f.get(this.m_instance);
                this.m_isEvaluated = true;
            } else if (this.m_whatIsIt == REMOTE_CONSTRUCTOR || this.m_whatIsIt == REMOTE_DECLARED_CONSTRUCTOR) {
                Constructor c;
                Constructor constructor = c = this.m_whatIsIt == REMOTE_CONSTRUCTOR ? Server.getConstructor(this.m_declaringClass, this.m_signature) : Server.getDeclaredConstructor(this.m_declaringClass, this.m_signature);
                if (this.m_recurse) {
                    for (int i = 0; i < this.m_args.length; ++i) {
                        if (this.m_args[i] == null || !(this.m_args[i] instanceof RObject)) continue;
                        this.m_args[i] = ((RObject)this.m_args[i]).evaluate();
                    }
                }
                this.m_value = c.newInstance(this.m_args);
                this.m_isEvaluated = true;
            } else if (this.m_whatIsIt == REMOTE_INSTANCE) {
                Class<?> c = Class.forName(this.m_declaringClass);
                this.m_value = c.newInstance();
                this.m_isEvaluated = true;
            } else if (this.m_whatIsIt == REMOTE_SET_FIELD || this.m_whatIsIt == REMOTE_SET_DECLARED_FIELD) {
                Field f;
                Field field = f = this.m_whatIsIt == REMOTE_SET_FIELD ? Server.getField(this.m_declaringClass, this.m_name) : Server.getDeclaredField(this.m_declaringClass, this.m_name);
                if (this.m_recurse) {
                    if (this.m_instance != null && this.m_instance instanceof RObject) {
                        this.m_instance = ((RObject)this.m_instance).evaluate();
                    }
                    if (this.m_index != null && this.m_index instanceof RObject) {
                        this.m_index = ((RObject)this.m_index).evaluate();
                    }
                }
                f.set(this.m_instance, this.m_instance);
                this.m_value = null;
                this.m_isEvaluated = true;
            } else if (this.m_whatIsIt == REMOTE_ARRAY_SUBSCRIPT) {
                if (this.m_recurse) {
                    if (this.m_instance != null && this.m_instance instanceof RObject) {
                        this.m_instance = ((RObject)this.m_instance).evaluate();
                    }
                    if (this.m_index != null && this.m_index instanceof RObject) {
                        this.m_index = ((RObject)this.m_index).evaluate();
                    }
                }
                this.m_value = Array.get(this.m_instance, (Integer)this.m_index);
                this.m_isEvaluated = true;
            } else {
                Object[] oa = new Object[this.m_args.length];
                for (int i = 0; i < this.m_args.length; ++i) {
                    if (this.m_args[i] != null && this.m_args[i] instanceof RObject) {
                        try {
                            oa[i] = ((RObject)this.m_args[i]).evaluate();
                        }
                        catch (Throwable t) {
                            oa[i] = t;
                        }
                        continue;
                    }
                    oa[i] = this.m_args[i];
                }
                this.m_value = oa;
            }
            this.m_whatIsIt = LOCAL_VALUE;
        }
        return this.m_value;
    }
}

