/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class has_profile_not_default
extends FilterableCheck
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_profile_not_default.class.getName());
    private String usernameWhereClause;
    private boolean hasProfileProperty = true;
    private Set<String> fixableProfiles;

    public has_profile_not_default() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA_ONLY);
        this.setGrouping(Check.Group.OTHER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("USERNAME").objectNameColumn("USERNAME").objectTypeFixed("USER").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String sqlQuery;
        this.usernameWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        String targetProfileProperty = exeCtx.getAnalysisProperty(TargetInstanceProp.PROFILES.getKey());
        if (targetProfileProperty == null || targetProfileProperty.trim().length() == 0) {
            this.hasProfileProperty = false;
        }
        if (this.hasProfileProperty) {
            List<Object> sourceProfilesList = new ArrayList();
            try {
                String getSourceProfilesQuery = "SELECT DISTINCT PROFILE FROM SYS.DBA_USERS " + this.usernameWhereClause;
                sourceProfilesList = SqlUtils.getStringList(getSourceProfilesQuery, exeCtx);
            }
            catch (SQLException e) {
                log.severe("Failed to fetch source profiles", e);
            }
            ArrayList<String> targetProfilesList = new ArrayList<String>(Arrays.asList(targetProfileProperty.trim().split(",")));
            ArrayList<String> missingProfiles = new ArrayList<String>();
            for (String string : sourceProfilesList) {
                if (string.trim().length() == 0 || targetProfilesList.contains(string)) continue;
                missingProfiles.add(string);
            }
            if (!missingProfiles.isEmpty()) {
                sqlQuery = "SELECT USERNAME, PROFILE FROM SYS.DBA_USERS " + this.usernameWhereClause + SqlUtils.createAndClause("PROFILE", true, missingProfiles);
                this.fixableProfiles = new HashSet<String>(missingProfiles);
            } else {
                sqlQuery = "SELECT USERNAME, PROFILE FROM SYS.DBA_USERS " + this.usernameWhereClause + SqlUtils.createAndClause("PROFILE", false, sourceProfilesList);
                this.fixableProfiles = Collections.emptySet();
            }
        } else {
            sqlQuery = "SELECT USERNAME, PROFILE FROM SYS.DBA_USERS " + this.usernameWhereClause + " AND PROFILE != 'DEFAULT'";
        }
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public CheckResult determineResult() {
        if (this.hasProfileProperty) {
            return super.blockerIfAnyValidator();
        }
        return super.warningIfAnyValidator();
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "create_missing_profiles";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPath = locus.getPathContribution() + File.separator + "create_missing_profiles" + ".sql";
        Fixup sqlFixup = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("create_missing_profiles").parentPath(parentFolderPath).relativeFilePath(relPath).build();
        try (FixupFileHelper fileHelper = new FixupFileHelper(this, sqlFixup);){
            String profileDDL;
            String userDefinedPredicate = exeCtx.hasOracleMaintained() ? "  AND o.oracle_maintained = 'N' " : "  AND o.object_name != 'VERIFY_FUNCTION_11G' ";
            String pvfDDLQuery = "SELECT DBMS_METADATA.GET_DDL('FUNCTION', O.OBJECT_NAME, O.OWNER) AS DDL  FROM  sys.dba_objects  o,   sys.dba_profiles p,   sys.dba_users u " + this.usernameWhereClause + "  AND p.resource_type = 'PASSWORD'   AND p.resource_name = 'PASSWORD_VERIFY_FUNCTION'   AND p.limit = o.object_name   AND u.profile = p.profile " + userDefinedPredicate;
            List<String> pvfDDLs = SqlUtils.getDDLStringList(pvfDDLQuery, exeCtx);
            List<String> massagedPvfDDLs = this.massagePvfDDLforTarget(exeCtx, pvfDDLs);
            fileHelper.writeFixupText(massagedPvfDDLs, 1);
            if (this.hasProfileProperty && !this.fixableProfiles.isEmpty()) {
                List<String> quotedNames = SqlUtils.quotifySqlNames(this.fixableProfiles);
                String commaSeparatedList = Utilities.join(",", quotedNames);
                profileDDL = "SELECT DBMS_METADATA.GET_DDL('PROFILE', COLUMN_VALUE) AS DDL FROM TABLE(SYS.ODCIVARCHAR2LIST(" + commaSeparatedList + "))";
            } else {
                profileDDL = "WITH PROFILES AS (  SELECT DISTINCT PROFILE FROM DBA_USERS " + this.usernameWhereClause + "  AND PROFILE != 'DEFAULT')SELECT DBMS_METADATA.GET_DDL('PROFILE', P.PROFILE) AS DDL FROM PROFILES P";
            }
            List<String> profileDDLQuery = SqlUtils.getDDLStringList(profileDDL, exeCtx);
            fileHelper.writeFixupText(profileDDLQuery, 1);
            this.addFixup(sqlFixup);
        }
        catch (SQLException e) {
            String errorMsg = Utilities.getErrorText("ERROR3005", e, "create_missing_profiles", this.getName());
            Utilities.printAndLogErrorMessage(errorMsg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMsg, e);
        }
    }

    private List<String> massagePvfDDLforTarget(ExecutionContext exeCtx, List<String> pvfDDLs) {
        ArrayList<String> massagedPvfDDLs = new ArrayList();
        if (exeCtx.isAutonomousSource() == exeCtx.isAutonomousTarget()) {
            massagedPvfDDLs = pvfDDLs;
        } else {
            for (String pvf : pvfDDLs) {
                if (exeCtx.isAutonomousTarget()) {
                    massagedPvfDDLs.add(pvf.replaceFirst("FUNCTION \"SYS\".", "FUNCTION \"ADMIN\"."));
                    continue;
                }
                massagedPvfDDLs.add(pvf.replaceFirst("FUNCTION \"ADMIN\".", "FUNCTION \"SYS\"."));
            }
        }
        return massagedPvfDDLs;
    }
}

