/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.has_columns_with_media_data_types;
import com.oracle.premigration.logger.PremigrationLogger;

public class has_columns_with_media_data_types_default
extends has_columns_with_media_data_types {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_columns_with_media_data_types_default.class.getName());

    public has_columns_with_media_data_types_default() {
        this.getTargetCloud().clear();
        this.getTargetCloud().add(TargetCloud.DEFAULT);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        super.prepare(exeCtx);
        String targetDatabaseVersion = exeCtx.getAnalysisProperty(TargetInstanceProp.DB_VERSION.getKey());
        if (targetDatabaseVersion == null || targetDatabaseVersion.trim().isEmpty()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_TARGET_UNKNOWN", this.getName()), CheckResult.INFORMATIONAL);
        } else if (Version.V19_1_0_0.compare(targetDatabaseVersion) == 1) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_TARGET_SUPPORTS", this.getName()), CheckResult.PASS);
        }
    }
}

