/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.CalcReferences;
import oracle.hcs.avviewer.AVViewerDialog;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.LanguageDBSettings;
import oracle.hcs.db.MetadataUpdateListener;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.editor.DocHtmlContentProvider;
import oracle.hcs.syntaxbuilder.editor.HCSTextFormatter;
import oracle.hcs.syntaxbuilder.editor.SQLFormatter;
import oracle.hcs.syntaxbuilder.editor.SyntaxFormatter;
import oracle.hcs.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.TemplateHandlerEmbedEditorPlugin;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.table.Queries;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.templates.templateview.TemplateData;
import oracle.hcs.util.FetchIcon;
import oracle.hcs.util.JavaXMLBind;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopup;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.editor.popup.PopupEventListener;
import oracle.javatools.editor.popup.StaticHtmlContentProvider;
import oracle.javatools.icons.OracleIcons;

public class EditorActions
implements ChangeListener,
UndoableEditListener,
Controller {
    private final FetchIcon fetchIcon;
    private static File path;
    private BasicEditorPane text;
    private final SyntaxParser parser;
    private final UndoManager undoMan;
    private CalcSelectionEditorPlugin calcSel;
    private AbstractAction undoAction;
    private AbstractAction redoAction;
    private AbstractAction copyAction;
    private AbstractAction pasteAction;
    private AbstractAction cutAction;
    private AbstractAction saveAction;
    private AbstractAction clearAction;
    private AbstractAction formatAction;
    private AbstractAction validateAction;
    private AbstractAction quickDocAction;
    private AbstractAction viewExceptionAction;
    private AbstractAction deleteOutter;
    private AbstractAction runAction;
    private AbstractAction compileAction;
    private AbstractAction changeFocusAction;
    private ToggleAction forceAction;
    private static final Logger LOG;
    private InsertionHandlerEditorPlugin ihandler;
    private Spec spec;
    private String connectionName;
    private String schemaName;
    private String analyticViewName;
    protected static Queries queries;
    protected static final String XMLFILE = "/oracle/hcs/actions/actionsQueries.xml";
    protected static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private static final Type[] ideActions;

    protected String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        EditorActions.queries = queries;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undoAction.setEnabled(this.undoMan.canUndo() && this.text.isEditable());
        this.redoAction.setEnabled(this.undoMan.canRedo() && this.text.isEditable());
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Type type;
        if (context.getView() == CodeEditor.getCodeEditor((BasicEditorPane)this.text) && (type = Type.fromCommandId(ideAction.getCommandId())) != null) {
            this.get(type).actionPerformed(null);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (context.getView() == CodeEditor.getCodeEditor((BasicEditorPane)this.text)) {
            this.stateChanged(null);
            Type type = Type.fromCommandId(ideAction.getCommandId());
            Action action = this.get(type);
            ideAction.setEnabled(action.isEnabled());
            return true;
        }
        return false;
    }

    public void setEditorPane(BasicEditorPane basicEditorPane) {
        this.text = basicEditorPane;
        this.setupKeyBindings();
    }

    public void setView(View view) {
        for (Type type : ideActions) {
            this.getIdeAction(type).addController((Controller)this);
        }
        view.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
            }

            public void viewClosed(ViewEvent viewEvent) {
                for (Type type : ideActions) {
                    IdeAction.removeController((int)type.getCommandId(), (Controller)EditorActions.this);
                }
            }
        });
    }

    private void setupKeyBindings() {
        if (this.text == null) {
            return;
        }
        InputMap inputMap = this.text.getInputMap();
        ActionMap actionMap = this.text.getActionMap();
        Type[] typeArray = Type.values();
        this.text.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                KeyStroke keyStroke = (KeyStroke)EditorActions.this.undoAction.getValue("AcceleratorKey");
                if (keyEvent.getKeyCode() == keyStroke.getKeyCode() && (keyEvent.getModifiers() & keyStroke.getModifiers()) != 0) {
                    EditorActions.this.undoAction.actionPerformed(null);
                }
                KeyStroke keyStroke2 = (KeyStroke)EditorActions.this.redoAction.getValue("AcceleratorKey");
                if (keyEvent.getKeyCode() == keyStroke2.getKeyCode() && (keyEvent.getModifiers() & keyStroke2.getModifiers()) != 0) {
                    EditorActions.this.redoAction.actionPerformed(null);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.text.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EditorActions.this.stateChanged(null);
            }
        });
        for (int i = 0; i < typeArray.length; ++i) {
            KeyStroke keyStroke;
            if (typeArray[i] == Type.UNDO || typeArray[i] == Type.REDO || this.get(typeArray[i]) == null || (keyStroke = (KeyStroke)this.get(typeArray[i]).getValue("AcceleratorKey")) == null) continue;
            actionMap.put((Object)typeArray[i], this.get(typeArray[i]));
            inputMap.put(keyStroke, (Object)typeArray[i]);
        }
    }

    public EditorActions(FetchIcon fetchIcon, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, CalcSelectionEditorPlugin calcSelectionEditorPlugin, BasicEditorPane basicEditorPane, Spec spec, SyntaxParser syntaxParser, UndoManager undoManager, String string, String string2, String string3) {
        this.fetchIcon = fetchIcon;
        this.parser = syntaxParser;
        this.text = basicEditorPane;
        this.undoMan = undoManager;
        this.ihandler = insertionHandlerEditorPlugin;
        this.spec = spec;
        this.calcSel = calcSelectionEditorPlugin;
        this.connectionName = string;
        this.analyticViewName = string3;
        this.schemaName = string2;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.pasteAction = new PasteAction();
        this.copyAction = new CopyAction();
        this.cutAction = new CutAction();
        this.saveAction = new SaveAction();
        this.clearAction = new ClearAction();
        this.formatAction = new FormatAction();
        this.validateAction = new ValidateAction();
        this.quickDocAction = new QuickDocAction();
        this.viewExceptionAction = new ViewExceptionAction();
        this.deleteOutter = new DeleteOuterAction();
        this.runAction = new RunAction();
        this.compileAction = new CompileAction();
        this.forceAction = new ForceAction(HCSArb.getString("FORCE_CREATE_CALC"), null);
        this.changeFocusAction = new ChangeFocusAction();
        if (basicEditorPane != null) {
            this.setupKeyBindings();
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
            if (codeEditor != null) {
                this.setView((View)codeEditor);
            }
        }
    }

    public EditorActions(FetchIcon fetchIcon, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, BasicEditorPane basicEditorPane, UndoManager undoManager) {
        this.fetchIcon = fetchIcon;
        this.text = basicEditorPane;
        this.undoMan = undoManager;
        this.ihandler = insertionHandlerEditorPlugin;
        this.parser = null;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.pasteAction = new PasteAction();
        this.copyAction = new CopyAction();
        this.cutAction = new CutAction();
        this.clearAction = new ClearAction();
        this.formatAction = new FormatSQLAction();
        if (this.text != null) {
            this.setupKeyBindings();
        }
    }

    public Action get(Type type) {
        switch (type) {
            case UNDO: {
                return this.undoAction;
            }
            case REDO: {
                return this.redoAction;
            }
            case COPY: {
                return this.copyAction;
            }
            case PASTE: {
                return this.pasteAction;
            }
            case CUT: {
                return this.cutAction;
            }
            case SAVE: {
                return this.saveAction;
            }
            case CLEAR: {
                return this.clearAction;
            }
            case FORMAT: {
                return this.formatAction;
            }
            case VALIDATE: {
                return this.validateAction;
            }
            case QUICKDOC: {
                return this.quickDocAction;
            }
            case VIEWEXCEPTION: {
                return this.viewExceptionAction;
            }
            case DELETE_OUTER: {
                return this.deleteOutter;
            }
            case REFRESH_METADATA: {
                return IdeActions.getViewRefreshAction();
            }
            case RUN: {
                return this.runAction;
            }
            case COMPILE: {
                return this.compileAction;
            }
            case FORCE: {
                return this.forceAction;
            }
            case CHANGE_FOCUS: {
                return this.changeFocusAction;
            }
        }
        return null;
    }

    private IdeAction getIdeAction(Type type) {
        Action action = this.get(type);
        if (action instanceof IdeAction) {
            return (IdeAction)action;
        }
        return IdeAction.findOrCreate((int)type.getCommandId(), null, (String)((String)action.getValue("Name")), (String)((String)action.getValue("Category")), (Integer)0, (Icon)((Icon)action.getValue("SmallIcon")), null, (boolean)true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Node node;
        Context context;
        boolean bl = this.text.getCaret().getDot() != this.text.getCaret().getMark();
        this.copyAction.setEnabled(bl);
        this.cutAction.setEnabled(bl && this.text.isEditable());
        if (this.validateAction != null) {
            this.validateAction.setEnabled(bl && this.text.isEditable());
        }
        boolean bl2 = this.text.getText().length() > 0;
        this.clearAction.setEnabled(bl2 && this.text.isEditable());
        this.formatAction.setEnabled(bl2 && this.text.isEditable());
        if (this.quickDocAction != null) {
            this.quickDocAction.setEnabled(bl);
        }
        if (this.deleteOutter != null) {
            this.deleteOutter.setEnabled(this.calcSel.getInnerExpression() != null && this.text.isEditable());
        }
        if ((context = CodeEditor.getContext((BasicEditorPane)this.text)) != null && (node = context.getNode()) != null && node instanceof CalculatedMeasureNode) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)node;
            boolean bl3 = calculatedMeasureNode.isForceCreate();
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)this.text);
            ContextMenu contextMenu = codeEditor.getContextMenu();
            JPopupMenu jPopupMenu = (JPopupMenu)contextMenu.getGUI(false);
            if (jPopupMenu != null) {
                Component[] componentArray;
                for (Component component : componentArray = jPopupMenu.getComponents()) {
                    ToggleMenuItem toggleMenuItem;
                    String string;
                    if (!(component instanceof ToggleMenuItem) || !(string = (toggleMenuItem = (ToggleMenuItem)component).getText()).equals(HCSArb.getString("FORCE_CREATE_CALC"))) continue;
                    toggleMenuItem.setSelected(bl3);
                }
            }
            this.forceAction.setState(bl3);
            this.changeFocusAction.setEnabled(true);
        }
    }

    private void setActionValues(Action action, String string) {
        action.putValue("Name", HCSArb.getString("EXPRESSION_EDITOR." + string));
        action.putValue("ShortDescription", action.getValue("Name"));
        action.putValue("COSTELLO", string);
        String[] stringArray = new String[]{"SmallIcon", "_ENABLE", "disabledIcon", "_DISABLE", "rolloverIcon", "_OVER", "pressedIcon", "_DOWN"};
        if (this.fetchIcon != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                Icon icon = this.fetchIcon.getIcon(string + stringArray[i + 1]);
                if (icon == null) continue;
                action.putValue(stringArray[i], icon);
            }
        }
    }

    static {
        LOG = Logger.getLogger(EditorActions.class.getName());
        ideActions = new Type[]{Type.COMPILE, Type.RUN, Type.VIEWEXCEPTION, Type.CLEAR, Type.FORMAT, Type.VALIDATE, Type.DELETE_OUTER, Type.FORCE, Type.CHANGE_FOCUS};
    }

    public static enum Type {
        COMPILE,
        RUN,
        UNDO,
        REDO,
        COPY,
        PASTE,
        CUT,
        DELETE_OUTER,
        SAVE,
        CLEAR,
        FORMAT,
        QUICKDOC,
        VALIDATE,
        VIEWEXCEPTION,
        REFRESH_METADATA,
        FORCE,
        CHANGE_FOCUS;

        private final int cmdId = this.name().equals("REFRESH_METADATA") ? IdeActions.getViewRefreshAction().getCommandId() : Ide.createCmdID((String)(((Object)((Object)this)).getClass().getName() + this.name()));

        public int getCommandId() {
            return this.cmdId;
        }

        public static Type fromCommandId(int n) {
            for (Type type : ideActions) {
                if (n != type.cmdId) continue;
                return type;
            }
            return null;
        }
    }

    private class UndoAction
    extends AbstractAction {
        UndoAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 128));
            EditorActions.this.setActionValues(this, "UNDO");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.undoMan != null) {
                if (EditorActions.this.undoMan.canUndo()) {
                    EditorActions.this.undoMan.undo();
                }
                this.setEnabled(EditorActions.this.undoMan.canUndo() && EditorActions.this.text.isEditable());
                EditorActions.this.redoAction.setEnabled(EditorActions.this.undoMan.canRedo() && EditorActions.this.text.isEditable());
                EditorActions.this.clearAction.setEnabled(EditorActions.this.text.getDocument().getLength() > 0 && EditorActions.this.text.isEditable());
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        RedoAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 128));
            EditorActions.this.setActionValues(this, "REDO");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.undoMan.canRedo()) {
                EditorActions.this.undoMan.redo();
            }
            this.setEnabled(EditorActions.this.undoMan.canRedo());
            EditorActions.this.undoAction.setEnabled(EditorActions.this.undoMan.canUndo() && EditorActions.this.text.isEditable());
            EditorActions.this.clearAction.setEnabled(EditorActions.this.text.getDocument().getLength() > 0 && EditorActions.this.text.isEditable());
        }
    }

    private class PasteAction
    extends AbstractAction {
        PasteAction() {
            this.setEnabled(true);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
            EditorActions.this.setActionValues(this, "PASTE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = (String)EditorActions.this.text.getToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                EditorActions.this.ihandler.insertSyntax(new TemplateData(string));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        boolean cut;

        CopyAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
            EditorActions.this.setActionValues(this, "COPY");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = EditorActions.this.text.getCaret().getDot();
            if (n2 != (n = EditorActions.this.text.getCaret().getMark())) {
                String string = EditorActions.this.text.getSelectedText();
                EditorActions.this.text.getToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                if (this.cut) {
                    EditorActions.this.text.replaceSelection("");
                }
            }
        }
    }

    private class CutAction
    extends CopyAction {
        CutAction() {
            this.cut = true;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 128));
            EditorActions.this.setActionValues(this, "CUT");
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            EditorActions.this.setActionValues(this, "SAVE");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            if (path == null) {
                jFileChooser.showOpenDialog((Component)EditorActions.this.text);
                path = jFileChooser.getSelectedFile();
                if (path == null) {
                    return;
                }
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(path);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(EditorActions.this.text.getText());
                bufferedWriter.close();
                outputStreamWriter.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        ClearAction() {
            EditorActions.this.setActionValues(this, "CLEAR");
            this.putValue("Category", "Edit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditorActions.this.text.getDocument().getLength();
            if (n > 0) {
                try {
                    EditorActions.this.text.getDocument().remove(0, n);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.setEnabled(false);
        }
    }

    private class FormatAction
    extends AbstractAction {
        HCSTextFormatter textFormatter;

        FormatAction() {
            this.setEnabled(false);
            this.initTextFormatter();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 128));
            this.putValue("Category", "Edit");
            EditorActions.this.setActionValues(this, "FORMAT");
        }

        protected void initTextFormatter() {
            this.setTextFormatter(new SyntaxFormatter(EditorActions.this.parser));
        }

        protected void setTextFormatter(HCSTextFormatter hCSTextFormatter) {
            this.textFormatter = hCSTextFormatter;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = EditorActions.this.text.getText().replace("\r\n", "\n");
            this.textFormatter.setText(string);
            String string2 = this.textFormatter.formatText(string).replace("\r\n", "\n");
            if (!string.equals(string2)) {
                EditorActions.this.ihandler.insertSyntax(new TemplateData(string2, TemplateData.Mode.REPLACEALL));
            }
        }
    }

    private class ValidateAction
    extends AbstractAction {
        ValidateAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 128));
            this.putValue("Category", "Debug");
            EditorActions.this.setActionValues(this, "VALIDATE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.text.getCaret().getDot() == EditorActions.this.text.getCaret().getMark()) {
                return;
            }
            boolean bl = EditorActions.this.parser.parseSyntax(EditorActions.this.text.getSelectedText(), null);
            if (bl) {
                JOptionPane.showMessageDialog((Component)EditorActions.this.text, HCSArb.getString("EXPRESSION_EDITOR.SELECTION_VALID"));
            } else {
                JOptionPane.showMessageDialog((Component)EditorActions.this.text, HCSArb.getString("EXPRESSION_EDITOR.SELECTION_INVALID"));
            }
        }
    }

    private class QuickDocAction
    extends AbstractAction {
        QuickDocAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 128));
            EditorActions.this.setActionValues(this, "QUICKDOC");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = EditorActions.this.text.getCaret().getDot();
            if (n2 != (n = EditorActions.this.text.getCaret().getMark())) {
                String string = EditorActions.this.text.getSelectedText();
                WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                try {
                    String string2;
                    waitCursor.show();
                    DocHtmlContentProvider docHtmlContentProvider = new DocHtmlContentProvider(EditorActions.this.spec, string);
                    if (docHtmlContentProvider == null) {
                        string2 = InsightBundle.get((String)"POPUP_MSG_NO_DOC");
                        docHtmlContentProvider = new StaticHtmlContentProvider(string2);
                    }
                    if ((string2 = HtmlPopup.invokePopup((BasicEditorPane)EditorActions.this.text, (HtmlContentProvider)docHtmlContentProvider)) != null) {
                        Listener listener = new Listener(EditorActions.this.text, (HtmlPopupView)string2);
                        EditorActions.this.text.addCaretListener((CaretListener)listener);
                        string2.addPopupEventListener((PopupEventListener)listener);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "Quick Doc failed", exception);
                }
                finally {
                    waitCursor.hide();
                }
            }
        }
    }

    private class ViewExceptionAction
    extends AbstractAction {
        ViewExceptionAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
            this.putValue("Category", "Debug");
            EditorActions.this.setActionValues(this, "VIEW_EXCEPTION");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<String> list = EditorActions.this.ihandler.getSyntaxErrors();
            if (list.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : list) {
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                }
                JOptionPane.showMessageDialog((Component)EditorActions.this.text, stringBuilder, HCSArb.getString("EXPRESSION_EDITOR.VIEW_EXCEPTION"), 0);
            }
        }
    }

    private class DeleteOuterAction
    extends AbstractAction {
        DeleteOuterAction() {
            EditorActions.this.setActionValues(this, "CLEAR");
            this.putValue("Name", HCSArb.getString("EXPRESSION_EDITOR.DELETEOUTER"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("Category", "Edit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.calcSel.getInnerExpression() != null) {
                ParseNode parseNode = EditorActions.this.calcSel.getInnerExpression();
                EditorActions.this.text.replaceSelection(parseNode.getFullValue());
            }
        }
    }

    private class RunAction
    extends AbstractAction
    implements MetadataUpdateListener {
        private AVViewerDialog dataViewer;
        private CalculatedMeasureNode node;

        public RunAction() {
            this.setEnabled(true);
            this.putValue("Name", Messages.getString((String)"Run"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"run.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                try {
                    if (EditorActions.this.ihandler.checkSyntax()) {
                        try {
                            this.node = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
                            if (this.node.isDirty()) {
                                HCSMetadataCache.addUpdateListener(EditorActions.this.connectionName, EditorActions.this.schemaName, this);
                                IdeActions.getFileSaveAction().performAction();
                                break block6;
                            }
                            List<String> list = this.findAvailableLanguages(this.node.getAVName(), this.node.getSchemaName());
                            this.launchDataViewer(this.node.getAVName(), this.node.getMeasureName(), list);
                        }
                        catch (Exception exception) {
                            LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
                        }
                        break block6;
                    }
                    CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HCSArb.format("EXPRESSION_EDITOR_INVALID_SYNTAX", calculatedMeasureNode.getData()));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }

        private List<String> findAvailableLanguages(String string, String string2) {
            List<String> list = Collections.EMPTY_LIST;
            String string3 = this.generateAVDimensionalityString(string, string2);
            try {
                Connection connection = Connections.getInstance().getConnection(this.node.getConnectionName());
                list = LanguageDBSettings.getDescriptionLanguagesUnionForObjectType(connection, string3);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return list;
        }

        private String generateAVDimensionalityString(String string, String string2) {
            HCSSchema hCSSchema = HCSMetadataCache.getSchema(EditorActions.this.connectionName, string2);
            AnalyticView analyticView = hCSSchema.findAV(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                arrayList.add(String.format("'%s'", aVDimensionality.getName()));
                for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                    arrayList.add(String.format("'%s'", aVHierarchy.getName()));
                }
            }
            arrayList.add(String.format("'%s'", analyticView.getName()));
            String string3 = String.join((CharSequence)",", arrayList);
            return string3;
        }

        private void launchDataViewer(final String string, final String string2, final List<String> list) {
            RaptorTask raptorTask = new RaptorTask(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() {
                    Boolean bl = Boolean.TRUE;
                    try {
                        HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(EditorActions.this.connectionName, EditorActions.this.schemaName);
                        AnalyticView analyticView = hCSSchema.findAV(string);
                        CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
                        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)calculatedMeasureNode.getProvider();
                        AVCalculatedMeasure aVCalculatedMeasure = analyticView.findCalculatedMeasure(string2);
                        RunAction.this.unselectAllMeasures(analyticView);
                        aVCalculatedMeasure.setSelected(true);
                        List<AVBaseMeasure> list2 = CalcReferences.getReferences(aVCalculatedMeasure, EditorActions.this.parser);
                        for (AVBaseMeasure object2 : list2) {
                            object2.setSelected(true);
                        }
                        Object object3 = null;
                        ParseNode parseNode = new ParseNode();
                        if (EditorActions.this.parser.parseSyntax(aVCalculatedMeasure.getMeasureExpression(), parseNode)) {
                            HCSSyntaxParser hCSSyntaxParser = (HCSSyntaxParser)EditorActions.this.parser;
                            object3 = hCSSyntaxParser.getAVHierarchiesReferenced();
                        }
                        RunAction.this.dataViewer = new AVViewerDialog((JFrame)Ide.getMainWindow(), oracleDatabaseImpl, analyticView, list, true, (Set<AVHierarchy>)object3);
                        RunAction.this.dataViewer.runQuery();
                        return bl;
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
                        return null;
                    }
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(HCSArb.getString("EXPRESSION_EDITOR_LOAD_METADATA"));
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunAction.this.dataViewer.showViewer();
                        }
                    });
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }

        private void unselectAllMeasures(AnalyticView analyticView) {
            for (AVMeasure aVBaseMeasure : analyticView.getMeasures()) {
                aVBaseMeasure.setSelected(false);
            }
            for (AVBaseMeasure aVBaseMeasure : analyticView.getCalculatedMeasures()) {
                aVBaseMeasure.setSelected(false);
            }
        }

        @Override
        public void metadataUpdated(HCSSchema hCSSchema) {
            try {
                HCSMetadataCache.removeUpdateListener(EditorActions.this.connectionName, EditorActions.this.schemaName, this);
                List<String> list = this.findAvailableLanguages(EditorActions.this.analyticViewName, EditorActions.this.schemaName);
                this.launchDataViewer(EditorActions.this.analyticViewName, this.node.getMeasureName(), list);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }

        @Override
        public void metadataCleared() {
        }
    }

    private class CompileAction
    extends AbstractAction {
        private static final String COMPILE_OBJECT_SQL = "compileObject";
        private static final String ANALYTIC_VIEW_STATE_QUERY = "analyticViewState";
        private static final String AVS_USER_ERRORS_QUERY = "avs_user_errors_query";
        private static final String OWNER = "OWNER";
        private static final String ANALYTIC_VIEW_NAME = "ANALYTIC_VIEW_NAME";
        private static final String INVALID = "INVALID";

        public CompileAction() {
            this.setEnabled(true);
            this.putValue("Name", Messages.getString((String)"Compile"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("SmallIcon", CompileArb.getIcon((String)"MAKE_ICON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Compiler compiler = Compiler.getCompiler();
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
            ArrayList<Throwable> arrayList2 = new ArrayList<Throwable>();
            boolean bl = false;
            boolean bl2 = false;
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
            try {
                EditorActions.this.ihandler.checkSyntax();
                String string = calculatedMeasureNode.getSchemaName();
                this.refreshMetadataCache(EditorActions.this.connectionName, string);
                if (EditorActions.this.parser.getExceptions().size() > 0) {
                    bl = true;
                    arrayList.addAll(EditorActions.this.parser.getExceptions());
                    arrayList2.addAll(EditorActions.this.parser.getExceptions());
                }
                Connection connection = Connections.getInstance().getConnection(EditorActions.this.connectionName);
                String string2 = calculatedMeasureNode.getAVName();
                String string3 = String.format(EditorActions.this.getQuery(COMPILE_OBJECT_SQL), "ANALYTIC VIEW", string, string2);
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.execute(string3);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(OWNER, string);
                hashMap.put(ANALYTIC_VIEW_NAME, string2);
                String string4 = EditorActions.this.getQuery(ANALYTIC_VIEW_STATE_QUERY);
                String string5 = dBUtil.executeReturnOneCol(string4, hashMap);
                if (string5 == null || string5.equalsIgnoreCase(INVALID)) {
                    bl2 = true;
                    string3 = EditorActions.this.getQuery(AVS_USER_ERRORS_QUERY);
                    String string6 = String.format("'%s'", string2);
                    string3 = String.format(string3, string6);
                    List list = dBUtil.executeReturnList(string3, hashMap);
                    for (Map map : list) {
                        String string7 = map.get("TEXT").toString();
                        String string8 = map.get("LINE").toString();
                        String string9 = map.get("POSITION").toString();
                        SyntaxException syntaxException = new SyntaxException("ServerErrorWithMessage", string7, string8, string9);
                        arrayList.add(syntaxException);
                        arrayList2.add(syntaxException);
                    }
                }
                if (!bl && !bl2) {
                    calculatedMeasureNode.setCompiled(true);
                    calculatedMeasureNode.logMessage(HCSArb.format("EXPRESSION_EDITOR_COMPILE_SUCCESS", calculatedMeasureNode.getMeasureName()));
                    calculatedMeasureNode.setLastCompileErrorsList(null);
                    calculatedMeasureNode.setCompiledWithErrors(false);
                    compiler.getOutputLog().log((Object)HCSArb.format("EXPRESSION_EDITOR_COMPILE_SUCCESS_MSG", calculatedMeasureNode.getMeasureName()));
                } else {
                    calculatedMeasureNode.setCompiledWithErrors(true);
                    calculatedMeasureNode.logError(arrayList);
                    calculatedMeasureNode.setLastCompileErrorsList(arrayList2);
                    compiler.getOutputLog().log((Object)HCSArb.format("EXPRESSION_EDITOR_COMPILE_ERRORS_MSG", calculatedMeasureNode.getMeasureName()));
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }

        private void refreshMetadataCache(final String string, final String string2) {
            RaptorTask<HCSSchema> raptorTask = new RaptorTask<HCSSchema>(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected HCSSchema doWork() {
                    HCSSchema hCSSchema = null;
                    try {
                        hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
                        if (EditorActions.this.parser instanceof HCSSyntaxParser) {
                            HCSSyntaxParser hCSSyntaxParser = (HCSSyntaxParser)EditorActions.this.parser;
                            hCSSyntaxParser.setSchema(hCSSchema);
                        }
                    }
                    catch (Exception exception) {
                        LOG.log(Level.SEVERE, String.format("Error fetching metadata for Connection %s and schema %s", string, string2), exception);
                    }
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setMessage(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"));
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    private class ForceAction
    extends ToggleAction {
        private String title;

        public ForceAction(String string, Icon icon) {
            super(string, icon);
            this.title = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)EditorActions.this.text);
            Toolbar toolbar = codeEditor.getToolbar();
            JCheckBox jCheckBox = null;
            Component[] componentArray = toolbar.getComponents();
            for (Component component : componentArray) {
                JCheckBox jCheckBox2;
                String string;
                if (!(component instanceof JCheckBox) || !(string = (jCheckBox2 = (JCheckBox)component).getText()).equals(this.title)) continue;
                jCheckBox = jCheckBox2;
            }
            int n = ((CalculatedMeasureNode)(object = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode())).isForceCreate() ? 1 : 0;
            ((CalculatedMeasureNode)object).setForceCreate(n == 0);
            this.setState(n == 0);
            jCheckBox.setSelected(n == 0);
        }
    }

    private class ChangeFocusAction
    extends AbstractAction {
        public ChangeFocusAction() {
            super(HCSArb.getString("GO_TO_TEMPLATE_EDITOR_PANEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
            if (calculatedMeasureNode.getTemplateHandler() instanceof TemplateHandlerEmbedEditorPlugin) {
                ((TemplateHandlerEmbedEditorPlugin)calculatedMeasureNode.getTemplateHandler()).getTemplatePanel().requestFocus();
            }
        }
    }

    private class FormatSQLAction
    extends FormatAction {
        @Override
        protected void initTextFormatter() {
            this.setTextFormatter(new SQLFormatter());
        }
    }

    private static class Listener
    implements CaretListener,
    PopupEventListener {
        private BasicEditorPane _editorPane;
        private HtmlPopupView _htmlPopupView;

        private Listener(BasicEditorPane basicEditorPane, HtmlPopupView htmlPopupView) {
            this._editorPane = basicEditorPane;
            this._htmlPopupView = htmlPopupView;
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            HtmlPopup.cancelPopup((BasicEditorPane)this._editorPane);
        }

        public void popupCanceled() {
        }

        public void contentsChanged() {
        }

        public void popupClosed() {
            this._editorPane.removeCaretListener((CaretListener)this);
            this._htmlPopupView.removePopupEventListener((PopupEventListener)this);
        }
    }
}

