/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax.hcsgen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.hcs.syntax.hcsgen.AdditionalFunctionState;
import oracle.hcs.syntax.hcsgen.CategoryState;
import oracle.hcs.syntax.hcsgen.ChoiceArgumentState;
import oracle.hcs.syntax.hcsgen.ConditionArgumentState;
import oracle.hcs.syntax.hcsgen.DimensionArgumentState;
import oracle.hcs.syntax.hcsgen.FunctionState;
import oracle.hcs.syntax.hcsgen.GeneratorState;
import oracle.hcs.syntax.hcsgen.GroupArgumentState;
import oracle.hcs.syntax.hcsgen.HierarchyClauseState;
import oracle.hcs.syntax.hcsgen.IdentifierArgumentState;
import oracle.hcs.syntax.hcsgen.InitialState;
import oracle.hcs.syntax.hcsgen.KeywordArgumentState;
import oracle.hcs.syntax.hcsgen.SpecificationState;
import oracle.hcs.syntax.hcsgen.TypedExpressionArgumentState;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

class FunctionDescriptorGenerator
extends DefaultHandler {
    private static final boolean DBG = false;
    final InitialState INITIAL = new InitialState();
    final CategoryState CATEGORY = new CategoryState();
    final SpecificationState SPECIFICATION = new SpecificationState();
    final FunctionState ROW_FUNCTION = new FunctionState(0);
    final FunctionState OLAP_FUNCTION = new FunctionState(1);
    final FunctionState AGGREGATION_FUNCTION = new FunctionState(4);
    final FunctionState AGG_EXP_FUNCTION = new FunctionState(8);
    final FunctionState ALLOCATION_FUNCTION = new FunctionState(5);
    final FunctionState FORECAST_FUNCTION = new FunctionState(6);
    final FunctionState QUERY_FUNCTION = new FunctionState(2);
    final FunctionState CONDITION_FUNCTION = new FunctionState(3);
    final GroupArgumentState GROUP = new GroupArgumentState();
    final ChoiceArgumentState CHOICE = new ChoiceArgumentState();
    final TypedExpressionArgumentState EXPRESSION = new TypedExpressionArgumentState();
    final ConditionArgumentState CONDITION = new ConditionArgumentState();
    final KeywordArgumentState KEYWORD = new KeywordArgumentState();
    final IdentifierArgumentState IDENTIFIER = new IdentifierArgumentState();
    final DimensionArgumentState DIMENSION = new DimensionArgumentState();
    final HierarchyClauseState HIERARCHY_CLAUSE = new HierarchyClauseState();
    final AdditionalFunctionState ADDITIONAL_FUNCTION = new AdditionalFunctionState();
    private GeneratorState m_CurrentState = null;
    public int m_Indent = 0;
    private Map m_FunctionMap = new HashMap();
    private Map m_FunctionTypeMap = new HashMap();
    private Set m_Keywords = new HashSet();
    private StringBuffer m_CurrentBuffer = null;
    private StringBuffer m_CategoryBuffer = new StringBuffer();

    FunctionDescriptorGenerator() {
    }

    private final void debugPrint(String string) {
    }

    void addKeyword(String string) {
        this.m_Keywords.add(string);
    }

    private GeneratorState getCurrentState() {
        return this.m_CurrentState;
    }

    private void pushState(GeneratorState generatorState) {
        generatorState.setContext(this, this.m_CurrentState);
        this.m_CurrentState = generatorState;
    }

    private void popState() {
        this.m_CurrentState = this.m_CurrentState.getParent();
    }

    public void read(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        Object object;
        Object object2;
        String string10 = string + File.separator + string2;
        String string11 = string + File.separator + string3;
        String string12 = string + File.separator + string4;
        String string13 = string + File.separator + string5;
        String string14 = string + File.separator + string6;
        try {
            object2 = new File(string7);
            ((File)object2).mkdirs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        object2 = string7 + File.separator + string8;
        String string15 = string7 + File.separator + string9;
        this.pushState(this.INITIAL);
        this.setCurrentBuffer(this.getCategoryBuffer());
        this.importFile(string11);
        this.appendLine("{");
        this.incrementIndent();
        this.appendLine("/* ******PUBLIC STATIC MEMBERS******* */");
        this.setCurrentBuffer(new StringBuffer());
        try {
            object = new ParserAdapter((Parser)new SAXParser());
            object.setContentHandler(this);
            object.setErrorHandler(this);
            FileInputStream fileInputStream = new FileInputStream(string10);
            InputSource inputSource = new InputSource(fileInputStream);
            object.parse(inputSource);
            this.printInitializationCode();
            this.endFile(string12);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            object = new FileWriter((String)object2, false);
            ((Writer)object).write(this.getCategoryBuffer().toString());
            ((Writer)object).write(this.getCurrentBuffer().toString());
            ((OutputStreamWriter)object).close();
            this.setCurrentBuffer(new StringBuffer());
            this.importFile(string13);
            this.appendLine("{");
            this.incrementIndent();
            this.appendLine("/*******PUBLIC STATIC MEMBERS********/");
            this.declareKeywords();
            this.importFile(string14);
            this.appendLine("}");
            object = new FileWriter(string15, false);
            ((Writer)object).write(this.getCurrentBuffer().toString());
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private void beginFile(String string) {
        this.append("/* Copyright (c) 2006, Oracle. All rights reserved.  */");
        this.appendLine("/**");
        this.appendLine(" * This is a generated class.");
        this.appendLine(" * Do not modify it by hand.");
        this.appendLine(" * Modify FunctionDeclarations.xml and then execute 'fngen'.");
        this.appendLine(" **/");
        this.appendLine("package oracle.hcs.syntax;");
        this.newLine();
        this.appendLine("import java.util.Map;");
        this.appendLine("import java.util.HashMap;");
        this.newLine();
        this.appendLine("public final class ");
        this.append(string);
        this.appendLine("{ ");
        this.incrementIndent();
    }

    private void declareKeywords() {
        this.appendLine("/**");
        this.appendLine(" * A static constant <CODE>Map</CODE> that contains the keywords in this catalog as keys and has <CODE>KeywordArgument</CODE> objects as values.");
        this.appendLine("*/");
        this.appendLine("public static final Map<String, KeywordArgument> KEYWORD_MAP = new HashMap<String, KeywordArgument>();");
        this.newLine();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_Keywords);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            this.appendLine("/**");
            this.appendLine(" * A static constant <CODE>KeywordArgument</CODE> representing the keyword <CODE>");
            this.append(string);
            this.append("</CODE>.");
            this.appendLine(" */");
            this.appendLine("public static final KeywordArgument ");
            this.append(string);
            this.append(" = new KeywordArgument(\"");
            this.append(string);
            this.append("\");");
        }
        this.appendLine("static");
        this.appendLine("{");
        this.incrementIndent();
        this.appendLine("// Class initialization");
        for (String string : arrayList) {
            this.appendLine("KEYWORD_MAP.put(\"");
            this.append(string);
            this.append("\", ");
            this.append(string);
            this.append(");");
        }
        this.decrementIndent();
        this.appendLine("}");
        this.decrementIndent();
        this.appendLine("");
    }

    private void declareMap(String string) {
        this.appendLine("final static private Map ");
        this.append(string);
        this.append(" = new HashMap();");
    }

    private void printInitializationCode() {
        this.appendLine("/*******PRIVATE STATIC MEMBERS********/");
        this.declareMap("DESCRIPTOR_MAP");
        this.newLine();
        this.appendLine("static");
        this.appendLine("{");
        this.incrementIndent();
        this.appendLine("// Class initialization");
        this.printMapInitialization(this.m_FunctionMap, "DESCRIPTOR_MAP");
        this.decrementIndent();
        this.appendLine("}");
    }

    private void printMapInitialization(Map map, String string) {
        Set set = map.keySet();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(set);
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            List list = (List)map.get(string2);
            this.appendLine(string);
            this.append(".put(\"");
            this.append(string2);
            this.append("\", ");
            this.incrementIndent();
            this.appendLine("new FunctionDescriptor[] {");
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    this.append(", ");
                }
                this.append((String)iterator.next());
                bl = false;
            }
            this.append("}");
            this.decrementIndent();
            this.append(");");
        }
    }

    private void endFile(String string) throws IOException {
        this.appendLine("/*******INSTANCE MEMBERS**********/  ");
        this.appendLine("/********PRIVATE METHODS**********/  ");
        this.appendLine("// There is no need to create an instance of this ");
        this.appendLine("// class");
        this.appendLine("private FunctionDescriptorCatalog() {}");
        this.newLine();
        this.appendLine("/********HIDDEN METHODS**********/");
        this.appendLine("/********PUBLIC METHODS**********/");
        this.newLine();
        this.importFile(string);
        this.decrementIndent();
        this.appendLine("}");
    }

    private void importFile(String string) {
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (null != (string2 = bufferedReader.readLine())) {
                this.appendLine(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.debugPrint("enter " + string2);
        GeneratorState generatorState = this.getCurrentState().transition(string2, attributes);
        this.pushState(generatorState);
        this.getCurrentState().initialize(attributes);
        this.debugPrint("done");
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.debugPrint("exit " + string2);
        this.getCurrentState().exit();
        this.popState();
        this.debugPrint("done");
    }

    void addFunction(String string, String string2) {
        Object object = this.m_FunctionMap.get(string);
        if (null == object) {
            object = new ArrayList();
            this.m_FunctionMap.put(string, object);
        }
        List list = (List)object;
        list.add(string2);
    }

    void addFunctionType(String string, String string2) {
        String[] stringArray = string.split("\\s");
        ArrayList arrayList = null;
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList = (ArrayList)this.m_FunctionTypeMap.get(stringArray[i]);
            if (null != arrayList) continue;
            arrayList = new ArrayList();
            this.m_FunctionTypeMap.put(stringArray[i], arrayList);
        }
        List list = arrayList;
        if (list.contains(string2)) {
            return;
        }
        list.add(string2);
    }

    StringBuffer getCategoryBuffer() {
        return this.m_CategoryBuffer;
    }

    StringBuffer getCurrentBuffer() {
        return this.m_CurrentBuffer;
    }

    void setCurrentBuffer(StringBuffer stringBuffer) {
        this.m_CurrentBuffer = stringBuffer;
    }

    public void append(String string) {
        this.getCurrentBuffer().append(string);
    }

    public void appendLine(String string) {
        if (null == string) {
            return;
        }
        this.newLineAndIndent();
        this.append(string);
    }

    public void incrementIndent() {
        ++this.m_Indent;
    }

    public void decrementIndent() {
        --this.m_Indent;
    }

    public void newLine() {
        this.append("\n");
    }

    public void newLineAndIndent() {
        this.newLine();
        for (int i = 0; i < this.m_Indent; ++i) {
            this.append("  ");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 9) {
            System.err.println("Usage: FunctionDescriptorGenerator <syntax dir> <xml filename> <function catalog header filename> <public method filename>  <keyword catalog header> <keyword catalog public> <output dir> <output function file> <output keyword file>");
            return;
        }
        new FunctionDescriptorGenerator().read(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], stringArray[8]);
    }
}

