/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.FunctionDescriptorArgument;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.ValidationContext;

public final class FunctionDescriptor {
    public static final int PSEUDO_COLUMN_FUNCTION = 1;
    public static final int ROW_FUNCTION = 2;
    public static final int OLAP_FUNCTION = 4;
    public static final int OLAP_HIER_FUNCTION = 8;
    public static final int AGGREGATION_FUNCTION = 16;
    public static final int ALLOCATION_FUNCTION = 32;
    public static final int FORECAST_FUNCTION = 64;
    public static final int CONDITION_FUNCTION = 128;
    public static final int QUERY_FUNCTION = 256;
    public static final int AGGREGATION_EXPRESSION_FUNCTION = 512;
    private FunctionDescriptorArgument[] m_Arguments;
    private String m_Name;
    private String m_Category;
    private boolean m_AWFunction;
    private DataType m_ReturnType;
    private int m_FunctionType;
    private boolean m_PseudoColumn;
    private FunctionDescriptorArgument[] m_HierarchyArguments;

    private FunctionDescriptorArgument[] getHierarchyArgumentsInternal() {
        return this.m_HierarchyArguments;
    }

    protected FunctionDescriptorArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    FunctionDescriptor(String string, int n, DataType dataType, String string2, boolean bl, boolean bl2, FunctionDescriptorArgument[] functionDescriptorArgumentArray, FunctionDescriptorArgument[] functionDescriptorArgumentArray2) {
        this.m_Name = string;
        this.m_AWFunction = bl;
        this.m_Category = string2;
        this.m_Arguments = functionDescriptorArgumentArray;
        this.m_ReturnType = dataType;
        this.m_FunctionType = n;
        this.m_PseudoColumn = bl2;
        this.m_HierarchyArguments = functionDescriptorArgumentArray2;
    }

    void toSyntax(StringBuffer stringBuffer) {
        stringBuffer.append(this.getFunctionName());
        FunctionDescriptorArgument.printArguments(this.getArgumentsInternal(), stringBuffer);
    }

    public boolean validate(FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2, FunctionArgument[] functionArgumentArray3, FunctionArgument[] functionArgumentArray4, ValidationContext validationContext) {
        int n;
        validationContext.setCurrentDataType(this.getFunctionReturnType());
        int n2 = 0;
        if (null != functionArgumentArray) {
            n2 = functionArgumentArray.length;
        }
        if ((n = FunctionDescriptorArgument.validateList(functionArgumentArray, functionArgumentArray2, this.getArgumentsInternal(), validationContext, 0)) != n2) {
            return false;
        }
        n2 = 0;
        if (null != functionArgumentArray3) {
            n2 = functionArgumentArray3.length;
        }
        return (n = FunctionDescriptorArgument.validateList(functionArgumentArray3, functionArgumentArray4, this.getHierarchyArgumentsInternal(), validationContext, 0)) == n2;
    }

    void throwUsageException() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toSyntax(stringBuffer);
        throw new SyntaxException("InvalidArguments", stringBuffer.toString());
    }

    public final String getFunctionName() {
        return this.m_Name;
    }

    public final String getCategory() {
        return this.m_Category;
    }

    public final boolean isAWFunction() {
        return this.m_AWFunction;
    }

    public final FunctionDescriptorArgument[] getArguments() {
        return (FunctionDescriptorArgument[])this.m_Arguments.clone();
    }

    public final DataType getFunctionReturnType() {
        return this.m_ReturnType;
    }

    public int getFunctionType() {
        return this.m_FunctionType;
    }

    public boolean isPseudoColumn() {
        return this.m_PseudoColumn;
    }
}

