/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.cache;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroupNode;
import oracle.hcs.av.panels.cache.AVCacheController;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class AVLevelGroupEditorCachePanel
extends JPanel {
    private DBObjectProvider prov;
    private AnalyticView analyticView;
    private AVCacheLevelGroupNode levelGroupNode;
    private AVCacheController cacheController;
    private DefaultTableModel levelGroupTableModel;
    private JTable levelGroupTable;
    private JButton addButton;
    private JButton removeButton;
    private ComponentWithTitlebar<JScrollPane> levelGroupTableContainer;
    private List<String> allDimensionHierarchyAliases = new ArrayList<String>();
    private JComboBox<String> dimensionHierarchyAliasComboBox;
    private DefaultComboBoxModel<String> dimensionHierarchyAliasComboBoxModel;
    private JComboBox<String> levelComboBox;
    private DefaultComboBoxModel<String> levelComboBoxModel;
    private ButtonGroup levelGroupProcessingOption;
    private static final int DIMENSION_HIERARCHY_ALIAS_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private boolean isAdding;
    private boolean isInitializing;

    public AVLevelGroupEditorCachePanel() {
        this.layoutComponents();
    }

    protected void initializePanel(AnalyticView analyticView, AVCacheLevelGroupNode aVCacheLevelGroupNode, AVCacheController aVCacheController, DBObjectProvider dBObjectProvider) {
        this.analyticView = analyticView;
        this.levelGroupNode = aVCacheLevelGroupNode;
        this.cacheController = aVCacheController;
        this.prov = dBObjectProvider;
        this.isInitializing = true;
        this.allDimensionHierarchyAliases.clear();
        TableColumn tableColumn = this.levelGroupTable.getColumnModel().getColumn(0);
        this.dimensionHierarchyAliasComboBoxModel = new DefaultComboBoxModel();
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            String string = dBObjectProvider.getExternalName(aVDimensionality.getDimensionAlias());
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                String string2 = dBObjectProvider.getExternalName(aVHierarchy.getHierarchyAlias());
                this.dimensionHierarchyAliasComboBoxModel.addElement(string + "." + string2);
                this.allDimensionHierarchyAliases.add(string + "." + string2);
            }
        }
        this.dimensionHierarchyAliasComboBox = new JComboBox<String>(this.dimensionHierarchyAliasComboBoxModel);
        tableColumn.setCellEditor(new DimensionHierarchyAliasCellEditor(this.dimensionHierarchyAliasComboBox));
        TableColumn tableColumn2 = this.levelGroupTable.getColumnModel().getColumn(1);
        this.levelComboBoxModel = new DefaultComboBoxModel();
        this.levelComboBox = new JComboBox<String>(this.levelComboBoxModel);
        tableColumn2.setCellEditor(new LevelCellEditor(this.levelComboBox));
        List<String> list = aVCacheLevelGroupNode.getLevelTuple();
        int n = 0;
        for (String string : list) {
            String string3 = AVCacheLevelGroupNode.getDimensionHierarchyAlias(string);
            String string4 = AVCacheLevelGroupNode.getLevelName(string);
            this.levelGroupTableModel.addRow(new Object[]{string3, string4});
            ++n;
        }
        if (n > 0) {
            this.levelGroupTable.setRowSelectionInterval(0, 0);
        }
        this.updateAddAndRemoveButtonsEnabled();
        this.isInitializing = false;
    }

    public void stopCellEditing() {
        if (this.levelGroupTable != null) {
            for (int i = 0; i < this.levelGroupTable.getColumnCount(); ++i) {
                DefaultCellEditor defaultCellEditor;
                TableColumn tableColumn = this.levelGroupTable.getColumnModel().getColumn(i);
                int n = tableColumn.getModelIndex();
                if (n == 0) {
                    defaultCellEditor = (DimensionHierarchyAliasCellEditor)tableColumn.getCellEditor();
                    ((DimensionHierarchyAliasCellEditor)defaultCellEditor).stopCellEditing2();
                    continue;
                }
                if (n != 1) continue;
                defaultCellEditor = (LevelCellEditor)tableColumn.getCellEditor();
                ((LevelCellEditor)defaultCellEditor).stopCellEditing2();
            }
        }
    }

    public void removeUI() {
        this.stopCellEditing();
        if (this.levelGroupTableContainer != null) {
            this.remove((Component)this.levelGroupTableContainer);
            this.levelGroupTableContainer = null;
        }
    }

    private void updateAddAndRemoveButtonsEnabled() {
        if (this.levelGroupTable.getRowCount() > 1) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        if (this.levelGroupTable.getRowCount() == this.allDimensionHierarchyAliases.size()) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    private void updateNodeModel() {
        if (this.isInitializing) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.levelGroupTable.getRowCount(); ++i) {
            String string = (String)this.levelGroupTableModel.getValueAt(i, 0) + "." + (String)this.levelGroupTableModel.getValueAt(i, 1);
            if (string.length() < 2) {
                return;
            }
            arrayList.add(string);
        }
        this.levelGroupNode.setLevelTuple(arrayList);
        this.cacheController.update(this.levelGroupNode);
    }

    public void processAdd() {
        this.isAdding = true;
        String string = this.levelGroupNode.getNextAvailableDimensionHierarchyAlias();
        String string2 = this.levelGroupNode.getNextAvailableLevelName();
        this.levelGroupTableModel.addRow(new Object[]{string, string2});
        int n = this.levelGroupTableModel.getRowCount() - 1;
        this.levelGroupTable.setRowSelectionInterval(n, n);
        this.updateAddAndRemoveButtonsEnabled();
        this.isAdding = false;
        this.updateNodeModel();
    }

    public void processRemove() {
        int n = this.levelGroupTable.getSelectedRow();
        if (n > -1) {
            this.stopCellEditing();
            this.levelGroupTableModel.removeRow(n);
            this.updateNodeModel();
            if (this.levelGroupTable.getRowCount() > 0) {
                int n2 = this.levelGroupTable.getRowCount() - 1;
                if (n > n2) {
                    this.levelGroupTable.setRowSelectionInterval(n2, n2);
                } else {
                    this.levelGroupTable.setRowSelectionInterval(n, n);
                }
            }
            this.updateAddAndRemoveButtonsEnabled();
        }
    }

    protected void layoutComponents() {
        this.levelGroupTableModel = new DefaultTableModel();
        this.levelGroupTableModel.setColumnIdentifiers(new String[]{HCSArb.getString("AV_LEVEL_GROUP_EDITOR_DIM_AND_HIER_ALIAS_LABEL"), HCSArb.getString("AV_LEVEL_GROUP_EDITOR_LEVEL_LABEL")});
        this.levelGroupTable = new JTable(this.levelGroupTableModel);
        this.levelGroupTable.setSelectionMode(0);
        ControlBar controlBar = new ControlBar();
        this.addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addButton.setToolTipText(HCSArb.getString("AV_CACHE_LEVEL_GROUP_ADD_BUTTON_TOOLTIP"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AVLevelGroupEditorCachePanel.this.processAdd();
            }
        });
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(HCSArb.getString("AV_CACHE_LEVEL_GROUP_REMOVE_BUTTON_TOOLTIP"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AVLevelGroupEditorCachePanel.this.processRemove();
            }
        });
        controlBar.add((Component)this.addButton);
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        controlBar.add((Component)this.removeButton);
        this.levelGroupTableContainer = new ComponentWithTitlebar();
        this.levelGroupTableContainer.setLabel(new JLabel(HCSArb.getString("AV_LEVEL_GROUP_EDITOR_LEVEL_TUPLE_DETAILS_LABEL")));
        this.levelGroupTableContainer.setControlBar(controlBar);
        JScrollPane jScrollPane = new JScrollPane(this.levelGroupTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.levelGroupTableContainer.setComponent((JComponent)jScrollPane);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)this.levelGroupTableContainer, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 0, 2), 0, 0));
    }

    private class DimensionHierarchyAliasCellEditor
    extends DefaultCellEditor {
        int row;
        int column;
        String originalDimensionAlias;

        public DimensionHierarchyAliasCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.originalDimensionAlias = (String)AVLevelGroupEditorCachePanel.this.levelGroupTableModel.getValueAt(n, 0);
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < AVLevelGroupEditorCachePanel.this.levelGroupTable.getRowCount(); ++i) {
                if (i == n) continue;
                arrayList.add((String)AVLevelGroupEditorCachePanel.this.levelGroupTableModel.getValueAt(i, 0));
            }
            AVLevelGroupEditorCachePanel.this.isInitializing = true;
            AVLevelGroupEditorCachePanel.this.dimensionHierarchyAliasComboBoxModel.removeAllElements();
            for (String string : AVLevelGroupEditorCachePanel.this.allDimensionHierarchyAliases) {
                if (arrayList.contains(string)) continue;
                AVLevelGroupEditorCachePanel.this.dimensionHierarchyAliasComboBoxModel.addElement(string);
            }
            AVLevelGroupEditorCachePanel.this.isInitializing = false;
            jComboBox.setSelectedItem(this.originalDimensionAlias);
            return jComboBox;
        }

        @Override
        public boolean stopCellEditing() {
            String string;
            String string2;
            if (!(AVLevelGroupEditorCachePanel.this.isInitializing || (string2 = (String)AVLevelGroupEditorCachePanel.this.levelGroupTableModel.getValueAt(this.row, 0)) == null || string2.isEmpty() || AVLevelGroupEditorCachePanel.this.isAdding || (string = (String)AVLevelGroupEditorCachePanel.this.dimensionHierarchyAliasComboBox.getSelectedItem()) == null || string.isEmpty() || string.equalsIgnoreCase(this.originalDimensionAlias))) {
                List<String> list = AVLevelGroupEditorCachePanel.this.levelGroupNode.getLevelNames(string);
                AVLevelGroupEditorCachePanel.this.levelComboBoxModel.removeAllElements();
                for (String string3 : list) {
                    AVLevelGroupEditorCachePanel.this.levelComboBoxModel.addElement(string3);
                }
                AVLevelGroupEditorCachePanel.this.levelComboBox.setSelectedIndex(0);
                String string4 = (String)AVLevelGroupEditorCachePanel.this.levelComboBox.getSelectedItem();
                AVLevelGroupEditorCachePanel.this.levelGroupTableModel.setValueAt(string4, this.row, 1);
            }
            boolean bl = super.stopCellEditing();
            if (!AVLevelGroupEditorCachePanel.this.isInitializing) {
                AVLevelGroupEditorCachePanel.this.updateNodeModel();
            }
            return bl;
        }

        public boolean stopCellEditing2() {
            return super.stopCellEditing();
        }
    }

    private class LevelCellEditor
    extends DefaultCellEditor {
        public LevelCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            String string = (String)AVLevelGroupEditorCachePanel.this.levelGroupTableModel.getValueAt(n, 0);
            String string2 = (String)AVLevelGroupEditorCachePanel.this.levelGroupTableModel.getValueAt(n, 1);
            boolean bl2 = false;
            List<String> list = AVLevelGroupEditorCachePanel.this.levelGroupNode.getLevelNames(string);
            AVLevelGroupEditorCachePanel.this.levelComboBoxModel.removeAllElements();
            for (String string3 : list) {
                AVLevelGroupEditorCachePanel.this.levelComboBoxModel.addElement(string3);
                if (!string2.equalsIgnoreCase(string3)) continue;
                bl2 = true;
            }
            if (bl2) {
                AVLevelGroupEditorCachePanel.this.levelComboBox.setSelectedItem(string2);
            } else {
                AVLevelGroupEditorCachePanel.this.levelComboBox.setSelectedIndex(0);
            }
            return jComboBox;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = super.stopCellEditing();
            AVLevelGroupEditorCachePanel.this.updateNodeModel();
            return bl;
        }

        public boolean stopCellEditing2() {
            return super.stopCellEditing();
        }
    }
}

