/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.impl.ChildFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AVValidationAction;
import oracle.hcs.av.calcs.CalculatedMeasurePinningTracker;
import oracle.hcs.av.calcs.CalculatedMeasureShowCompilePage;
import oracle.hcs.av.calcs.DockableSpecTree;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureBufferPinning;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.hcs.navigator.CalculatedMeasureRefreshNodeListener;
import oracle.hcs.syntaxbuilder.HCSSyntaxHandler;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureClassifications;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureDependencies;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureReferences;
import oracle.hcs.syntaxbuilder.language.HCSLanguageModule;
import oracle.hcs.templates.templateview.TemplateData;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeListener;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.javatools.editor.BasicEditorPane;

public class HCSCalculatedMeasureAddin
implements Addin {
    public static final String VIEW_TYPE = "CALC_MEASURE_VIEW_TYPE";
    private AVValidationAction avValidation;
    private String INVALID = "INVALID";
    private static Logger LOG = Logger.getLogger(HCSCalculatedMeasureAddin.class.getName());
    private EditorListener refreshOnActivate = new EditorListener(){

        private void checkSchema(Editor editor, String string) {
            if (editor.getContext() != null && editor.getContext().getNode() != null && editor.getContext().getNode() instanceof CalculatedMeasureNode) {
                CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)editor.getContext().getNode();
                PlSqlFeatures.setSupportedBreadcrumbs((boolean)calculatedMeasureNode.isBreadcrumbsOn());
                PlSqlFeatures.setSupportedGutterNavigation((boolean)calculatedMeasureNode.isGutterNavOn());
                if (!HCSMetadataCache.hasForConnection(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName())) {
                    LOG.finest(String.format("editor for calc %s %s withOUT a valid cache", string, calculatedMeasureNode.getMeasureName()));
                    HCSCalculatedMeasureAddin.this.doUpdate(calculatedMeasureNode, editor);
                } else {
                    LOG.finest(String.format("editor for calc %s %s WITH a valid cache", string, calculatedMeasureNode.getMeasureName()));
                }
            }
        }

        public void editorOpened(Editor editor) {
            this.checkSchema(editor, "opened");
        }

        public void editorActivated(Editor editor) {
            this.checkSchema(editor, "activated");
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    };
    private Controller refreshController = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (context.getNode() instanceof CalculatedMeasureNode && context.getView() instanceof CodeEditor) {
                CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)context.getNode();
                HCSMetadataCache.removeSchema(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName());
                HCSCalculatedMeasureAddin.this.doUpdate(calculatedMeasureNode, (Editor)((CodeEditor)context.getView()));
                return true;
            }
            if (HCSCalculatedMeasureAddin.this.isHCS(context.getElement())) {
                String string = "";
                String string2 = "";
                try {
                    URL uRL = ((DatabaseElement)context.getElement()).getURL();
                    string = DBURLFormatHelper.getCatalogSchema((URL)uRL);
                    string2 = DBURLFormatHelper.getConnectionName((URL)uRL);
                    HCSMetadataCache.removeSchema(string2, string);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, String.format("Error removing schema %s for connection %s", string, string2), throwable);
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    };
    private ConnectionListener discardOnDisconnect = new ConnectionListener(){

        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            HCSMetadataCache.removeSchemas(string);
            DockableSpecTree.getInstance().removeSpecs(string);
        }
    };
    private static final HashSet<String> NODE_TYPES = new HashSet();

    public void initialize() {
        new HCSLanguageModule();
        CodeEditor.registerNodeType(CalculatedMeasureNode.class, (String)"hcsexp");
        TemplateData.Mode.setTranslations();
        EditorManager.getEditorManager().addEditorListener((EditorListener)DockableSpecTree.getInstance());
        EditorManager.getEditorManager().addEditorListener((EditorListener)new CalculatedMeasureShowCompilePage());
        CodeEditor.createHighlightStyle((String)"hcssyntaxbuilder.squiggly", (String)HCSArb.getString("EXPRESSION_EDITOR_SQUIGLY_STYLE"), (int)2, null, null, (int)0, (int)4, (Color)Color.RED);
        Color color = new Color(111, 152, 203);
        CodeEditor.createHighlightStyle((String)"hcssyntaxbuilder.inner_selection", (String)HCSArb.getString("EXPRESSION_EDITOR_INNER_SELECTION_STYLE"), (int)101, null, (Color)color);
        HCSCalculatedMeasureAddin.registerEditor(HCSArb.getString("CREATE_DERIVED_MEASURE_DIALOG.REFERENCES_TAB"), CalculatedMeasureReferences.class);
        HCSCalculatedMeasureAddin.registerEditor(HCSArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB"), CalculatedMeasureDependencies.class);
        HCSCalculatedMeasureAddin.registerEditor(HCSArb.getString("CLASSIFICATIONS_LABEL_TITLE"), CalculatedMeasureClassifications.class);
        IdeActions.getViewRefreshAction().addController(this.refreshController);
        EditorManager.getEditorManager().addEditorListener(this.refreshOnActivate);
        Connections.getInstance().addConnectionListener(this.discardOnDisconnect);
        EditorManager.getEditorManager().addEditorListener((EditorListener)new CalculatedMeasurePinningTracker());
        Node.addNodeListenerForType(CalculatedMeasureNode.class, (NodeListener)new CalculatedMeasureBufferPinning());
        Node.addNodeListenerForType(CalculatedMeasureNode.class, (NodeListener)new CalculatedMeasureRefreshNodeListener());
        this.avValidation = new AVValidationAction();
    }

    private boolean isHCS(Element element) {
        String string = null;
        if (element instanceof ObjectFolder) {
            string = ((ObjectFolder)element).getObjectType();
        } else if (element instanceof ChildFolder) {
            string = ((ChildFolder)element).getObjectType();
        } else if (element instanceof ObjectNode) {
            string = ((ObjectNode)element).getObjectType();
        }
        return string != null && NODE_TYPES.contains(string);
    }

    private void doUpdate(final CalculatedMeasureNode calculatedMeasureNode, final Editor editor) {
        CodeEditor codeEditor = null;
        if (editor instanceof CodeEditor) {
            codeEditor = (CodeEditor)editor;
        }
        final CodeEditor codeEditor2 = codeEditor;
        RaptorTask<HCSSchema> raptorTask = new RaptorTask<HCSSchema>(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected HCSSchema doWork() {
                HCSSchema hCSSchema = null;
                try {
                    hCSSchema = HCSMetadataCache.getUpdatedSchema(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName());
                    if (editor != null) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        Toolbar toolbar = codeEditor2.getToolbar();
                        JCheckBox jCheckBox = HCSCalculatedMeasureAddin.this.getForceCreateCalcCheckBox(toolbar);
                        if (jCheckBox != null) {
                            object5 = Connections.getInstance().getConnection(calculatedMeasureNode.getConnectionName());
                            object4 = DBUtil.getInstance((Connection)object5);
                            object3 = calculatedMeasureNode.getAVName();
                            object = HCSCalculatedMeasureAddin.this.avValidation.isAVValid((String)object3, (String)(object2 = calculatedMeasureNode.getSchemaName()), (DBUtil)object4);
                            if (object != null) {
                                jCheckBox.setSelected(((String)object).equals(HCSCalculatedMeasureAddin.this.INVALID));
                                calculatedMeasureNode.setForceCreate(jCheckBox.isSelected());
                            }
                        }
                        object5 = codeEditor2.getFocusedEditorPane();
                        object4 = hCSSchema.findAV(calculatedMeasureNode.getAVName());
                        if (object4 != null && object5 != null && (object3 = ((AnalyticView)object4).findBaseMeasure(calculatedMeasureNode.getMeasureName())) != null) {
                            object2 = HCSCalculatedMeasureAddin.this.buildProperties(calculatedMeasureNode);
                            object = new HCSSyntaxParser(hCSSchema, (Properties)object2);
                            String string = HCSSyntaxHandler.format(hCSSchema.getName(), ((AVBaseMeasure)object3).getExpression());
                            String string2 = ((HCSSyntaxParser)object).formatSyntax(string);
                            if (!object5.getText().equals(string2) && !calculatedMeasureNode.isDirty()) {
                                if (((HCSSyntaxParser)object).parseSyntax(string2, null)) {
                                    object5.setText(string2);
                                } else {
                                    object5.setText(string);
                                }
                                calculatedMeasureNode.markDirty(false);
                            }
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ BasicEditorPane val$pane;
                                final /* synthetic */ String val$formatted;
                                final /* synthetic */ HCSSyntaxParser val$parser;
                                final /* synthetic */ String val$expression;
                                {
                                    this.val$pane = basicEditorPane;
                                    this.val$formatted = string;
                                    this.val$parser = hCSSyntaxParser;
                                    this.val$expression = string2;
                                }

                                @Override
                                public void run() {
                                    int n = 1;
                                    if (calculatedMeasureNode.isDirty()) {
                                        n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), HCSArb.getString("EXPRESSION_EDITOR_RELOAD_EXPRESSION"), HCSArb.getString("EXPRESSION_EDITOR_RELOAD_EXPRESSION_TITLE"), 0);
                                    }
                                    if (n == 0 || !this.val$pane.getText().equals(this.val$formatted) && !calculatedMeasureNode.isDirty()) {
                                        if (this.val$parser.parseSyntax(this.val$formatted, null)) {
                                            this.val$pane.setText(this.val$formatted);
                                        } else {
                                            this.val$pane.setText(this.val$expression);
                                        }
                                        calculatedMeasureNode.markDirty(false);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, String.format("Error fetching metadata for Connection %s and schema %s", calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName()), exception);
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setMessage(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private Properties buildProperties(CalculatedMeasureNode calculatedMeasureNode) {
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", calculatedMeasureNode.getSchemaName());
        properties.setProperty("CUBE", calculatedMeasureNode.getAVName());
        properties.setProperty("CONTEXT", "MEASURE_EXPRESSION");
        return properties;
    }

    private JCheckBox getForceCreateCalcCheckBox(Toolbar toolbar) {
        for (int i = 0; i < toolbar.getComponentCount(); ++i) {
            String string = toolbar.getComponent(i).getName();
            if (!(toolbar.getComponent(i) instanceof JCheckBox) || !string.equals("ForceCreateCalcCheckBox")) continue;
            return (JCheckBox)toolbar.getComponent(i);
        }
        return null;
    }

    public static void registerEditor(final String string, final Class<? extends Editor> clazz) {
        EditorAddin editorAddin = new EditorAddin(){

            public Class<? extends Editor> getEditorClass() {
                return clazz;
            }

            public MenuSpec getMenuSpecification() {
                return new MenuSpec(string, null);
            }

            public boolean isDefault() {
                return false;
            }

            public float getEditorWeight(Element element) {
                if (element instanceof CalculatedMeasureNode) {
                    return 0.0f;
                }
                return Float.NaN;
            }
        };
        EditorManager.getEditorManager().registerDynamic(editorAddin);
    }

    static {
        NODE_TYPES.add("HCSAVMEASURE");
        NODE_TYPES.add("HCSCALCMEASURE");
        NODE_TYPES.add("ANALYTIC VIEW");
        NODE_TYPES.add("ATTRIBUTE DIMENSION");
        NODE_TYPES.add("HIERARCHY");
        NODE_TYPES.add("HCSHIERARCHYLEVEL");
    }
}

