/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.OpenOracleConnectionComboBox;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;

public class TargetChooserToolbar
implements IModifyToolbar {
    static String _defaultConn = null;

    public void modifyToolbar(Toolbar toolbar) {
        this.addConnectionCombo(toolbar, true);
    }

    protected void addConnectionCombo(Toolbar toolbar, boolean bl) {
        Object object;
        toolbar.addSeparator();
        if (bl) {
            toolbar.add(Box.createHorizontalGlue());
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setOpaque(false);
            toolbar.add((Component)object);
            ((JComponent)object).setVisible(false);
        }
        toolbar.add((Component)new JLabel(MigrationProjectNavigatorArb.getString("TARGET")));
        toolbar.add(Box.createHorizontalStrut(10));
        object = new OpenOracleConnectionComboBox();
        String string = TargetChooserToolbar.getDefaultConn();
        if (string != null) {
            try {
                this.validateConnection(string);
                object.setCurrentConnection(string);
            }
            catch (DBException dBException) {
                _defaultConn = null;
                Preferences preferences = Preferences.getPreferences();
                MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                migrationConfig.setTargetConn(null);
            }
        }
        JComboBox jComboBox = object.getJComboBox();
        jComboBox.addItemListener(new ConnComboListener((DBConnectionComboBox)object));
        jComboBox.setToolTipText(MigrationProjectNavigatorArb.getString("TARGET_TIP"));
        toolbar.add((Component)jComboBox);
    }

    protected void validateConnection(String string) throws DBException {
    }

    public static String getDefaultConn() {
        return _defaultConn;
    }

    public void modifyToolbar(Toolbar toolbar, Map<String, Object> map) {
        this.modifyToolbar(toolbar);
    }

    private class ConnComboListener
    implements ItemListener {
        private DBConnectionComboBox _combo;

        public ConnComboListener(DBConnectionComboBox dBConnectionComboBox) {
            this._combo = dBConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string;
                _defaultConn = string = (String)itemEvent.getItem();
                try {
                    Connection connection = Connections.getInstance().getConnection(string, true);
                    Preferences preferences = Preferences.getPreferences();
                    MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                    migrationConfig.setTargetConn(_defaultConn);
                }
                catch (Exception exception) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getLocalizedMessage(), (String)MigrationProjectNavigatorArb.getString("ERROR_CONNECTING"), null);
                    _defaultConn = null;
                }
            }
        }
    }
}

