/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.ui.GenerateDialogTaskUI;
import oracle.dbtools.migration.workbench.core.ui.GenerateRunnerTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.Assert;

public class GenerateInitiator
extends AbstractMenuAction {
    private URL m_url;

    public void launch() {
        Context context = this.getContext();
        MdConnection mdConnection = MigrationUtils.getMdConnection(context);
        try {
            GenerationOutputStream generationOutputStream = this.createPrintStream();
            MigrationObjectFilterList migrationObjectFilterList = MigrationFilterUtil.generateFilters(context);
            GenerateWorker generateWorker = new GenerateWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), generationOutputStream, migrationObjectFilterList);
            URL uRL = this.m_url;
            if (MigrationAddin.getMigrationConfig().getFileOutputOption() == 2) {
                uRL = null;
            }
            GenerateRunnerTask generateRunnerTask = new GenerateRunnerTask(generateWorker, uRL, mdConnection.getName());
            final GenerateDialogTaskUI generateDialogTaskUI = new GenerateDialogTaskUI(generateRunnerTask.getDescriptor());
            generateWorker.addEventListener(generateDialogTaskUI);
            RaptorTaskManager.getInstance().addTask((RaptorTask)generateRunnerTask, Collections.singletonList(new ITaskViewer(){

                public void addTaskUI(ITaskUI iTaskUI) {
                }

                public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return generateDialogTaskUI;
                }

                public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return this.getTaskUI(raptorTaskDescriptor);
                }

                public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void removeTaskUI(ITaskUI iTaskUI) {
                }
            }));
        }
        catch (Exception exception) {
            Assert.printStackTrace((Throwable)exception);
        }
    }

    public void setArgs(String string) {
    }

    private GenerationOutputStream createPrintStream() throws IOException, UnsupportedEncodingException {
        File file = File.createTempFile(Messages.getString("GenerateInitiator.0"), ".sql");
        file.deleteOnExit();
        this.m_url = file.toURL();
        SimpleGenerationOutputStream simpleGenerationOutputStream = null;
        String string = Ide.getEnvironOptions().getEncoding();
        simpleGenerationOutputStream = string == null ? new SimpleGenerationOutputStream(new PrintStream(file)) : new SimpleGenerationOutputStream(new PrintStream(file, string));
        return simpleGenerationOutputStream;
    }
}

