/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdAdditionalPropertie;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class AdditionalPropertyCache {
    private static final String RETRIEVE_ADDITIONAL_PROPERTIES_QUERY = "SELECT REF_ID_FK, PROP_KEY, VALUE, PROPERTY_ORDER, CONNECTION_ID_FK FROM MD_ADDITIONAL_PROPERTIES  WHERE CONNECTION_ID_FK = ? ORDER BY PROPERTY_ORDER";
    private static final String RETRIEVE_ADDITIONAL_PROPERTIES_QUERY_NO_CONNECTIONID = "SELECT REF_ID_FK, PROP_KEY, VALUE, PROPERTY_ORDER, CONNECTION_ID_FK FROM MD_ADDITIONAL_PROPERTIES  ORDER BY PROPERTY_ORDER";
    private static final String REMOVE_PROPERTIES_QUERY = "DELETE FROM MD_ADDITIONAL_PROPERTIES WHERE REF_ID_FK=?";
    HashMap<Long, ArrayList<AdditionalProperty>> _additionalPropertyMap = null;
    DBObjectId _connectionId = null;
    PersistenceManager _pm = null;

    public AdditionalPropertyCache(PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        this._pm = persistenceManager;
        this._connectionId = dBObjectId;
        try {
            if (this._additionalPropertyMap == null) {
                this._additionalPropertyMap = new HashMap();
                this.initAdditionalProperties();
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    private void initAdditionalProperties() throws PersistenceException {
        try (CloseableResultSet closeableResultSet = null;){
            PreparedStatement preparedStatement;
            if (this._connectionId != null) {
                preparedStatement = this._pm.getPreparedStatement(RETRIEVE_ADDITIONAL_PROPERTIES_QUERY);
                preparedStatement.setLong(1, this._connectionId.getId());
            } else {
                preparedStatement = this._pm.getPreparedStatement(RETRIEVE_ADDITIONAL_PROPERTIES_QUERY_NO_CONNECTIONID);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                AdditionalProperty additionalProperty = new AdditionalProperty(resultSet.getString(2), resultSet.getString(3), resultSet.getLong(5));
                long l = resultSet.getLong(1);
                ArrayList<AdditionalProperty> arrayList = this._additionalPropertyMap.get(l);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(additionalProperty);
                this._additionalPropertyMap.put(l, arrayList);
            }
        }
    }

    public void removeExistingAdditionalProperties(DBObjectId dBObjectId) throws PersistenceException {
        try {
            PreparedStatement preparedStatement = this._pm.getPreparedStatement(REMOVE_PROPERTIES_QUERY);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public void saveAdditionalProperties(ArrayList<AdditionalProperty> arrayList, DBObjectId dBObjectId, String string, DBObjectId dBObjectId2) throws PersistenceException {
        this.removeExistingAdditionalProperties(dBObjectId2);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        for (AdditionalProperty additionalProperty : arrayList) {
            MdAdditionalPropertie mdAdditionalPropertie = new MdAdditionalPropertie(dBObjectId, dBObjectId2, string, additionalProperty.getKey());
            mdAdditionalPropertie.setPropertyOrder(n++);
            mdAdditionalPropertie.setValue(additionalProperty.getValue());
            mdAdditionalPropertie.save(this._pm);
        }
    }

    public ArrayList<AdditionalProperty> retrieveAdditionalProperties(DBObjectId dBObjectId) {
        return this._additionalPropertyMap.get(dBObjectId.getId());
    }
}

