/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.nq;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.parser.QuadHandler;
import oracle.spatial.rdf.server.parser.nq.NquadsParserConstants;
import oracle.spatial.rdf.server.parser.nq.NquadsParserTokenManager;
import oracle.spatial.rdf.server.parser.nq.ParseException;
import oracle.spatial.rdf.server.parser.nq.SimpleCharStream;
import oracle.spatial.rdf.server.parser.nq.Token;

public class NquadsParser
implements NquadsParserConstants {
    private QuadHandler qh;
    public NquadsParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[9];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static NquadsParser getParser() {
        return new NquadsParser((Reader)null);
    }

    public void parse(InputStream inputStream, QuadHandler quadHandler) throws ParseException {
        try {
            this.qh = quadHandler;
            this.qh.init();
            this.ReInit(inputStream);
            this.Input();
            this.qh.commit();
        }
        catch (RDFException rDFException) {
            throw new ParseException(rDFException.getMessage());
        }
    }

    private String canonicalizeToEscaped(String string) {
        return QueryUtils.canonicalizeToEscaped(string);
    }

    private static String escapeUnicode(String string) throws ParseException {
        String string2 = string;
        try {
            string2 = QueryUtils.escapeUnicode(string);
        }
        catch (RDFException rDFException) {
            throw new ParseException(rDFException.getMessage());
        }
        return string2;
    }

    public final void Input() throws ParseException {
        this.nquadsDoc();
        this.jj_consume_token(0);
    }

    public final void nquadsDoc() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: {
                this.statement();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 8: {
                    this.statement();
                    continue block9;
                }
            }
            this.jj_la1[2] = this.jj_gen;
        }
    }

    public final void statement() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string = this.subject();
        string2 = this.predicate();
        string3 = this.object();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: {
                string4 = this.graphLabel();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(15);
        try {
            this.qh.processQuad(NquadsParser.escapeUnicode(string), NquadsParser.escapeUnicode(string2), NquadsParser.escapeUnicode(string3), NquadsParser.escapeUnicode(string4));
        }
        catch (RDFException rDFException) {
            throw new ParseException(rDFException.getMessage());
        }
    }

    public final String subject() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                string = this.iri();
                break;
            }
            case 8: {
                string2 = this.bnode();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (string != null) {
            string3 = string;
        } else if (string2 != null) {
            string3 = string2;
        }
        return string3;
    }

    public final String predicate() throws ParseException {
        String string = null;
        string = this.iri();
        return string;
    }

    public final String object() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                string = this.iri();
                break;
            }
            case 8: {
                string2 = this.bnode();
                break;
            }
            case 7: {
                string3 = this.literal();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (string != null) {
            string4 = string;
        } else if (string2 != null) {
            string4 = string2;
        } else if (string3 != null) {
            string4 = string3;
        }
        return string4;
    }

    public final String graphLabel() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                string = this.iri();
                break;
            }
            case 8: {
                string2 = this.bnode();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (string != null) {
            string3 = string;
        } else if (string2 != null) {
            string3 = string2;
        }
        return string3;
    }

    public final String literal() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string = this.string();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 16: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        string2 = this.iri();
                        break block0;
                    }
                    case 4: {
                        string3 = this.langTag();
                        break block0;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        string4 = string;
        if (string2 != null) {
            string4 = string4 + "^^" + string2;
        } else if (string3 != null) {
            string4 = string4 + string3;
        }
        return string4;
    }

    public final String iri() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(6);
        return this.canonicalizeToEscaped(token.image);
    }

    public final String bnode() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(8);
        return this.canonicalizeToEscaped(token.image);
    }

    public final String string() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(7);
        return "\"" + this.canonicalizeToEscaped(token.image.substring(1, token.image.length() - 1)) + "\"";
    }

    public final String langTag() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(4);
        return this.canonicalizeToEscaped(token.image);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{320, 32, 320, 320, 320, 448, 320, 65552, 65552};
    }

    public NquadsParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public NquadsParser(InputStream inputStream, String string) {
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new NquadsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public NquadsParser(Reader reader) {
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new NquadsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public NquadsParser(NquadsParserTokenManager nquadsParserTokenManager) {
        this.token_source = nquadsParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(NquadsParserTokenManager nquadsParserTokenManager) {
        this.token_source = nquadsParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[17];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 9; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 17; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        NquadsParser.jj_la1_init_0();
    }
}

