/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTPathAlternative;
import oracle.spatial.rdf.server.parser.sparql.ASTPathElt;
import oracle.spatial.rdf.server.parser.sparql.ASTPathSequence;
import oracle.spatial.rdf.server.parser.sparql.ASTSimplePathMod;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class PropertyPathZeroRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int NUM_ZERO_LIMIT = 4;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.empty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 47) {
                ASTTriplesBlock aSTTriplesBlock = (ASTTriplesBlock)simpleNode;
                if (this.hasOptimizablePath(aSTTriplesBlock)) {
                    SimpleNode simpleNode2 = aSTTriplesBlock;
                    int n = 1;
                    SimpleNode simpleNode3 = (SimpleNode)aSTTriplesBlock.jjtGetChild(1);
                    while (simpleNode3.id == 68 && simpleNode3.jjtGetNumChildren() == 1) {
                        simpleNode2 = simpleNode3;
                        n = 0;
                        simpleNode3 = (SimpleNode)simpleNode3.jjtGetChild(0);
                    }
                    if (simpleNode3.id != 66) {
                        throw new RDFException("PropertyPathZeroRewriteOptimizer: unexpected child type in predicate position");
                    }
                    SimpleNode simpleNode4 = this.generatePPAlternate((ASTPathSequence)simpleNode3);
                    simpleNode2.jjtAddChild(simpleNode4, n);
                    simpleNode4.jjtSetParent(simpleNode2);
                }
                if (aSTTriplesBlock.jjtGetNumChildren() <= 3) continue;
                stack.push(aSTTriplesBlock.jjtGetChild(3));
                continue;
            }
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                stack.push(simpleNode.jjtGetChild(i));
            }
        }
        return node;
    }

    private SimpleNode generatePPAlternate(ASTPathSequence aSTPathSequence) throws RDFException {
        int n;
        int n2;
        int n3;
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        int[] nArray = new int[aSTPathSequence.jjtGetNumChildren()];
        int n4 = 0;
        int n5 = nArray.length - 1;
        int n6 = 0;
        for (n3 = 0; n3 < aSTPathSequence.jjtGetNumChildren(); ++n3) {
            SimpleNode simpleNode = (SimpleNode)aSTPathSequence.jjtGetChild(n3);
            if (this.isZeroLength(simpleNode)) {
                nArray[n3] = n4++;
                arrayList.add(this.getNonZeroAlt(simpleNode));
                if (n3 < n5) {
                    n5 = n3;
                }
                n6 = n3;
                continue;
            }
            nArray[n3] = -1;
        }
        n3 = 0;
        int n7 = nArray.length - 1;
        if (n5 > 0) {
            n3 = n5 - 1;
            n7 = n6;
        } else if (n6 < n7) {
            n7 = n6 + 1;
        }
        int n8 = (int)Math.pow(2.0, arrayList.size());
        SimpleNode[] simpleNodeArray = new SimpleNode[n8];
        for (n2 = 0; n2 < n8; ++n2) {
            simpleNodeArray[n2] = this.genSequenceForValue(n2, aSTPathSequence, arrayList, nArray, n3, n7);
        }
        n2 = n3 + 1 + (nArray.length - 1 - n7);
        ASTPathSequence aSTPathSequence2 = null;
        int n9 = 0;
        if (n2 > 1) {
            aSTPathSequence2 = new ASTPathSequence(66);
            aSTPathSequence2.jjtSetInitCapacity(n3 + 1 + (nArray.length - 1 - n7));
            for (int i = 0; i < n3; ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTPathSequence.jjtGetChild(i);
                aSTPathSequence2.jjtAddChild(simpleNode, n9);
                ++n9;
                simpleNode.jjtSetParent(aSTPathSequence2);
            }
        }
        ASTPathAlternative aSTPathAlternative = new ASTPathAlternative(65);
        aSTPathAlternative.jjtSetInitCapacity(simpleNodeArray.length);
        for (n = 0; n < simpleNodeArray.length; ++n) {
            aSTPathAlternative.jjtAddChild(simpleNodeArray[n], n);
            simpleNodeArray[n].jjtSetParent(aSTPathAlternative);
        }
        if (n2 > 1) {
            aSTPathSequence2.jjtAddChild(aSTPathAlternative, n9);
            ++n9;
            aSTPathAlternative.jjtSetParent(aSTPathSequence2);
            for (n = n7 + 1; n < aSTPathSequence.jjtGetNumChildren(); ++n) {
                SimpleNode simpleNode = (SimpleNode)aSTPathSequence.jjtGetChild(n);
                aSTPathSequence2.jjtAddChild(simpleNode, n9);
                ++n9;
                simpleNode.jjtSetParent(aSTPathSequence2);
            }
        }
        SimpleNode simpleNode = aSTPathAlternative;
        if (n2 > 1) {
            simpleNode = aSTPathSequence2;
        }
        return simpleNode;
    }

    private SimpleNode genSequenceForValue(int n, ASTPathSequence aSTPathSequence, List<SimpleNode> list, int[] nArray, int n2, int n3) {
        int n4 = aSTPathSequence.jjtGetNumChildren();
        SimpleNode simpleNode = new ASTPathSequence(66);
        int n5 = 0;
        for (int i = n2; i <= n3; ++i) {
            int n6;
            if (nArray[i] < 0) {
                SimpleNode simpleNode2 = (SimpleNode)((SimpleNode)aSTPathSequence.jjtGetChild(i)).cloneSubTree();
                simpleNode.jjtAddChild(simpleNode2, n5);
                ++n5;
                simpleNode2.jjtSetParent(simpleNode);
                continue;
            }
            if (nArray[i] < 0 || (n6 = (int)(Math.floor((double)n / Math.pow(2.0, nArray[i])) % 2.0)) <= 0) continue;
            SimpleNode simpleNode3 = (SimpleNode)list.get(nArray[i]).cloneSubTree();
            simpleNode.jjtAddChild(simpleNode3, n5);
            ++n5;
            simpleNode3.jjtSetParent(simpleNode);
        }
        if (simpleNode.jjtGetNumChildren() == 1) {
            simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        }
        return simpleNode;
    }

    private SimpleNode getNonZeroAlt(SimpleNode simpleNode) throws RDFException {
        SimpleNode simpleNode2 = null;
        if (simpleNode.id == 67) {
            simpleNode2 = this.getEltAlt((ASTPathElt)simpleNode);
        } else {
            SimpleNode simpleNode3 = simpleNode;
            while (simpleNode3.id != 67) {
                simpleNode3 = (SimpleNode)simpleNode3.jjtGetChild(0);
            }
            SimpleNode simpleNode4 = (SimpleNode)simpleNode3.jjtGetParent();
            simpleNode3 = this.getEltAlt((ASTPathElt)simpleNode3);
            simpleNode4.jjtAddChild(simpleNode3, 0);
            simpleNode3.jjtSetParent(simpleNode4);
            simpleNode2 = simpleNode;
        }
        return simpleNode2;
    }

    private SimpleNode getEltAlt(ASTPathElt aSTPathElt) throws RDFException {
        SimpleNode simpleNode = null;
        if (aSTPathElt.jjtGetNumChildren() != 2 || ((SimpleNode)aSTPathElt.jjtGetChild((int)1)).id != 69) {
            throw new RDFException("PropertyPathZeroRewriteOptimizer: Unexpected children under ASTPathElt");
        }
        String string = ((ASTSimplePathMod)aSTPathElt.jjtGetChild((int)1)).name;
        if (string.equals("?")) {
            simpleNode = (SimpleNode)((SimpleNode)aSTPathElt.jjtGetChild(0)).cloneSubTree();
        } else if (string.equals("*")) {
            simpleNode = (SimpleNode)aSTPathElt.cloneSubTree();
            ASTSimplePathMod aSTSimplePathMod = (ASTSimplePathMod)simpleNode.jjtGetChild(1);
            aSTSimplePathMod.name = "+";
        } else {
            throw new RDFException("PropertyPathZeroRewriteOptimizer: Unexpected modifier under ASTPathElt");
        }
        return simpleNode;
    }

    private boolean hasOptimizablePath(ASTTriplesBlock aSTTriplesBlock) {
        boolean bl = false;
        SimpleNode simpleNode = (SimpleNode)aSTTriplesBlock.jjtGetChild(1);
        while (simpleNode.id == 68 && simpleNode.jjtGetNumChildren() == 1) {
            simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        }
        if (simpleNode.id == 66) {
            int n;
            boolean bl2 = false;
            for (n = 0; n < simpleNode.jjtGetNumChildren() && !bl2; ++n) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n);
                if (!this.isNonZeroLength(simpleNode2)) continue;
                bl2 = true;
            }
            n = 0;
            int n2 = 0;
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (!this.isZeroLength(simpleNode3)) continue;
                n = 1;
                ++n2;
            }
            bl = bl2 && n != 0 && n2 <= 4;
        }
        return bl;
    }

    private boolean isNonZeroLength(SimpleNode simpleNode) {
        boolean bl = false;
        if (simpleNode.id == 73) {
            bl = true;
        } else if (simpleNode.id == 68) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
            while (simpleNode2.id == 68) {
                simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
            }
            if (simpleNode2.id == 73) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isZeroLength(SimpleNode simpleNode) {
        boolean bl = false;
        SimpleNode simpleNode2 = simpleNode;
        while (simpleNode2.id == 68) {
            simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
        }
        if (simpleNode2.id == 67 && simpleNode2.jjtGetNumChildren() == 2) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(1);
            if (simpleNode3.id == 69) {
                ASTSimplePathMod aSTSimplePathMod = (ASTSimplePathMod)simpleNode3;
                if (aSTSimplePathMod.name.equals("*") || aSTSimplePathMod.name.equals("?")) {
                    bl = true;
                }
            }
        }
        return bl;
    }
}

