/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class OraBindValue {
    private BvType type;
    private Long valueId;
    private String valueType;
    private String vnamePrefix;
    private String vnameSuffix;
    private String litType;
    private String litLang;
    private String litLong;
    private Integer intVal;
    private Long longVal;
    private Float floatVal;
    private Double doubleVal;

    private OraBindValue(BvType bvType, Long l, String string, String string2, String string3, String string4, String string5, String string6, Integer n, Long l2, Float f, Double d) {
        this.type = bvType;
        this.valueId = l;
        this.valueType = string;
        this.vnamePrefix = string2;
        this.vnameSuffix = string3;
        this.litType = string4;
        this.litLang = string5;
        this.litLong = string6;
        this.intVal = n;
        this.longVal = l2;
        this.floatVal = f;
        this.doubleVal = d;
    }

    public void setValueId(long l) {
        this.valueId = l;
    }

    public BvType getType() {
        return this.type;
    }

    public Long getValueId() {
        return this.valueId;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getVnamePrefix() {
        return this.vnamePrefix;
    }

    public String getVnameSuffix() {
        return this.vnameSuffix;
    }

    public String getLitType() {
        return this.litType;
    }

    public String getLitLang() {
        return this.litLang;
    }

    public String getLitLong() {
        return this.litLong;
    }

    public Integer getIntVal() {
        return this.intVal;
    }

    public Long getLongVal() {
        return this.longVal;
    }

    public Float getFloatVal() {
        return this.floatVal;
    }

    public Double getDoubleVal() {
        return this.doubleVal;
    }

    public String toString() {
        return "[" + (Object)((Object)this.type) + " (" + this.valueId + "): " + this.valueType + ", " + this.vnamePrefix + ", " + this.vnameSuffix + ", " + this.litType + ", " + this.litLang + ", " + (this.litLong == null ? "0" : String.valueOf(this.litLong.length())) + ", " + this.intVal + ", " + this.longVal + ", " + this.floatVal + ", " + this.doubleVal + "]";
    }

    public ASTTripleAtom toTripleAtom() {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        switch (this.type) {
            case URI: {
                aSTTripleAtom.type = 1;
                aSTTripleAtom.name = this.vnamePrefix + this.vnameSuffix;
                break;
            }
            case PLAIN_LIT: {
                aSTTripleAtom.type = 3;
                aSTTripleAtom.name = this.vnamePrefix != null ? this.vnamePrefix : this.litLong;
                break;
            }
            case LANG_LIT: {
                aSTTripleAtom.type = 4;
                aSTTripleAtom.name = this.vnamePrefix != null ? this.vnamePrefix : this.litLong;
                aSTTripleAtom.litLang = this.litLang;
                break;
            }
            case TYPED_LIT: {
                aSTTripleAtom.type = 5;
                aSTTripleAtom.name = this.vnamePrefix != null ? this.vnamePrefix : this.litLong;
                aSTTripleAtom.litType = this.litType;
                break;
            }
            case INTEGER: {
                aSTTripleAtom.type = 5;
                aSTTripleAtom.name = String.valueOf(this.intVal);
                aSTTripleAtom.litType = "http://www.w3.org/2001/XMLSchema#int";
                break;
            }
            case LONG: {
                aSTTripleAtom.type = 5;
                aSTTripleAtom.name = String.valueOf(this.longVal);
                aSTTripleAtom.litType = "http://www.w3.org/2001/XMLSchema#long";
                break;
            }
            case FLOAT: {
                aSTTripleAtom.type = 5;
                aSTTripleAtom.name = String.valueOf(this.floatVal);
                aSTTripleAtom.litType = "http://www.w3.org/2001/XMLSchema#float";
                break;
            }
            case DOUBLE: {
                aSTTripleAtom.type = 5;
                aSTTripleAtom.name = String.valueOf(this.doubleVal);
                aSTTripleAtom.litType = "http://www.w3.org/2001/XMLSchema#double";
                break;
            }
        }
        return aSTTripleAtom;
    }

    public static OraBindValue createURI(String string) {
        String string2 = QueryUtils.valueNamePrefix(string, "UR");
        String string3 = null;
        if (string2.length() < string.length()) {
            string3 = string.substring(string2.length());
        }
        return new OraBindValue(BvType.URI, null, "UR", string2, string3, null, null, null, null, null, null, null);
    }

    public static OraBindValue createInt(int n) {
        return new OraBindValue(BvType.INTEGER, null, "TL", String.valueOf(n), null, "http://www.w3.org/2001/XMLSchema#int", null, null, n, null, null, null);
    }

    public static OraBindValue createLong(long l) {
        return new OraBindValue(BvType.LONG, null, "TL", String.valueOf(l), null, "http://www.w3.org/2001/XMLSchema#long", null, null, null, l, null, null);
    }

    public static OraBindValue createFloat(float f) {
        return new OraBindValue(BvType.FLOAT, null, "TL", String.valueOf(f), null, "http://www.w3.org/2001/XMLSchema#float", null, null, null, null, Float.valueOf(f), null);
    }

    public static OraBindValue createDouble(double d) {
        return new OraBindValue(BvType.DOUBLE, null, "TL", String.valueOf(d), null, "http://www.w3.org/2001/XMLSchema#double", null, null, null, null, null, d);
    }

    private static OraBindValue createLiteral(BvType bvType, String string, String string2, String string3, int n) {
        int n2 = QueryUtils.computeConstTermLen(string, string2, string3);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (n2 > n) {
            string6 = string;
            switch (bvType) {
                case PLAIN_LIT: {
                    string4 = "CPLL";
                    break;
                }
                case LANG_LIT: {
                    string4 = "CPLL@";
                    break;
                }
                case TYPED_LIT: {
                    string4 = "CTLL";
                }
            }
        } else {
            string5 = string;
            switch (bvType) {
                case PLAIN_LIT: {
                    string4 = "PL";
                    break;
                }
                case LANG_LIT: {
                    string4 = "PL@";
                    break;
                }
                case TYPED_LIT: {
                    string4 = "TL";
                }
            }
        }
        return new OraBindValue(bvType, null, string4, string5, null, string3, string2, string6, null, null, null, null);
    }

    public static OraBindValue createPlainLiteral(String string, int n) {
        return OraBindValue.createLiteral(BvType.PLAIN_LIT, string, null, null, n);
    }

    public static OraBindValue createLangLiteral(String string, String string2, int n) {
        return OraBindValue.createLiteral(BvType.LANG_LIT, string, string2, null, n);
    }

    public static OraBindValue createTypedLiteral(String string, String string2, int n) {
        return OraBindValue.createLiteral(BvType.TYPED_LIT, string, null, string2, n);
    }

    public static enum BvType {
        URI,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        PLAIN_LIT,
        LANG_LIT,
        TYPED_LIT;

    }
}

