/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Stack;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTInversePathElt;
import oracle.spatial.rdf.server.parser.sparql.ASTPathElt;
import oracle.spatial.rdf.server.parser.sparql.ASTPathSequence;
import oracle.spatial.rdf.server.parser.sparql.ASTSimplePathMod;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class ConstObjPPRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        Node node2;
        if (((SimpleNode)node).id == 47 && node.jjtGetNumChildren() > 2 && this.isVar(node.jjtGetChild(0)) && this.isConstant(node.jjtGetChild(2)) && (this.isUnboundedPathElt(node2 = node.jjtGetChild(1)) || this.isUnboundedPathSeq(node2) && !this.containsPathSequence(node2))) {
            this.rewriteTriplesBlock((ASTTriplesBlock)node);
        }
        int n = ((SimpleNode)node).jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            this.optimizeQuery((SimpleNode)node.jjtGetChild(i));
        }
        return node;
    }

    private void rewriteTriplesBlock(ASTTriplesBlock aSTTriplesBlock) {
        Node node = aSTTriplesBlock.jjtGetChild(0);
        aSTTriplesBlock.jjtAddChild(aSTTriplesBlock.jjtGetChild(2), 0);
        aSTTriplesBlock.jjtAddChild(node, 2);
        SimpleNode simpleNode = (SimpleNode)aSTTriplesBlock.jjtGetChild(1);
        if (simpleNode.id == 67) {
            this.reverseUnboundedPathElt((ASTPathElt)simpleNode);
        } else {
            this.reverseUnboundedPathSeq((ASTPathSequence)simpleNode);
        }
    }

    private void reverseUnboundedPathSeq(ASTPathSequence aSTPathSequence) {
        int n;
        int n2 = aSTPathSequence.jjtGetNumChildren();
        for (n = 0; n < n2; ++n) {
            if (this.isUnboundedPathElt(aSTPathSequence.jjtGetChild(n))) {
                this.reverseUnboundedPathElt((ASTPathElt)aSTPathSequence.jjtGetChild(n));
                continue;
            }
            aSTPathSequence.jjtAddChild(this.reverseNode(aSTPathSequence.jjtGetChild(n)), n);
        }
        for (n = 0; n < n2 / 2; ++n) {
            Node node = aSTPathSequence.jjtGetChild(n);
            aSTPathSequence.jjtAddChild(aSTPathSequence.jjtGetChild(n2 - n - 1), n);
            aSTPathSequence.jjtAddChild(node, n2 - n - 1);
        }
    }

    private Node reverseNode(Node node) {
        Node node2;
        if (((SimpleNode)node).id == 68) {
            node2 = node.jjtGetChild(0);
        } else {
            node2 = new ASTInversePathElt(68);
            node2.jjtAddChild(node, 0);
            node.jjtSetParent(node2);
        }
        return node2;
    }

    private void reverseUnboundedPathElt(ASTPathElt aSTPathElt) {
        Node node = aSTPathElt.jjtGetChild(0);
        ASTInversePathElt aSTInversePathElt = new ASTInversePathElt(68);
        aSTInversePathElt.jjtAddChild(node, 0);
        node.jjtSetParent(aSTInversePathElt);
        aSTPathElt.jjtAddChild(aSTInversePathElt, 0);
        aSTInversePathElt.jjtSetParent(aSTPathElt);
    }

    private boolean isUnboundedPathSeq(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 66 && this.isUnboundedPathElt(node.jjtGetChild(node.jjtGetNumChildren() - 1))) {
            bl = true;
        }
        return bl;
    }

    private boolean containsPathSequence(Node node) {
        int n;
        Stack<Node> stack = new Stack<Node>();
        for (n = node.jjtGetNumChildren() - 1; n >= 0; --n) {
            stack.push(node.jjtGetChild(n));
        }
        n = 0;
        while (n == 0 && !stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            if (((SimpleNode)node2).id == 66) {
                n = 1;
            }
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return n != 0;
    }

    private boolean isUnboundedPathElt(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 67 && node.jjtGetNumChildren() == 2 && this.isUnboundModifier(node.jjtGetChild(1))) {
            bl = true;
        }
        return bl;
    }

    private boolean isUnboundModifier(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 69 && (((ASTSimplePathMod)node).name == "*" || ((ASTSimplePathMod)node).name == "+")) {
            bl = true;
        }
        return bl;
    }

    private boolean isVar(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 73 && ((ASTTripleAtom)node).type == 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isConstant(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 73 && ((ASTTripleAtom)node).type != 0) {
            bl = true;
        }
        return bl;
    }
}

