/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.legend.LegendPosition;
import oracle.dss.legend.shared.CompositeLegendItem;
import oracle.dss.legend.shared.LegendItem;
import oracle.dss.legend.shared.LegendListItem;
import oracle.dss.legend.shared.text.LegendSectionTitle;
import oracle.dss.legend.shared.text.LegendText;
import oracle.dss.legend.shared.visit.LegendVisitContext;
import oracle.dss.legend.shared.visit.LegendVisitor;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Stroke;

public class LegendSection
extends CompositeLegendItem<LegendListItem> {
    private LegendSectionTitle m_title;
    protected Map<LegendListItem, LegendListItem> m_uniqueItems = new HashMap<LegendListItem, LegendListItem>();
    protected Map<Object, LegendListItem> m_dataItemMap = new HashMap<Object, LegendListItem>();
    protected Map<LegendListItem, Set<Object>> m_itemDataMap = new HashMap<LegendListItem, Set<Object>>();
    protected LegendPosition m_align;

    public void sortItems() {
        Collections.sort(this.m_items);
    }

    @Override
    public void internalAccept(LegendVisitor visitor, LegendVisitContext context) {
        visitor.visit(this, context);
        if (this.m_title != null) {
            this.m_title.accept(visitor, context);
        }
        super.internalAccept(visitor, context);
    }

    public LegendListItem getItem(Object data) {
        return this.m_dataItemMap.get(data);
    }

    public boolean addUniqueItem(LegendListItem item) {
        if (!this.m_uniqueItems.containsKey(item)) {
            this.addItem(item);
            this.m_uniqueItems.put(item, item);
            return true;
        }
        return false;
    }

    public boolean addUniqueItem(LegendListItem item, Object data) {
        boolean added = this.addUniqueItem(item);
        LegendListItem listItem = this.m_uniqueItems.get(item);
        if (!this.m_itemDataMap.containsKey(listItem)) {
            HashSet emptySet = new HashSet();
            this.m_itemDataMap.put(listItem, emptySet);
        }
        this.m_itemDataMap.get(listItem).add(data);
        this.m_dataItemMap.put(data, listItem);
        return added;
    }

    public LegendSectionTitle getTitle() {
        return this.m_title;
    }

    public void setTitle(LegendSectionTitle title) {
        this.m_title = title;
    }

    public void setItemsAlignment(LegendPosition align) {
        this.m_align = align;
    }

    @Override
    public void calc() {
        int allocWidth = this.m_width;
        int titleHeight = 0;
        int titleWidth = 0;
        int runningHeight = 0;
        if (this.m_title != null) {
            this.m_title.setWidth(allocWidth);
            this.m_title.calc();
            titleHeight = this.m_title.getHeight() + 2;
            titleWidth = this.m_title.getWidth();
            runningHeight += titleHeight;
        }
        int maxWidth = Integer.MIN_VALUE;
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            item.setWidth(allocWidth);
            item.setHeight(this.m_height - titleHeight);
            item.calc();
            if (item instanceof LegendListItem) {
                runningHeight += item.getHeight();
                if (i < this.m_items.size() - 1) {
                    runningHeight += 2;
                }
            }
            maxWidth = Math.max(maxWidth, item.getWidth());
        }
        this.m_width = this.calcWidth(maxWidth);
        this.m_height = runningHeight;
    }

    @Override
    public void calcFinal() {
        for (LegendItem item : this.m_items) {
            if (!(item instanceof LegendText)) continue;
            item.setWidth(this.m_width);
            item.calc();
            this.m_height += item.getHeight();
        }
    }

    protected int calcWidth(int width) {
        return this.m_title != null ? Math.max(this.m_title.getWidth(), width) : width;
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> section = new ArrayList<DrawableObject>();
        boolean isBidi = this.m_settings.isBidi();
        int curr_x = this.m_x;
        if (isBidi) {
            curr_x += this.m_width;
        }
        int curr_y = this.m_y;
        if (this.m_title != null) {
            if (isBidi) {
                this.m_title.setPosition(curr_x - this.m_title.getWidth(), curr_y);
            } else {
                this.m_title.setPosition(curr_x, curr_y);
            }
            section.addAll(this.m_title.render());
            curr_y += this.m_title.getHeight() + 2;
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            if (isBidi) {
                item.setPosition(curr_x - item.getWidth(), curr_y);
            } else {
                item.setPosition(curr_x, curr_y);
            }
            section.addAll(item.render());
            curr_y += item.getHeight();
            if (i >= this.m_items.size() - 1) continue;
            curr_y += 2;
        }
        return section;
    }

    public String getTitleText() {
        return this.m_title == null ? null : this.m_title.getText();
    }

    @Override
    public Fill getDefaultFill() {
        return new FillColor(this.m_settings.getStyles().getBackgroundColor());
    }

    @Override
    public Stroke getDefaultBorder() {
        return null;
    }
}

