/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Date;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.DataTickLabelInfo;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.TickLabelCallback;
import oracle.dss.graph.pfj.NumberFormatCallBack;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GraphNumberFormatCallback
extends NumberFormatCallBack {
    protected CommonGraph m_commonGraph;
    protected int m_row;
    protected int m_column;
    protected int m_valueType;
    private static final String m_method_toString = "public String toString( double dVal )";

    public GraphNumberFormatCallback(CommonGraph g) {
        this.m_commonGraph = g;
    }

    private ViewFormat _getMarkerTextViewFormat(int value) {
        return this.m_commonGraph.getMarkerText().getViewFormat(value);
    }

    @Concealed
    public ViewFormat getTooltipViewFormat(int valueType) {
        int graphType = this.m_commonGraph.getGraphType();
        if (graphType >= 55 && graphType <= 60 || graphType == 93 || graphType == 94) {
            return this.m_commonGraph.getSliceLabel().getViewFormat();
        }
        return this._getMarkerTextViewFormat(valueType);
    }

    public ViewFormat getMarkerTextViewFormat(int seriesID, int groupID) {
        ViewFormat markerTextVF = null;
        try {
            markerTextVF = this.m_commonGraph.getPFJ().getJGraphType().isDualY() && this.m_commonGraph.getSeries().isAssignedToY2(seriesID % this.m_commonGraph.getSeriesObjectCount()) ? this._getMarkerTextViewFormat(2) : this._getMarkerTextViewFormat(1);
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return markerTextVF;
    }

    public ViewFormat getMarkerTextViewFormat(int seriesID) {
        ViewFormat markerTextVF = null;
        int graphType = this.m_commonGraph.getGraphType();
        switch (graphType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 54: 
            case 67: 
            case 68: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 100: {
                markerTextVF = this._getMarkerTextViewFormat(1);
                this.m_valueType = 76;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 69: 
            case 98: {
                try {
                    if (this.m_commonGraph.getSeries().isAssignedToY2(seriesID % this.m_commonGraph.getSeriesObjectCount())) {
                        markerTextVF = this._getMarkerTextViewFormat(2);
                        this.m_valueType = 77;
                        break;
                    }
                    markerTextVF = this._getMarkerTextViewFormat(1);
                    this.m_valueType = 76;
                }
                catch (SeriesOutOfRangeException seriesOutOfRangeException) {}
                break;
            }
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 89: 
            case 91: {
                if (this.m_valueType == 75) {
                    markerTextVF = this._getMarkerTextViewFormat(0);
                    break;
                }
                if (this.m_valueType == 76) {
                    markerTextVF = this._getMarkerTextViewFormat(1);
                    break;
                }
                if (this.m_valueType == 77) {
                    markerTextVF = this._getMarkerTextViewFormat(2);
                    break;
                }
                if (this.m_valueType != 78) break;
                markerTextVF = this._getMarkerTextViewFormat(3);
                break;
            }
            case 71: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                if (this.getValueType().equals("VOLUME")) {
                    markerTextVF = this._getMarkerTextViewFormat(4);
                    break;
                }
                markerTextVF = this._getMarkerTextViewFormat(1);
                break;
            }
            default: {
                markerTextVF = new ViewFormat();
                this.m_commonGraph.getErrorHandler().log("Unexpected GraphType", "oracle.dss.graph.GraphNumberFormatCallback", "getMarkerTextViewFormat");
            }
        }
        return markerTextVF;
    }

    @Override
    public String toString(double dVal) {
        boolean isPercent = false;
        ViewFormat viewFormat = null;
        DataAccess dataAccess = null;
        QDR qdr = null;
        GraphFormatManager fm = this.m_commonGraph.getGraphFormatManager();
        switch (this.getLabelType()) {
            case 0: {
                BaseDataAxis dataAxis;
                int tickLabel;
                int axisID;
                if (this.isY1AxisLabel()) {
                    axisID = 80;
                    tickLabel = 48;
                    dataAxis = this.m_commonGraph.getY1Axis();
                    viewFormat = this.m_commonGraph.getY1Axis().getViewFormat();
                } else if (this.isY2AxisLabel()) {
                    axisID = 81;
                    tickLabel = 53;
                    dataAxis = this.m_commonGraph.getY2Axis();
                    viewFormat = this.m_commonGraph.getY2Axis().getViewFormat();
                } else if (this.isX1AxisLabel()) {
                    axisID = 79;
                    tickLabel = 43;
                    dataAxis = this.m_commonGraph.getX1Axis();
                    viewFormat = this.m_commonGraph.getX1Axis().getViewFormat();
                } else {
                    axisID = 80;
                    dataAxis = this.m_commonGraph.getY1Axis();
                    tickLabel = 48;
                    viewFormat = this.m_commonGraph.getY1Axis().getViewFormat();
                }
                double axisMax = this.getAxisMax();
                double axisMin = this.getAxisMin();
                double tickStep = this.getAxisStep();
                boolean bLogScale = dataAxis.isScaledLogarithmic();
                double logBase = dataAxis.getLogarithmicBase();
                int gType = this.m_commonGraph.getGraphType();
                if (gType == 23 || gType == 30 || gType == 35 || gType == 40 || gType == 47 || gType == 54) {
                    isPercent = true;
                }
                if (this.isY2AxisLabel() && gType == 96) {
                    isPercent = true;
                }
                TickLabelCallback callback = this.m_commonGraph.getTickLabelCallback(tickLabel);
                DataTickLabelInfo dataInfo = new DataTickLabelInfo(this.getAxisLabelOrdinalPosition(), dVal);
                String value = null;
                if (callback != null) {
                    value = callback.getTickLabel(dataInfo, tickLabel);
                }
                if (callback == null || value == null) {
                    return fm.formatAxisValue(dVal, viewFormat, axisMax, axisMin, tickStep, axisID, isPercent, bLogScale, logBase);
                }
                return value;
            }
            case 1: 
            case 6: {
                int sliceTextType = this.m_commonGraph.getSliceLabel().getTextType();
                if (1 == sliceTextType || 3 == sliceTextType) {
                    isPercent = true;
                }
                viewFormat = this.m_commonGraph.getSliceLabel().getViewFormat();
                this.calculateColumnAndRow();
                dataAccess = this.m_commonGraph.getDataAccess();
                qdr = new DataComponentInfo(this.m_row, this.m_column).getQDR(dataAccess, 1);
                return fm.formatPieValue(dVal, viewFormat, isPercent, qdr, false);
            }
            case 2: {
                viewFormat = this.m_commonGraph.getSliceLabel().getViewFormat();
                return fm.formatPieValue(dVal, viewFormat, false, null, false);
            }
            case 3: 
            case 5: {
                int gType = this.m_commonGraph.getGraphType();
                if (gType == 23 || gType == 30 || gType == 35 || gType == 40 || gType == 47 || gType == 54) {
                    isPercent = true;
                }
                this.calculateColumnAndRow();
                viewFormat = this.getMarkerTextViewFormat(this.getSeries());
                dataAccess = this.m_commonGraph.getDataAccess();
                qdr = new DataComponentInfo(this.m_row, this.m_column).getQDR(dataAccess, 1);
                String percentval = null;
                percentval = this.m_valueType == 75 && this.m_commonGraph.getPFJ().isContinuousTimeAxis() ? this.m_commonGraph.getPFJ().getToolTipCallBack().convertDateToString(new Date((long)dVal)) : fm.formatDataValue(dVal, viewFormat, this.m_valueType, this.m_column, this.m_row, isPercent, qdr, false);
                return percentval;
            }
            case 4: {
                this.calculateColumnAndRow();
                dataAccess = this.m_commonGraph.getDataAccess();
                qdr = new DataComponentInfo(this.m_row, this.m_column).getQDR(dataAccess, 1);
                int type = this.m_commonGraph.getGraphType();
                if (type >= 55 && type <= 60 || type == 93 || type == 94) {
                    if ("PIE_BAR_VALUE".equals(this.getValueType())) {
                        viewFormat = this.getMarkerTextViewFormat(this.getSeries());
                        return fm.formatDataValue(dVal, viewFormat, this.m_valueType, this.m_column, this.m_row, isPercent, qdr, true);
                    }
                    viewFormat = this.m_commonGraph.getSliceLabel().getViewFormat();
                    if ("PIE_PERCENTAGE_VALUE".equals(this.getValueType())) {
                        isPercent = true;
                    }
                    return fm.formatPieValue(dVal, viewFormat, isPercent, qdr, true);
                }
                if ("PERCENTAGE_VALUE".equals(this.getValueType())) {
                    isPercent = true;
                }
                viewFormat = this.getMarkerTextViewFormat(this.getSeries());
                return fm.formatDataValue(dVal, viewFormat, this.m_valueType, this.m_column, this.m_row, isPercent, qdr, true);
            }
        }
        String labelType = "BadLabelType";
        Object dataValue = dVal > 1.0 || dVal == 0.0 ? Double.toString(dVal) : Integer.toString((int)(dVal * 100.0 + 0.5)) + "%";
        return dataValue;
    }

    private void calculateColumnAndRow() {
        int graphType = this.m_commonGraph.getGraphType();
        int index = this.getGroup();
        try {
            switch (graphType) {
                case 61: 
                case 62: 
                case 65: 
                case 66: {
                    if (this.isX1AxisLabel()) {
                        index = this.getGroup() * 2;
                        this.m_valueType = 75;
                        break;
                    }
                    if (this.isY1AxisLabel()) {
                        index = this.getGroup() * 2 + 1;
                        this.m_valueType = 76;
                        break;
                    }
                    if (this.isY2AxisLabel()) {
                        index = this.getGroup() * 2 + 1;
                        this.m_valueType = 77;
                        break;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        index = this.getGroup() * 2;
                        this.m_valueType = 75;
                        break;
                    }
                    if (!this.getValueType().equals("YVALUE")) break;
                    index = this.getGroup() * 2 + 1;
                    this.m_valueType = 76;
                    if (graphType != 62 && graphType != 66 || !this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) break;
                    this.m_valueType = 77;
                    break;
                }
                case 63: 
                case 64: {
                    if (this.isX1AxisLabel()) {
                        index = this.getGroup() * 3;
                        this.m_valueType = 75;
                        break;
                    }
                    if (this.isY1AxisLabel()) {
                        index = this.getGroup() * 3 + 1;
                        this.m_valueType = 76;
                        break;
                    }
                    if (this.isY2AxisLabel()) {
                        index = this.getGroup() * 3 + 1;
                        this.m_valueType = 77;
                        break;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        index = this.getGroup() * 3;
                        this.m_valueType = 75;
                        break;
                    }
                    if (!this.getValueType().equals("YVALUE")) break;
                    index = this.getGroup() * 3 + 1;
                    this.m_valueType = 76;
                    if (graphType != 64 || !this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) break;
                    this.m_valueType = 77;
                    break;
                }
                case 89: 
                case 91: {
                    if (this.isX1AxisLabel()) {
                        index = this.getGroup() * 3;
                        this.m_valueType = 75;
                        break;
                    }
                    if (this.isY1AxisLabel()) {
                        index = this.getGroup() * 3 + 1;
                        this.m_valueType = 76;
                        break;
                    }
                    if (this.isY2AxisLabel()) {
                        index = this.getGroup() * 3 + 1;
                        this.m_valueType = 77;
                        break;
                    }
                    if (this.isZ1AxisLabel()) {
                        index = this.getGroup() * 3 + 2;
                        this.m_valueType = 78;
                        break;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        index = this.getGroup() * 3;
                        this.m_valueType = 75;
                        break;
                    }
                    if (this.getValueType().equals("YVALUE")) {
                        index = this.getGroup() * 3 + 1;
                        this.m_valueType = 76;
                        if (graphType != 91 || !this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) break;
                        this.m_valueType = 77;
                        break;
                    }
                    if (!this.getValueType().equals("ZVALUE")) break;
                    index = this.getGroup() * 3 + 2;
                    this.m_valueType = 78;
                    break;
                }
                case 90: 
                case 92: {
                    if (this.isX1AxisLabel()) {
                        index = this.getGroup() * 4;
                        this.m_valueType = 75;
                    } else if (this.isY1AxisLabel()) {
                        index = this.getGroup() * 4 + 1;
                        this.m_valueType = 76;
                    } else if (this.isY2AxisLabel()) {
                        index = this.getGroup() * 4 + 1;
                        this.m_valueType = 77;
                    } else if (this.isZ1AxisLabel()) {
                        index = this.getGroup() * 4 + 2;
                        this.m_valueType = 78;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        index = this.getGroup() * 4;
                        this.m_valueType = 75;
                    }
                    if (this.getValueType().equals("YVALUE")) {
                        index = this.getGroup() * 4 + 1;
                        this.m_valueType = 76;
                        if (graphType == 92 && this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) {
                            this.m_valueType = 77;
                        }
                    }
                    if (!this.getValueType().equals("ZVALUE")) break;
                    index = this.getGroup() * 4 + 2;
                    this.m_valueType = 78;
                    break;
                }
                case 71: 
                case 83: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("OPEN")) {
                        index = this.getGroup() * 5;
                        break;
                    }
                    if (this.getValueType().equals("HIGH")) {
                        index = this.getGroup() * 5 + 1;
                        break;
                    }
                    if (this.getValueType().equals("LOW")) {
                        index = this.getGroup() * 5 + 2;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        index = this.getGroup() * 5 + 3;
                        break;
                    }
                    if (!this.getValueType().equals("VOLUME")) break;
                    index = this.getGroup() * 5 + 4;
                    this.m_valueType = 77;
                    break;
                }
                case 70: 
                case 79: 
                case 80: 
                case 81: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("OPEN")) {
                        index = this.getGroup() * 4;
                    } else if (this.getValueType().equals("HIGH")) {
                        index = this.getGroup() * 4 + 1;
                    } else if (this.getValueType().equals("LOW")) {
                        index = this.getGroup() * 4 + 2;
                    } else if (this.getValueType().equals("CLOSE")) {
                        index = this.getGroup() * 4 + 3;
                    }
                    if (graphType != 80 && graphType != 81 || !this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) break;
                    this.m_valueType = 77;
                    break;
                }
                case 82: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("HIGH")) {
                        index = this.getGroup() * 3;
                        break;
                    }
                    if (this.getValueType().equals("LOW")) {
                        index = this.getGroup() * 3 + 1;
                        break;
                    }
                    if (!this.getValueType().equals("VOLUME")) break;
                    index = this.getGroup() * 3 + 2;
                    this.m_valueType = 77;
                    break;
                }
                case 84: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("OPEN")) {
                        index = this.getGroup() * 3;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        index = this.getGroup() * 3 + 1;
                        break;
                    }
                    if (!this.getValueType().equals("VOLUME")) break;
                    index = this.getGroup() * 3 + 2;
                    this.m_valueType = 77;
                    break;
                }
                case 72: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("OPEN")) {
                        index = this.getGroup() * 2;
                        break;
                    }
                    if (!this.getValueType().equals("CLOSE")) break;
                    index = this.getGroup() * 2 + 1;
                    break;
                }
                case 73: 
                case 74: 
                case 75: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("HIGH")) {
                        index = this.getGroup() * 2;
                    } else if (this.getValueType().equals("LOW")) {
                        index = this.getGroup() * 2 + 1;
                    }
                    if (graphType != 74 && graphType != 75 || !this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) break;
                    this.m_valueType = 77;
                    break;
                }
                case 76: 
                case 77: 
                case 78: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("HIGH")) {
                        index = this.getGroup() * 3;
                    } else if (this.getValueType().equals("LOW")) {
                        index = this.getGroup() * 3 + 1;
                    } else if (this.getValueType().equals("CLOSE")) {
                        index = this.getGroup() * 3 + 2;
                    }
                    if (graphType != 77 && graphType != 78 || !this.m_commonGraph.getSeries().isAssignedToY2(this.getSeries() % this.m_commonGraph.getSeriesObjectCount())) break;
                    this.m_valueType = 77;
                    break;
                }
                case 88: {
                    this.m_valueType = 76;
                    if (this.getValueType().equals("HIGH")) {
                        index = this.getGroup() * 4;
                        break;
                    }
                    if (this.getValueType().equals("LOW")) {
                        index = this.getGroup() * 4 + 1;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        index = this.getGroup() * 4 + 2;
                        break;
                    }
                    if (!this.getValueType().equals("VOLUME")) break;
                    index = this.getGroup() * 4 + 3;
                    this.m_valueType = 77;
                }
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        int pfjRow = this.m_commonGraph.isDataRowShownAsASeries() ? this.getSeries() : index;
        int pfjColumn = this.m_commonGraph.isDataRowShownAsASeries() ? index : this.getSeries();
        this.m_column = ((DataCallback)this.m_commonGraph.getDataFilter()).getDataAccessColumn(pfjRow, pfjColumn);
        this.m_row = ((DataCallback)this.m_commonGraph.getDataFilter()).getDataAccessRow(pfjRow, pfjColumn);
    }
}

