/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.OXQueryItem;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class BindExpr
extends Variable {
    private OXMLItem bindValue;
    private OXMLSequence bindSeq;

    public BindExpr(QName qName, OXMLSequenceType oXMLSequenceType) {
        super(qName, oXMLSequenceType);
    }

    public boolean isBindValSet() {
        if (this.bindSeq != null) {
            return true;
        }
        return this.bindValue != null;
    }

    public void setInt(QueryState queryState, int n) {
        this.checkType(OXMLSequenceType.TINTEGER);
        if (this.bindValue == null) {
            this.bindValue = queryState.createItem();
        }
        this.bindValue.setInt(OXMLSequenceType.TINTEGER, n);
        this.staticType = OXMLSequenceType.TINTEGER;
    }

    public void setFloat(QueryState queryState, float f) {
        this.checkType(OXMLSequenceType.TFLOAT);
        if (this.bindValue == null) {
            this.bindValue = queryState.createItem();
        }
        this.bindValue.setDouble(OXMLSequenceType.TFLOAT, (double)f);
        this.staticType = OXMLSequenceType.TFLOAT;
    }

    public void setNode(QueryState queryState, XMLNode xMLNode) {
        this.checkType(OXMLSequenceType.NODE_ONE);
        if (this.bindValue == null) {
            this.bindValue = queryState.createItem();
        }
        this.bindValue.setNode(xMLNode);
        this.staticType = this.bindValue.getItemType();
    }

    public void setBoolean(QueryState queryState, boolean bl) {
        this.checkType(OXMLSequenceType.TBOOLEAN);
        if (this.bindValue == null) {
            this.bindValue = queryState.createItem();
        }
        this.bindValue.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
        this.staticType = OXMLSequenceType.TBOOLEAN;
    }

    public void setString(QueryState queryState, String string) {
        this.checkType(OXMLSequenceType.TSTRING);
        if (this.bindValue == null) {
            this.bindValue = queryState.createItem();
        }
        this.bindValue.setString(OXMLSequenceType.TSTRING, string);
        this.staticType = OXMLSequenceType.TSTRING;
    }

    public void setItem(QueryState queryState, OXMLItem oXMLItem) {
        this.checkType(oXMLItem.getItemType());
        this.bindValue = oXMLItem;
        this.staticType = oXMLItem.getItemType();
    }

    public void setSequence(OXMLSequence oXMLSequence) {
        this.bindSeq = ((OXQuerySequence)oXMLSequence).materializeIt();
        if (this.userSpecifiedType != null && !oXMLSequence.isOfType(this.userSpecifiedType)) {
            throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"));
        }
    }

    private void checkType(OXMLSequenceType oXMLSequenceType) {
        if (this.userSpecifiedType != null && !oXMLSequenceType.isOfType(this.userSpecifiedType)) {
            throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"));
        }
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        if (this.bindSeq != null) {
            ((OXQuerySequence)this.bindSeq).restart();
            return this.refCount > 1 ? (OXMLSequence)this.bindSeq.clone() : this.bindSeq;
        }
        if (!this.isBindValSet()) {
            throw new XQException(" Value for bind variable " + XQueryUtils.getQNameString(this.qname) + " not set ");
        }
        return queryState.createSequence(this.bindValue);
    }

    @Override
    public XMLNode DefinitionToXML() {
        XMLElement xMLElement = (XMLElement)BindExpr.getDoc().createElement("BindExpr");
        xMLElement.setAttribute("name", this.qname.toString());
        return xMLElement;
    }

    @Override
    public XMLNode toXML() {
        return super.DefinitionToXML();
    }

    @Override
    public ConvertXML DefinitionFromXML(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("name");
        this.qname = XQueryUtils.createQNameFromString(null, string);
        this.bindValue = (OXQueryItem)((Object)ConvertXMLUtils.fromXMLUntag(xMLElement));
        BindExpr.getSymbolTable().put(string, this);
        return this;
    }

    @Override
    public void toSqlDefn(XQXGen xQXGen) {
        xQXGen.startElement("bindexpr", XQXGen.createAttrs("name", this.qname.toString()));
        xQXGen.endElement("bindexpr");
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("bindexpr", XQXGen.createAttrs("name", this.qname.toString()));
        xQXGen.endElement("bindexpr");
    }

    protected void toSqlSuper(XQXGen xQXGen) {
        super.toSql(xQXGen);
    }
}

