/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;

public class PM2PhysicalRolesDialog
extends JPanel {
    private static final String KEY_ESCAPE = "ESCAPE";
    private DataFlowDesign dfDesign;
    private ApplicationView appView;
    private JDialog dialog;
    private JButton bnClose;
    private JButton bnOK = new JButton(Messages.getString("PM2PhysicalRolesDialog.Transform"));
    private Dimension dim = new Dimension(250, 250);
    private Map map = new TreeMap(new NameComparator());
    private TableModel tableModel;
    private JComboBox cbRelationals;
    private JComboBox cbPhysicals;
    private JComboBox cbDatabases = new JComboBox();
    private JLabel lbDB = new JLabel(Messages.getString("PM2PhysicalRolesDialog.SelectSQLServerDatabase"));
    private RelationalDesign reldes;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PM2PhysicalRolesDialog.this.close();
        }
    };

    public PM2PhysicalRolesDialog(DataFlowDesign dfDesign, ApplicationView appView) {
        this.dfDesign = dfDesign;
        this.appView = appView;
        this.setLayout(new BorderLayout());
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.createLeftPanel(), "West");
        jpanel.add((Component)this.createRightPanel(), "East");
        jpanel.add((Component)this.createBottomPanel(), "South");
        this.add((Component)jpanel, "Center");
    }

    private JPanel createLeftPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PM2PhysicalRolesDialog.AvailableRoles")));
        panel.setPreferredSize(this.dim);
        this.tableModel = new TableModel();
        JTable table = new JTable(this.tableModel);
        table.setSelectionMode(0);
        TableColumn column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        JScrollPane sp = new JScrollPane(table);
        panel.add((Component)sp, "Center");
        this.collectRoles();
        return panel;
    }

    private JPanel createRightPanel() {
        this.cbDatabases.setVisible(false);
        this.lbDB.setVisible(this.cbDatabases.isVisible());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PM2PhysicalRolesDialog.SelectModel")));
        panel.setPreferredSize(this.dim);
        Dimension dimension = new Dimension(220, 20);
        JPanel jpanel1 = new JPanel();
        JPanel pnRel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Messages.getString("PM2PhysicalRolesDialog.SelectRelationalModel"));
        pnRel.add((Component)label, "North");
        this.cbRelationals = new JComboBox<Object>(this.dfDesign.getDesign().getRelationalDesigns().toArray());
        this.cbRelationals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PM2PhysicalRolesDialog.this.updateStorageDesigns();
            }
        });
        this.cbRelationals.setPreferredSize(dimension);
        pnRel.add((Component)this.cbRelationals, "Center");
        jpanel1.add(pnRel);
        JPanel jpanel2 = new JPanel(new BorderLayout());
        JPanel jpanel22 = new JPanel();
        JPanel pnPhysicals = new JPanel(new BorderLayout());
        label = new JLabel(Messages.getString("PM2PhysicalRolesDialog.SelectPhysicalModel"));
        pnPhysicals.add((Component)label, "North");
        this.cbPhysicals = new JComboBox();
        this.cbPhysicals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PM2PhysicalRolesDialog.this.bnOK.setEnabled(PM2PhysicalRolesDialog.this.cbPhysicals.getSelectedItem() != null);
                PM2PhysicalRolesDialog.this.updateDBCombo();
            }
        });
        this.cbPhysicals.setPreferredSize(dimension);
        this.cbPhysicals.setToolTipText(Messages.getString("PM2PhysicalRolesDialog.OnlyOpenedUDBSQLServerCanBeSelected"));
        pnPhysicals.add((Component)this.cbPhysicals, "Center");
        jpanel22.add(pnPhysicals);
        jpanel2.add((Component)jpanel22, "North");
        JPanel jpanel3 = new JPanel();
        JPanel pnDB = new JPanel(new BorderLayout());
        pnDB.add((Component)this.lbDB, "North");
        this.cbDatabases.setPreferredSize(dimension);
        pnDB.add((Component)this.cbDatabases, "Center");
        jpanel3.add(pnDB);
        jpanel2.add(jpanel3);
        panel.add((Component)jpanel1, "North");
        panel.add((Component)jpanel2, "Center");
        this.updateStorageDesigns();
        return panel;
    }

    private void updateDBCombo() {
        boolean visible = this.cbPhysicals.getSelectedItem() != null && this.cbPhysicals.getSelectedItem() instanceof StorageDesignSqlServer;
        this.cbDatabases.setVisible(visible);
        this.lbDB.setVisible(visible);
        if (visible) {
            this.cbDatabases.removeAllItems();
            StorageDesignSqlServer sd = (StorageDesignSqlServer)this.cbPhysicals.getSelectedItem();
            Object[] dbs = sd.getDataBaseSet().toArray();
            for (int i = 0; i < dbs.length; ++i) {
                this.cbDatabases.addItem(dbs[i]);
            }
        }
    }

    private void collectRoles() {
        Object[] roles = this.dfDesign.getProcessModel().getRoleSet().toArray();
        ArrayList processes = new ArrayList();
        this.dfDesign.addAllPrimitiveProcessesConnectedToStore(processes);
        if (roles.length > 0 && processes.size() > 0) {
            block0: for (int i = 0; i < roles.length; ++i) {
                Role role = (Role)roles[i];
                List rp = role.getProcesses();
                for (Process process : rp) {
                    if (!processes.contains(process) || process.getProcessedEntities(true).size() <= 0) continue;
                    this.map.put(roles[i], Boolean.TRUE.toString());
                    continue block0;
                }
            }
        }
    }

    private void updateStorageDesigns() {
        if (this.cbRelationals.getSelectedItem() != null && this.cbRelationals.getSelectedItem() instanceof RelationalDesign) {
            RelationalDesign design = (RelationalDesign)this.cbRelationals.getSelectedItem();
            StorageDesign[] storegeDesigns = design.getStorageDesignFactory().getOpenStorageDesigns();
            Arrays.sort(storegeDesigns, new NameComparator());
            this.cbPhysicals.removeAllItems();
            for (int i = 0; i < storegeDesigns.length; ++i) {
                StorageDesign sd = storegeDesigns[i];
                if (!(sd instanceof StorageDesignUDB) && !(sd instanceof StorageDesignSqlServer) && !(sd instanceof StorageDesignOracle)) continue;
                this.cbPhysicals.addItem(sd);
            }
        }
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        this.bnOK.setMnemonic(84);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PM2PhysicalRolesDialog.this.transform();
                PM2PhysicalRolesDialog.this.close();
            }
        });
        this.bnOK.setEnabled(this.cbPhysicals.getItemCount() > 0);
        this.bnClose = new JButton(Messages.getString("PM2PhysicalRolesDialog.Cancel"));
        this.bnClose.setPreferredSize(this.bnOK.getPreferredSize());
        this.bnClose.setMnemonic(67);
        this.bnClose.addActionListener(this.escape);
        panel.add(this.bnOK);
        panel.add(this.bnClose);
        return panel;
    }

    private void close() {
        this.getJDialog().dispose();
    }

    private void transform() {
        Object selectedSD = this.cbPhysicals.getSelectedItem();
        this.reldes = (RelationalDesign)this.cbRelationals.getSelectedItem();
        if (selectedSD != null) {
            for (Role role : this.map.keySet()) {
                RoleOracle roleOracle;
                Process.ProcessedObject po;
                StorageObject permission;
                TableProxy tableProxy;
                Table table;
                PO_Tab pt;
                int i;
                StorageDesign sd;
                boolean checked = Boolean.valueOf((String)this.map.get(role));
                if (!checked) continue;
                Object[] objects = this.getTables(role.getProcesses()).toArray();
                if (selectedSD instanceof StorageDesignUDB) {
                    UserGroupUDB ug;
                    sd = (StorageDesignUDB)selectedSD;
                    if (this.reldes == null) {
                        this.reldes = sd.getPhysicalDesign();
                    }
                    if ((ug = (UserGroupUDB)((StorageDesignUDB)sd).getUserGroupSet().getByName(role.getName())) == null) {
                        ug = ((StorageDesignUDB)sd).getUserGroupSet().createUserGroup();
                        ug.setName(role.getName());
                    }
                    for (i = 0; i < objects.length; ++i) {
                        pt = (PO_Tab)objects[i];
                        table = pt.table;
                        tableProxy = (TableProxyUDB)sd.getProxy(table);
                        if (tableProxy == null) continue;
                        permission = this.getUDBPermission((StorageDesignUDB)sd, ug, tableProxy);
                        if (permission == null) {
                            permission = ((StorageDesignUDB)sd).getPermissionsSet().createPermissions();
                            ((PermissionsUDB)permission).setTable((TableProxyUDB)tableProxy);
                            ((PermissionsUDB)permission).setGroup(ug);
                        }
                        permission.setDirty(true);
                        po = pt.po;
                        if (po.isOpCreate()) {
                            ((PermissionsUDB)permission).setPrivileges("INSERT");
                        }
                        if (po.isOpDelete()) {
                            ((PermissionsUDB)permission).setPrivileges("DELETE");
                        }
                        if (po.isOpUpdate()) {
                            ((PermissionsUDB)permission).setPrivileges("UPDATE");
                        }
                        if (!po.isOpRead()) continue;
                        ((PermissionsUDB)permission).setPrivileges("SELECT");
                    }
                    continue;
                }
                if (selectedSD instanceof StorageDesignSqlServer) {
                    RoleSqlServer roleSQLServer;
                    sd = (StorageDesignSqlServer)selectedSD;
                    if (this.reldes == null) {
                        this.reldes = sd.getPhysicalDesign();
                    }
                    if ((roleSQLServer = (RoleSqlServer)((StorageDesignSqlServer)sd).getRoleSet().getByName(role.getName())) == null) {
                        roleSQLServer = ((StorageDesignSqlServer)sd).getRoleSet().createRole();
                        roleSQLServer.setName(role.getName());
                        roleSQLServer.setDatabase((DataBaseSqlServer)this.cbDatabases.getSelectedItem());
                    }
                    for (i = 0; i < objects.length; ++i) {
                        pt = (PO_Tab)objects[i];
                        table = pt.table;
                        tableProxy = (TableProxySqlServer)sd.getProxy(table);
                        if (tableProxy == null) continue;
                        permission = this.getSQLServerPermission((StorageDesignSqlServer)sd, roleSQLServer, tableProxy);
                        if (permission == null) {
                            permission = ((StorageDesignSqlServer)sd).getPermissionsSet().createPermissions();
                            ((PermissionsSqlServer)permission).setTable((TableProxySqlServer)tableProxy);
                            ((PermissionsSqlServer)permission).setRole(roleSQLServer);
                        }
                        permission.setDirty(true);
                        po = pt.po;
                        if (po.isOpCreate()) {
                            ((PermissionsSqlServer)permission).setPrivileges("INSERT");
                        }
                        if (po.isOpDelete()) {
                            ((PermissionsSqlServer)permission).setPrivileges("DELETE");
                        }
                        if (po.isOpUpdate()) {
                            ((PermissionsSqlServer)permission).setPrivileges("UPDATE");
                        }
                        if (!po.isOpRead()) continue;
                        ((PermissionsSqlServer)permission).setPrivileges("SELECT");
                    }
                    continue;
                }
                if (!(selectedSD instanceof StorageDesignOracle)) continue;
                sd = (StorageDesignOracle)selectedSD;
                if (this.reldes == null) {
                    this.reldes = sd.getPhysicalDesign();
                }
                if ((roleOracle = (RoleOracle)((StorageDesignOracle)sd).getRoleSet().getByName(role.getName())) == null) {
                    roleOracle = ((StorageDesignOracle)sd).getRoleSet().createRole();
                    roleOracle.setName(role.getName());
                }
                for (i = 0; i < objects.length; ++i) {
                    pt = (PO_Tab)objects[i];
                    table = pt.table;
                    tableProxy = (TableProxy)sd.getProxy(table);
                    if (tableProxy == null) continue;
                    permission = this.getOracleermission((StorageDesignOracle)sd, roleOracle, tableProxy);
                    if (permission == null) {
                        permission = ((StorageDesignOracle)sd).getPermissionsSet().createPermissions();
                        ((PermissionsOracle)permission).setTable((TableProxyOracle)tableProxy);
                        ((PermissionsOracle)permission).setRole(roleOracle);
                    }
                    permission.setDirty(true);
                    po = pt.po;
                    if (po.isOpCreate()) {
                        ((PermissionsOracle)permission).setPrivileges("INSERT");
                    }
                    if (po.isOpDelete()) {
                        ((PermissionsOracle)permission).setPrivileges("DELETE");
                    }
                    if (po.isOpUpdate()) {
                        ((PermissionsOracle)permission).setPrivileges("UPDATE");
                    }
                    if (!po.isOpRead()) continue;
                    ((PermissionsOracle)permission).setPrivileges("SELECT");
                }
            }
        }
    }

    private PermissionsUDB getUDBPermission(StorageDesignUDB sd, StorageObject userGroup, StorageObject proxy) {
        for (PermissionsUDB perm : sd.getPermissionsSet()) {
            if (perm.getGroup() != userGroup || perm.getTable() != proxy) continue;
            return perm;
        }
        return null;
    }

    private PermissionsSqlServer getSQLServerPermission(StorageDesignSqlServer sd, StorageObject role, StorageObject proxy) {
        for (PermissionsSqlServer perm : sd.getPermissionsSet()) {
            if (perm.getRole() != role || perm.getTable() != proxy) continue;
            return perm;
        }
        return null;
    }

    private PermissionsOracle getOracleermission(StorageDesignOracle sd, StorageObject role, StorageObject proxy) {
        for (PermissionsOracle perm : sd.getPermissionsSet()) {
            if (perm.getRole() != role || perm.getTable() != proxy) continue;
            return perm;
        }
        return null;
    }

    private List getTables(List processes) {
        ArrayList<PO_Tab> result = new ArrayList<PO_Tab>();
        for (int i = 0; i < processes.size(); ++i) {
            Process process = (Process)processes.get(i);
            List entities = process.getProcessedEntities(false);
            for (int j = 0; j < entities.size(); ++j) {
                Process.ProcessedObject po = (Process.ProcessedObject)entities.get(j);
                List tables = this.getTablesForEntity((Entity)po.getObject());
                for (Table table : tables) {
                    PO_Tab pt = new PO_Tab();
                    pt.po = po;
                    pt.table = table;
                    result.add(pt);
                }
            }
        }
        return result;
    }

    private List getTablesForEntity(Entity entity) {
        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
        if (entity.getGenerator() != null) {
            list.add(entity.getGenerator());
        } else {
            for (RelationalDesign design : this.dfDesign.getDesign().getRelationalDesigns()) {
                ModelIDObject impl = design.getTableSet().getObjectGeneratedBy(entity);
                if (impl == null) continue;
                list.add(impl);
            }
        }
        return list;
    }

    public void showDialog() {
        this.getJDialog().setVisible(true);
    }

    public JDialog getJDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.appView.getFrame(), Messages.getString("PM2PhysicalRolesDialog.TransformProcessModelRolesToPhysicalRoles"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PM2PhysicalRolesDialog.this.close();
                }
            });
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            int condition = 1;
            JComponent c = (JComponent)this.dialog.getContentPane();
            c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
            c.getActionMap().put(KEY_ESCAPE, this.escape);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        window.setLocation(newLocation);
    }

    private class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object o1, Object o2) {
            ModelObject sd1 = (ModelObject)o1;
            ModelObject sd2 = (ModelObject)o2;
            return sd1.getName().compareToIgnoreCase(sd2.getName());
        }
    }

    public class TableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PM2PhysicalRolesDialog.this.map.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PM2PhysicalRolesDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("PM2PhysicalRolesDialog.RoleName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Role role = (Role)PM2PhysicalRolesDialog.this.map.keySet().toArray()[row];
            if (col == 0) {
                return Boolean.valueOf((String)PM2PhysicalRolesDialog.this.map.get(role));
            }
            if (col == 1) {
                return role.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (col == 0) {
                Role role = (Role)PM2PhysicalRolesDialog.this.map.keySet().toArray()[row];
                PM2PhysicalRolesDialog.this.map.put(role, ((Boolean)obj).toString());
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    class PO_Tab {
        Process.ProcessedObject po;
        Table table;

        PO_Tab() {
        }
    }
}

