/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public abstract class CustomWizard
extends JDialog {
    protected ApplicationView view;
    protected JButton bnBack;
    protected JButton bnNext;
    protected JButton bnFinish;
    protected JButton bnCancel;
    protected JButton bnHelp;
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.doCancel();
        }
    };

    public CustomWizard(ApplicationView view) {
        super(view.getFrame());
        this.view = view;
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.initMainPanel(), "Center");
        this.getContentPane().add((Component)this.initBottomPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CustomWizard.this.doClosing();
            }
        });
        int condition = 2;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.setPreferredSize(new Dimension(960, 620));
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(true);
        this.setModal(true);
    }

    protected abstract String getCaption();

    protected abstract JPanel initMainPanel();

    protected String getHelpIndex() {
        return "";
    }

    protected JPanel initBottomPanel() {
        JPanel jpanel = new JPanel(new FlowLayout(2));
        this.bnBack = new JButton(Messages.getString("CustomWizard.Back"));
        this.bnBack.setMnemonic(66);
        this.bnBack.addActionListener(new BackAction());
        this.bnNext = new JButton(Messages.getString("CustomWizard.Next"));
        this.bnNext.setMnemonic(78);
        this.bnNext.addActionListener(new NextAction());
        this.bnFinish = new JButton(Messages.getString("CustomWizard.Finish"));
        this.bnFinish.setMnemonic(70);
        this.bnFinish.addActionListener(new FinishAction());
        this.bnCancel = new JButton(Messages.getString("CustomWizard.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnHelp = new JButton(Messages.getString("CustomWizard.Help"));
        this.bnHelp.setMnemonic(72);
        this.bnHelp.addActionListener(new HelpAction());
        this.bnBack.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnNext.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnFinish.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jpanel.add(this.bnBack);
        jpanel.add(this.bnNext);
        jpanel.add(this.bnFinish);
        jpanel.add(this.bnCancel);
        jpanel.add(this.bnHelp);
        this.getRootPane().setDefaultButton(this.bnNext);
        return jpanel;
    }

    protected abstract void doBack();

    protected abstract void doNext();

    protected abstract void doFinish();

    protected abstract void doCancel();

    protected void doClosing() {
    }

    protected void showHelp() {
        HelpManager.showTopic(this, this.getHelpIndex());
    }

    public ApplicationView getAppView() {
        return this.view;
    }

    private class BackAction
    implements ActionListener {
        private BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.doBack();
        }
    }

    private class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.doNext();
        }
    }

    private class FinishAction
    implements ActionListener {
        private FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.doFinish();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.doCancel();
        }
    }

    private class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomWizard.this.showHelp();
        }
    }
}

