/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;

public class TableSpacePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private TableSpaceUDB tableSpace;
    private JComboBox cbDBDefinition;
    private JComboBox cbManagedBy;
    private JComboBox cbType;
    private JComboBox cbNodegroup;
    private JComboBox cbPageSize;
    private JTextField ifExtentSize;
    private JTextField ifPrefetchSize;
    private JComboBox cbBufferPool;
    private JDecimalField dfOverhead;
    private JDecimalField dfTransferRate;
    private JComboBox cbDroppedTblRecovery;
    protected JPanel tables;
    protected DefaultListModel tablesListModel;
    protected JList tablesList;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected DefaultListModel allGroupsModel;
    protected DefaultListModel selectedGroupsModel;
    private JList allGroupsList;
    private JList selectedGroupsList;
    private JButton bnAddGroup;
    private JButton bnRemoveGroup;
    protected JComboBox cbGrantOption;

    public TableSpacePropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.tableSpace = (TableSpaceUDB)object;
        this.setHeight(450);
        this.initCommentsView(190);
        this.initCommentsInRDBMS(190);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableSpacePropertyDialogUDB.TableSpaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDBDefinition();
        this.initManagedBy();
        this.initType();
        this.initNodegroup();
        this.initPageSize();
        this.initExtentSize();
        this.initPrefetchSize();
        this.initBufferPool();
        this.initOverhead();
        this.initTransferRate();
        this.initDroppedTblRecovery();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initDBDefinition() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.DBDefinitionOnly"));
        this.general.add(label);
        this.cbDBDefinition = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDBDefinition);
        this.cbDBDefinition.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDBDefinition);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDBDefinition, 50);
    }

    private void initManagedBy() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.ManagedBy"));
        this.general.add(label);
        this.cbManagedBy = new JComboBox<Object>(TableSpaceUDB.getAvailableManagedByTypes());
        this.setBG(this.cbManagedBy);
        this.cbManagedBy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbManagedBy);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbManagedBy, 80);
    }

    private void initType() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.DataType"));
        this.general.add(label);
        this.cbType = new JComboBox<String>(TableSpaceUDB.getAvailableDataTypes());
        this.cbType.addActionListener(new TypeListener());
        this.setBG(this.cbType);
        this.cbType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbType);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbType, 110);
    }

    private void initNodegroup() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.Nodegroup"));
        this.general.add(label);
        this.cbNodegroup = new JComboBox();
        this.setBG(this.cbNodegroup);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getNodeGroupSet().toArray(), this.cbNodegroup);
        }
        this.cbNodegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNodegroup);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbNodegroup, 140);
    }

    private void initPageSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.PageSize"));
        this.general.add(label);
        this.cbPageSize = new JComboBox<Object>(TableSpaceUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbPageSize, 170);
    }

    private void initExtentSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.ExtentSize"));
        this.general.add(label);
        this.ifExtentSize = new JTextField("", 26);
        this.general.add(this.ifExtentSize);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifExtentSize, 200);
    }

    private void initPrefetchSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.PrefetchSize"));
        this.general.add(label);
        this.ifPrefetchSize = new JTextField("", 26);
        this.general.add(this.ifPrefetchSize);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifPrefetchSize, 230);
    }

    private void initBufferPool() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.BufferPool"));
        this.general.add(label);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbBufferPool, 260);
    }

    private void initOverhead() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.Overhead"));
        this.general.add(label);
        this.dfOverhead = new JDecimalField(0.0, 26);
        this.general.add(this.dfOverhead);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.dfOverhead, 290);
    }

    private void initTransferRate() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.TransferRate"));
        this.general.add(label);
        this.dfTransferRate = new JDecimalField(0.0, 26);
        this.general.add(this.dfTransferRate);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.dfTransferRate, 320);
    }

    private void initDroppedTblRecovery() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.DroppedTableRec"));
        this.general.add(label);
        this.cbDroppedTblRecovery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDroppedTblRecovery);
        this.cbDroppedTblRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDroppedTblRecovery);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbDroppedTblRecovery, 350);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TableSpacePropertyDialogUDB.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TableSpacePropertyDialogUDB.this.getStorageDesign().getTableSpaceSet().getElementsList());
                list.remove(TableSpacePropertyDialogUDB.this.tableSpace);
                new PropertiesPropagationDialog(TableSpacePropertyDialogUDB.this.getAppView(), TableSpacePropertyDialogUDB.this.tableSpace, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 390);
    }

    @Override
    protected void addTabs() {
        this.initUsePrivilegesView();
        this.initTablesView();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogUDB.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initToUserGroups();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.AllUsers"));
        this.usePrivilegesPanel.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(190, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.SelectedUsers"));
        this.usePrivilegesPanel.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(190, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 315, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 313, 32);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Add"));
        this.bnAddUser.addActionListener(new AddColumnsActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 215, 75);
        this.bnRemoveUser = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 215, 105);
        TableSpacePropertyDialogUDB.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    private void initToUserGroups() {
        this.initAllUserGroupsList();
        this.initSelectedUserGroupsList();
        this.initGroupsButtons();
    }

    private void initAllUserGroupsList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.AllUsersGroups"));
        this.usePrivilegesPanel.add(label);
        this.allGroupsModel = new DefaultListModel();
        this.allGroupsList = new JList(this.allGroupsModel);
        ListSelectionModel listSelectionModel = this.allGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllGroupListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allGroupsList);
        sp.setPreferredSize(new Dimension(190, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 184);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 202);
    }

    private void initSelectedUserGroupsList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.SelectedUserGroups"));
        this.usePrivilegesPanel.add(label);
        this.selectedGroupsModel = new DefaultListModel();
        this.selectedGroupsList = new JList(this.selectedGroupsModel);
        ListSelectionModel listSelectionModel = this.selectedGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedGroupListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedGroupsList);
        sp.setPreferredSize(new Dimension(190, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 315, 184);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 312, 202);
    }

    private void initGroupsButtons() {
        this.bnAddGroup = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Add"));
        this.bnAddGroup.addActionListener(new AddGroupsActionListener());
        this.bnAddGroup.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddGroup, 215, 245);
        this.bnRemoveGroup = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Remove"));
        this.bnRemoveGroup.setEnabled(false);
        this.bnRemoveGroup.addActionListener(new RemoveGroupsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveGroup, 215, 275);
        TableSpacePropertyDialogUDB.equalizeButtonSizes(this.bnAddGroup, this.bnRemoveGroup);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.GrantOption"));
        this.usePrivilegesPanel.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 350);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 350);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogUDB.Tables"), this.tables);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tablesList);
        spTS.setPreferredSize(new Dimension(495, 400));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTSLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbDBDefinition.setSelectedItem(this.tableSpace.getDBDefOnly() ? YES_NO[0] : YES_NO[1]);
        this.cbManagedBy.setSelectedItem(this.tableSpace.getManagedBy());
        this.cbType.setSelectedItem(this.tableSpace.getDataType());
        if (this.tableSpace.getDataType().equalsIgnoreCase("REGULAR")) {
            this.cbDroppedTblRecovery.setEnabled(true);
        } else {
            this.cbDroppedTblRecovery.setEnabled(false);
        }
        this.cbNodegroup.setSelectedItem(this.tableSpace.getNodeGroup());
        this.cbPageSize.setSelectedItem(this.tableSpace.getPageSize());
        this.ifExtentSize.setText(this.tableSpace.getExtentSize());
        this.ifPrefetchSize.setText(this.tableSpace.getPrefetchSize());
        this.cbBufferPool.setSelectedItem(this.tableSpace.getBufferPool());
        this.dfOverhead.setValue(this.tableSpace.getOverhead());
        this.dfTransferRate.setValue(this.tableSpace.getTransferRate());
        this.cbDroppedTblRecovery.setSelectedItem(this.tableSpace.getDroppedTableRecovery() ? YES_NO[0] : YES_NO[1]);
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (this.tableSpace.getUserSet().contains(user.getName())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        Object[] userGroupSet = this.getStorageDesign().getUserGroupSet().toArray();
        for (int i = 0; i < userGroupSet.length; ++i) {
            UserGroupUDB group = (UserGroupUDB)userGroupSet[i];
            if (this.tableSpace.getUserGroupSet().contains(group.getName())) {
                this.selectedGroupsModel.addElement(group);
                continue;
            }
            this.allGroupsModel.addElement(group);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogUDB.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        Object[] tss = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            if (((TableProxyUDB)tss[i]).getTableSpace() != this.tableSpace) continue;
            this.tablesListModel.addElement(tss[i]);
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.tableSpace.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null) {
            this.tableSpace.setName(this.tfName.getText());
            Object selected = this.cbDBDefinition.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setDBDefOnly(result);
            this.tableSpace.setManagedBy((String)this.cbManagedBy.getSelectedItem());
            this.tableSpace.setDataType((String)this.cbType.getSelectedItem());
            selected = this.cbNodegroup.getSelectedItem();
            if (selected instanceof NodeGroupUDB) {
                this.tableSpace.setNodeGroup((NodeGroupUDB)selected);
            } else {
                this.tableSpace.setNodeGroup(null);
            }
            this.tableSpace.setPageSize((Integer)this.cbPageSize.getSelectedItem());
            this.tableSpace.setExtentSize(this.ifExtentSize.getText());
            this.tableSpace.setPrefetchSize(this.ifPrefetchSize.getText());
            selected = this.cbBufferPool.getSelectedItem();
            if (selected instanceof BufferPoolUDB) {
                this.tableSpace.setBufferPool((BufferPoolUDB)selected);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setOverhead(this.dfOverhead.getFloatValue());
            this.tableSpace.setTransferRate(this.dfTransferRate.getFloatValue());
            selected = this.cbDroppedTblRecovery.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setDroppedTableRecovery(result);
            Object[] userSet = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)ob).getName());
            }
            Object[] userGroupsSet = this.selectedGroupsModel.toArray();
            for (int i = 0; i < userGroupsSet.length; ++i) {
                Object ob = userGroupsSet[i];
                if (!(ob instanceof UserGroupUDB)) continue;
                this.tableSpace.setGroups(((UserGroupUDB)ob).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogUDB.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.tableSpace.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)TableSpacePropertyDialogUDB.this.cbType.getSelectedItem()).equalsIgnoreCase("REGULAR")) {
                TableSpacePropertyDialogUDB.this.cbDroppedTblRecovery.setEnabled(true);
            } else {
                TableSpacePropertyDialogUDB.this.cbDroppedTblRecovery.setEnabled(false);
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.allUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnAddUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.selectedUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnRemoveUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDB.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDB.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDB.this.selectedUsersModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDB.this.selectedUsersModel.addElement(ob);
                    TableSpacePropertyDialogUDB.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDB.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDB.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDB.this.allUsersModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDB.this.allUsersModel.addElement(ob);
                    TableSpacePropertyDialogUDB.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class AllGroupListSelectionHandler
    implements ListSelectionListener {
        private AllGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.allGroupsList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnAddGroup.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnAddGroup.setEnabled(true);
                }
            }
        }
    }

    private class SelectedGroupListSelectionHandler
    implements ListSelectionListener {
        private SelectedGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.selectedGroupsList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnRemoveGroup.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnRemoveGroup.setEnabled(true);
                }
            }
        }
    }

    private class AddGroupsActionListener
    implements ActionListener {
        private AddGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDB.this.allGroupsModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDB.this.allGroupsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDB.this.selectedGroupsModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDB.this.selectedGroupsModel.addElement(ob);
                    TableSpacePropertyDialogUDB.this.allGroupsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveGroupsActionListener
    implements ActionListener {
        private RemoveGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDB.this.selectedGroupsModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDB.this.selectedGroupsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDB.this.allGroupsModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDB.this.allGroupsModel.addElement(ob);
                    TableSpacePropertyDialogUDB.this.selectedGroupsModel.removeElement(ob);
                }
            }
        }
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyUDB selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyUDB)TableSpacePropertyDialogUDB.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogUDB dialog = new TablePropertyDialogUDB(TableSpacePropertyDialogUDB.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

