/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ListPartitionPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ListPartitionPropertyDialogOraclev11g
extends ListPartitionPropertyDialogOraclev10g
implements ListSelectionListener {
    private ListPartitionOraclev11g listPartition;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel subPartOrderPanel;
    private JTable subPartitionsOrderTable;
    private List subPartitions;
    private DefaultListSelectionModel subPartSelectionModel;
    private SubPartitionsOrderModel subPartitionsOrderModel;
    private boolean subPartOrdered = false;

    public ListPartitionPropertyDialogOraclev11g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSubPartQuantity();
    }

    private void initSubPartQuantity() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.SubPartQuantity"));
        this.general.add(label);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.general.add(this.ifSubPartQuantity);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifSubPartQuantity, 200);
    }

    @Override
    protected void addTabs() {
        this.initSubPartTSView();
        this.initSubPartOrderTab();
        super.addTabs();
    }

    private void initSubPartTSView() {
        this.subPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ListPartitionPropertyDialogOracle.SubPartitionTableSpaces"), this.subPartTS);
        this.initSubPartTS();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initAllSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(label);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(label);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(Messages.getString("ListPartitionPropertyDialogOracle.Add"));
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 160, 90);
        this.bnRemoveSubPartTS = new JButton(Messages.getString("ListPartitionPropertyDialogOracle.Remove"));
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 160, 120);
        ListPartitionPropertyDialogOraclev11g.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    private void initSubPartOrderTab() {
        this.subPartOrderPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionsOrder"), this.subPartOrderPanel);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        btnProperties.addActionListener(new SubPartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            btnUp.addActionListener(new SubMoveUpAction());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            btnDown.addActionListener(new SubMoveDownAction());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.subPartOrderPanel.add(buttonGeneral);
        this.setObjectConstraints(this.getSubPartOrderLayout(), buttonGeneral, 10, 0);
        this.subPartitionsOrderModel = new SubPartitionsOrderModel();
        this.subPartSelectionModel = new DefaultListSelectionModel();
        this.subPartSelectionModel.setSelectionMode(2);
        this.subPartitionsOrderTable = new JTable(this.subPartitionsOrderModel);
        this.subPartitionsOrderTable.setSelectionModel(this.subPartSelectionModel);
        JScrollPane sp = new JScrollPane(this.subPartitionsOrderTable);
        sp.setPreferredSize(new Dimension(400, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartOrderPanel.add(sp);
        this.setObjectConstraints(this.getSubPartOrderLayout(), sp, 6, 40);
    }

    private SpringLayout getSubPartOrderLayout() {
        return (SpringLayout)this.subPartOrderPanel.getLayout();
    }

    private StorageObjectCollection getSubPartitions() {
        PartitionListOracle partList = this.listPartition.getPartitionList();
        if (partList != null) {
            String subpartType = partList.getSubpartitionType();
            if (subpartType.equals("HASH")) {
                return this.listPartition.getHashSubpartitions();
            }
            if (subpartType.equals("LIST")) {
                return this.listPartition.getListSubpartitions();
            }
            if (subpartType.equals("RANGE")) {
                return this.listPartition.getRangeSubpartitions();
            }
        }
        return null;
    }

    private boolean subMoveToIndex(Object object, int index) {
        if (this.subPartitions.contains(object) && this.subPartitions.size() > index && index >= 0) {
            this.subPartitions.remove(object);
            this.subPartitions.add(index, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel selModel, int[] selection) {
        selModel.clearSelection();
        if (selection.length > 0) {
            for (int i = selection.length - 1; i > -1; --i) {
                selModel.addSelectionInterval(selection[i], selection[i]);
            }
        }
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.listPartition = (ListPartitionOraclev11g)((ListPartitionPropertyDialogOraclev10g)this).listPartition;
        PartitionListOracle pl = this.listPartition.getPartitionList();
        if (this.listPartition.hasSubPartitions() || !pl.getSubpartitionType().equalsIgnoreCase("HASH")) {
            this.ifSubPartQuantity.setEnabled(false);
            int ind = this.getPane().indexOfComponent(this.subPartTS);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, false);
            }
        } else {
            this.ifSubPartQuantity.setValue((long)this.listPartition.getSubPartitionsQuantity());
        }
        this.subPartitions = new ArrayList();
        StorageObjectCollection subParts = this.getSubPartitions();
        if (subParts != null) {
            subParts.setForbiddenCreateElement(true);
            subParts.addAllElementsTo(this.subPartitions);
        }
        Iterator tsIt = this.listPartition.getSubPartTSSet().iterator();
        while (tsIt.hasNext()) {
            ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
            if (!(ts instanceof TableSpaceOracle)) continue;
            this.selectedSubPartTSModel.addElement(ts);
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedSubPartTSModel.contains(ts)) continue;
            this.allSubPartTSModel.addElement(ts);
        }
    }

    @Override
    protected void setProperties() {
        StorageObjectCollection storedSubParts;
        int size;
        super.setProperties();
        this.listPartition.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
        this.listPartition.getSubPartTSSet().clear();
        Object[] tsSet = this.selectedSubPartTSModel.toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            Object ts = tsSet[i];
            if (!(ts instanceof TableSpaceOraclev10g)) continue;
            this.listPartition.setSubPartitionsTableSpaces(((TableSpaceOraclev10g)ts).getObjectID());
        }
        if (this.subPartOrdered && (size = (storedSubParts = this.getSubPartitions()).size()) == this.subPartitions.size()) {
            this.subPartOrdered = false;
            for (int i = 0; i < size; ++i) {
                storedSubParts.justRemove(storedSubParts.getElement(0));
            }
            for (int i = 0; i < size; ++i) {
                if (this.subPartitions.get(i) instanceof PartitionOracle) {
                    PartitionOracle p = (PartitionOracle)this.subPartitions.get(i);
                    p.setParent(storedSubParts);
                    storedSubParts.add(p);
                    p.setPosition(i + 1);
                    continue;
                }
                storedSubParts.add((ModelObject)this.subPartitions.get(i));
            }
        }
    }

    @Override
    protected void clearOnDispose() {
        StorageObjectCollection subParts;
        PartitionListOracle partitionList = this.listPartition.getPartitionList();
        if (partitionList != null && (subParts = this.getSubPartitions()) != null) {
            subParts.setForbiddenCreateElement(partitionList.getSubpartitionType().equals(""));
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ListPartitionPropertyDialogOraclev11g.this.allSubPartTSList.getSelectedIndex() == -1) {
                    ListPartitionPropertyDialogOraclev11g.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    ListPartitionPropertyDialogOraclev11g.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    ListPartitionPropertyDialogOraclev11g.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    ListPartitionPropertyDialogOraclev11g.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = ListPartitionPropertyDialogOraclev11g.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.contains(ob)) continue;
                    ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.addElement(ob);
                    ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.contains(ob)) continue;
                    ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.addElement(ob);
                    ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SubPartitionPropertiesAction
    implements ActionListener {
        private SubPartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.getSelectedRow();
            if (row > -1 && row < ListPartitionPropertyDialogOraclev11g.this.subPartitions.size()) {
                StorageObject selected = (StorageObject)ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(row);
                selected.showPropertyDialog();
            }
        }
    }

    private class SubMoveUpAction
    implements ActionListener {
        private SubMoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(objectNumber);
                    ListPartitionPropertyDialogOraclev11g.this.subMoveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                ListPartitionPropertyDialogOraclev11g.this.setSelection(ListPartitionPropertyDialogOraclev11g.this.subPartSelectionModel, selection);
                ListPartitionPropertyDialogOraclev11g.this.subPartOrdered = true;
                ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubMoveDownAction
    implements ActionListener {
        private SubMoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < ListPartitionPropertyDialogOraclev11g.this.subPartitions.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(objectNumber);
                    ListPartitionPropertyDialogOraclev11g.this.subMoveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                ListPartitionPropertyDialogOraclev11g.this.setSelection(ListPartitionPropertyDialogOraclev11g.this.subPartSelectionModel, selection);
                ListPartitionPropertyDialogOraclev11g.this.subPartOrdered = true;
                ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubPartitionsOrderModel
    extends AbstractTableModel {
        private SubPartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (ListPartitionPropertyDialogOraclev11g.this.subPartitions == null) {
                return 0;
            }
            return ListPartitionPropertyDialogOraclev11g.this.subPartitions.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionName");
            }
            if (column == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StorageObject sel = (StorageObject)ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(row);
            if (col == 0) {
                return sel.getName();
            }
            if (col == 1) {
                if (sel instanceof PartitionOracle) {
                    return ((PartitionOracle)sel).getValueList();
                }
                if (sel instanceof ListStorageTemplatePartitionOracle) {
                    return ((ListStorageTemplatePartitionOracle)sel).getValueList();
                }
                return "";
            }
            return new Integer(row * col);
        }
    }
}

