/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SpatialColDefPropertiesDialog
extends CustomDialog {
    private JDialog dialog;
    private JButton bnOK;
    private JPanel general;
    private List sList;
    private JTable sTable;
    private JButton btnAddDimension;
    private JButton btnRemoveDimension;
    private static final int FIELD_WIDTH = 180;
    private static final int FIELD_HEIGHT = 20;
    private static final Dimension defaultSize = new Dimension(180, 20);
    private JComboBox cbSpatialColumn;
    private JCheckBox chFunction;
    private JButton btnFuncExpression;
    private JTextField ifSystemID;
    private Index spatialIndex;
    private Table table;
    private List columnsList;
    private List indexesList;
    private JTextField tfName;
    private SpatialColumnDefObject spDefinition;
    private Object sType;
    private boolean readOnly = false;
    private JComboBox cbIndex;
    private List wrList = new ArrayList();

    public SpatialColDefPropertiesDialog(ApplicationView appView, Table table, List columnsList, List indexesList, boolean readOnly) {
        super(appView);
        this.table = table;
        this.columnsList = columnsList;
        this.indexesList = indexesList;
        this.readOnly = readOnly;
        for (Index index : indexesList) {
            if (index.isPK() || index.isUnique() || index.isFK()) continue;
            WR wr = new WR(index);
            this.wrList.add(wr);
        }
        this.general = new JPanel(new BorderLayout(10, 10));
        this.setLayout(new BorderLayout());
        this.initGeneralView();
        this.add((Component)this.general, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        if (!readOnly) {
            this.bnOK = new JButton(Messages.getString("SpatialColDefPropertiesDialog.OK"));
            this.bnOK.addActionListener(new OKAction());
            this.bnOK.setMnemonic(79);
            this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bottomPanel.add(this.bnOK);
        }
        JButton bnCancel = new JButton(!readOnly ? Messages.getString("SpatialColDefPropertiesDialog.Cancel") : Messages.getString("SpatialColDefPropertiesDialog.Close"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnCancel);
        bottomPanel.add(bnHelp);
        this.add((Component)bottomPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.getCaption(), true);
            this.dialog.getContentPane().add(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.setSize(new Dimension(400, 400));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = SpatialColDefPropertiesDialog.this.dialog.getWidth();
                    int h = SpatialColDefPropertiesDialog.this.dialog.getHeight();
                    w = Math.max(400, w);
                    h = Math.max(400, h);
                    SpatialColDefPropertiesDialog.this.dialog.setSize(w, h);
                }
            });
            CommonUtil.centerOnScreen(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void initProperties(Object object) {
        if (object instanceof SpatialColumnDefObject) {
            WR wr;
            this.spDefinition = (SpatialColumnDefObject)object;
            this.tfName.setText(this.spDefinition.getName());
            this.updateSpatialColumns();
            this.cbSpatialColumn.setSelectedItem(this.spDefinition.getSpatialColumn());
            this.chFunction.setSelected(this.spDefinition.isFunction());
            this.btnFuncExpression.setText(this.spDefinition.getFuncExpression());
            this.ifSystemID.setText(this.spDefinition.getSystemID());
            this.sList.addAll(this.spDefinition.getTableDimensions());
            this.fillComboItems(this.wrList.toArray(), this.cbIndex, true);
            this.spatialIndex = this.spDefinition.getSpatialIndex();
            if (this.spatialIndex != null && (wr = this.getWR(this.wrList, this.spatialIndex)) != null) {
                this.cbIndex.setSelectedItem(wr);
            }
            this.enableSpatialComponents();
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "SPATIAL_COLUMN_DEF_DIALOG";
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    public String getCaption() {
        return Messages.getString("SpatialColDefPropertiesDialog.SpatialDefinitionProperties");
    }

    private void initGeneralView() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SpatialColDefPropertiesDialog.SpatialDefinition")));
        JPanel topPanel = new JPanel(new BorderLayout(10, 10));
        JPanel topGridPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        JLabel lbName = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.NameL"));
        lbName.setPreferredSize(this.getDefaultSize());
        this.tfName = new JTextField();
        this.tfName.setEnabled(!this.readOnly);
        topGridPanel.add(this.createRow(lbName, (Component)this.tfName));
        JLabel lbSpatialColumn = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.SpatialColumn"));
        lbSpatialColumn.setPreferredSize(this.getDefaultSize());
        this.cbSpatialColumn = new JComboBox();
        this.cbSpatialColumn.setEnabled(!this.readOnly);
        this.cbSpatialColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpatialColDefPropertiesDialog.this.enableSpatialComponents();
            }
        });
        topGridPanel.add(this.createRow(lbSpatialColumn, (Component)this.cbSpatialColumn));
        JLabel lbFunction = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.UseFunction"));
        lbFunction.setPreferredSize(this.getDefaultSize());
        this.chFunction = new JCheckBox();
        this.chFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpatialColDefPropertiesDialog.this.enableSpatialComponents();
            }
        });
        this.chFunction.setPreferredSize(this.getDefaultSize());
        this.chFunction.setEnabled(!this.readOnly);
        topGridPanel.add(this.createRow(lbFunction, (Component)this.chFunction));
        JLabel lbFuncExpression = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.FunctionExpressionL"));
        lbFuncExpression.setPreferredSize(this.getDefaultSize());
        this.btnFuncExpression = new JButton();
        this.btnFuncExpression.setPreferredSize(this.getDefaultSize());
        this.btnFuncExpression.setHorizontalAlignment(0);
        this.btnFuncExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor editor = new StringEditor(SpatialColDefPropertiesDialog.this.getApplicationView(), SpatialColDefPropertiesDialog.this.btnFuncExpression.getText(), Messages.getString("SpatialColDefPropertiesDialog.FunctionExpression"), SpatialColDefPropertiesDialog.this.readOnly);
                editor.setModal(true);
                editor.show();
                if (!editor.cancel) {
                    SpatialColDefPropertiesDialog.this.btnFuncExpression.setText(editor.getText());
                }
            }
        });
        topGridPanel.add(this.createRow(lbFuncExpression, (Component)this.btnFuncExpression));
        JLabel lbSystemID = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.CoordinateSystemID"));
        lbSystemID.setPreferredSize(this.getDefaultSize());
        this.ifSystemID = new JTextField();
        this.ifSystemID.setPreferredSize(this.getPreferredSize());
        this.ifSystemID.setEnabled(!this.readOnly);
        topGridPanel.add(this.createRow(lbSystemID, (Component)this.ifSystemID));
        JLabel lbsIndex = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.SpatialIndexName"));
        lbsIndex.setPreferredSize(this.getDefaultSize());
        this.cbIndex = new JComboBox();
        this.cbIndex.setPreferredSize(this.getDefaultSize());
        topGridPanel.add(this.createRow(lbsIndex, (Component)this.cbIndex));
        topPanel.add((Component)topGridPanel, "North");
        this.sList = new ArrayList();
        this.sTable = new JTable(new SpatialTableModel());
        this.sTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.sTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SpatialColDefPropertiesDialog.DimensionalInformation")));
        if (!this.readOnly) {
            this.btnAddDimension = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.btnAddDimension.setToolTipText(Messages.getString("SpatialColDefPropertiesDialog.Add"));
            this.btnAddDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpatialColumnDefObject.TableDimension dimension = SpatialColDefPropertiesDialog.this.spDefinition.new SpatialColumnDefObject.TableDimension();
                    SpatialColDefPropertiesDialog.this.sList.add(dimension);
                    SpatialColDefPropertiesDialog.this.sTable.updateUI();
                    if (SpatialColDefPropertiesDialog.this.sList.size() == 4) {
                        SpatialColDefPropertiesDialog.this.btnAddDimension.setEnabled(false);
                    }
                }
            });
            this.btnRemoveDimension = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.btnRemoveDimension.setToolTipText(Messages.getString("SpatialColDefPropertiesDialog.Remove"));
            this.btnRemoveDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowNumber = SpatialColDefPropertiesDialog.this.sTable.getSelectedRow();
                    if (rowNumber != -1 && SpatialColDefPropertiesDialog.this.sList.size() > 0 && rowNumber < SpatialColDefPropertiesDialog.this.sList.size()) {
                        SpatialColDefPropertiesDialog.this.sList.remove(rowNumber);
                        SpatialColDefPropertiesDialog.this.spDefinition.getTableDimensions().remove(rowNumber);
                        SpatialColDefPropertiesDialog.this.sTable.updateUI();
                        if (!SpatialColDefPropertiesDialog.this.btnAddDimension.isEnabled() && SpatialColDefPropertiesDialog.this.sList.size() < 4) {
                            SpatialColDefPropertiesDialog.this.btnAddDimension.setEnabled(true);
                        }
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnAddDimension);
            toolBar.add(this.btnRemoveDimension);
            buttonGeneral.add(toolBar);
            bottomPanel.add((Component)buttonGeneral, "North");
        }
        scrollpane.setPreferredSize(new Dimension(325, 100));
        bottomPanel.add(scrollpane);
        panel.add((Component)topPanel, "North");
        panel.add((Component)bottomPanel, "Center");
        this.general.add(panel);
    }

    private Dimension getDefaultSize() {
        return defaultSize;
    }

    private void setProperties() {
        int icol = this.sTable.getEditingColumn();
        int irow = this.sTable.getEditingRow();
        if (icol > -1 && irow > -1) {
            this.sTable.getCellEditor(irow, icol).stopCellEditing();
        }
        this.spDefinition.setName(this.tfName.getText());
        if (this.spatialIndex != null && !this.indexesList.contains(this.spatialIndex)) {
            this.indexesList.add(this.spatialIndex);
        }
        Index index = null;
        WR wr = (WR)this.cbIndex.getSelectedItem();
        if (wr != null) {
            index = wr.index;
        }
        if (this.spatialIndex != null && index != this.spatialIndex) {
            this.spatialIndex.setSpatialIndex(false);
            this.spatialIndex.setSpatialColumnDefiniton(null);
            ((IndexMemento)this.spatialIndex.getIndexMemento()).spatial = false;
        }
        this.spatialIndex = index;
        if (this.spatialIndex != null) {
            this.spatialIndex.setSpatialIndex(true);
            this.spatialIndex.setSpatialColumnDefiniton(this.spDefinition);
            ((IndexMemento)this.spatialIndex.getIndexMemento()).spatial = true;
            this.spatialIndex.setIndexExpression("");
        }
        this.spDefinition.setSpatialIndex(this.spatialIndex);
        if (this.cbSpatialColumn.isEnabled()) {
            Column column = (Column)this.cbSpatialColumn.getSelectedItem();
            this.spDefinition.setSpatialColumn(column);
            this.spDefinition.setFunction(false);
            this.spDefinition.setFuncExpression("");
            if (this.spatialIndex != null) {
                ((IndexMemento)this.spatialIndex.getIndexMemento()).expression = "";
                ((IndexMemento)this.spatialIndex.getIndexMemento()).columns.clear();
                if (column != null) {
                    ((IndexMemento)this.spatialIndex.getIndexMemento()).add(column);
                }
            }
        } else {
            this.spDefinition.setFunction(this.chFunction.isSelected());
            this.spDefinition.setFuncExpression(this.btnFuncExpression.getText().trim());
            if (this.spatialIndex != null) {
                ((IndexMemento)this.spatialIndex.getIndexMemento()).expression = this.btnFuncExpression.getText().trim();
                ((IndexMemento)this.spatialIndex.getIndexMemento()).columns.clear();
                this.spatialIndex.setIndexExpression(this.btnFuncExpression.getText().trim());
            }
            this.spDefinition.setSpatialColumn(null);
        }
        this.spDefinition.setSystemID(this.ifSystemID.getText());
        this.spDefinition.setTableDimensions(this.sList);
    }

    private void onCancel() {
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void enableSpatialComponents() {
        Object obj = this.cbSpatialColumn.getSelectedItem();
        if (obj != null) {
            this.chFunction.setEnabled(false);
            this.btnFuncExpression.setEnabled(false);
        } else {
            this.chFunction.setEnabled(!this.readOnly);
            this.btnFuncExpression.setEnabled(this.chFunction.isSelected());
            this.cbSpatialColumn.setEnabled(!this.readOnly ? !this.chFunction.isSelected() : false);
        }
    }

    protected JPanel createRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add((Component)lbName, "West");
        newRow.add(field, "Center");
        return newRow;
    }

    private void updateSpatialColumns() {
        this.cbSpatialColumn.removeAllItems();
        this.fillComboItems(this.getSpatialColumnsList().toArray(), this.cbSpatialColumn, true);
        this.cbSpatialColumn.setSelectedItem(this.spDefinition.getSpatialColumn());
    }

    private List getSpatialColumnsList() {
        ArrayList<Column> list = new ArrayList<Column>();
        Iterator it = this.columnsList.iterator();
        if (this.sType == null) {
            this.sType = this.table.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
        }
        while (it.hasNext()) {
            Column col = (Column)it.next();
            Datatype colType = col.getDataType();
            if (colType != this.sType) continue;
            list.add(col);
        }
        return list;
    }

    protected void fillComboItems(Object[] items, JComboBox comboBox, boolean addNull) {
        comboBox.removeAllItems();
        if (addNull) {
            comboBox.addItem(null);
        }
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    private WR getWR(List wrList, Index index) {
        for (WR wr : wrList) {
            if (wr.index != index) continue;
            return wr;
        }
        return null;
    }

    class WR {
        Index index;

        WR(Index index) {
            this.index = index;
        }

        public String toString() {
            return ((IndexMemento)this.index.getIndexMemento()).name;
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpatialColDefPropertiesDialog.this.setProperties();
            SpatialColDefPropertiesDialog.this.close();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpatialColDefPropertiesDialog.this.onCancel();
            SpatialColDefPropertiesDialog.this.close();
        }
    }

    public class SpatialTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return SpatialColDefPropertiesDialog.this.sList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SpatialColDefPropertiesDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("SpatialColDefPropertiesDialog.LowBoundary");
            }
            if (column == 2) {
                return Messages.getString("SpatialColDefPropertiesDialog.UpperBoundary");
            }
            if (column == 3) {
                return Messages.getString("SpatialColDefPropertiesDialog.Tolerance");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !SpatialColDefPropertiesDialog.this.readOnly;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SpatialColumnDefObject.TableDimension dimension = (SpatialColumnDefObject.TableDimension)SpatialColDefPropertiesDialog.this.sList.get(row);
            if (col == 0) {
                return dimension.getName();
            }
            if (col == 1) {
                return dimension.getLowBoundary();
            }
            if (col == 2) {
                return dimension.getUpperBoundary();
            }
            if (col == 3) {
                return dimension.getTolerance();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SpatialColumnDefObject.TableDimension dimension = (SpatialColumnDefObject.TableDimension)SpatialColDefPropertiesDialog.this.sList.get(rowIndex);
            if (columnIndex == 0) {
                dimension.setName((String)aValue);
            } else if (columnIndex == 1) {
                dimension.setLowBoundary((String)aValue);
            } else if (columnIndex == 2) {
                dimension.setUpperBoundary((String)aValue);
            } else if (columnIndex == 3) {
                dimension.setTolerance((String)aValue);
            }
        }
    }
}

