/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.PresummarizedLevelsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;
import oracle.ide.Ide;

public class SlicePropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Slice slice;
    private JCheckBox chReadOnly;
    private JComboBox cbEntity;
    private JCheckBox chFullyRealized;
    private JTable levelsTable;
    private JTable attributesTable;
    private List levelsList;
    private JTable scTable;
    private List scList;
    private List selectedMeasureWrappers;
    private List allMeasureWrappers;
    private List selectedLevels;
    private List selectedAttributes;
    private List allDimensions;
    private ContainerObject newEntity;
    private List usedFactEntities;
    private List aggrEntities;
    private StringBuffer sb;
    private StringBuffer eb;
    private boolean error = false;
    private boolean quote = false;
    private boolean aggrFirst;
    private final String indent = "   ";
    private final String tpref = "T";
    private boolean usePrefix = true;
    String quoteStr = "";
    private JTextField tfEntityName;
    private JButton bnNewEntity;
    private JTable smTable;
    private List smList;
    private JComboBox cbTypes;
    private JTextArea selPane;
    private JTabbedPane tab;
    private JTextField tfSchema;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private String schema = "";
    private RelationalDesign physDesign;
    private StorageDesign storDesign;
    private JCheckBox aggrCB;
    private JCheckBox quoteCB;
    List measureDependencies;
    boolean cyclicRef = false;
    private List sortedMeasures;
    private List tracedMeasures;
    private Map entMap;
    private List links;
    private List factPrefs;
    private List factRefs;
    private List factJoins;
    private List additonalTables;
    private List foreignKeys;
    private JPanel pnMeasures;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnSummaryLevels;
    private JButton btnAddSL;
    private JButton btnRemoveSL;
    private JTable sTable;
    private JPanel pnDimensions;
    private JPanel pnSelAttributes;
    private JPanel pnMapping;
    private JPanel pnQuery;
    private List rlist;
    private JPanel pnCriteria;
    private JPanel pnOracleAW;
    private List sqlList;
    private JTable sqlTable;
    private List newSQLList;
    private JButton btnDimensionProperties;
    private JButton btnRemoveDimension;
    private JButton btnSCProperties;
    private JButton btnRemoveSC;
    private JButton btnAWProperties;
    private JButton btnRemoveAW;

    public SlicePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public SlicePropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SlicePropertiesDialogEx.SliceProperties");
    }

    private void initGeneral() {
        JLabel lbReadOnly = new JLabel(LB_READ_ONLY);
        lbReadOnly.setPreferredSize(this.getDefaultSize());
        this.chReadOnly = new JCheckBox();
        this.chReadOnly.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbReadOnly, this.chReadOnly));
        JLabel lbFullyRealized = new JLabel(LB_FULLY_REALIZED);
        lbFullyRealized.setPreferredSize(this.getDefaultSize());
        this.chFullyRealized = new JCheckBox();
        this.chFullyRealized.setPreferredSize(this.getDefaultSize());
        this.chFullyRealized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlicePropertiesDialogEx.this.enableControls();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbFullyRealized, this.chFullyRealized));
        JLabel lbEntity = new JLabel(LB_ENTITY);
        lbEntity.setPreferredSize(this.getDefaultSize());
        this.cbEntity = new JComboBox();
        this.cbEntity.setPreferredSize(this.getDefaultSize());
        this.cbEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlicePropertiesDialogEx.this.enableSliceMappingsControls(SlicePropertiesDialogEx.this.cbEntity.getSelectedItem() == null);
                SlicePropertiesDialogEx.this.updateSliceMappings();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbEntity, this.cbEntity));
    }

    @Override
    protected String getHelpIndex() {
        return "SLICE_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Slice) {
            this.slice = (Slice)object;
            this.initDefaults(false);
            this.taDescription.setText(this.slice.getDescription());
            this.copySelectedLevels(this.slice.getSelectedLevels());
            this.makeSelectedAttributes();
            this.allDimensions.addAll(this.slice.getCube().getDimensions());
            this.chReadOnly.setSelected(this.slice.isReadOnlySlice());
            this.chFullyRealized.setSelected(this.slice.isFullyRealized());
            this.slice.verifyMeasureWrappers();
            this.selectedMeasureWrappers.addAll(this.slice.getSelectedMeasureWrappers());
            this.allMeasureWrappers.addAll(this.slice.getAllMeasureWrappers());
            this.fillComboItems(this.slice.getMultidimensionalDesign().getAllColntainers().toArray(), this.cbEntity, true);
            this.cbEntity.setSelectedItem(this.slice.getEntity());
            this.levelsList.addAll(this.slice.getLevels());
            this.rlist = new ArrayList();
            this.slice.getDesign().getRelationalDesigns().addAllElementsTo(this.rlist);
            this.fillComboItems(this.rlist.toArray(), this.cbRelDes, true);
            if (this.rlist.size() > 0) {
                this.cbRelDes.setSelectedItem(this.rlist.get(0));
            }
            this.scList.addAll(this.slice.getSelectionCriterias());
            this.sqlList.addAll(this.slice.getSQLDefinitions());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.makeQuery();
            this.enableControls();
            this.updateSliceMappings();
            this.initDynamicProperties();
        }
    }

    private List getMappings() {
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        for (SelObject so : this.selectedAttributes) {
            if (!so.selected) continue;
            result.add(so.object);
        }
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            result.add(mw.getMeasure());
        }
        return result;
    }

    private DesignObject getMapping(ContainedObject attributeID) {
        for (Slice.SliceMapping sm : this.slice.getSliceMappings()) {
            if (sm.getAttribute() != attributeID) continue;
            return sm.getMapping();
        }
        return null;
    }

    private void updateSliceMappings() {
        this.smList.clear();
        for (int i = ((DefaultTableModel)this.smTable.getModel()).getRowCount() - 1; i >= 0; --i) {
            ((DefaultTableModel)this.smTable.getModel()).removeRow(i);
        }
        if (this.cbEntity.getSelectedItem() != null) {
            ContainerObject entity = (ContainerObject)this.cbEntity.getSelectedItem();
            for (int i = 0; i < entity.getElements().length; ++i) {
                ContainedObject attribute = entity.getElement(i);
                DesignObject mapping = this.getMapping(attribute);
                Slice slice = this.slice;
                Objects.requireNonNull(slice);
                this.smList.add(slice.new Slice.SliceMapping(attribute, mapping));
            }
        }
        for (Slice.SliceMapping sm : this.smList) {
            ((DefaultTableModel)this.smTable.getModel()).addRow(new Object[]{sm.getAttribute().getLongName(), sm.getMapping()});
        }
        this.smTable.updateUI();
    }

    private void enableControls() {
        this.enableSliceMappingsControls(this.cbEntity.getSelectedItem() == null);
    }

    private void enableSliceMappingsControls(boolean enable) {
        if (this.tfEntityName != null) {
            this.tfEntityName.setEnabled(this.isEditable() ? enable : false);
        }
        if (this.bnNewEntity != null) {
            this.bnNewEntity.setEnabled(this.isEditable() ? enable : false);
        }
    }

    private void sortMeasures(List measures) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(measures);
        for (Measure measure : measures) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence md = this.getMeasureDependence(measure, this.measureDependencies);
        if (md == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (md.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (Measure meas : md.dependOn) {
            if (this.tracedMeasures.contains(meas) && !this.sortedMeasures.contains(meas)) {
                this.cyclicRef = true;
                String mname = "\"" + meas.getCube().getName() + "\".\"" + meas.getName() + "\"";
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.CyclicReferenceForMeasureP"), mname), Messages.getString("SlicePropertiesDialogEx.ListOfMeasuresWillNotBeComplete"), 0, 0, null, new String[]{Messages.getString("SlicePropertiesDialogEx.Ok")}, Messages.getString("SlicePropertiesDialogEx.Ok"));
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.CyclicReferenceForMeasure")).append(mname);
                return;
            }
            if (this.sortedMeasures.contains(meas)) continue;
            this.addToSorted(meas);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(Measure measure, List measureDependencies) {
        for (MeasureDependence md : measureDependencies) {
            if (md.measure != measure) continue;
            return md;
        }
        return null;
    }

    private List getMeasureDependencies(List measures) {
        ArrayList<MeasureDependence> list = new ArrayList<MeasureDependence>();
        for (Measure measure : measures) {
            MeasureDependence md = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                list.add(md);
                continue;
            }
            String formula = measure.getFormula();
            for (Measure measn : measures) {
                String namedq;
                if (measn == measure || formula.indexOf(namedq = "\"" + measn.getName().trim() + "\"") <= -1) continue;
                md.dependOn.add(measn);
            }
            list.add(md);
        }
        return list;
    }

    private void makeQuery() {
        this.physDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
        this.storDesign = (StorageDesign)this.cbStorage.getSelectedItem();
        this.aggrFirst = this.aggrCB.isSelected();
        this.quote = this.quoteCB.isSelected();
        this.error = false;
        this.quoteStr = this.quote ? "\"" : "";
        this.schema = this.tfSchema.getText();
        this.sb.setLength(0);
        this.eb.setLength(0);
        this.sb.append("Select ");
        this.sortMeasures(this.slice.getCube().getMeasures());
        if (!this.cyclicRef) {
            this.checkMeasures();
            this.makeTablesMapAndLinks();
            this.processMeasures("   ", this.aggrFirst);
            this.processSelectedAttributes(true);
            this.sb.append("\nFrom");
            this.addTables();
            this.addWhereClause();
            this.sb.append("\nGroup By");
            this.processSelectedAttributes(false);
        }
        if (this.error) {
            this.selPane.setText(this.eb.toString());
        } else {
            this.selPane.setText(this.sb.toString());
        }
    }

    private int testForMeasure(ContainerObject ent, List measures) {
        Iterator it = this.selectedMeasureWrappers.iterator();
        boolean multient = false;
        measures.clear();
        while (it.hasNext()) {
            Slice.MeasureWrapper mw = (Slice.MeasureWrapper)it.next();
            List list = mw.getMeasure().getFactEntities();
            if (!list.contains(ent)) continue;
            measures.add(mw.getMeasure());
            if (list.size() <= 1) continue;
            multient = true;
        }
        if (measures.size() > 0) {
            if (multient) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ModelIDObject getCorrespondentObject(DesignObject object) {
        if (this.storDesign != null) {
            if (object instanceof Entity) {
                Table tab = ((Entity)object).getEngTable(this.physDesign);
                if (tab != null) return (TableProxy)this.storDesign.getTableProxySet().getProxy(tab.getObjectID());
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableForEntity")).append(object.getName());
                return object;
            }
            if (object instanceof EntityView) {
                TableView tabView = ((EntityView)object).getEngTableView(this.physDesign);
                if (this.tab != null) return (TableViewProxy)this.storDesign.getTableViewProxySet().getProxy(tabView.getObjectID());
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableViewForEntityView"), object.getName()));
                return object;
            }
            if (object instanceof Attribute) {
                ContainedObject column = ((Attribute)object).getEngColumn(this.physDesign);
                if (column != null) return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingColumnForAttribute")).append(object.getLongName());
                return object;
            }
            if (object instanceof AttributeView) {
                ColumnView column = ((AttributeView)object).getEngColumnView(this.physDesign);
                if (column != null) return column;
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingcolumnViewForAttributeView")).append(object.getLongName());
                return object;
            }
            if (!(object.getDesignPart() instanceof RelationalDesign)) return object;
            StorageObject sto = this.storDesign.getStorageObject(object.getObjectID());
            if (sto == null) return object;
            return sto;
        }
        if (object instanceof Entity) {
            Table tab = ((Entity)object).getEngTable(this.physDesign);
            if (tab != null) return tab;
            this.error = true;
            this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableForEntity")).append(object.getName());
            return object;
        }
        if (object instanceof EntityView) {
            TableView tab = ((EntityView)object).getEngTableView(this.physDesign);
            if (tab != null) return tab;
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableViewForEntityView"), object.getName()));
            return object;
        }
        if (object instanceof Attribute) {
            ContainedObject column = ((Attribute)object).getEngColumn(this.physDesign);
            if (column != null) return column;
            this.error = true;
            this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingColumnForAttribute")).append(object.getLongName());
            return object;
        }
        if (!(object instanceof AttributeView)) return object;
        ColumnView column = ((AttributeView)object).getEngColumnView(this.physDesign);
        if (column != null) return column;
        this.error = true;
        this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingcolumnViewForAttributeView")).append(object.getLongName());
        return object;
    }

    private String getSchema(ModelIDObject object) {
        if (object instanceof TableProxy) {
            TableProxy tp = (TableProxy)object;
            StorageObject sto = tp.getUserSchema();
            if (sto != null) {
                return sto.getName();
            }
            String sch = tp.getSchemaImplementationName();
            if (!"".equals(sch)) {
                return sch;
            }
        }
        return this.schema;
    }

    private String factPref(ContainerObject ent) {
        Object obj = this.entMap.get(ent.getName());
        if (obj == null) {
            return "";
        }
        return (String)obj;
    }

    private void processFactEntities() {
        this.aggrEntities.clear();
        this.usePrefix = false;
        if (!this.aggrFirst) {
            boolean first = true;
            for (ContainerObject ent : this.slice.getCube().getFactEntities()) {
                ModelIDObject obj;
                ArrayList measures;
                int test = this.testForMeasure(ent, measures = new ArrayList());
                if (test <= -1 || (obj = this.getCorrespondentObject(ent)) == null) continue;
                String sch = this.getSchema(obj);
                if (sch != null && !"".equalsIgnoreCase(sch)) {
                    if (first) {
                        this.sb.append("\n   ").append(this.quoteStr + sch + this.quoteStr + ".").append(this.quoteStr + obj.getName() + this.quoteStr).append(" " + this.factPref(ent));
                        first = false;
                        continue;
                    }
                    this.sb.append(",\n   ").append(this.quoteStr + sch + this.quoteStr + ".").append(this.quoteStr + obj.getName() + this.quoteStr).append(" " + this.factPref(ent));
                    continue;
                }
                if (first) {
                    this.sb.append("\n   ").append(obj.getName()).append(" " + this.factPref(ent));
                    first = false;
                    continue;
                }
                this.sb.append(",\n   ").append(obj.getName()).append(" " + this.factPref(ent));
            }
        } else {
            boolean firstent = true;
            Iterator ite = this.slice.getCube().getFactEntities().iterator();
            ArrayList measures = new ArrayList();
            while (ite.hasNext()) {
                ModelIDObject obj;
                ContainerObject ent = (ContainerObject)ite.next();
                int test = this.testForMeasure(ent, measures);
                if (test == 1) {
                    ModelIDObject obj2 = this.getCorrespondentObject(ent);
                    if (obj2 == null) continue;
                    String sch = this.getSchema(obj2);
                    if (sch != null && !"".equalsIgnoreCase(sch)) {
                        if (firstent) {
                            this.sb.append("\n   ").append(this.quoteStr + sch + this.quoteStr + ".").append(this.quoteStr + obj2.getName() + this.quoteStr).append(" " + this.factPref(ent));
                            firstent = false;
                            continue;
                        }
                        this.sb.append(",\n   ").append(this.quoteStr + sch + this.quoteStr + ".").append(this.quoteStr + obj2.getName() + this.quoteStr).append(" " + this.factPref(ent));
                        continue;
                    }
                    if (firstent) {
                        this.sb.append("\n   ").append(obj2.getName()).append(" " + this.factPref(ent));
                        firstent = false;
                        continue;
                    }
                    this.sb.append(",\n   ").append(obj2.getName()).append(" " + this.factPref(ent));
                    continue;
                }
                if (test != 0) continue;
                this.aggrEntities.add(ent);
                if (firstent) {
                    this.sb.append("\n   (\n").append("   ").append("Select ");
                    firstent = false;
                } else {
                    this.sb.append(",\n   (\n").append("   ").append("Select ");
                }
                this.processMeasures("      ", false, measures, ent);
                this.processLinksToDimensions("      ", this.factRefs, ent);
                if (ent != null && (obj = this.getCorrespondentObject(ent)) != null) {
                    String sch = this.getSchema(obj);
                    if (sch != null && !"".equalsIgnoreCase(sch)) {
                        this.sb.append("\n").append("   ").append("From ").append(this.quoteStr + sch + this.quoteStr + ".").append(this.quoteStr + obj.getName() + this.quoteStr);
                    } else {
                        this.sb.append("\n").append("   ").append("From ").append(this.quoteStr + obj.getName() + this.quoteStr);
                    }
                }
                this.sb.append("\n").append("   ").append("Group By ");
                boolean first = true;
                for (int i = 0; i < this.factRefs.size(); ++i) {
                    Object object = this.factRefs.get(i);
                    if (object instanceof Slice.MeasureWrapper) {
                        Slice.MeasureWrapper mw = (Slice.MeasureWrapper)object;
                        String text = this.getMeasureExpression(mw.getMeasure());
                        if (first) {
                            this.sb.append("\n").append("      ").append(text);
                            first = false;
                            continue;
                        }
                        this.sb.append(",\n").append("      ").append(text);
                        continue;
                    }
                    ModelIDObject obj3 = this.getCorrespondentObject((DesignObject)object);
                    if (obj3 == null) continue;
                    if (first) {
                        this.sb.append("\n").append("      ").append(this.quoteStr + obj3.getName() + this.quoteStr);
                        first = false;
                        continue;
                    }
                    this.sb.append(",\n").append("      ").append(this.quoteStr + obj3.getName() + this.quoteStr);
                }
                this.sb.append("\n   ) " + this.factPref(ent));
            }
        }
        this.usePrefix = true;
    }

    private void processLinksToDimensions(String indent, List list, ContainerObject ent) {
        list.clear();
        boolean first = true;
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (!mw.getMeasure().isNonAdditive() || mw.getMeasure().getFactEntity() != ent) continue;
            list.add(mw);
            if (!first) {
                this.sb.append(",");
            } else {
                first = false;
            }
            Object text = this.getMeasureExpression(mw.getMeasure());
            text = (String)text + " AS \"" + mw.getMeasure().getName() + "\"";
            this.sb.append("\n").append(indent).append((String)text);
        }
        for (Slice.SelectedLevel sl : this.selectedLevels) {
            if (sl.rollupLink != null) {
                if (ent != sl.rollupLink.getFactEntity()) continue;
                list.addAll(sl.rollupLink.getChildToParentAttributes());
                continue;
            }
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = sl.getDimension();
            Link link = this.slice.getCube().getFirstLinkToTarget(dim);
            if (link == null || ent != link.getRollupLink().getFactEntity()) continue;
            list.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        for (FactEntitiesJoin fej : this.factJoins) {
            boolean found = false;
            List alist = null;
            if (fej.getLeftEntity() == ent) {
                found = true;
                alist = fej.getLeftAttributes();
            } else if (fej.getRightEntity() == ent) {
                found = true;
                alist = fej.getRightAttributes();
            }
            if (!found) continue;
            for (DesignObject obj : alist) {
                if (list.contains(obj)) continue;
                list.add(obj);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            ModelIDObject obj;
            if (list.get(i) instanceof Slice.MeasureWrapper || (obj = this.getCorrespondentObject((DesignObject)list.get(i))) == null) continue;
            if (first) {
                this.sb.append("\n").append(indent).append(this.quoteStr + obj.getName() + this.quoteStr);
                first = false;
                continue;
            }
            this.sb.append(",\n").append(indent).append(this.quoteStr + obj.getName() + this.quoteStr);
        }
    }

    private void processMeasures(String indent, boolean aliasOnly, List measures, ContainerObject ent) {
        boolean first = true;
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (mw.getMeasure().isFactDimension() || !measures.contains(mw.getMeasure())) continue;
            this.processMeasure(mw, aliasOnly, !first, indent);
            first = false;
        }
    }

    private String getMeasureExpression(Measure measure) {
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        if (!measure.isFormula()) {
            if (measure.getMeasureFact() != null) {
                ContainedObject attr = measure.getMeasureFact();
                ModelIDObject con = this.getCorrespondentObject(attr);
                ContainerObject ent = attr.getContainer();
                if (this.usePrefix) {
                    return this.factPref(ent) + "." + this.quoteStr + con.getName() + this.quoteStr;
                }
                return this.quoteStr + con.getName() + this.quoteStr;
            }
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.FactAttributeNotAssignedForMeasure"), measure.getName()));
            return "";
        }
        if (cube.getFactEntities().size() > 0) {
            String temp;
            ModelIDObject con;
            for (ContainerObject entity : cube.getFactEntities()) {
                Collection list = entity.getElementsCollection();
                for (ContainedObject obj : list) {
                    String obname = "\"" + obj.getLongName().trim() + "\"";
                    if (func.indexOf(obname) > -1) {
                        con = this.getCorrespondentObject(obj);
                        temp = this.usePrefix ? this.factPref(entity) + "." + this.quoteStr + con.getName().trim() + this.quoteStr : this.quoteStr + con.getName().trim() + this.quoteStr;
                        func = this.replace(func, obname, temp);
                        continue;
                    }
                    obname = "\"" + obj.getName().trim() + "\"";
                    if (func.indexOf(obname) <= -1) continue;
                    con = this.getCorrespondentObject(obj);
                    temp = this.usePrefix ? this.factPref(entity) + "." + this.quoteStr + con.getName().trim() + this.quoteStr : this.quoteStr + con.getName().trim() + this.quoteStr;
                    func = this.replace(func, obname, temp);
                }
            }
            for (Measure obj : cube.getMeasures()) {
                String obname;
                if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1) continue;
                if (!obj.isFormula()) {
                    if (obj.getMeasureFact() != null) {
                        ContainedObject attr = obj.getMeasureFact();
                        ContainerObject ent = attr.getContainer();
                        con = this.getCorrespondentObject(attr);
                        temp = this.usePrefix ? this.factPref(ent) + "." + this.quoteStr + con.getName().trim() + this.quoteStr : this.quoteStr + con.getName().trim() + this.quoteStr;
                        func = this.replace(func, obname, temp);
                        continue;
                    }
                    this.error = true;
                    this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.FactAttributeNotAssignedForMeasure"), measure.getName()));
                    continue;
                }
                String mexpression = "(" + this.getMeasureExpression(obj) + ")";
                func = this.replace(func, obname, mexpression);
            }
        } else {
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.FactEntityNotAssignedForCube"), cube.getName()));
        }
        return func;
    }

    private String replace(String origin, String str1, String str2) {
        String temp = str1.trim();
        Object result = origin;
        int ind = ((String)result).indexOf(temp);
        int lstr1 = temp.length();
        while (ind > -1) {
            String tresult = ind == 0 ? "" : ((String)result).substring(0, ind);
            int k = tresult.length() + str2.length();
            result = tresult + str2 + ((String)result).substring(ind + lstr1);
            ind = ((String)result).indexOf(temp, k);
        }
        return result;
    }

    private void processMeasure(Slice.MeasureWrapper mw, boolean aliasOnly, boolean addcomma, String indent) {
        Object text = aliasOnly ? (this.usePrefix && mw.getMeasure().getFactEntity() != null ? this.factPref(mw.getMeasure().getFactEntity()) + ".\"" + mw.getMeasureAlias() + "\"" : "\"" + mw.getMeasureAlias() + "\"") : this.getMeasureExpression(mw.getMeasure());
        text = mw.getFunctionName() + "(" + (String)text + ") AS \"" + mw.getMeasureAlias() + "\" ,";
        this.sb.append("\n").append(indent).append((String)text);
    }

    private void addTables() {
        this.processFactEntities();
        TreeMap sort = new TreeMap();
        DesignObjectSet es = this.slice.getMultidimensionalDesign().getEntitySet();
        for (String name : this.entMap.keySet()) {
            sort.put(this.entMap.get(name), name);
        }
        for (String pref : sort.keySet()) {
            ModelIDObject mo;
            ContainerObject ent;
            String name = (String)sort.get(pref);
            if (this.factPrefs.contains(pref) || (ent = (ContainerObject)es.getByName(name)) == null || (mo = this.getCorrespondentObject(ent)) == null) continue;
            String sch = this.getSchema(mo);
            if (sch != null && !"".equalsIgnoreCase(sch)) {
                this.sb.append(",\n   ").append(this.quoteStr + sch + this.quoteStr + "." + this.quoteStr + mo.getName() + this.quoteStr + " " + pref);
                continue;
            }
            this.sb.append(",\n   ").append(this.quoteStr + mo.getName() + this.quoteStr + " " + pref);
        }
    }

    private String getTablePrefix(ContainerObject entity) {
        String pref;
        if (entity != null && (pref = (String)this.entMap.get(entity.getName())) != null) {
            return pref + ".";
        }
        return "";
    }

    private void addWhereClause() {
        ModelIDObject mo2;
        ModelIDObject mo1;
        String pref2;
        String pref1;
        ContainedObject attr2;
        ContainedObject attr1;
        Cube cube = this.slice.getCube();
        this.sb.append("\nWhere");
        boolean first = true;
        for (FactEntitiesJoin fej : this.factJoins) {
            for (int i = 0; i < fej.getLeftAttributes().size(); ++i) {
                ContainedObject attr12 = (ContainedObject)fej.getLeftAttributes().get(i);
                ContainedObject attr22 = (ContainedObject)fej.getRightAttributes().get(i);
                String pref12 = this.getTablePrefix(fej.getLeftEntity());
                String pref22 = this.getTablePrefix(fej.getRightEntity());
                ModelIDObject mo12 = this.getCorrespondentObject(attr12);
                ModelIDObject mo22 = this.getCorrespondentObject(attr22);
                if (!first) {
                    this.sb.append(" AND ");
                } else {
                    first = false;
                }
                this.sb.append("\n   ").append(pref12 + this.quoteStr + mo12.getName() + this.quoteStr + " = " + pref22 + this.quoteStr + mo22.getName() + this.quoteStr);
            }
        }
        for (Slice.SelectedLevel sl : this.selectedLevels) {
            Level level = (Level)sl.getHierarchy().getLevels().get(0);
            Link link = cube.getFirstLinkToTarget(sl.getDimension());
            if (link == null) continue;
            RollupLink rlink = link.getRollupLink();
            if (sl.rollupLink != null) {
                rlink = sl.rollupLink;
            }
            if (rlink.getChildToParentAttributes().size() == level.getLevelKey().size()) {
                for (int i = 0; i < rlink.getChildToParentAttributes().size(); ++i) {
                    attr1 = (ContainedObject)rlink.getChildToParentAttributes().get(i);
                    attr2 = (ContainedObject)level.getLevelKey().get(i);
                    pref1 = this.getTablePrefix(attr1.getContainer());
                    pref2 = this.getTablePrefix(attr2.getContainer());
                    mo1 = this.getCorrespondentObject(attr1);
                    mo2 = this.getCorrespondentObject(attr2);
                    if (!first) {
                        this.sb.append(" AND ");
                    } else {
                        first = false;
                    }
                    this.sb.append("\n   ").append(pref1 + this.quoteStr + mo1.getName() + this.quoteStr + " = " + pref2 + this.quoteStr + mo2.getName() + this.quoteStr);
                }
                continue;
            }
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NumberOfReferenceAttributesInCubeDiffer"), cube.getName(), level.getName()));
        }
        for (Link link : this.links) {
            RollupLink rlink = link.getRollupLink();
            Level tlevel = (Level)link.getTargetMDObject();
            Level slevel = (Level)link.getSourceMDObject();
            if (rlink.getChildToParentAttributes().size() == tlevel.getLevelKey().size()) {
                for (int i = 0; i < rlink.getChildToParentAttributes().size(); ++i) {
                    attr1 = (ContainedObject)rlink.getChildToParentAttributes().get(i);
                    attr2 = (ContainedObject)tlevel.getLevelKey().get(i);
                    pref1 = this.getTablePrefix(attr1.getContainer());
                    pref2 = this.getTablePrefix(attr2.getContainer());
                    mo1 = this.getCorrespondentObject(attr1);
                    mo2 = this.getCorrespondentObject(attr2);
                    if (!first) {
                        this.sb.append(" AND ");
                    } else {
                        first = false;
                    }
                    this.sb.append("\n   ").append(pref1 + this.quoteStr + mo1.getName() + this.quoteStr + " = " + pref2 + this.quoteStr + mo2.getName() + this.quoteStr);
                }
                continue;
            }
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NumberOfReferenceAttributesInCubeDiffer"), slevel.getName(), tlevel.getName()));
        }
    }

    private String getCAExpression(CalculatedAttribute ca) {
        Level level = ca.getLevel();
        String func = ca.getFunction();
        for (DesignObject obj : level.getLevelEntity().getElementsCollection()) {
            ModelIDObject con;
            String obname;
            if (obj == ca || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1 || (con = this.getCorrespondentObject(obj)) == null) continue;
            String temp = this.getTablePrefix(level.getLevelEntity()) + this.quoteStr + con.getName().trim() + this.quoteStr;
            func = this.replace(func, obname, temp);
        }
        return func;
    }

    private void processSelectedAttributes(boolean addalias) {
        boolean first = true;
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (!mw.getMeasure().isNonAdditive()) continue;
            if (!first) {
                this.sb.append(",");
            } else {
                first = false;
            }
            ContainerObject ent = mw.getMeasure().getFactEntity();
            Object text = this.getMeasureExpression(mw.getMeasure());
            if (addalias) {
                if (this.aggrFirst && this.aggrEntities.contains(ent)) {
                    text = this.factPref(mw.getMeasure().getFactEntity()) + ".\"" + mw.getMeasure().getName() + "\"";
                }
                text = (String)text + " AS \"" + mw.getMeasure().getName() + "\"";
            } else if (this.aggrFirst && this.aggrEntities.contains(ent)) {
                text = this.factPref(mw.getMeasure().getFactEntity()) + ".\"" + mw.getMeasure().getName() + "\"";
            }
            this.sb.append("\n").append("   ").append((String)text);
        }
        for (Slice.SelectedLevel sl : this.selectedLevels) {
            Iterator its = sl.getSelectedAttributes().iterator();
            while (its.hasNext()) {
                if (!first) {
                    this.sb.append(",");
                } else {
                    first = false;
                }
                DesignObject dobj = (DesignObject)its.next();
                if (dobj instanceof CalculatedAttribute) {
                    String func = this.getCAExpression((CalculatedAttribute)dobj);
                    if (addalias) {
                        this.sb.append("\n").append("   ").append(func).append(" AS \"" + dobj.getName() + "\"");
                        continue;
                    }
                    this.sb.append("\n").append("   ").append(func);
                    continue;
                }
                ModelIDObject obj = this.getCorrespondentObject(dobj);
                if (addalias) {
                    this.sb.append("\n").append("   ").append(this.getTablePrefix(sl.getLevel().getLevelEntity())).append(this.quoteStr + obj.getName() + this.quoteStr);
                    continue;
                }
                this.sb.append("\n").append("   ").append(this.getTablePrefix(sl.getLevel().getLevelEntity())).append(this.quoteStr + obj.getName() + this.quoteStr);
            }
        }
    }

    private void processMeasures(String indent, boolean aliasOnly) {
        boolean first = true;
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (mw.getMeasure().isNonAdditive()) continue;
            this.processMeasure(mw, aliasOnly, !first, indent);
            first = false;
        }
    }

    private void checkMeasures() {
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (!mw.getMeasure().isSemiAdditive()) continue;
            Measure.AggregateFunction af = mw.getAggrFunction();
            for (Slice.SelectedLevel sl : this.selectedLevels) {
                if (af.isDefinedOnDimension(sl.getDimension())) continue;
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.SemiAdditiveMeasureNotDefined"), mw.getMeasure().getName(), sl.getDimension().getName()));
            }
        }
    }

    private List getUsedFactEntities() {
        Cube cube = this.slice.getCube();
        ArrayList<ContainerObject> list = new ArrayList<ContainerObject>();
        Iterator it = cube.getFactEntities().iterator();
        ArrayList measures = new ArrayList();
        while (it.hasNext()) {
            ContainerObject ent = (ContainerObject)it.next();
            int test = this.testForMeasure(ent, measures);
            if (test <= -1) continue;
            list.add(ent);
        }
        return list;
    }

    private void makeFactJoins() {
        this.factJoins.clear();
        this.additonalTables.clear();
        this.foreignKeys.clear();
        if (this.usedFactEntities.size() > 1) {
            List joins = this.slice.getCube().getJoins();
            if (joins.size() < this.usedFactEntities.size() - 1) {
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.JoinsNotEnough"), this.slice.getCube().getName()));
            } else {
                for (FactEntitiesJoin fej : joins) {
                    if (!this.usedFactEntities.contains(fej.getLeftEntity()) || !this.usedFactEntities.contains(fej.getRightEntity())) continue;
                    this.factJoins.add(fej);
                }
            }
        }
    }

    private void makeTablesMapAndLinks() {
        this.usedFactEntities = this.getUsedFactEntities();
        this.makeFactJoins();
        if (this.usedFactEntities.size() == 0) {
            this.error = true;
            if (this.selectedMeasureWrappers.size() == 0) {
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoMeasuresSelected"));
            } else {
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoAttributesUsageInSelectedMeasuresDefinition"));
            }
        }
        this.entMap.clear();
        this.links.clear();
        this.factPrefs.clear();
        Iterator ite = this.usedFactEntities.iterator();
        int i = 1;
        while (ite.hasNext()) {
            ContainerObject ent = (ContainerObject)ite.next();
            String pref = "T" + String.valueOf(i);
            this.factPrefs.add(pref);
            this.entMap.put(ent.getName(), pref);
            ++i;
        }
        block1: for (Slice.SelectedLevel sl : this.selectedLevels) {
            Object ob;
            ContainerObject fent;
            if (sl.rollupLink != null && (fent = sl.rollupLink.getFactEntity()) != null && (ob = this.entMap.get(fent.getName())) == null) {
                String pref = "T" + String.valueOf(i);
                this.entMap.put(fent.getName(), pref);
                ++i;
            }
            Level slevel = sl.getLevel();
            Level prevlev = (Level)sl.getHierarchy().getLevels().get(0);
            for (Level level : sl.getHierarchy().getLevels()) {
                Link link;
                String pref;
                Object ob2;
                ContainerObject lent;
                if (level != slevel) {
                    lent = level.getLevelEntity();
                    if (lent != null) {
                        ob2 = this.entMap.get(lent.getName());
                        if (ob2 == null) {
                            pref = "T" + String.valueOf(i);
                            this.entMap.put(lent.getName(), pref);
                            ++i;
                        }
                    } else {
                        this.error = true;
                        this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLevelEntityForLevel"), level.getName()));
                    }
                    if (prevlev.getLevelEntity() != level.getLevelEntity()) {
                        link = prevlev.getFirstLinkToTarget(level);
                        if (link != null) {
                            if (!this.links.contains(link)) {
                                this.links.add(link);
                            }
                        } else {
                            this.error = true;
                            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLinkBetweenLevel"), prevlev.getName(), level.getName()));
                        }
                    }
                    prevlev = level;
                    continue;
                }
                lent = level.getLevelEntity();
                if (lent != null) {
                    ob2 = this.entMap.get(lent.getName());
                    if (ob2 == null) {
                        pref = "T" + String.valueOf(i);
                        this.entMap.put(lent.getName(), pref);
                        ++i;
                    }
                } else {
                    this.error = true;
                    this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLevelEntityForLevel"), level.getName()));
                }
                if (prevlev.getLevelEntity() == level.getLevelEntity()) continue block1;
                link = prevlev.getFirstLinkToTarget(level);
                if (link != null) {
                    if (this.links.contains(link)) continue block1;
                    this.links.add(link);
                    continue block1;
                }
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLinkBetweenLevel"), prevlev.getName(), level.getName()));
                continue block1;
            }
        }
    }

    private void copySelectedLevels(List slevels) {
        Iterator it = slevels.iterator();
        this.selectedLevels.clear();
        while (it.hasNext()) {
            Slice.SelectedLevel sl1 = (Slice.SelectedLevel)it.next();
            Slice slice = this.slice;
            Objects.requireNonNull(slice);
            Slice.SelectedLevel sl2 = slice.new Slice.SelectedLevel(sl1.getDimension(), sl1.getHierarchy(), sl1.getLevel(), this.slice);
            sl2.getSelectedAttributes().addAll(sl1.getSelectedAttributes());
            sl2.rollupLink = sl1.rollupLink;
            this.selectedLevels.add(sl2);
        }
    }

    private void makeSelectedAttributes() {
        this.selectedAttributes.clear();
        for (int i = 0; i < this.selectedLevels.size(); ++i) {
            Slice.SelectedLevel sl = (Slice.SelectedLevel)this.selectedLevels.get(i);
            SelObject so = new SelObject(sl.getLevel(), sl);
            this.selectedAttributes.add(so);
            for (DesignObject dobj : sl.getLevel().getAllAttributes()) {
                SelObject sob = new SelObject(dobj, sl);
                if (sl.getSelectedAttributes().contains(dobj)) {
                    sob.selected = true;
                }
                this.selectedAttributes.add(sob);
            }
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.aggrEntities = new ArrayList();
        this.sb = new StringBuffer();
        this.eb = new StringBuffer();
        this.scList = new ArrayList();
        this.levelsList = new ArrayList();
        this.selectedMeasureWrappers = new ArrayList();
        this.allMeasureWrappers = new ArrayList();
        this.selectedLevels = new ArrayList();
        this.selectedAttributes = new ArrayList();
        this.allDimensions = new ArrayList();
        this.smList = new ArrayList();
        this.sortedMeasures = new ArrayList();
        this.tracedMeasures = new ArrayList();
        this.entMap = new HashMap();
        this.links = new ArrayList();
        this.factPrefs = new ArrayList();
        this.factRefs = new ArrayList();
        this.factJoins = new ArrayList();
        this.additonalTables = new ArrayList();
        this.foreignKeys = new ArrayList();
        this.sqlList = new ArrayList();
        this.newSQLList = new ArrayList();
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getMeasuresPanel());
        this.addToTree(root, this.getDimensionsPanel());
        this.addToTree(root, this.getSelAttributesPanel());
        this.addToTree(root, this.getMappingPanel());
        this.addToTree(root, this.getQueryPanel());
        this.addToTree(root, this.getCriteriaPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getOracleAWPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    private boolean containsWrapperFor(List list, Measure measure, String funcID) {
        for (Slice.MeasureWrapper mw : list) {
            if (mw.getMeasure() != measure || !mw.getAggrFunction().getObjectID().equals(funcID)) continue;
            return true;
        }
        return false;
    }

    private Slice.MeasureWrapper getMeasureWrapperFor(Measure measure) {
        for (Slice.MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (mw.getMeasure() != measure) continue;
            return mw;
        }
        return null;
    }

    @Override
    protected void setProperties() {
        this.slice.setName(this.tfName.getText());
        this.slice.setComment(this.taComments.getText());
        this.slice.setNotes(this.taNotes.getText());
        this.slice.setDescription(this.taDescription.getText());
        this.slice.setReadOnlySlice(this.chReadOnly.isSelected());
        this.slice.setFullyRealized(this.chFullyRealized.isSelected());
        this.slice.setEntity((ContainerObject)this.cbEntity.getSelectedItem());
        ContainerObject ent = this.slice.getEntity();
        if (ent != null && ent instanceof ContainerWithKeyObject) {
            ((ContainerWithKeyObject)ent).setTypeID("4");
        }
        this.slice.getSelectionCriterias().clear();
        for (SelectionCriteria criteria : this.scList) {
            if (criteria.getMeasureWrapper() == null || !this.containsWrapperFor(this.selectedMeasureWrappers, criteria.getMeasureWrapper().getMeasure(), criteria.getMeasureWrapper().getAggrFunction().getObjectID())) continue;
            this.slice.addSelectionCriteria(criteria);
        }
        this.slice.getSelectedMeasureWrappers().clear();
        this.slice.getSelectedMeasureWrappers().addAll(this.selectedMeasureWrappers);
        this.slice.getSelectedLevels().clear();
        this.slice.getSelectedLevels().addAll(this.selectedLevels);
        this.slice.getSliceMappings().clear();
        for (Slice.SliceMapping sm : this.smList) {
            Measure measure;
            Slice.MeasureWrapper mw;
            this.slice.getSliceMappings().add(sm);
            if (!(sm.getMapping() instanceof Measure) || (mw = this.getMeasureWrapperFor(measure = (Measure)sm.getMapping())) == null) continue;
            Object func = measure.getMeasureExpression(measure);
            func = mw.getFunctionName() + "(" + (String)func + ")";
            sm.getAttribute().setSourceType(Messages.getString("SlicePropertiesDialogEx.Aggregate"));
            sm.getAttribute().setFormulaDesc((String)func);
        }
        this.slice.getSQLDefinitions().clear();
        this.slice.getSQLDefinitions().addAll(this.sqlList);
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        SlicePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.slice.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.slice.setProperty(dp.getName(), dp.getValue());
        }
    }

    private List makeSelectedDimensions() {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension>();
        for (Slice.SelectedLevel sl : this.selectedLevels) {
            list.add(sl.getDimension());
        }
        return list;
    }

    private void makeSelectionCriteria(List before, List after) {
        for (Slice.MeasureWrapper mw : after) {
            String where;
            if (before.indexOf(mw) != -1 || "".equals(where = mw.getMeasure().getWhereClause().trim()) || this.findSelectionCriteriaFor(mw) != null) continue;
            SelectionCriteria criteria = ((MultidimensionalDesign)this.slice.getDesignPart()).createSelectionCriteria();
            criteria.setSlice(this.slice);
            criteria.setMeasureWrapper(mw);
            criteria.setSelectionCriteria(where);
            this.scList.add(criteria);
            this.scTable.updateUI();
        }
    }

    private SelectionCriteria findSelectionCriteriaFor(Slice.MeasureWrapper mw) {
        for (SelectionCriteria sc : this.scList) {
            if (sc.getMeasureWrapper().getMeasure() != mw.getMeasure() || !sc.getMeasureWrapper().getAggrFunction().getObjectID().equals(mw.getAggrFunction().getObjectID())) continue;
            return sc;
        }
        return null;
    }

    protected JPanel getMeasuresPanel() {
        if (this.pnMeasures == null) {
            this.pnMeasures = this.createPage(Messages.getString("SlicePropertiesDialogEx.Measures"));
            this.sTable = new JTable(new MeasureWrappersModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SlicePropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        Slice.MeasureWrapper mw = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                        String title = MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.SummaryLevelsFor"), mw.getMeasureAlias());
                        PresummarizedLevelsDialog sld = new PresummarizedLevelsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.makeSelectedDimensions(), mw.levels, title);
                        sld.setVisible(true);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SlicePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        Slice.MeasureWrapper mw = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                        Measure measure = (Measure)((MultidimensionalDesign)SlicePropertiesDialogEx.this.slice.getDesignPart()).getMeasureSet().getObjectByID(mw.getMeasure().getObjectID());
                        if (measure != null) {
                            measure.showPropertyDialog();
                        }
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArrayList list = new ArrayList();
                        list.addAll(SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        SelectElementsDialog dialog = new SelectElementsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.allMeasureWrappers, SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        dialog.setVisible(true);
                        SlicePropertiesDialogEx.this.makeSelectionCriteria(list, SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        SlicePropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = SlicePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && objectNumber < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            SlicePropertiesDialogEx.this.selectedMeasureWrappers.remove(objectNumber);
                            SlicePropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                this.btnSummaryLevels = new JButton(configuration.getIcon("LEVEL_ICON", this.getPreferredIconSize()));
                this.btnSummaryLevels.setToolTipText(Messages.getString("SlicePropertiesDialogEx.SetOracleAWPresummarizedLevels"));
                this.btnSummaryLevels.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = SlicePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (row != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            Slice.MeasureWrapper mw = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                            String title = MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.SummaryLevelsFor"), mw.getMeasureAlias());
                            PresummarizedLevelsDialog sld = new PresummarizedLevelsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.makeSelectedDimensions(), mw.levels, title);
                            sld.setVisible(true);
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
                toolBar.addSeparator();
                toolBar.add(this.btnSummaryLevels);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnMeasures.add(pPanel);
        }
        return this.pnMeasures;
    }

    private void updateSelectedAttributes() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.selectedAttributes);
        this.selectedAttributes.clear();
        for (int i = 0; i < this.selectedLevels.size(); ++i) {
            Slice.SelectedLevel sl = (Slice.SelectedLevel)this.selectedLevels.get(i);
            SelObject so = this.findSelObjectFor(temp, sl.getLevel());
            if (so == null) {
                so = new SelObject(sl.getLevel(), sl);
            }
            this.selectedAttributes.add(so);
            for (DesignObject dobj : sl.getLevel().getAllAttributes()) {
                SelObject sob = this.findSelObjectFor(temp, dobj);
                if (sob == null) {
                    sob = new SelObject(dobj, sl);
                }
                this.selectedAttributes.add(sob);
            }
        }
    }

    private SelObject findSelObjectFor(List list, DesignObject designObject) {
        for (int i = 0; i < list.size(); ++i) {
            SelObject so = (SelObject)list.get(i);
            if (so.object != designObject) continue;
            return so;
        }
        return null;
    }

    private void updateSelectedLevels(List selectedDimensions) {
        ArrayList temp = new ArrayList();
        temp.addAll(this.selectedLevels);
        this.selectedLevels.clear();
        Iterator itd = selectedDimensions.iterator();
        while (itd.hasNext()) {
            boolean found = false;
            Iterator it = temp.iterator();
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)itd.next();
            while (it.hasNext()) {
                Slice.SelectedLevel sl = (Slice.SelectedLevel)it.next();
                if (sl.getDimension() != dim) continue;
                this.selectedLevels.add(sl);
                found = true;
                break;
            }
            if (found || dim.getHierarchies().size() <= 0) continue;
            Hierarchy hier = (Hierarchy)dim.getHierarchies().getElement(0);
            Level level = (Level)hier.getLevels().get(0);
            Slice slice = this.slice;
            Objects.requireNonNull(slice);
            Slice.SelectedLevel selectedLevel = slice.new Slice.SelectedLevel(dim, hier, level, this.slice);
            this.selectedLevels.add(selectedLevel);
        }
    }

    protected JPanel getDimensionsPanel() {
        if (this.pnDimensions == null) {
            this.pnDimensions = this.createPage(Messages.getString("SlicePropertiesDialogEx.DimensionsLevels"));
            this.levelsTable = new JTable(new LevelTableModel());
            this.levelsTable.setSelectionMode(0);
            this.levelsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow()) != -1 && SlicePropertiesDialogEx.this.selectedLevels.size() > 0 && row < SlicePropertiesDialogEx.this.selectedLevels.size()) {
                        Slice.SelectedLevel sl = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
                        sl.getLevel().showPropertyDialog();
                    }
                }
            });
            this.levelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow();
                        if (selectedRow == -1) {
                            SlicePropertiesDialogEx.this.btnDimensionProperties.setEnabled(false);
                            SlicePropertiesDialogEx.this.btnRemoveDimension.setEnabled(false);
                        } else {
                            SlicePropertiesDialogEx.this.btnDimensionProperties.setEnabled(true);
                            SlicePropertiesDialogEx.this.btnRemoveDimension.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.levelsTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnDimensionProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDimensionProperties.setEnabled(false);
            this.btnDimensionProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDimensionProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow();
                    if (row != -1 && SlicePropertiesDialogEx.this.selectedLevels.size() > 0 && row < SlicePropertiesDialogEx.this.selectedLevels.size()) {
                        Slice.SelectedLevel sl = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
                        sl.getLevel().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnDimensionProperties);
            if (this.isEditable()) {
                this.btnAddSL = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddSL.setToolTipText(BTN_ADD);
                this.btnAddSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List selDimensions = SlicePropertiesDialogEx.this.makeSelectedDimensions();
                        SelectElementsDialog dialog = new SelectElementsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.allDimensions, selDimensions);
                        dialog.setVisible(true);
                        SlicePropertiesDialogEx.this.updateSelectedLevels(selDimensions);
                        SlicePropertiesDialogEx.this.updateSelectedAttributes();
                        ((LevelTableModel)SlicePropertiesDialogEx.this.levelsTable.getModel()).dataChanged();
                        SlicePropertiesDialogEx.this.attributesTable.updateUI();
                    }
                });
                this.btnRemoveDimension = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveDimension.setEnabled(false);
                this.btnRemoveDimension.setToolTipText(BTN_REMOVE);
                this.btnRemoveDimension.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow();
                        if (objectNumber != -1 && SlicePropertiesDialogEx.this.selectedLevels.size() > 0 && objectNumber < SlicePropertiesDialogEx.this.selectedLevels.size()) {
                            SlicePropertiesDialogEx.this.selectedLevels.remove(objectNumber);
                            SlicePropertiesDialogEx.this.updateSelectedAttributes();
                            SlicePropertiesDialogEx.this.levelsTable.updateUI();
                            SlicePropertiesDialogEx.this.attributesTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAddSL);
                toolBar.add(this.btnRemoveDimension);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnDimensions.add(pPanel);
            TableColumn column = null;
            block5: for (int i = 0; i < 3; ++i) {
                column = this.levelsTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        column.setCellEditor(new ColumnHierLevelCB());
                        continue block5;
                    }
                    case 1: {
                        column.setCellEditor(new ColumnHierLevelCB());
                        continue block5;
                    }
                    case 2: {
                        column.setCellEditor(new ColumnHierLevelCB());
                    }
                }
            }
        }
        return this.pnDimensions;
    }

    private void updateComboMappings() {
        int i;
        this.cbTypes.removeAllItems();
        List mappings = this.getMappings();
        for (i = 0; i < mappings.size(); ++i) {
            this.cbTypes.addItem(mappings.get(i));
        }
        for (i = 0; i < this.smList.size(); ++i) {
            Slice.SliceMapping sm = (Slice.SliceMapping)this.smList.get(i);
            if (sm.getMapping() == null || mappings.contains(sm.getMapping())) continue;
            sm.setMapping(null);
            this.smTable.setValueAt(null, i, 1);
        }
        this.smTable.updateUI();
    }

    protected JPanel getSelAttributesPanel() {
        if (this.pnSelAttributes == null) {
            this.pnSelAttributes = this.createPage(Messages.getString("SlicePropertiesDialogEx.SelectedAttributes"));
            this.attributesTable = new JTable(new SelAttributesModel());
            this.attributesTable.setSelectionMode(0);
            this.attributesTable.setDefaultRenderer(Object.class, new SelAttributesRenderer());
            this.attributesTable.getTableHeader().setReorderingAllowed(false);
            this.attributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SlicePropertiesDialogEx.this.attributesTable.getSelectedRow()) != -1 && SlicePropertiesDialogEx.this.selectedAttributes.size() > 0 && row < SlicePropertiesDialogEx.this.selectedAttributes.size()) {
                        SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(row);
                        so.object.showPropertyDialog();
                    }
                }
            });
            TableColumn column = null;
            column = this.attributesTable.getColumnModel().getColumn(0);
            column.setCellEditor(new SelAttributeEditor());
            column.setPreferredWidth(5);
            JScrollPane scrollpane = new JScrollPane(this.attributesTable);
            this.pnSelAttributes.add(scrollpane);
        }
        return this.pnSelAttributes;
    }

    private void newEntity() {
        this.newEntity = this.slice.getDesign().getLogicalDesign().createEntity();
        if (!"".equalsIgnoreCase(this.tfEntityName.getText())) {
            this.newEntity.setName(this.tfEntityName.getText());
        }
        this.cbEntity.addItem(this.newEntity);
        this.cbEntity.setSelectedItem(this.newEntity);
        for (DesignObject mapping : this.getMappings()) {
            Attribute attribute = ((Entity)this.newEntity).createAttribute(mapping.getName());
            Slice slice = this.slice;
            Objects.requireNonNull(slice);
            this.smList.add(slice.new Slice.SliceMapping(attribute, mapping));
        }
        for (Slice.SliceMapping sm : this.smList) {
            ((DefaultTableModel)this.smTable.getModel()).addRow(new Object[]{sm.getAttribute().getLongName(), sm.getMapping()});
        }
        this.smTable.updateUI();
    }

    private void newTable() {
        if (this.slice.getMultidimensionalDesign().getBoundModel() instanceof RelationalDesign) {
            RelationalDesign rd = (RelationalDesign)this.slice.getMultidimensionalDesign().getBoundModel();
            this.newEntity = rd.createTable();
            if (!"".equalsIgnoreCase(this.tfEntityName.getText())) {
                this.newEntity.setName(this.tfEntityName.getText());
            }
            this.cbEntity.addItem(this.newEntity);
            this.cbEntity.setSelectedItem(this.newEntity);
            for (DesignObject mapping : this.getMappings()) {
                Column attribute = ((Table)this.newEntity).createColumn(mapping.getName());
                Slice slice = this.slice;
                Objects.requireNonNull(slice);
                this.smList.add(slice.new Slice.SliceMapping(attribute, mapping));
            }
            for (Slice.SliceMapping sm : this.smList) {
                ((DefaultTableModel)this.smTable.getModel()).addRow(new Object[]{sm.getAttribute().getLongName(), sm.getMapping()});
            }
            this.smTable.updateUI();
        }
    }

    protected JPanel getMappingPanel() {
        if (this.pnMapping == null) {
            this.pnMapping = this.createPage(Messages.getString("SlicePropertiesDialogEx.SliceToEntityMappings"));
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel pnNewEntity = new JPanel(new FlowLayout(0));
            pnNewEntity.setBorder(BorderFactory.createEtchedBorder());
            JLabel label = new JLabel(Messages.getString("SlicePropertiesDialogEx.EntityName"));
            pnNewEntity.add(label);
            this.tfEntityName = new JTextField(13);
            pnNewEntity.add(this.tfEntityName);
            this.bnNewEntity = new JButton(Messages.getString("SlicePropertiesDialogEx.NewEntity"));
            this.bnNewEntity.setEnabled(this.isEditable());
            this.bnNewEntity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SlicePropertiesDialogEx.this.slice.getMultidimensionalDesign().getBoundModel() instanceof RelationalDesign) {
                        SlicePropertiesDialogEx.this.newTable();
                    } else {
                        SlicePropertiesDialogEx.this.newEntity();
                    }
                }
            });
            pnNewEntity.add(this.bnNewEntity);
            pnMain.add((Component)pnNewEntity, "North");
            this.smTable = new JTable(new SliceMappingsTableModel());
            this.cbTypes = new JComboBox<Object>(this.getMappings().toArray());
            this.smTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.cbTypes));
            this.smTable.setSelectionMode(0);
            this.smTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SlicePropertiesDialogEx.this.smTable.getSelectedRow()) > -1 && SlicePropertiesDialogEx.this.smList.size() > 0 && row < SlicePropertiesDialogEx.this.smList.size()) {
                        Slice.SliceMapping attribute = (Slice.SliceMapping)SlicePropertiesDialogEx.this.smList.get(row);
                        attribute.getAttribute().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.smTable);
            pnMain.add((Component)scrollpane, "Center");
            this.pnMapping.add(pnMain);
        }
        return this.pnMapping;
    }

    protected JPanel getQueryPanel() {
        if (this.pnQuery == null) {
            this.pnQuery = this.createPage(Messages.getString("SlicePropertiesDialogEx.QueryWizard"));
            this.tab = new JTabbedPane();
            JPanel queryPanel = new JPanel(new BorderLayout());
            this.selPane = new JTextArea();
            this.selPane.setEditable(true);
            JScrollPane sp = new JScrollPane(this.selPane);
            SimpleAttributeSet as = new SimpleAttributeSet();
            StyleConstants.setAlignment(as, 0);
            sp.setHorizontalScrollBarPolicy(30);
            sp.setVerticalScrollBarPolicy(20);
            queryPanel.add((Component)sp, "Center");
            JPanel queryOptionsPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbFormula = new JLabel(Messages.getString("SlicePropertiesDialogEx.DefaultSchema"));
            lbFormula.setPreferredSize(this.getDefaultSize());
            this.tfSchema = new JTextField("");
            this.tfSchema.setPreferredSize(this.getDefaultSize());
            queryOptionsPanel.add(this.createRow(lbFormula, this.tfSchema));
            JLabel lbRelD = new JLabel(Messages.getString("SlicePropertiesDialogEx.RelationalModel"));
            lbRelD.setPreferredSize(this.getDefaultSize());
            this.cbRelDes = new JComboBox();
            this.cbRelDes.setPreferredSize(this.getDefaultSize());
            queryOptionsPanel.add(this.createRow(lbRelD, this.cbRelDes));
            JLabel lbStoreD = new JLabel(Messages.getString("SlicePropertiesDialogEx.PhysicalModel"));
            lbStoreD.setPreferredSize(this.getDefaultSize());
            this.cbStorage = new JComboBox();
            this.cbStorage.setPreferredSize(this.getDefaultSize());
            this.cbRelDes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object ob = SlicePropertiesDialogEx.this.cbRelDes.getSelectedItem();
                    if (ob != null && ob instanceof RelationalDesign) {
                        RelationalDesign phd = (RelationalDesign)ob;
                        ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                        StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                        for (int i = 0; i < stds.length; ++i) {
                            StorageDesign sd = stds[i];
                            rlist.add(sd);
                        }
                        SlicePropertiesDialogEx.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                    } else if (ob == null) {
                        SlicePropertiesDialogEx.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                    }
                }
            });
            queryOptionsPanel.add(this.createRow(lbStoreD, this.cbStorage));
            JLabel aggrLB = new JLabel(Messages.getString("SlicePropertiesDialogEx.AggregateFactsFirst"));
            aggrLB.setPreferredSize(this.getDefaultSize());
            aggrLB.setToolTipText(Messages.getString("SlicePropertiesDialogEx.OptionForLargeDimensionTables"));
            this.aggrCB = new JCheckBox();
            this.aggrCB.setToolTipText(aggrLB.getToolTipText());
            this.aggrCB.setPreferredSize(this.getDefaultSize());
            queryOptionsPanel.add(this.createRow(aggrLB, this.aggrCB));
            JLabel quoteLB = new JLabel(Messages.getString("SlicePropertiesDialogEx.UseQuotedNames"));
            quoteLB.setPreferredSize(this.getDefaultSize());
            this.quoteCB = new JCheckBox();
            this.quoteCB.setPreferredSize(this.getDefaultSize());
            queryOptionsPanel.add(this.createRow(quoteLB, this.quoteCB));
            this.tab.addTab(Messages.getString("SlicePropertiesDialogEx.Query"), queryPanel);
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)queryOptionsPanel, "North");
            this.tab.addTab(Messages.getString("SlicePropertiesDialogEx.Options"), jpanel);
            QueryGenerator qg = new QueryGenerator();
            this.tab.addChangeListener(qg);
            this.pnQuery.add(this.tab);
        }
        return this.pnQuery;
    }

    protected JPanel getCriteriaPanel() {
        if (this.pnCriteria == null) {
            this.pnCriteria = this.createPage(Messages.getString("SlicePropertiesDialogEx.SelectionCriteria"));
            this.scTable = new JTable(new SelectionCriteriaTableModel());
            this.scTable.setSelectionMode(0);
            this.scTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SlicePropertiesDialogEx.this.scTable.getSelectedRow()) > -1 && SlicePropertiesDialogEx.this.scList.size() > 0 && row < SlicePropertiesDialogEx.this.scList.size()) {
                        SelectionCriteria sc = (SelectionCriteria)SlicePropertiesDialogEx.this.scList.get(row);
                        sc.showModal = SlicePropertiesDialogEx.this.slice.showModal || SlicePropertiesDialogEx.this.slice.showForFirstTime();
                        sc.setMeasureWrappersList(SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        sc.showPropertyDialog();
                    }
                }
            });
            this.scTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = SlicePropertiesDialogEx.this.scTable.getSelectedRow();
                        if (selectedRow == -1) {
                            SlicePropertiesDialogEx.this.btnSCProperties.setEnabled(false);
                            SlicePropertiesDialogEx.this.btnRemoveSC.setEnabled(false);
                        } else {
                            SlicePropertiesDialogEx.this.btnSCProperties.setEnabled(true);
                            SlicePropertiesDialogEx.this.btnRemoveSC.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.scTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnSCProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnSCProperties.setEnabled(false);
            this.btnSCProperties.setToolTipText(BTN_PROPERTIES);
            this.btnSCProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SlicePropertiesDialogEx.this.scTable.getSelectedRow();
                    if (row > -1 && SlicePropertiesDialogEx.this.scList.size() > 0 && row < SlicePropertiesDialogEx.this.scList.size()) {
                        SelectionCriteria sc = (SelectionCriteria)SlicePropertiesDialogEx.this.scList.get(row);
                        sc.showModal = SlicePropertiesDialogEx.this.slice.showModal || SlicePropertiesDialogEx.this.slice.showForFirstTime();
                        sc.setMeasureWrappersList(SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        sc.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnSCProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectionCriteria criteria = ((MultidimensionalDesign)SlicePropertiesDialogEx.this.slice.getDesignPart()).createSelectionCriteria();
                        criteria.setSlice(SlicePropertiesDialogEx.this.slice);
                        SlicePropertiesDialogEx.this.scList.add(criteria);
                        SlicePropertiesDialogEx.this.scTable.updateUI();
                    }
                });
                this.btnRemoveSC = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveSC.setEnabled(false);
                this.btnRemoveSC.setToolTipText(BTN_REMOVE);
                this.btnRemoveSC.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = SlicePropertiesDialogEx.this.scTable.getSelectedRow();
                        if (objectNumber != -1 && SlicePropertiesDialogEx.this.scList.size() > 0 && objectNumber < SlicePropertiesDialogEx.this.scList.size()) {
                            SlicePropertiesDialogEx.this.scList.remove(objectNumber);
                            SlicePropertiesDialogEx.this.scTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveSC);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnCriteria.add(pPanel);
        }
        return this.pnCriteria;
    }

    protected JPanel getOracleAWPanel() {
        if (this.pnOracleAW == null) {
            this.pnOracleAW = this.createPage(Messages.getString("SlicePropertiesDialogEx.SQLAccessToOracleAW"));
            this.sqlTable = new JTable(new SQLToAWTableModel());
            this.sqlTable.setSelectionMode(0);
            this.sqlTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow()) > -1 && SlicePropertiesDialogEx.this.sqlList.size() > 0 && row < SlicePropertiesDialogEx.this.sqlList.size()) {
                        SQLAccessToAW sc = (SQLAccessToAW)SlicePropertiesDialogEx.this.sqlList.get(row);
                        sc.verifyDefinitions();
                        sc.showPropertyDialog();
                    }
                }
            });
            this.sqlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow();
                        if (selectedRow == -1) {
                            SlicePropertiesDialogEx.this.btnAWProperties.setEnabled(false);
                            SlicePropertiesDialogEx.this.btnRemoveAW.setEnabled(false);
                        } else {
                            SlicePropertiesDialogEx.this.btnAWProperties.setEnabled(true);
                            SlicePropertiesDialogEx.this.btnRemoveAW.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sqlTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnAWProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnAWProperties.setEnabled(false);
            this.btnAWProperties.setToolTipText(BTN_PROPERTIES);
            this.btnAWProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow();
                    if (row > -1 && SlicePropertiesDialogEx.this.sqlList.size() > 0 && row < SlicePropertiesDialogEx.this.sqlList.size()) {
                        SQLAccessToAW sc = (SQLAccessToAW)SlicePropertiesDialogEx.this.sqlList.get(row);
                        sc.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnAWProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLAccessToAW sql = SlicePropertiesDialogEx.this.slice.getMultidimensionalDesign().createSQLAccessToAW();
                        sql.setSlice(SlicePropertiesDialogEx.this.slice);
                        SlicePropertiesDialogEx.this.newSQLList.add(sql);
                        SlicePropertiesDialogEx.this.sqlList.add(sql);
                        SlicePropertiesDialogEx.this.sqlTable.clearSelection();
                        int lastRow = SlicePropertiesDialogEx.this.sqlTable.convertRowIndexToView(SlicePropertiesDialogEx.this.sqlTable.getModel().getRowCount() - 1);
                        SlicePropertiesDialogEx.this.sqlTable.setRowSelectionInterval(lastRow, lastRow);
                        SlicePropertiesDialogEx.this.sqlTable.updateUI();
                    }
                });
                this.btnRemoveAW = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveAW.setEnabled(false);
                this.btnRemoveAW.setToolTipText(BTN_REMOVE);
                this.btnRemoveAW.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow();
                        if (objectNumber != -1 && SlicePropertiesDialogEx.this.sqlList.size() > 0 && objectNumber < SlicePropertiesDialogEx.this.sqlList.size()) {
                            SlicePropertiesDialogEx.this.sqlList.remove(objectNumber);
                            SlicePropertiesDialogEx.this.sqlTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveAW);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnOracleAW.add(pPanel);
        }
        return this.pnOracleAW;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    class SelObject {
        boolean selected = false;
        boolean editable;
        DesignObject object;
        Level level;
        List selAttrs;

        SelObject(DesignObject object, Slice.SelectedLevel sl) {
            this.object = object;
            this.level = sl.getLevel();
            this.selAttrs = sl.getSelectedAttributes();
            if (!(object instanceof Level)) {
                if (this.selAttrs.contains(object)) {
                    this.selected = true;
                }
                if (this.level.getLevelKey().contains(object)) {
                    this.editable = false;
                    this.selected = true;
                    if (!this.selAttrs.contains(object)) {
                        this.selAttrs.add(object);
                    }
                } else {
                    this.editable = true;
                }
            } else {
                this.editable = false;
            }
        }

        void setSelected(boolean flag) {
            if (!this.selected && flag) {
                this.selAttrs.add(this.object);
            } else if (this.selected && !flag) {
                this.selAttrs.remove(this.object);
            }
            this.selected = flag;
        }
    }

    class MeasureDependence {
        Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(Measure measure) {
            this.measure = measure;
        }
    }

    private class MeasureWrappersModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SlicePropertiesDialogEx.Measure"), Messages.getString("SlicePropertiesDialogEx.AggregateFunction"), Messages.getString("SlicePropertiesDialogEx.MeasureAlias")};

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.selectedMeasureWrappers.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Slice.MeasureWrapper object = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(row);
            if (col == 0) {
                return object.getMeasure().getName();
            }
            if (col == 1) {
                return object.getAggrFunction().name;
            }
            if (col == 2) {
                return object.getAggrFunction().measureAlias;
            }
            return "";
        }
    }

    private class LevelTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SlicePropertiesDialogEx.Dimension"), Messages.getString("SlicePropertiesDialogEx.Hierarchy"), Messages.getString("SlicePropertiesDialogEx.Level")};

        private LevelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.selectedLevels.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!SlicePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            if (columnIndex > 0) {
                return true;
            }
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(rowIndex);
            List list = SlicePropertiesDialogEx.this.slice.getCube().getAllRollupLinksToTarget(selectedLevel.getDimension());
            return list.size() > 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
            if (col == 0) {
                if (value instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                    if (selectedLevel.getDimension() != value) {
                        oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)value;
                        selectedLevel.setDimension(dim);
                        this.fireTableDataChanged();
                    }
                } else if (value instanceof RollupLink) {
                    selectedLevel.rollupLink = (RollupLink)value;
                    this.fireTableDataChanged();
                }
            } else if (col == 1) {
                if (value instanceof Hierarchy && selectedLevel.getHierarchy() != value) {
                    Hierarchy hier = (Hierarchy)value;
                    Level level = selectedLevel.getLevel();
                    selectedLevel.setHierarchy(hier);
                    if (!hier.getLevels().contains(level)) {
                        selectedLevel.setLevel((Level)hier.getLevels().get(0));
                        SlicePropertiesDialogEx.this.updateSelectedAttributes();
                    }
                    this.fireTableDataChanged();
                }
            } else if (col == 2 && value instanceof Level && selectedLevel.getLevel() != value) {
                Level level = (Level)value;
                selectedLevel.setLevel(level);
                SlicePropertiesDialogEx.this.updateSelectedAttributes();
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
            if (col == 0) {
                List list = SlicePropertiesDialogEx.this.slice.getCube().getAllRollupLinksToTarget(selectedLevel.getDimension());
                if (list.size() > 1) {
                    if (selectedLevel.rollupLink == null) {
                        selectedLevel.rollupLink = (RollupLink)list.get(0);
                    }
                    return selectedLevel.rollupLink;
                }
                return selectedLevel.getDimension();
            }
            if (col == 1) {
                return selectedLevel.getHierarchy();
            }
            if (col == 2) {
                return selectedLevel.getLevel();
            }
            return new Integer(row * col);
        }
    }

    class ColumnHierLevelCB
    extends DefaultCellEditor {
        JComboBox cbox;

        ColumnHierLevelCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Slice.SelectedLevel sl;
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
            if (column == 0 && value instanceof RollupLink) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dim = selectedLevel.getDimension();
                List list = SlicePropertiesDialogEx.this.slice.getCube().getAllRollupLinksToTarget(dim);
                this.cbox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                this.cbox.setSelectedItem(selectedLevel.rollupLink);
            }
            if (column == 1 && value instanceof Hierarchy) {
                sl = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
                this.cbox.setModel(new DefaultComboBoxModel<Object>(selectedLevel.getDimension().getHierarchies().toArray()));
                this.cbox.setSelectedItem(sl.getHierarchy());
            }
            if (column == 2 && value instanceof Level) {
                sl = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(row);
                this.cbox.setModel(new DefaultComboBoxModel<Object>(selectedLevel.getHierarchy().getLevels().toArray()));
                this.cbox.setSelectedItem(sl.getLevel());
            }
            return this.cbox;
        }
    }

    private class SelAttributesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SlicePropertiesDialogEx.Status"), Messages.getString("SlicePropertiesDialogEx.AttributesLevels")};

        private SelAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.selectedAttributes.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!SlicePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            if (columnIndex > 0) {
                return false;
            }
            SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(rowIndex);
            return so.editable;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(row);
                if (so.editable && value instanceof Boolean) {
                    so.selected = (Boolean)value;
                    if (so.selected && !so.selAttrs.contains(so.object)) {
                        so.selAttrs.add(so.object);
                    } else {
                        so.selAttrs.remove(so.object);
                    }
                    SlicePropertiesDialogEx.this.updateComboMappings();
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(row);
            if (col == 1) {
                return so.object.getName();
            }
            if (col == 0 && so.object instanceof Level) {
                return Messages.getString("SlicePropertiesDialogEx.LevelL");
            }
            if (col == 0) {
                return so.selected;
            }
            return new Integer(row * col);
        }
    }

    public class SelAttributesRenderer
    extends DefaultTableCellRenderer {
        SelAttributesCBRenderer cbRenderer;

        public SelAttributesRenderer() {
            this.cbRenderer = new SelAttributesCBRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fc;
            Color bc;
            SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(row);
            Component comp = !(so.object instanceof Level) && column == 0 ? this.cbRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!so.editable) {
                bc = Color.LIGHT_GRAY;
                fc = Color.WHITE;
            } else {
                bc = Color.WHITE;
                fc = Color.BLACK;
            }
            if (so.object instanceof Level) {
                bc = Color.DARK_GRAY;
                fc = Color.WHITE;
            }
            comp.setBackground(bc);
            comp.setForeground(fc);
            return comp;
        }
    }

    class SelAttributeEditor
    extends DefaultCellEditor {
        JCheckBox cbox;

        SelAttributeEditor() {
            super(new JCheckBox());
            this.cbox = (JCheckBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(row);
            if (column == 0 && !(so.object instanceof Level) && so.editable) {
                this.cbox.setSelected(so.selected);
            }
            return this.cbox;
        }
    }

    private class SliceMappingsTableModel
    extends DefaultTableModel {
        private SliceMappingsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SlicePropertiesDialogEx.Attributes");
            }
            if (column == 1) {
                return Messages.getString("SlicePropertiesDialogEx.Mappings");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!SlicePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1 && aValue instanceof DesignObject) {
                Slice.SliceMapping sm = (Slice.SliceMapping)SlicePropertiesDialogEx.this.smList.get(row);
                sm.setMapping((DesignObject)aValue);
            }
            super.setValueAt(aValue, row, column);
        }
    }

    class QueryGenerator
    implements ChangeListener {
        QueryGenerator() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == SlicePropertiesDialogEx.this.tab && SlicePropertiesDialogEx.this.tab.getSelectedIndex() == 0) {
                SlicePropertiesDialogEx.this.makeQuery();
            }
        }
    }

    private class SelectionCriteriaTableModel
    extends AbstractTableModel {
        private SelectionCriteriaTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.scList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SlicePropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("SlicePropertiesDialogEx.MeasureAlias");
            }
            if (column == 2) {
                return Messages.getString("SlicePropertiesDialogEx.WhereClause");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SelectionCriteria object = (SelectionCriteria)SlicePropertiesDialogEx.this.scList.get(row);
            if (col == 0) {
                return object.getName();
            }
            if (col == 1) {
                if (object.getMeasureWrapper() != null) {
                    return object.getMeasureWrapper().getMeasureAlias();
                }
                return "";
            }
            if (col == 2) {
                return object.getSelectionCriteria();
            }
            return new Integer(row * col);
        }
    }

    private class SQLToAWTableModel
    extends AbstractTableModel {
        private SQLToAWTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.sqlList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SlicePropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("SlicePropertiesDialogEx.MeasureAlias");
            }
            if (column == 2) {
                return Messages.getString("SlicePropertiesDialogEx.WhereClause");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SQLAccessToAW object = (SQLAccessToAW)SlicePropertiesDialogEx.this.sqlList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    public class SelAttributesCBRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SelObject so = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(row);
            this.setSelected(so.selected);
            return this;
        }
    }
}

