/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public class ArcPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Arc arc;
    private JTextField tfEntity;
    private JPanel pnRelations;
    private List rList;
    private JTable rTable;

    public ArcPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ArcPropertiesDialogEx.ArcProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "ARC_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Arc) {
            this.arc = (Arc)object;
            this.initDefaults(false);
            this.tfEntity.setText(this.arc.getEntity().getName());
            Object[] relations = this.arc.getRelations().toArray();
            Arrays.sort(relations, new RelationComparator());
            for (int i = 0; i < relations.length; ++i) {
                Object obj = relations[i];
                this.rList.add(obj);
            }
            this.initDynamicProperties();
        }
    }

    private void initGeneral() {
        JLabel lbEntity = new JLabel(LB_ENTITY);
        lbEntity.setPreferredSize(this.getDefaultSize());
        this.tfEntity = new JTextField();
        this.tfEntity.setPreferredSize(this.getDefaultSize());
        this.tfEntity.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbEntity, this.tfEntity));
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getRelationsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.arc.setName(this.tfName.getText());
        this.arc.setComment(this.taComments.getText());
        this.arc.setNotes(this.taNotes.getText());
        ArcPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.arc.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.arc.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getRelationsPanel() {
        if (this.pnRelations == null) {
            this.pnRelations = this.createPage(Messages.getString("ArcPropertiesDialogEx.Relations"));
            this.rList = new ArrayList();
            this.rTable = new JTable(new RelationModel());
            this.rTable.setSelectionMode(0);
            this.rTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Relation relation;
                    int row;
                    if (e.getClickCount() == 2 && (row = ArcPropertiesDialogEx.this.rTable.getSelectedRow()) != -1 && ArcPropertiesDialogEx.this.rList.size() > 0 && row < ArcPropertiesDialogEx.this.rList.size() && !(relation = (Relation)ArcPropertiesDialogEx.this.rList.get(row)).isDialogVisible()) {
                        relation.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.rTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Relation relation;
                    int row = ArcPropertiesDialogEx.this.rTable.getSelectedRow();
                    if (row != -1 && ArcPropertiesDialogEx.this.rList.size() > 0 && row < ArcPropertiesDialogEx.this.rList.size() && !(relation = (Relation)ArcPropertiesDialogEx.this.rList.get(row)).isDialogVisible()) {
                        relation.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonGeneral, "North");
            jpanel.add(scrollpane);
            this.pnRelations.add(jpanel);
        }
        return this.pnRelations;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class RelationComparator
    implements Comparator {
        private RelationComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Relation)o1).getName().compareTo(((Relation)o2).getName());
        }
    }

    public class RelationModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ArcPropertiesDialogEx.this.rList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ArcPropertiesDialogEx.RelationName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Relation relation = (Relation)ArcPropertiesDialogEx.this.rList.get(row);
            if (col == 0) {
                return relation.getName();
            }
            return new Integer(row * col);
        }
    }
}

