/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.File;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;

public class WXMLNote
extends AbstractWXMLDesignObject {
    Note note = null;

    public WXMLNote(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Note;
        if (result) {
            this.note = (Note)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.note != null) {
            String designName = this.note.getDesignPart().getAppView().getDesignName();
            Object path = "";
            if (this.note.getDesignPart() instanceof LogicalDesign) {
                path = "logical";
            } else if (this.note.getDesignPart() instanceof RelationalDesign) {
                path = "rel" + File.separatorChar + this.note.getDesignPart().getPathIDString();
            } else if (this.note.getDesignPart() instanceof DataFlowDesign) {
                path = DATAFLOW_PATH + File.separatorChar + StringUtilities.encodeAttributeValue(this.note.getDesignPart().getObjectID());
            } else if (this.note.getDesignPart() instanceof MultidimensionalDesign) {
                path = "multidimensional" + File.separatorChar + StringUtilities.encodeAttributeValue(this.note.getDesignPart().getObjectID());
            } else if (this.note.getDesignPart() instanceof DataTypesDesign) {
                path = "datatypes";
            } else if (this.note.getDesignPart() instanceof TransformationTask) {
                path = TRPACKAGE_PATH + "/" + StringUtilities.encodeAttributeValue(((TransformationTask)this.note.getDesignPart()).getTransformationPackage().getObjectID()) + "/" + StringUtilities.encodeAttributeValue(this.note.getDesignPart().getObjectID());
            }
            buffer.append(designName).append('/').append((String)path).append('/');
        }
        buffer.append(this.getConfiguration().get("notePath"));
        return buffer.toString();
    }
}

