/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPoolMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractXMLHandler
implements XMLConstants {
    public static final String NULL_STR = "null";
    public static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Logger LOGGER;
    public static final String DOC_VERSION = "2.0";
    public static final String NEWLINE;
    private XMLPersistenceManager persistenceMgr;

    public AbstractXMLHandler(XMLPersistenceManager persistenceMgr) {
        this.persistenceMgr = persistenceMgr;
    }

    public abstract String getRelativePath();

    public String getRelativePath(Object object) {
        return this.getRelativePath();
    }

    public String getFilename(Object name) {
        return String.valueOf(name);
    }

    public abstract boolean canWrite(Object var1);

    public boolean canRead(Object object) {
        if (object instanceof String) {
            return this.canRead((String)object);
        }
        return false;
    }

    public abstract boolean canRead(String var1);

    protected MDConfiguration getConfiguration() {
        return MDConfiguration.getDefaultInstance();
    }

    public XMLPersistenceManager getPersistenceManager() {
        return this.persistenceMgr;
    }

    protected Document createDocument() {
        return this.createDocument("metadatadoc");
    }

    protected Document createDocument(String rootTag) {
        Document doc = null;
        try {
            doc = DOCUMENT_BUILDER.newDocument();
            Element docElement = doc.getDocumentElement();
            docElement = doc.createElement(rootTag);
            docElement.setAttribute("version", this.getVersion());
            doc.appendChild(docElement);
        }
        catch (Exception e) {
            LOGGER.error("problem creating document. AbstractXMLHandler.createDocument(): ", e);
        }
        return doc;
    }

    public final PMWPoolMap getPMWPoolMap() {
        return this.getPersistenceManager().getPMWPoolMap();
    }

    public static Element getFirstChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    protected void appendComment(Element element, String comment) {
        this.appendComment(element, comment, 0);
    }

    protected void appendComment(Element element, String comment, int level) {
        StringBuffer buf = new StringBuffer();
        buf.append(NEWLINE);
        for (int i = 0; i < level; ++i) {
            buf.append('\t');
        }
        buf.append("<!-- ").append(comment).append(" -->");
        buf.append(NEWLINE);
        Text commentNode = element.getOwnerDocument().createTextNode(buf.toString());
        element.appendChild(commentNode);
    }

    protected void showStatusMessage(String message) {
        this.getPersistenceManager().showStatusMessage(message);
    }

    protected String getVersion() {
        return DOC_VERSION;
    }

    public void prettyPrint(Document doc, PrintWriter out) {
        Element d = doc.getDocumentElement();
        this.print(d, 0, out);
        out.println();
        out.flush();
    }

    public void prettyPrint(Document doc) {
        PrintWriter outw = new PrintWriter(System.out);
        this.prettyPrint(doc, outw);
    }

    public String prettyPrint(Document doc, StringBuffer buffer) {
        Element d = doc.getDocumentElement();
        this.print(d, 0, buffer);
        return buffer.toString();
    }

    public void prettyPrint(Document doc, OutputStream out) {
        PrintWriter outw = new PrintWriter(out);
        this.prettyPrint(doc, outw);
    }

    protected void print(Element elm, int level, StringBuffer buffer) {
        boolean containsChild;
        if (level == 0) {
            buffer.append(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            buffer.append(NEWLINE);
        } else {
            this.printlvl(level, buffer);
        }
        buffer.append('<');
        buffer.append(elm.getTagName());
        NamedNodeMap atts = elm.getAttributes();
        int length = atts.getLength();
        for (int i = 0; atts != null && i < length; ++i) {
            buffer.append(' ');
            buffer.append(atts.item(i).getNodeName());
            buffer.append("=\"");
            buffer.append(atts.item(i).getNodeValue());
            buffer.append('\"');
        }
        NodeList children = elm.getChildNodes();
        int shouldNewLine = 0;
        boolean bl = containsChild = children != null && 0 < children.getLength();
        if (containsChild) {
            buffer.append('>');
            for (int i = 0; i < children.getLength(); ++i) {
                Node c = children.item(i);
                if (c instanceof Element) {
                    ++shouldNewLine;
                    this.print((Element)c, level + 1, buffer);
                    continue;
                }
                this.print(c, level + 1, buffer);
            }
        }
        if (shouldNewLine > 0) {
            this.printlvl(level, buffer);
        }
        if (containsChild) {
            buffer.append("</");
            buffer.append(elm.getTagName());
            buffer.append('>');
        } else {
            buffer.append(" />");
        }
    }

    protected void print(Element elm, int level, PrintWriter out) {
        boolean containsChild;
        this.printlvl(level, out);
        out.print('<');
        out.print(elm.getTagName());
        NamedNodeMap atts = elm.getAttributes();
        int length = atts.getLength();
        for (int i = 0; atts != null && i < length; ++i) {
            out.print(' ');
            out.print(atts.item(i).getNodeName());
            out.print("=\"");
            out.print(atts.item(i).getNodeValue());
            out.print('\"');
        }
        NodeList children = elm.getChildNodes();
        int shouldNewLine = 0;
        boolean bl = containsChild = children != null && 0 < children.getLength();
        if (containsChild) {
            out.print('>');
            for (int i = 0; i < children.getLength(); ++i) {
                Node c = children.item(i);
                if (c instanceof Element) {
                    ++shouldNewLine;
                    this.print((Element)c, level + 1, out);
                    continue;
                }
                this.print(c, level + 1, out);
            }
        }
        if (shouldNewLine > 0) {
            this.printlvl(level, out);
        }
        if (containsChild) {
            out.print("</");
            out.print(elm.getTagName());
            out.print('>');
        } else {
            out.print(" />");
        }
        out.flush();
    }

    protected void printlvl(int level, PrintWriter out) {
        out.println();
        for (int i = 0; i < level; ++i) {
            out.print('\t');
        }
    }

    protected void printlvl(int level, StringBuffer buffer) {
        buffer.append(NEWLINE);
        for (int i = 0; i < level; ++i) {
            buffer.append('\t');
        }
    }

    protected void print(Node node, int level, PrintWriter out) {
        out.print(node);
    }

    protected void print(Node node, int level, StringBuffer buffer) {
        buffer.append(node.getNodeValue());
    }

    protected void print(Node node, PrintWriter out) {
        this.print(node, 0, out);
    }

    protected void appendProperties(Element objectInfoNode, String id, Map map) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement(id);
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
        }
        objectInfoNode.appendChild(propertiesList);
    }

    protected void appendProperty(Element parameterElement, String key, String value) {
        parameterElement.setAttribute("name", key);
        parameterElement.setAttribute("value", AbstractXMLHandler.encodeAttributeValue(value));
    }

    protected void readPropertiesListLocateRoot(Element parent, PropertyMap object) {
        NodeList list = parent.getElementsByTagName("properties");
        if (list.getLength() > 0) {
            this.readPropertiesList((Element)list.item(0), object);
        }
    }

    protected void readPropertiesList(Element parent, PropertyMap object) {
        NodeList paramList = parent.getElementsByTagName("parameter");
        int length = paramList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)paramList.item(i);
            this.doReadPropertyFromParameterElement(parameter, object);
        }
    }

    protected void readPropertiesList(Element parent, PropertyMap object, StorageObject sto) {
        if (parent != null) {
            NodeList paramList = parent.getElementsByTagName("parameter");
            int length = paramList.getLength();
            for (int i = 0; i < length; ++i) {
                Element parameter = (Element)paramList.item(i);
                this.doReadPropertyFromParameterElement(parameter, object, sto);
            }
        }
    }

    private void doReadPropertyFromParameterElement(Element parameter, PropertyMap object) {
        String key = parameter.getAttribute("name");
        if (!key.equalsIgnoreCase("object.property.auto.ReadOnly")) {
            String value = parameter.getAttribute("value");
            object.setProperty(key, AbstractXMLHandler.decodeAttributeValue(value));
        }
    }

    private void doReadPropertyFromParameterElement(Element parameter, PropertyMap object, StorageObject sto) {
        StorageDesign stDes = sto.getStorageDesign();
        String key = parameter.getAttribute("name");
        if (!key.equalsIgnoreCase("object.property.auto.ReadOnly")) {
            String value = parameter.getAttribute("value");
            value = this.replaceIDsInValue(value, stDes);
            object.setProperty(key, AbstractXMLHandler.decodeAttributeValue(value));
        }
    }

    private String replaceIDsInValue(String value, StorageDesign storageDesign) {
        if (value != null) {
            ModelIDObject obj;
            Object res = "";
            Map map = storageDesign.getCorrespondenceMap();
            if (value.indexOf(44) > 0 && map != null) {
                boolean first = true;
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    String id = token.trim();
                    ModelIDObject obj2 = (ModelIDObject)map.get(id);
                    if (obj2 != null && !id.equals(obj2.getObjectID())) {
                        token = obj2.getObjectID();
                    }
                    if (first) {
                        res = token;
                        first = false;
                        continue;
                    }
                    res = (String)res + "," + token;
                }
                return res;
            }
            if (map != null && (obj = (ModelIDObject)map.get(value)) != null) {
                String newID = obj.getObjectID();
                return newID;
            }
        }
        return value;
    }

    public static String encodeAttributeValue(String unencoded) {
        return StringUtilities.encodeAttributeValue(unencoded);
    }

    public static String decodeAttributeValue(String encoded) {
        return StringUtilities.decodeAttributeValue(encoded);
    }

    static {
        LOGGER = new Logger(AbstractXMLHandler.class);
        DocumentBuilder temp = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            temp = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not instantiate XML parser in AbstractXMLHandler (DOCUMENT_BUILDER) " + e);
        }
        DOCUMENT_BUILDER = temp;
        NEWLINE = System.getProperty("line.separator");
    }
}

