/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRColumnProxyCollation
extends AbstractDRStorageDesign {
    private final String RULE_ID = "132E8AC2-5973-E2C1-9FCF-DCCA8A356645";

    public DRColumnProxyCollation(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRColumnProxyCollation.CheckCollationName"));
        this.setDescription(MessageFormat.format(Messages.getString("DRColumnProxyCollation.TheCollationNameApplicableforColumnsOf"), "the char, varchar, text, nchar, nvarchar, and ntext"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ColumnProxySqlServer column = (ColumnProxySqlServer)object;
        if (!("".equalsIgnoreCase(column.getCollation()) || column.getDataTypeName().equalsIgnoreCase("CHAR") || column.getDataTypeName().equalsIgnoreCase("VARCHAR") || column.getDataTypeName().equalsIgnoreCase("TEXT") || column.getDataTypeName().equalsIgnoreCase("NCHAR") || column.getDataTypeName().equalsIgnoreCase("NVARCHAR") || column.getDataTypeName().equalsIgnoreCase("NTEXT"))) {
            return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRColumnProxyCollation.CollationNameNotApplicable"), column.getDatatypeString()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRColumnProxyCollation.TheCollationNameValid"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "132E8AC2-5973-E2C1-9FCF-DCCA8A356645";
    }
}

