/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyParameters
extends AbstractDRStorageDesign {
    private final String RULE_ID = "D54C693F-D7EB-D0BF-B4DB-61E974FC263D";

    public DRTableProxyParameters(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyParameters.CheckTableProxyParameters"));
        this.setDescription(Messages.getString("DRTableProxyParameters.TableProxyShouldHaveSpecifiedTablespaceAndOwner"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyDB2 table = (TableProxyDB2)object;
        if (table.getTableSpace() == null) {
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRTableProxyParameters.TablespaceNotSpecifiedFor"), table.getName()));
        }
        if (table.getOwner() == null) {
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRTableProxyParameters.OwnerNotSpecifiedFor"), table.getName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyParameters.TableParametersAreSet"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "D54C693F-D7EB-D0BF-B4DB-61E974FC263D";
    }
}

