/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ListStorageTemplatePartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private TableSpaceOracle tablespace = null;
    private String valueList = "Default";
    private String dataSegmentCompression = "";
    private int position = 0;
    private AbstractStorageObjectOracle subPartitionOf;
    private TableProxyOracle partOfStorageTable;
    private StorageObjectCollection lobs;
    public static final String TYPE_NAME = "ListStorageTemplatePartition";

    public ListStorageTemplatePartitionOracle(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.lobs = new StorageObjectCollection(((StorageDesignOracle)storage).getHashPartitionLobItemSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("ListStorageTemplatePartitionOracle.LobStorages"));
        this.lobs.setClassForParent(ListStorageTemplatePartitionOracle.class);
        this.lobs.setSetMethod("setListTemplatePartition");
        ((StorageDesignOracle)storage).getHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ListTemplatePart";
    }

    public TableSpaceOracle getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tablespace) {
        if (this.tablespace != tablespace) {
            this.tablespace = tablespace;
            this.fireDataFieldChange();
        }
    }

    public String getValueList() {
        return this.valueList;
    }

    public void setValueList(String valueList) {
        if (valueList != null && valueList.equals(this.valueList)) {
            return;
        }
        this.valueList = valueList;
        this.fireDataFieldChange();
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public void setDataSegmentCompression(String dataSegmentCompression) {
        if (!this.dataSegmentCompression.equals(dataSegmentCompression) && (ConstantsOracle.checkYesNo(dataSegmentCompression) || "".equals(dataSegmentCompression))) {
            this.dataSegmentCompression = dataSegmentCompression;
            this.fireDataFieldChange();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (this.position != position) {
            StorageObjectCollection partitions;
            Object parent;
            this.position = position;
            if (position > 0 && (parent = this.getParent()) instanceof StorageObjectCollection && position <= (partitions = (StorageObjectCollection)parent).size() && partitions.getChild(position - 1) != this) {
                partitions.moveElementToIndex(this, position - 1);
            }
            this.fireDataFieldChange();
        }
    }

    public void setSubPartitionOf(AbstractStorageObjectOracle subPartitionOf) {
        if (this.subPartitionOf != subPartitionOf) {
            this.subPartitionOf = subPartitionOf;
            if (subPartitionOf != null) {
                this.setPAC_Element(subPartitionOf.getPAC_Element());
                if (subPartitionOf instanceof PartitionOracle) {
                    ((PartitionOracle)subPartitionOf).addListStorageTemplatePartitionOracle(this);
                } else if (subPartitionOf instanceof ListPartitionOraclev11g) {
                    ((ListPartitionOraclev11g)subPartitionOf).addSubpartition(this);
                }
            }
            this.fireDataFieldChange();
        }
    }

    public AbstractStorageObjectOracle getSubPartitionOf() {
        return this.subPartitionOf;
    }

    public void setPartOfStorageTable(TableProxyOracle partOfStorageTable) {
        if (this.partOfStorageTable != partOfStorageTable) {
            this.partOfStorageTable = partOfStorageTable;
            if (partOfStorageTable != null) {
                this.setPAC_Element(partOfStorageTable);
                partOfStorageTable.addTemplateSubPartition(this);
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getPartOfStorageTable() {
        return this.partOfStorageTable;
    }

    public StorageObjectCollection getLobs() {
        return this.lobs;
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle lob = (HashPartitionLobItemOracle)event.getAffected();
            if (lob.getListTemplatePartition() == this) {
                lob.setParent(this.lobs);
                this.lobs.add(lob);
            } else {
                this.lobs.remove(lob);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof HashPartitionLobItemOracle) {
                HashPartitionLobItemOracle lob = (HashPartitionLobItemOracle)event.getAffected();
                lob.addObjectListener(this);
                if (lob.getListTemplatePartition() == this) {
                    lob.setParent(this.lobs);
                    this.lobs.add(lob);
                } else {
                    this.lobs.remove(lob);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle lob = (HashPartitionLobItemOracle)event.getAffected();
            this.lobs.remove(lob);
            lob.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobs;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ListStorageTemplatePartitionOracle listPartition = null;
        StorageObject stObject = (StorageObject)((StorageDesignOracle)targetDesign).getListStorageTemplatePartitionSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                listPartition = (ListStorageTemplatePartitionOracle)stObject;
            }
        } else {
            listPartition = ((StorageDesignOracle)targetDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
        }
        if (listPartition != null) {
            listPartition.setName(this.getName());
            if (this.getPartOfStorageTable() != null) {
                Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getPartOfStorageTable().getObject().getName());
                TableProxyOracle tableProxy = (TableProxyOracle)targetDesign.getTableProxySet().getProxy(table.getObjectID());
                if (tableProxy == null) {
                    TableProxyOracle newTableProxy = (TableProxyOracle)((TableProxySetOracle)targetDesign.getTableProxySet()).createProxy(table);
                    newTableProxy.setName(this.getPartOfStorageTable().getName());
                    newTableProxy.setRawObject(true);
                    listPartition.setPartOfStorageTable(newTableProxy);
                } else {
                    listPartition.setPartOfStorageTable(tableProxy);
                }
            }
            if (this.getSubPartitionOf() != null) {
                PartitionOracle partition = (PartitionOracle)((StorageDesignOracle)targetDesign).getPartitionSet().getByName(this.getSubPartitionOf().getName());
                if (partition == null) {
                    PartitionOracle newPartition = ((StorageDesignOracle)targetDesign).getPartitionSet().createPartition();
                    newPartition.setName(this.getSubPartitionOf().getName());
                    newPartition.setRawObject(true);
                    listPartition.setSubPartitionOf(newPartition);
                } else {
                    listPartition.setSubPartitionOf(partition);
                }
            }
            for (HashPartitionLobItemOracle lob : this.getLobs()) {
                HashPartitionLobItemOracle targetLob = (HashPartitionLobItemOracle)((StorageDesignOracle)targetDesign).getHashPartitionLobItemSet().getByName(lob.getName());
                if (targetLob == null) {
                    HashPartitionLobItemOracle newLob = ((StorageDesignOracle)targetDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
                    newLob.setName(lob.getName());
                    newLob.setRawObject(true);
                    newLob.setListTemplatePartition(listPartition);
                    listPartition.getLobs().add(newLob);
                    continue;
                }
                targetLob.setListTemplatePartition(listPartition);
                listPartition.getLobs().add(targetLob);
            }
            listPartition.setValueList(this.getValueList());
            if (this.getTablespace() != null) {
                TableSpaceOracle tableSpace = (TableSpaceOracle)((StorageDesignOracle)targetDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (tableSpace == null) {
                    TableSpaceOracle newTableSpace = ((StorageDesignOracle)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTablespace().getName());
                    newTableSpace.setRawObject(true);
                    listPartition.setTablespace(newTableSpace);
                } else {
                    listPartition.setTablespace(tableSpace);
                }
            }
            listPartition.setDataSegmentCompression(this.getDataSegmentCompression());
            listPartition.setPosition(this.getPosition());
            listPartition.setComment(this.getComment());
            listPartition.setRawObject(false);
        }
    }

    public HashPartitionLobItemOracle createLob() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (HashPartitionLobItemOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> lips = new ArrayList<LocalIndexProperties>();
        for (LocalIndexProperties lip : ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet()) {
            if (lip.getPartition() != this || lip.getIndex() == null) continue;
            lips.add(lip);
        }
        return lips;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties lip = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        lip.setPartition(this);
        return lip;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16);
    }

    @Override
    public void remove() {
        if (this.subPartitionOf != null) {
            this.subPartitionOf.removeObject(this);
        } else if (this.partOfStorageTable != null) {
            this.partOfStorageTable.removeTemplateSubPartition(this);
        }
        super.remove();
    }
}

