/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class ColumnViewComparator
extends PropertiesComparator {
    private ContainedObjectWithDomain left_co;
    private ContainedObjectWithDomain right_co;

    public ColumnViewComparator(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        super(left_co, right_co);
        this.left_co = left_co;
        this.right_co = right_co;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph = new PropertyHolder(COMMENT_IN_RDBMS);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.left_co != null ? this.left_co.getCommentInRDBMS() : "");
        ph.setRightValue(this.right_co != null ? this.right_co.getCommentInRDBMS() : "");
        if (this.isExcludedFromComparison(COMMENT_IN_RDBMS)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(COMMENT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_co != null ? this.left_co.getComment() : "");
            ph.setRightValue(this.right_co != null ? this.right_co.getComment() : "");
            if (this.isExcludedFromComparison(COMMENT)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(NOTES);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_co != null ? this.left_co.getNotes() : "");
            ph.setRightValue(this.right_co != null ? this.right_co.getNotes() : "");
            if (this.isExcludedFromComparison(NOTES)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_co.setCommentInRDBMS(this.left_co.getCommentInRDBMS());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.right_co.setComment(this.left_co.getComment());
                    continue;
                }
                if (!ph.getName().equals(NOTES)) continue;
                this.right_co.setNotes(this.left_co.getNotes());
            }
            this.right_co.setTemporaryWriteable(false);
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }
}

