/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Component;
import java.awt.Dimension;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.erwin.ERSAXHandler;
import oracle.dbtools.crest.imports.erwin.ERSAXParserv7x;
import oracle.dbtools.crest.imports.erwin.ERwinConstants;
import oracle.dbtools.crest.imports.erwin.ERwinParserv4x;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ERwinHandler
extends DefaultHandler
implements ERwinConstants {
    protected static final Logger LOGGER = new Logger(ERwinHandler.class);
    private ApplicationView appView;
    private ProgressDialog monitor;
    private File currentFile;
    private boolean inExistingDesign;
    private String oldDesignPath;
    private String designName;
    private Design design;
    private int version = 0;
    String tempVal;
    Entity tempEntity;
    Attribute tempAttr;
    boolean inent;
    boolean inattr;
    boolean inrel;
    CharArrayWriter text = new CharArrayWriter();

    public ERwinHandler(ApplicationView appView, boolean inExistingDesign) {
        this.appView = appView;
        this.inExistingDesign = inExistingDesign;
        this.design = appView.getCurrentDesign();
    }

    protected void setDesignName(String designName) {
        this.designName = !this.inExistingDesign ? designName : this.appView.getDesignName();
        this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.appView.designExists(designName)) {
            this.appView.deleteDesign(designName);
        }
        if (!this.inExistingDesign) {
            this.appView.setDesignName(designName);
        }
        if (!this.inExistingDesign) {
            this.design.setFileName(this.designName);
        }
    }

    public void parse(File file, int version) {
        this.version = version;
        if (file.isFile()) {
            try {
                this.oldDesignPath = this.appView.getCurrentDesign().getDesignPath();
                this.currentFile = file;
                new Thread(new Runner()).start();
            }
            catch (Exception e) {
                LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file, ImportLogger importLog) {
        try {
            FileInputStream is;
            block26: {
                is = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                if (this.version == 4) {
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = null;
                        try {
                            db = dbf.newDocumentBuilder();
                        }
                        catch (ParserConfigurationException e1) {
                            LOGGER.error(e1);
                        }
                        if (db == null) break block26;
                        Document doc = db.parse(inputSource);
                        Element elmERwin = doc.getDocumentElement();
                        String docName = elmERwin.getNodeName();
                        Element elmModel = this.getElement(elmERwin, "Model");
                        if (docName.equalsIgnoreCase("ERwin4") && elmModel != null) {
                            ERwinParserv4x parserv4x = new ERwinParserv4x(this.appView, this.inExistingDesign);
                            parserv4x.parseModel(file, importLog, this.monitor, elmModel);
                            break block26;
                        }
                        importLog.addError("Error parsing ERwin 4.x file: " + file.getAbsolutePath());
                    }
                    catch (Throwable t) {
                        LOGGER.error("ERwinHandler - Unable to parse ERwin 4.x file: " + file.getAbsolutePath(), t);
                        importLog.addError("Error parsing ERwin 4.x File...");
                    }
                } else if (this.version == 7) {
                    try {
                        System.out.println("start " + System.currentTimeMillis());
                        ApplicationView.canLogging = false;
                        SAXParserFactory spf = SAXParserFactory.newInstance();
                        ERSAXHandler esp = null;
                        try {
                            SAXParser sp = spf.newSAXParser();
                            esp = new ERSAXParserv7x(this.appView, this.inExistingDesign, importLog);
                            sp.parse(inputSource, (DefaultHandler)esp);
                        }
                        catch (SAXException se) {
                            importLog.addError(se.getMessage());
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (esp != null) {
                                esp.monitorClose();
                            }
                        }
                        System.out.println("end " + System.currentTimeMillis());
                    }
                    catch (Throwable t) {
                        LOGGER.error("ERwinHandler - Unable to parse ERwin 7.x file: " + file.getAbsolutePath(), t);
                        importLog.addError("Error parsing ERwin 7.x File: " + file.getAbsolutePath());
                    }
                    finally {
                        ApplicationView.canLogging = true;
                        this.getLogicalDesign().sortCollections();
                    }
                } else {
                    importLog.addError("ERwinHandler - Unable to parse file: " + file.getAbsolutePath());
                    this.appView.getCurrentDesign().setDesignPath(this.oldDesignPath);
                    this.design = null;
                    System.gc();
                }
            }
            ((InputStream)is).close();
        }
        catch (Exception e) {
            LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), e);
            importLog.addError("Error parsing File...");
        }
    }

    protected Element getElement(Element element, String tagNameSpace, String tagName) {
        NodeList nodeList = element.getElementsByTagNameNS(tagNameSpace, tagName);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    protected Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    protected String getElementValue(Element element, String tagName) {
        try {
            return this.getElement(element, tagName).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getElementPropValue(Element element, String tagName) {
        String tagProps = element.getTagName() + "Props";
        Element elmProps = this.getElement(element, tagProps);
        if (elmProps != null) {
            return this.getElementValue(elmProps, tagName);
        }
        return null;
    }

    protected String getValue(Element element) {
        try {
            return element.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List getElements(Element element, String tagName) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
        return list;
    }

    protected void createMappings(Design design, Map logicalObjects, Map relationalObjects) {
        for (Object key : logicalObjects.keySet()) {
            DesignObject logicalObject = (DesignObject)logicalObjects.get(key);
            DesignObject relationalObject = (DesignObject)relationalObjects.get(key);
            if (logicalObject == null || relationalObject == null || design.getExtendedMap().getMapping(logicalObject, relationalObject) != null || this.isDeleted(logicalObject) || this.isDeleted(relationalObject)) continue;
            XtdMapping mapping = design.getExtendedMap().createMapping(logicalObject, relationalObject);
            relationalObject.setGeneratorID(logicalObject.getObjectID());
            mapping.setCreationTime(System.currentTimeMillis());
        }
    }

    protected boolean isDeleted(DesignObject designObject) {
        if (designObject instanceof ContainedObject) {
            ContainedObject co = (ContainedObject)designObject;
            return co.getContainer() == null;
        }
        return false;
    }

    protected boolean isUTFString(String string) {
        int l = string.length();
        try {
            byte[] b = string.getBytes("UTF-8");
            return l < b.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    private Design getDesign() {
        return this.appView.getCurrentDesign();
    }

    private LogicalDesign getLogicalDesign() {
        return this.getDesign().getLogicalDesign();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equalsIgnoreCase("Entity")) {
            this.tempEntity = this.getLogicalDesign().createEntity();
            this.tempEntity.setName(attributes.getValue("name"));
            this.inent = true;
        }
        if (this.tempEntity != null && qName.equalsIgnoreCase("Attribute")) {
            this.tempAttr = this.tempEntity.createAttribute();
            this.tempAttr.setName(attributes.getValue("name"));
            this.inattr = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inent && !this.inattr) {
            String text;
            if (qName.equalsIgnoreCase("Comment") && (text = this.getText()) != null && !"".equals(text)) {
                this.tempEntity.setComment(text);
            }
            if (qName.equalsIgnoreCase("Entity")) {
                this.inent = false;
            }
        } else if (this.inent && this.inattr) {
            String text;
            if (qName.equalsIgnoreCase("Comment") && (text = this.getText()) != null && !"".equals(text)) {
                this.tempAttr.setComment(text);
            }
            if (qName.equalsIgnoreCase("Attribute")) {
                this.inattr = false;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }

    public String getText() {
        return this.text.toString().trim();
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ERwinHandler.this.design.closeAllDiagrams();
                ERwinHandler.this.design.setDisableTreeUpdate(true);
                ERwinHandler.this.design.setPropagatePKChahges(false);
                ERwinHandler.this.design.getLogicalDesign().getMainView().setAutoRoute(false);
                ERwinHandler.this.design.getLogicalDesign().getMainView().setBoxInBox(false);
                ERwinHandler.this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                ERwinHandler.this.design.getRelationalDesign().getMainView().setAutoRoute(false);
                ERwinHandler.this.design.getRelationalDesign().getMainView().setBoxInBox(false);
                ERwinHandler.this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                ImportLogger importLog = new ImportLogger();
                try {
                    ERwinHandler.this.monitor = new ProgressDialog(ERwinHandler.this.appView, "", 0, 100);
                    try {
                        try {
                            ERwinHandler.this.monitor.setNote(Messages.getString("ERwinHandler.ParseFile"));
                            ERwinHandler.this.monitor.setProgress(5);
                            ERwinHandler.this.parseFile(ERwinHandler.this.currentFile, importLog);
                            ERwinHandler.this.monitor.setProgress(100);
                            if (ERwinHandler.this.inExistingDesign) {
                                ERwinHandler.this.appView.getCurrentDesign().setDesignPath(ERwinHandler.this.oldDesignPath);
                            } else {
                                ERwinHandler.this.appView.getCurrentDesign().setDesignPath("");
                            }
                            ERwinHandler.this.appView.synchronizeTitle();
                        }
                        finally {
                            ERwinHandler.this.appView.setImporting(false);
                        }
                    }
                    finally {
                        ERwinHandler.this.monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ERwinHandler.this.design.setPropagatePKChahges(true);
                            ERwinHandler.this.design.getLogicalDesign().setMainViewVisible(true);
                            ERwinHandler.this.design.getRelationalDesign().setMainViewVisible(true);
                            ERwinHandler.this.design.setDisableTreeUpdate(false);
                            ERwinHandler.this.appView.centerDesign();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (ERwinHandler.this.appView.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(ERwinHandler.this.appView);
                    logPanel.setLog(importLog.generateReport(ERwinHandler.this.appView));
                    logPanel.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception e) {
                ERwinHandler.this.design.destroyAll(false);
                ERwinHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + ERwinHandler.this.designName, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ERwinHandler.UnableToImportTheFile"), Messages.getString("ERwinHandler.ErrorImportingFile"), 0);
            }
        }
    }

    protected class ValidationRuleHolder {
        private int type = 0;
        private String rule;
        private String minValue;
        private String maxValue;
        private Map valueList = new TreeMap();
        private String definition = "";
        private String name = "";

        public ValidationRuleHolder(int type) {
            this.type = type;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public int getType() {
            return this.type;
        }

        public Map getValueList() {
            return this.valueList;
        }

        public void addValue(String value, String description) {
            this.valueList.put(value, description);
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    protected class IHObject {
        private String parentID;
        private String childID;
        private String comment = "";

        public IHObject(String parentID, String childID) {
            this.parentID = parentID;
            this.childID = childID;
        }

        public String getChildID() {
            return this.childID;
        }

        public String getParentID() {
            return this.parentID;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    protected class FKElement {
        private String id;
        private String parentAttributeID;
        private String parentRelationshipID;

        public FKElement(String id, String parentAttributeID, String parentRelationshipID) {
            this.id = id;
            this.parentAttributeID = parentAttributeID;
            this.parentRelationshipID = parentRelationshipID;
        }

        public String getID() {
            return this.id;
        }

        public String getParentAttributeID() {
            return this.parentAttributeID;
        }

        public String getParentRelationshipID() {
            return this.parentRelationshipID;
        }
    }
}

