/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k12;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.DataBaseSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceSqlServerv2k12
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateSequenceSqlServerv2k12.class);

    public SHCreateSequenceSqlServerv2k12(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSequenceSqlServerv2k12.clearCR(line);
        if (Token.startsWithString(statement, "CREATE SEQUENCE")) {
            try {
                this.parseSequence(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateSequenceSqlServerv2k12.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSequence(String statement) {
        SequenceSqlServerv2k12 sequence;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer stoDesign = (StorageDesignSqlServer)this.design.getStorageDesign(site);
        if (stoDesign != null && stoDesign instanceof StorageDesignSqlServerv2k12 && (sequence = ((StorageDesignSqlServerv2k12)stoDesign).getSequenceSet().createSequence()) != null) {
            this.initNameAndSchema(sequence, (StorageDesignSqlServerv2k12)stoDesign);
            this.initDatabase(sequence, (StorageDesignSqlServerv2k12)stoDesign);
            this.initIntegerType(sequence);
            this.initStartWith(sequence);
            this.initIncrementBy(sequence);
            this.initMaxValue(sequence);
            this.initMinValue(sequence);
            this.initCycle(sequence);
            this.initCache(sequence);
            this.design.getRelationalDesign().stampModelObjectDDL(sequence);
        }
    }

    private void initNameAndSchema(SequenceSqlServerv2k12 sequence, StorageDesignSqlServerv2k12 storageDesign) {
        String startOfName = Token.getStringAfter(this.statement, "SEQUENCE");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
            String schemaName = name.substring(0, posPoint);
            name = name.substring(posPoint + 1);
            SchemaSqlServer schema = (SchemaSqlServer)storageDesign.getSchemaSet().getByName(schemaName);
            if (schema == null) {
                schema = storageDesign.getSchemaSet().createSchema();
                schema.setName(schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            sequence.setSchema(schema);
        }
        sequence.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            sequence.setNameHasQuotes(true);
        }
    }

    private void initDatabase(SequenceSqlServerv2k12 sequence, StorageDesignSqlServerv2k12 storageDesign) {
        String schemaName;
        DataBaseSqlServerv2k12 db = null;
        if (sequence.getSchema() != null && !(schemaName = sequence.getSchema().getName()).equalsIgnoreCase("")) {
            SchemaSqlServer schema = (SchemaSqlServer)storageDesign.getSchemaSet().getByName(schemaName);
            db = schema != null ? (DataBaseSqlServerv2k12)schema.getDatabase() : (DataBaseSqlServerv2k12)storageDesign.getDataBaseSet().getByName(schemaName);
        }
        if (db == null) {
            db = (DataBaseSqlServerv2k12)this.getCurrentDB();
        }
        sequence.setDatabase(db);
    }

    private void initIntegerType(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "AS")) {
            String str = Token.getStringAfter(this.statement, "AS");
            String type = Token.getFirstToken(str);
            sequence.setIntegerType(type);
            str = Token.getStringAfter(str, type);
            if (str.indexOf("(") == 0 && str.indexOf(")") > 0) {
                String prec = str.substring(1, str.indexOf(")")).trim();
                if (prec.indexOf(",") > 0) {
                    prec = prec.substring(0, prec.indexOf(",")).trim();
                }
                sequence.setIntegerPrecision(prec);
            }
        }
    }

    private void initStartWith(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "START")) {
            String str = Token.getTokenAfter(this.statement, "WITH");
            sequence.setStartWith(str);
        }
    }

    private void initIncrementBy(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "INCREMENT")) {
            String str = Token.getTokenAfter(this.statement, "BY");
            sequence.setIncrementBy(str);
        }
    }

    private void initMinValue(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            if (Token.getTokenBefore(this.statement, "MINVALUE").equalsIgnoreCase("NO")) {
                sequence.setMinValue("");
            } else {
                String str = Token.getTokenAfter(this.statement, "MINVALUE");
                sequence.setMinValue(str);
            }
        }
    }

    private void initMaxValue(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            if (Token.getTokenBefore(this.statement, "MAXVALUE").equalsIgnoreCase("NO")) {
                sequence.setMaxValue("");
            } else {
                String str = Token.getTokenAfter(this.statement, "MAXVALUE");
                sequence.setMaxValue(str);
            }
        }
    }

    private void initCycle(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            if (Token.getTokenBefore(this.statement, "CYCLE").equalsIgnoreCase("NO")) {
                sequence.setCycle("NO");
            } else {
                sequence.setCycle("YES");
            }
        }
    }

    private void initCache(SequenceSqlServerv2k12 sequence) {
        if (Token.hasToken(this.statement, "CACHE")) {
            if (Token.getTokenBefore(this.statement, "CACHE").equalsIgnoreCase("NO")) {
                sequence.setNoCache("YES");
                sequence.setCache("");
            } else {
                sequence.setNoCache("NO");
                if (!"".equals(Token.getTokenAfter(this.statement, "CACHE"))) {
                    String cache = Token.getTokenAfter(this.statement, "CACHE");
                    sequence.setCache(cache);
                } else {
                    sequence.setCache("");
                }
            }
        }
    }
}

