/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String VIEW_METADATA = "VIEW_METADATA";
    private static final Logger LOGGER = new Logger(SHCreateViewSqlServer.class);
    private AbstractView view;
    private TableViewProxySqlServer viewProxy;
    private StorageDesignSqlServerv2k storageDesign;
    private String userName = "";
    private String userDefined;

    public SHCreateViewSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateViewSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "CREATE VIEW")) {
            try {
                this.userDefined = line;
                this.createView(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(line);
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createView(String statement) {
        this.statement = statement;
        this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
        this.design.getRelationalDesign().stampModelObjectDDL(this.view);
        String viewName = this.initName();
        if (this.userName != null && !"".equals(this.userName)) {
            this.view.setSchema(this.userName);
        }
        this.view.setName(viewName);
        this.initUserDefinedSql();
        if (!this.initCols()) {
            this.initCol();
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.viewProxy = (TableViewProxySqlServer)this.storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID());
            if (this.viewProxy != null) {
                this.initUserAndDB();
                this.initEncription();
                this.initSchemaBinding();
                this.initViewMetadata();
                this.initCheckOptions();
            }
        }
    }

    private void initUserDefinedSql() {
        int optIndex;
        String afterAs = Token.getStringAfter(this.userDefined, "AS");
        if (afterAs.startsWith("(")) {
            afterAs = Token.getValBetweenBrackets(afterAs);
        }
        if ((optIndex = afterAs.toUpperCase().indexOf("WITH CHECK OPTION")) > 0) {
            afterAs = afterAs.substring(0, optIndex).trim();
        }
        this.view.setUserDefinedSQL(afterAs);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("MSSQL");
    }

    private String initName() {
        String temp = Token.getTokenAfter(this.statement, "VIEW").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "VIEW", '[', ']').trim() : Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        if (tokenizer.countTokens() == 2) {
            this.userName = tokenizer.nextToken().trim();
            name = tokenizer.nextToken().trim();
        }
        return name;
    }

    public boolean initCols() {
        String statementAs = this.removeClosingBrackets(this.statement);
        String beforeSelect = Token.getStringBefore(statementAs, " as select ");
        if (!Token.hasToken(beforeSelect, "OF") && Token.hasCloseAndOpenBrackets(beforeSelect)) {
            String cols = Token.getValBetweenBrackets(beforeSelect, 1);
            if (!"".equalsIgnoreCase(cols)) {
                StringTokenizer tokenizer = new StringTokenizer(cols, ",");
                String column = "";
                while (tokenizer.hasMoreTokens()) {
                    column = Token.removeQuotes(tokenizer.nextToken());
                    AbstractViewElement cvExp = this.view.createViewElement(this.view.getDesignPart());
                    cvExp.setName(column);
                    cvExp.setDesign(this.design);
                    cvExp.setAlias(column);
                    cvExp.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                    this.view.add(cvExp);
                }
            }
            return true;
        }
        return false;
    }

    public void initCol() {
        String statementAs = this.removeClosingBrackets(this.statement);
        String stmt = Token.getStringAfter(statementAs, "AS SELECT").trim();
        if (stmt.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            stmt = Token.getStringAfter(statementAs, "SELECT").trim();
        }
        if (!stmt.equalsIgnoreCase("")) {
            if (Token.hasToken(statementAs, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.toUpperCase().indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("TOP")) {
                stmt = Token.cutFirstToken(stmt);
                stmt = Token.cutFirstToken(stmt);
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("PERCENT")) {
                stmt = Token.cutFirstToken(stmt);
            }
            if (stmt.toUpperCase().startsWith("WITH TIES")) {
                stmt = stmt.substring(9).trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            Object columnAlias = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getNameAfterToken(column, "AS", '[', ']');
                    column = Token.getStringBeforeToken(column, "AS");
                }
                column = Token.encodeQuotedString(column);
                column = Token.encodeSquareBracketsString(column);
                if (columnAlias == null && column.indexOf(32) > -1) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = ((String)columnAlias).lastIndexOf(34);
                        columnAlias = ((String)columnAlias).substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else if (column.charAt(column.length() - 1) == '\'') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = ((String)columnAlias).lastIndexOf(39);
                        columnAlias = ((String)columnAlias).substring(lastIndex) + "'";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                if (!(Token.hasCloseAndOpenBrackets(column) || column.indexOf(43) != -1 || column.indexOf(45) != -1 || column.indexOf(42) != -1 || column.indexOf(47) != -1 || column.indexOf(37) != -1 || column.indexOf(38) != -1 || column.indexOf(124) != -1 || column.indexOf(94) != -1 || Token.hasToken(column, "OR") || Token.hasToken(column, "BETWEEN") || Token.hasToken(column, "AND") || column.indexOf(46) <= -1 || (column = column.substring(column.indexOf(46) + 1)).indexOf(46) <= -1)) {
                    column = column.substring(column.indexOf(46) + 1);
                }
                if ((column = Token.removeQuotes(Token.decodeQuotedString(column))).equalsIgnoreCase("") || column.equalsIgnoreCase("*")) continue;
                AbstractViewElement cvExp = this.view.createViewElement(this.view.getDesignPart());
                this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                cvExp.setName(column);
                cvExp.setDesign(this.design);
                cvExp.setExpression(column);
                cvExp.setContainer(this.view);
                this.view.add(cvExp);
                if (columnAlias != null) {
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString((String)columnAlias));
                    cvExp.setAlias((String)columnAlias);
                    cvExp.setHeaderAlias((String)columnAlias);
                    continue;
                }
                cvExp.setAlias(cvExp.getName());
            }
        }
    }

    private void initUserAndDB() {
        DataBaseSqlServer db = null;
        if (!this.userName.equalsIgnoreCase("")) {
            UserSqlServer user = (UserSqlServer)this.storageDesign.getUserSet().getByName(this.userName);
            if (user != null) {
                this.viewProxy.setUser(user);
                db = user.getDatabase();
            } else {
                db = (DataBaseSqlServer)this.storageDesign.getDataBaseSet().getByName(this.userName);
            }
        }
        if (db == null) {
            db = this.getCurrentDB();
        }
        this.viewProxy.setDataBase(db);
    }

    private void initEncription() {
        if (this.statement.toUpperCase().indexOf("ENCRYPTION") > -1) {
            this.viewProxy.setEncryption("YES");
        } else {
            this.viewProxy.setEncryption("NO");
        }
    }

    private void initSchemaBinding() {
        if (this.statement.toUpperCase().indexOf("SCHEMABINDING") > -1) {
            this.viewProxy.setSchemaBinding("YES");
        } else {
            this.viewProxy.setSchemaBinding("NO");
        }
    }

    private void initViewMetadata() {
        if (this.statement.toUpperCase().indexOf(VIEW_METADATA) > -1) {
            this.viewProxy.setViewMetaData("YES");
        } else {
            this.viewProxy.setViewMetaData("NO");
        }
    }

    private void initCheckOptions() {
        if (this.statement.toUpperCase().indexOf("WITH CHECK OPTION") > -1) {
            this.viewProxy.setCheckOption(true);
        } else {
            this.viewProxy.setCheckOption(false);
        }
    }

    public void setView(AbstractView view) {
        this.view = view;
    }

    private String removeClosingBrackets(String statement) {
        int ind = statement.toLowerCase().indexOf(" as ");
        String stb = "";
        Object stmt = statement;
        if (ind > -1) {
            stb = statement.substring(0, ind + 4);
            stmt = statement.substring(ind + 4).trim();
            if (((String)stmt).charAt(0) == '(') {
                stmt = Token.getValBetweenBrackets((String)stmt);
            }
            stmt = stb + (String)stmt;
        }
        return stmt;
    }
}

