/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHColumnElementsOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTableOraclev9i;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.FKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SHAlterTableOraclev9i
extends DDLStatementHandler {
    private Table table;
    private RDBMSSite site = null;
    private StorageDesignOraclev9i storageDesign = null;
    private FKIndexAssociation fkass = null;
    private String line;
    private static final Logger LOGGER = new Logger(SHAlterTableOraclev9i.class);

    public SHAlterTableOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterTableOraclev9i.clearCR(line);
        this.line = line;
        this.statement = statement;
        if (Token.startsWithString(statement, "ALTER TABLE")) {
            this.parseAlterTable(statement);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseAlterTable(String statement) {
        try {
            this.initTable();
            if (this.table != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
                String nameString = Token.getStringAfter(statement, "RENAME TO");
                if (nameString.length() > 0) {
                    SHAlterTableOraclev10g.processRenameTable(statement, this.table);
                } else {
                    String[] splittedConstr = statement.split(" ADD ");
                    if (splittedConstr.length == 1) {
                        splittedConstr = statement.split(" add ");
                    }
                    Iterator<String> it = Arrays.asList(splittedConstr).iterator();
                    while (it.hasNext()) {
                        String part_statement = it.next().trim();
                        if (Token.startsWithString(part_statement, "ALTER TABLE")) {
                            String afterModify = Token.getStringAfter(part_statement, "MODIFY");
                            if (afterModify.length() <= 0) continue;
                            if (afterModify.startsWith("(")) {
                                String withinBrackets = Token.getValBetweenBrackets(afterModify, 1);
                                int startIndex = 0;
                                int commaIndex = 0;
                                while (commaIndex > -1) {
                                    commaIndex = withinBrackets.indexOf(44, startIndex);
                                    while (commaIndex > -1 && Token.hasOpenBracketNoClose(withinBrackets.substring(startIndex, commaIndex))) {
                                        commaIndex = withinBrackets.indexOf(44, commaIndex + 1);
                                    }
                                    if (commaIndex <= -1) continue;
                                    this.processModifyColumn(withinBrackets.substring(startIndex, commaIndex));
                                    startIndex = commaIndex + 1;
                                }
                                this.processModifyColumn(withinBrackets.substring(startIndex));
                                continue;
                            }
                            String firstToken = Token.getFirstToken(afterModify);
                            if (!firstToken.equalsIgnoreCase("CONSTRAINT") && !firstToken.equalsIgnoreCase("PRIMARY") && !firstToken.equalsIgnoreCase("UNIQUE")) continue;
                            this.parseModifyConstraint(part_statement);
                            continue;
                        }
                        int startIndex = 0;
                        if (part_statement.startsWith("(")) {
                            part_statement = Token.getValBetweenBrackets(part_statement, 1);
                            int commaIndex = 0;
                            while (commaIndex > -1) {
                                commaIndex = part_statement.indexOf(44, startIndex);
                                while (commaIndex > -1 && Token.hasOpenBracketNoClose(part_statement.substring(startIndex, commaIndex))) {
                                    commaIndex = part_statement.indexOf(44, commaIndex + 1);
                                }
                                if (commaIndex <= -1) continue;
                                this.processClause(part_statement.substring(startIndex, commaIndex));
                                startIndex = commaIndex + 1;
                            }
                        }
                        this.processClause(part_statement.substring(startIndex));
                    }
                }
                this.importLog.incrementImportedStatements();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
            this.importLog.addFailedStatement(SHAlterTableOraclev9i.FormatCR(this.line, "\n"));
        }
    }

    private void processModifyColumn(String text) {
        SHColumnElementsOraclev9i columnHandler = new SHColumnElementsOraclev9i();
        Map columnMap = columnHandler.getElementsColumn(text);
        String columnName = (String)columnMap.get("columnname");
        Column column = null;
        if (columnName.length() > 0) {
            Column[] columnSet = (Column[])this.table.getElementsAndNestedElements();
            for (int ci = 0; ci < columnSet.length; ++ci) {
                String colname = columnSet[ci].getName();
                if (!columnName.equalsIgnoreCase(colname)) continue;
                column = columnSet[ci];
                break;
            }
        }
        if (column != null) {
            SHCreateTableOraclev9i tableHandler = (SHCreateTableOraclev9i)this.getCreateTableHandler();
            tableHandler.initColumnProps(columnMap, this.design, this.table, column);
        }
    }

    private void processClause(String clause) {
        if (this.isFK(clause)) {
            this.parseFK(clause);
        } else if (!this.initColumn(clause)) {
            if (this.isPK(clause)) {
                this.initPK(clause);
            } else if (this.isUK(clause)) {
                this.initUK(clause);
            } else if (this.isCheck(clause)) {
                this.initCheck(clause);
            }
        }
    }

    public void parseFK(String statement) {
        this.fkass = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        this.statement = statement;
        int index = StringUtilities.indexOf(statement, "CONSTRAINT");
        if (index < 0) {
            index = StringUtilities.indexOf(statement, "FOREIGN");
        }
        if (index > -1) {
            String fks = statement.substring(index);
            Object constr = null;
            StringTokenizer tokenizer = new StringTokenizer(fks, ",");
            while (tokenizer.hasMoreTokens()) {
                constr = tokenizer.nextToken().trim();
                while (Token.hasOpenBracketNoClose((String)constr) && tokenizer.hasMoreTokens()) {
                    constr = (String)constr + ", " + tokenizer.nextToken().trim();
                }
                if (this.table == null) continue;
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
                if (!this.isFK((String)constr)) continue;
                this.initForeignKey((String)constr);
            }
        }
    }

    private boolean isFK(String st) {
        return Token.hasToken(st, "FOREIGN");
    }

    private void initTable() throws ObjectDoesNotExistException {
        this.table = null;
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"');
        String tableName = this.getNameFor(name);
        String userName = Token.getValBeforeCharacter(name, '.');
        if (this.table == null) {
            this.table = SHAlterTableOraclev10g.getTableFor(userName, tableName, this.design);
        }
        if (this.table == null) {
            this.importLog.addError("Table with name " + name + " does not exist.");
            throw new ObjectDoesNotExistException("Table with name " + name);
        }
    }

    private void initForeignKey(String statement) {
        String stringWithFK = statement;
        if (stringWithFK.trim().startsWith("(")) {
            stringWithFK = Token.getValBetweenBrackets(stringWithFK);
        }
        boolean hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        while (hasForeignKey) {
            Table tableRef;
            Object nameFK;
            int positionForeign = StringUtilities.indexOf(stringWithFK, "FOREIGN");
            String fkString = stringWithFK.substring(positionForeign);
            boolean needsQuotes = false;
            if (Token.hasToken(stringWithFK, "CONSTRAINT")) {
                String afterConstraint = Token.getStringAfterToken(stringWithFK, "CONSTRAINT");
                nameFK = Token.getFirstName(afterConstraint, '\"', '\"');
                needsQuotes = afterConstraint.startsWith("\"") && !((String)nameFK).equals(((String)nameFK).toUpperCase());
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 25) {
                    tableName = tableName.substring(0, 25);
                }
                nameFK = tableName + "_FK" + this.table.getFKAssociationsCount();
            }
            int positionBracket = fkString.indexOf(41);
            String firstBrackets = fkString.substring(0, positionBracket + 1).trim();
            String columns = Token.getValBetweenBrackets(firstBrackets);
            List columnNames = this.getColumnNames(columns);
            ArrayList<Column> columnsRef = new ArrayList<Column>();
            Column[] columnSet = (Column[])this.table.getElementsAndNestedElements();
            block1: for (String name : columnNames) {
                for (int ci = 0; ci < columnSet.length; ++ci) {
                    String colname = columnSet[ci].getName();
                    if (!name.equalsIgnoreCase(colname)) continue;
                    columnsRef.add(columnSet[ci]);
                    continue block1;
                }
            }
            fkString = Token.getStringAfterToken(fkString, "REFERENCES");
            String nameReferenced = Token.getFirstName(fkString, '\"', '\"');
            String userName = "";
            String nameRef = nameReferenced;
            int dotIndex = nameReferenced.indexOf(46);
            if (dotIndex > -1) {
                userName = nameReferenced.substring(0, dotIndex);
                nameRef = nameReferenced.substring(dotIndex + 1);
            }
            if ((tableRef = null) == null) {
                tableRef = SHAlterTableOraclev10g.getTableFor(userName, nameRef, this.design);
            }
            if (tableRef != null) {
                Index index = null;
                boolean hasBrackets = Token.hasString(fkString, "(");
                if (hasBrackets) {
                    String columnsReferenced = Token.getValBetweenBrackets(fkString, 1);
                    List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                    index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                } else {
                    index = (Index)tableRef.getPK();
                }
                if (index != null) {
                    FKProxyOraclev9i fk;
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    this.fkass = this.table.addFK(index, null, reference);
                    this.fkass.setName((String)nameFK);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.fkass);
                    KeyObject localFKIndex = this.fkass.getLocalFKIndex();
                    localFKIndex.setName((String)nameFK);
                    localFKIndex.setNameHasQuotes(needsQuotes);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(this.fkass, columnsRef, index);
                    } else {
                        this.fixFKColumns(this.fkass, columnsRef, index);
                    }
                    String onDelete = Token.getStringAfter(fkString, "ON DELETE").toUpperCase();
                    if (onDelete.length() > 0 && (onDelete = onDelete.startsWith("CASCADE") ? "CASCADE" : (onDelete.startsWith("SET NULL") ? "SET NULL" : null)) != null) {
                        this.fkass.setDeleteRule(onDelete);
                    }
                    if (this.storageDesign != null && (fk = (FKProxyOraclev9i)this.storageDesign.getFKProxySet().getProxy(localFKIndex.getObjectID())) != null) {
                        this.setConstraintState(fk, statement, false);
                    }
                }
            } else {
                String error = "Referenced table " + nameReferenced + " doesn't exist\n" + this.statement;
                this.importLog.addError(error);
            }
            stringWithFK = fkString;
            hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String columnName = tokColumns.nextToken().trim();
            if (columnName.startsWith("\"")) {
                columnName = Token.removeQuotes(columnName);
            }
            columns.add(columnName);
        }
        return columns;
    }

    private String getNameFor(String name) {
        int posPoint;
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40)).trim();
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        name = Token.getName(name);
        return name;
    }

    private Column getColumnFor(Table table, String name) {
        Column[] columns = (Column[])table.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            Column temp = columns[i];
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            return temp;
        }
        return null;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        FKElement[] cols = columnsRef.toArray(new Column[0]);
        fkAss.swapFKColumnsWith(cols);
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isPK(String st) {
        return st.toUpperCase(Locale.ENGLISH).indexOf("PRIMARY KEY") > -1;
    }

    private void initPK(String statement) {
        Object pkName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean needsQuotes = false;
        if (Token.hasToken(statement, "CONSTRAINT")) {
            String afterConstraint = Token.getStringAfterToken(statement, "CONSTRAINT");
            pkName = Token.getFirstName(afterConstraint, '\"', '\"');
            needsQuotes = afterConstraint.startsWith("\"") && !((String)pkName).equals(((String)pkName).toUpperCase());
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 25) {
                tableName = tableName.substring(0, 25);
            }
            pkName = tableName + "_PK";
        }
        Index indexPK = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "PRIMARY KEY"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            indexPK = this.table.createIndex();
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName);
                if (column == null) continue;
                indexPK.add(column);
            }
            indexPK.makePK();
            if (pkName != null) {
                indexPK.setName((String)pkName);
                indexPK.setNameHasQuotes(needsQuotes);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexPK);
            PKProxyOraclev9i pkProxy = (PKProxyOraclev9i)this.storageDesign.getPKProxySet().getProxy(indexPK.getObjectID());
            boolean isPKConstraint = Token.hasString(statement.toUpperCase(Locale.ENGLISH), "PRIMARY KEY");
            if (isPKConstraint && pkProxy != null) {
                this.setConstraintState(pkProxy, statement, false);
                String usingIndexStatement = Token.getStringAfter(statement, "USING INDEX");
                if (usingIndexStatement.length() > 0) {
                    String firstToken = Token.getFirstToken(usingIndexStatement);
                    if (firstToken.equalsIgnoreCase("LOCAL")) {
                        pkProxy.setUsingIndex("LOCAL PARTITIONED");
                    } else if (firstToken.equalsIgnoreCase("GLOBAL")) {
                        pkProxy.setUsingIndex("GLOBAL PARTITIONED");
                        IndexGlobalPartitionsListOraclev9i igpl = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(igpl);
                        pkProxy.setIndexGlobalPL(igpl);
                        igpl.setIndex(pkProxy);
                        String restOfStatement = Token.getStringAfter(statement, "GLOBAL PARTITION BY RANGE");
                        String columnList = Token.getValBetweenBrackets(restOfStatement);
                        if (Token.hasToken(columnList, ")")) {
                            columnList = Token.getStringBefore(columnList, ")");
                        }
                        igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(columnList));
                    } else if (firstToken.equalsIgnoreCase("(")) {
                        pkProxy.setUsingIndex("BY CREATE INDEX STATEMENT");
                        pkProxy.setCreateIndexStatement(Token.getValBetweenBrackets(usingIndexStatement));
                    } else {
                        pkProxy.setUsingIndex("BY INDEX NAME");
                        if (firstToken.equalsIgnoreCase("PCTFREE") || firstToken.equalsIgnoreCase("INITRANS") || firstToken.equalsIgnoreCase("MAXTRANS") || firstToken.equalsIgnoreCase("STORAGE") || firstToken.equalsIgnoreCase("LOGGING") || firstToken.equalsIgnoreCase("NOLOGGING") || firstToken.equalsIgnoreCase("TABLESPACE") || firstToken.equalsIgnoreCase("SORT") || firstToken.equalsIgnoreCase("NOSORT")) {
                            pkProxy.setExistingIndex(null);
                        } else {
                            String iName = Token.getFirstName(usingIndexStatement, '\"', '\"');
                            String indName = this.getNameFor(iName);
                            String userName = Token.getValBeforeCharacter(iName, '.');
                            Index idx = this.table.getIndexByNameAndSchema(userName, indName);
                            if (idx == null) {
                                this.table.getIndexByName(indName);
                            }
                            if (idx != null) {
                                IndexProxyOracle indexProxy = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(idx.getObjectID());
                                pkProxy.setExistingIndex(indexProxy);
                            }
                        }
                    }
                    if (pkProxy.getExistingIndex() == null && !pkProxy.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String tsName;
                        boolean storage;
                        String maxTransStr;
                        String initransStr;
                        SegmentOracle segment = null;
                        String pctFreeStr = Token.getTokenAfter(usingIndexStatement, "PCTFREE");
                        if (!"".equalsIgnoreCase(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                            try {
                                int pctFree = Integer.parseInt(pctFreeStr);
                                segment = this.getSegment(segment);
                                segment.setPCTFree(pctFree);
                            }
                            catch (NumberFormatException pctFree) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(initransStr = Token.getTokenAfter(usingIndexStatement, "INITRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(initransStr);
                                segment = this.getSegment(segment);
                                segment.setInitrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(maxTransStr = Token.getTokenAfter(usingIndexStatement, "MAXTRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(maxTransStr);
                                segment = this.getSegment(segment);
                                segment.setMaxTrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (storage = Token.hasToken(usingIndexStatement, "STORAGE")) {
                            String groupsStr;
                            String freeListsStr;
                            String maxExtentsStr;
                            String minExtentsStr;
                            String pctIncStr;
                            String nextStr;
                            String storageStatement = Token.getStringAfter(usingIndexStatement, "STORAGE");
                            String initialStr = Token.getTokenAfter(storageStatement, "INITIAL");
                            if (!"".equalsIgnoreCase(initialStr) && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(initialStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCInitialExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(nextStr = Token.getTokenAfter(storageStatement, "NEXT")) && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(nextStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCNextExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(pctIncStr = Token.getTokenAfter(storageStatement, "PCTINCREASE")) && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                try {
                                    int value = Integer.parseInt(pctIncStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCPctIncrease(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(minExtentsStr = Token.getTokenAfter(storageStatement, "MINEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                try {
                                    int value = Integer.parseInt(minExtentsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCMinExtents(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(maxExtentsStr = Token.getTokenAfter(storageStatement, "MAXEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCMaxExtents(maxExtentsStr);
                            }
                            if (!"".equalsIgnoreCase(freeListsStr = Token.getTokenAfter(storageStatement, "FREELISTS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                                try {
                                    int value = Integer.parseInt(freeListsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreeLists(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(groupsStr = Token.getTokenAfter(storageStatement, "GROUPS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                                try {
                                    int value = Integer.parseInt(groupsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreelistGroups(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            String bufferPool = Token.getQuotedNameAfterToken(storageStatement, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(groupsStr) && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCBufferPool(bufferPool);
                            }
                        }
                        if (!(tsName = Token.getQuotedNameAfterToken(usingIndexStatement, "TABLESPACE")).equalsIgnoreCase("")) {
                            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                pkProxy.setTableSpace(ts);
                            }
                        }
                        if (Token.hasToken(usingIndexStatement, "NOSORT")) {
                            pkProxy.setIndexSort("NO");
                        } else if (Token.hasToken(usingIndexStatement, "REVERSE")) {
                            pkProxy.setIndexSort("REVERSE");
                        } else {
                            pkProxy.setIndexSort("SORTED");
                        }
                        if (Token.hasToken(usingIndexStatement, "NOLOGGING")) {
                            pkProxy.setLogging("NO");
                        } else if (Token.hasToken(usingIndexStatement, "LOGGING")) {
                            pkProxy.setLogging("YES");
                        } else {
                            pkProxy.setLogging("");
                        }
                        boolean computeStatistics = Token.hasString(usingIndexStatement.toUpperCase(Locale.ENGLISH), "COMPUTE STATISTICS");
                        if (computeStatistics) {
                            pkProxy.setComputeStatistics("YES");
                        } else {
                            pkProxy.setComputeStatistics("NO");
                        }
                        if (segment != null) {
                            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                            pkProxy.setIndexSegment(equalSegment);
                        }
                    }
                }
            }
        }
    }

    private SegmentOracle getSegment(SegmentOracle segment) {
        if (segment == null) {
            segment = this.storageDesign.getSegmentSet().createSegment();
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
        }
        return segment;
    }

    private boolean isUK(String st) {
        return Token.hasToken(st, "UNIQUE");
    }

    private void initUK(String statement) {
        Object ukName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean needsQuotes = false;
        if (Token.hasToken(statement, "CONSTRAINT")) {
            String afterConstraint = Token.getStringAfterToken(statement, "CONSTRAINT");
            ukName = Token.getFirstName(afterConstraint, '\"', '\"');
            needsQuotes = afterConstraint.startsWith("\"") && !((String)ukName).equals(((String)ukName).toUpperCase());
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 25) {
                tableName = tableName.substring(0, 25);
            }
            ukName = tableName + "_UK" + this.table.getUKeys().size();
        }
        Index indexUK = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "UNIQUE"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            indexUK = this.table.createIndex();
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName);
                if (column == null) continue;
                indexUK.add(column);
            }
            indexUK.setUnique(true);
            if (ukName != null) {
                indexUK.setName((String)ukName);
                indexUK.setNameHasQuotes(needsQuotes);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexUK);
            UniqueOraclev9i unique = (UniqueOraclev9i)this.storageDesign.getUniqueSet().getProxy(indexUK.getObjectID());
            if (unique != null) {
                this.setConstraintState(unique, statement, false);
                String usingIndexStatement = Token.getStringAfter(statement, "USING INDEX");
                if (usingIndexStatement.length() > 0) {
                    String firstToken = Token.getFirstToken(usingIndexStatement);
                    if (firstToken.equalsIgnoreCase("LOCAL")) {
                        unique.setUsingIndex("LOCAL PARTITIONED");
                    } else if (firstToken.equalsIgnoreCase("GLOBAL")) {
                        unique.setUsingIndex("GLOBAL PARTITIONED");
                        IndexGlobalPartitionsListOraclev9i igpl = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(igpl);
                        unique.setUsingIndexGlobalPL(igpl);
                        igpl.setIndex(unique);
                        String restOfStatement = Token.getStringAfter(statement, "GLOBAL PARTITION BY RANGE");
                        String columnList = Token.getStringAfter(restOfStatement, "(");
                        if (Token.hasToken(columnList, ")")) {
                            columnList = Token.getStringBefore(columnList, ")");
                        }
                        igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(columnList));
                    } else if (firstToken.equalsIgnoreCase("(")) {
                        unique.setUsingIndex("BY CREATE INDEX STATEMENT");
                        unique.setCreateIndexStatement(Token.getValBetweenBrackets(usingIndexStatement));
                    } else {
                        unique.setUsingIndex("BY INDEX NAME");
                        if (firstToken.equalsIgnoreCase("PCTFREE") || firstToken.equalsIgnoreCase("INITRANS") || firstToken.equalsIgnoreCase("MAXTRANS") || firstToken.equalsIgnoreCase("STORAGE") || firstToken.equalsIgnoreCase("LOGGING") || firstToken.equalsIgnoreCase("NOLOGGING") || firstToken.equalsIgnoreCase("TABLESPACE") || firstToken.equalsIgnoreCase("SORT") || firstToken.equalsIgnoreCase("NOSORT")) {
                            unique.setExistingIndex(null);
                        } else {
                            String iName = Token.getFirstName(usingIndexStatement, '\"', '\"');
                            String indName = this.getNameFor(iName);
                            String userName = Token.getValBeforeCharacter(iName, '.');
                            Index idx = this.table.getIndexByNameAndSchema(userName, indName);
                            if (idx == null) {
                                this.table.getIndexByName(indName);
                            }
                            if (idx != null) {
                                IndexProxyOracle indexProxy = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(idx.getObjectID());
                                unique.setExistingIndex(indexProxy);
                            }
                        }
                    }
                    if (unique.getExistingIndex() == null && !unique.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String tsName;
                        boolean storage;
                        String maxTransStr;
                        String initransStr;
                        SegmentOracle segment = null;
                        String pctFreeStr = Token.getTokenAfter(usingIndexStatement, "PCTFREE");
                        if (!"".equalsIgnoreCase(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                            try {
                                int pctFree = Integer.parseInt(pctFreeStr);
                                segment = this.getSegment(segment);
                                segment.setPCTFree(pctFree);
                            }
                            catch (NumberFormatException pctFree) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(initransStr = Token.getTokenAfter(usingIndexStatement, "INITRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(initransStr);
                                segment = this.getSegment(segment);
                                segment.setInitrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(maxTransStr = Token.getTokenAfter(usingIndexStatement, "MAXTRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(maxTransStr);
                                segment = this.getSegment(segment);
                                segment.setMaxTrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (storage = Token.hasToken(usingIndexStatement, "STORAGE")) {
                            String groupsStr;
                            String freeListsStr;
                            String maxExtentsStr;
                            String minExtentsStr;
                            String pctIncStr;
                            String nextStr;
                            String storageStatement = Token.getStringAfter(usingIndexStatement, "STORAGE");
                            String initialStr = Token.getTokenAfter(storageStatement, "INITIAL");
                            if (!"".equalsIgnoreCase(initialStr) && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(initialStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCInitialExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(nextStr = Token.getTokenAfter(storageStatement, "NEXT")) && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(nextStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCNextExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(pctIncStr = Token.getTokenAfter(storageStatement, "PCTINCREASE")) && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                try {
                                    int value = Integer.parseInt(pctIncStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCPctIncrease(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(minExtentsStr = Token.getTokenAfter(storageStatement, "MINEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                try {
                                    int value = Integer.parseInt(minExtentsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCMinExtents(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(maxExtentsStr = Token.getTokenAfter(storageStatement, "MAXEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCMaxExtents(maxExtentsStr);
                            }
                            if (!"".equalsIgnoreCase(freeListsStr = Token.getTokenAfter(storageStatement, "FREELISTS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                                try {
                                    int value = Integer.parseInt(freeListsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreeLists(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(groupsStr = Token.getTokenAfter(storageStatement, "GROUPS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                                try {
                                    int value = Integer.parseInt(groupsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreelistGroups(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            String bufferPool = Token.getQuotedNameAfterToken(storageStatement, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(groupsStr) && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCBufferPool(bufferPool);
                            }
                        }
                        if (!(tsName = Token.getQuotedNameAfterToken(usingIndexStatement, "TABLESPACE")).equalsIgnoreCase("")) {
                            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                unique.setTableSpace(ts);
                            }
                        }
                        if (Token.hasToken(usingIndexStatement, "NOSORT")) {
                            unique.setIndexSort("NO");
                        } else if (Token.hasToken(usingIndexStatement, "REVERSE")) {
                            unique.setIndexSort("REVERSE");
                        } else {
                            unique.setIndexSort("SORTED");
                        }
                        if (Token.hasToken(usingIndexStatement, "NOLOGGING")) {
                            unique.setLogging("NO");
                        } else if (Token.hasToken(usingIndexStatement, "LOGGING")) {
                            unique.setLogging("YES");
                        } else {
                            unique.setLogging("");
                        }
                        boolean computeStatistics = Token.hasString(usingIndexStatement.toUpperCase(Locale.ENGLISH), "COMPUTE STATISTICS");
                        if (computeStatistics) {
                            unique.setComputeStatistics("YES");
                        } else {
                            unique.setComputeStatistics("NO");
                        }
                        if (segment != null) {
                            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                            unique.setIndexSegment(equalSegment);
                        }
                    }
                }
            }
        }
    }

    private boolean isCheck(String st) {
        return Token.hasToken(st, "CHECK");
    }

    private Column getColumnForConstr(Table table, String condition) {
        String check = condition.toUpperCase();
        ContainedObject[] cols = table.getElements();
        Column col = null;
        boolean found = false;
        for (int i = 0; i < cols.length; ++i) {
            col = (Column)cols[i];
            String name = col.getName().toUpperCase();
            if (check.indexOf(name) <= -1) continue;
            found = true;
            for (int k = 0; k < cols.length; ++k) {
                String c2name;
                Column c2 = (Column)cols[k];
                if (col == c2 || check.indexOf(c2name = c2.getName().toUpperCase()) <= -1) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return col;
        }
        return null;
    }

    private void initCheck(String constr) {
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.statement = constr;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String constrName = "";
        if (Token.hasToken(this.statement, "CONSTRAINT")) {
            constrName = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT");
        }
        String condition = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK")).trim();
        try {
            CheckConstraint check;
            Column column = this.getColumnForConstr(this.table, condition);
            if (column != null && (check = column.getCheck()) == null) {
                CheckConstraint constraint = new CheckConstraint();
                constraint.add(this.storageDesign.getRDBMSType(), condition);
                column.setUseDomainConstraints(false);
                column.parseAndSetCheckConstraint(constraint);
                column.setConstraintName(constrName);
                this.design.getRelationalDesign().stampModelObjectDDL(constraint);
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID());
                if (columnProxy != null) {
                    this.setConstraintState(columnProxy, this.statement, false);
                }
                return;
            }
        }
        catch (Exception column) {
            // empty catch block
        }
        TableLevelConstraint constraint = this.table.createCheckConstraint(constrName, condition);
        this.table.addCheckConstraint(constraint);
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        TableCheckConstraintOracle proxy = tableProxy.getTableConstraint(constraint);
        if (proxy != null) {
            this.setConstraintState(proxy, this.statement, false);
        }
    }

    private boolean initColumn(String constr) {
        SHColumnElementsOraclev9i columnHandler = new SHColumnElementsOraclev9i();
        Map columnMap = columnHandler.getElementsColumn(constr);
        SHCreateTableOraclev9i tableHandler = (SHCreateTableOraclev9i)this.getCreateTableHandler();
        return tableHandler.initColumn(columnMap, this.design, this.table);
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private void parseModifyConstraint(String clause) {
        String modifyConstraint = Token.getStringAfter(clause, "MODIFY CONSTRAINT");
        if (modifyConstraint.length() > 0) {
            String constraintName = Token.getFirstName(modifyConstraint, '\"', '\"');
            StorageObject constraintObject = null;
            for (KeyObject pkUk : this.table.getPKandUKConstraints()) {
                if (!pkUk.getName().equalsIgnoreCase(constraintName)) continue;
                constraintObject = this.storageDesign.getStorageObject(pkUk.getObjectID());
                break;
            }
            if (constraintObject == null) {
                for (FKIndexAssociation fk : this.table.getFKAssociationsList()) {
                    if (!fk.getName().equalsIgnoreCase(constraintName)) continue;
                    constraintObject = this.storageDesign.getStorageObject(fk.getObjectID());
                    break;
                }
            }
            if (constraintObject != null) {
                this.setConstraintState(constraintObject, clause, false);
            } else {
                TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
                ColumnProxy[] proxies = tableProxy.getColumnProxies();
                for (int i = 0; i < proxies.length; ++i) {
                    String columnProxyNncName;
                    ColumnProxyOracle columnProxy = (ColumnProxyOracle)proxies[i];
                    Column column = columnProxy.getColumn();
                    String columnCheckConstraintName = column.getConstraintName();
                    if (constraintName.equalsIgnoreCase(columnCheckConstraintName)) {
                        this.setConstraintState(columnProxy, clause, false);
                        break;
                    }
                    String string = columnProxyNncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : column.getNotNullConstraintName();
                    if (!constraintName.equalsIgnoreCase(columnProxyNncName)) continue;
                    this.setConstraintState(columnProxy, clause, true);
                    break;
                }
            }
        }
    }

    private void setConstraintState(StorageObject constraintObject, String clause, boolean notNullConstraint) {
        String deferrable = null;
        String initially = null;
        String enable = null;
        String validate = null;
        String rely = null;
        if (Token.hasToken(clause, "DEFERRABLE")) {
            deferrable = Token.getTokenBefore(clause, "DEFERRABLE").equalsIgnoreCase("NOT") ? "NO" : "YES";
        }
        if (Token.hasToken(clause, "INITIALLY")) {
            initially = Token.getTokenAfter(clause, "INITIALLY").toUpperCase(Locale.ENGLISH);
        }
        if (Token.hasToken(clause, "DISABLE")) {
            enable = "NO";
            validate = "NO";
        } else if (Token.hasToken(clause, "ENABLE")) {
            enable = "YES";
        }
        if (Token.hasToken(clause, "NOVALIDATE")) {
            validate = "NO";
        } else if (Token.hasToken(clause, "VALIDATE")) {
            validate = "YES";
        }
        if (Token.hasToken(clause, "NORELY")) {
            rely = "NO";
        } else if (Token.hasToken(clause, "RELY")) {
            rely = "YES";
        }
        TableProxyOracle excTable = null;
        String exceptionsTable = Token.getStringAfter(clause, "EXCEPTIONS INTO");
        if (exceptionsTable.length() > 0) {
            String excTableName = Token.getFirstName(exceptionsTable, '\"', '\"');
            int dotIndex = excTableName.indexOf(46);
            if (dotIndex > 0) {
                String userName = excTableName.substring(0, dotIndex);
                excTableName = excTableName.substring(dotIndex + 1);
                excTable = (TableProxyOracle)this.storageDesign.getTableProxySet().getByUserSchemaAndName(userName, excTableName);
            }
            if (excTable == null) {
                excTable = (TableProxyOracle)this.storageDesign.getTableProxySet().getByName(excTableName);
            }
        }
        if (constraintObject instanceof PKProxyOracle) {
            PKProxyOracle pkProxy = (PKProxyOracle)constraintObject;
            if (deferrable != null) {
                pkProxy.setDeferrable(deferrable);
            }
            if (initially != null) {
                pkProxy.setInitially(initially);
            }
            if (enable != null) {
                pkProxy.setEnable(enable);
            }
            if (validate != null) {
                pkProxy.setValidate(validate);
            }
            if (rely != null) {
                pkProxy.setRely(rely);
            }
            if (excTable != null) {
                pkProxy.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof UniqueOracle) {
            UniqueOracle unique = (UniqueOracle)constraintObject;
            if (deferrable != null) {
                unique.setDeferrable(deferrable);
            }
            if (initially != null) {
                unique.setInitially(initially);
            }
            if (enable != null) {
                unique.setEnable(enable);
            }
            if (validate != null) {
                unique.setValidate(validate);
            }
            if (rely != null) {
                unique.setRely(rely);
            }
            if (excTable != null) {
                unique.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof FKProxyOracle) {
            FKProxyOracle fkProxy = (FKProxyOracle)constraintObject;
            if (deferrable != null) {
                fkProxy.setDeferrable(deferrable);
            }
            if (initially != null) {
                fkProxy.setInitially(initially);
            }
            if (enable != null) {
                fkProxy.setEnable(enable);
            }
            if (validate != null) {
                fkProxy.setValidate(validate);
            }
            if (rely != null) {
                fkProxy.setRely(rely);
            }
            if (excTable != null) {
                fkProxy.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof TableCheckConstraintOracle) {
            TableCheckConstraintOracle checkProxy = (TableCheckConstraintOracle)constraintObject;
            if (deferrable != null) {
                checkProxy.setDeferrable(deferrable);
            }
            if (initially != null) {
                checkProxy.setInitially(initially);
            }
            if (enable != null) {
                checkProxy.setEnable(enable);
            }
            if (validate != null) {
                checkProxy.setValidate(validate);
            }
            if (excTable != null) {
                checkProxy.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof ColumnProxyOracle) {
            ColumnProxyOracle columnProxy = (ColumnProxyOracle)constraintObject;
            if (deferrable != null) {
                if (notNullConstraint) {
                    columnProxy.setNncDeferrable(deferrable);
                } else {
                    columnProxy.setDeferrable(deferrable);
                }
            }
            if (initially != null) {
                if (notNullConstraint) {
                    columnProxy.setNncInitially(initially);
                } else {
                    columnProxy.setInitially(initially);
                }
            }
            if (enable != null) {
                if (notNullConstraint) {
                    columnProxy.setNncEnable(enable);
                } else {
                    columnProxy.setEnable(enable);
                }
            }
            if (validate != null) {
                if (notNullConstraint) {
                    columnProxy.setNncValidate(validate);
                } else {
                    columnProxy.setValidate(validate);
                }
            }
            if (rely != null && notNullConstraint) {
                columnProxy.setNncRely(rely);
            }
            if (excTable != null) {
                if (notNullConstraint) {
                    columnProxy.setNncExceptionsTable(excTable);
                } else {
                    columnProxy.setExceptionsTable(excTable);
                }
            }
        }
    }
}

