/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class SHCreateObjectOracle
extends DDLStatementHandler {
    protected static final Logger LOGGER = new Logger(SHCreateObjectOracle.class);

    public SHCreateObjectOracle(Design design) {
        super(design);
    }

    protected boolean canHandle(String statement) {
        if (Token.getFirstToken(statement).equalsIgnoreCase("CREATE")) {
            String firstToken;
            String restOfText = Token.cutTokenFromFront(statement, "CREATE");
            if (Token.startsWithString(restOfText, "OR REPLACE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "OR REPLACE");
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("EDITIONABLE") || firstToken.equalsIgnoreCase("NONEDITIONABLE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if (Token.startsWithString(restOfText, this.getTypeName())) {
                return true;
            }
        }
        return false;
    }

    protected abstract String getTypeName();

    @Override
    public void handle(String line) {
        String statement = SHCreateObjectOracle.clearCR(line);
        if (this.canHandle(statement)) {
            try {
                this.parse(statement, line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateObjectOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    protected void parse(String statement, String line) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (storageDesignOracle != null) {
            boolean success;
            String ownerAndName;
            PlSqlSourceStorageObjectOracle objectOracle = this.createElement(storageDesignOracle);
            String name = ownerAndName = this.extractOwnerAndName(statement);
            String ownerName = null;
            int dotIndex = ownerAndName.indexOf(46);
            if (dotIndex > -1) {
                ownerName = name.substring(0, dotIndex);
                UserOracle owner = (UserOracle)storageDesignOracle.getUserSet().getByName(ownerName);
                if (owner == null && ownerName.trim().length() > 0) {
                    owner = storageDesignOracle.getUserSet().createUser();
                    owner.setName(ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                objectOracle.setOwner(owner);
                name = name.substring(dotIndex + 1);
            }
            if (!(success = objectOracle.setName(name))) {
                PlSqlSourceStorageObjectOracle existingObject = null;
                ModelObjectSet modelObjectSet = objectOracle.getObjectSet();
                if (ownerName == null) {
                    existingObject = (PlSqlSourceStorageObjectOracle)modelObjectSet.getByName(name);
                } else if (modelObjectSet instanceof FunctionSetOracle) {
                    existingObject = ((FunctionSetOracle)modelObjectSet).getByOwnerAndName(ownerName, name);
                } else if (modelObjectSet instanceof StoredProcedureSetOracle) {
                    existingObject = ((StoredProcedureSetOracle)modelObjectSet).getByOwnerAndName(ownerName, name);
                } else if (modelObjectSet instanceof PackageSetOracle) {
                    existingObject = ((PackageSetOracle)modelObjectSet).getByOwnerAndName(ownerName, name);
                }
                if (existingObject != null) {
                    if (existingObject instanceof PackageOracle) {
                        ((PackageOracle)objectOracle).setBodySource(((PackageOracle)existingObject).getBodySource());
                    }
                    existingObject.remove();
                    objectOracle.setName(name);
                }
            }
            objectOracle.setSource(this.extractSource(line));
        }
    }

    protected abstract PlSqlSourceStorageObjectOracle createElement(StorageDesignOracle var1);

    protected String extractOwnerAndName(String statement) {
        String typeName = this.getTypeName();
        String afterType = Token.getStringAfter(statement, typeName);
        return Token.getFirstName(afterType, '\"', '\"');
    }

    protected String extractSource(String line) {
        return line;
    }
}

