/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class DMSVNOperationAdd
extends AbstractSVNOperation {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger((String)DMSVNOperationAdd.class.getName());
    public static final String COMMAND_ID = DMSVNOperationAdd.class.getName();

    public DMSVNOperationAdd() {
        super(COMMAND_ID);
    }

    public DMSVNOperationAdd(String commandID) {
        super(commandID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor(parentUi, "Adding Resources");
        progress.setMillisToPopup(0);
        progress.setCloseOnFinish(true);
        progress.setCancellable(false);
        progress.start();
        try {
            this.invokeAdd(profile, commandState);
        }
        finally {
            progress.finish();
        }
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        this.invokeAdd(profile, commandState);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAdd(VCSProfile profile, CommandState commandState) throws Exception {
        TreeSet directories = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return URLFileSystem.getPlatformPathName((URL)((URL)o1)).compareTo(URLFileSystem.getPlatformPathName((URL)((URL)o2)));
            }
        });
        HashSet files = new HashSet();
        this.sortResources(profile, VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables()), directories, files);
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest("Adding directories:");
            this.dumpUrls(directories, sLogger, Level.FINEST);
            sLogger.finest("Adding files");
            this.dumpUrls(files, sLogger, Level.FINEST);
        }
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            Collection notifier = this.getProcessedUrlsNotifier(commandState);
            SVNOperationLogger.getInstance().beginOperation(svnClient, null);
            for (URL directory : directories) {
                svnClient.addDirectory(new File(URLFileSystem.getPlatformPathName((URL)directory)), false);
                notifier.add(directory);
            }
            for (URL file : files) {
                svnClient.addFile(new File(URLFileSystem.getPlatformPathName((URL)file)));
                notifier.add(file);
            }
            SVNOperationLogger.getInstance().successFinish(Resource.get((String)"OP_ADD"));
        }
        catch (SVNClientException svne) {
            this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)svne)));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private void sortResources(VCSProfile profile, URL[] resources, Set directories, Set files) throws Exception {
        StatusCache statusCache = profile.getPolicyStatusCache();
        VCSStatusFilter unaddedFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.UNADDED");
        URLFilter wcFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
        for (int i = 0; i < resources.length; ++i) {
            URL currentResource = resources[i];
            URL parent = URLFileSystem.getParent((URL)currentResource);
            while (wcFilter.accept(parent) && unaddedFilter.accept((VCSStatus)statusCache.get(parent))) {
                directories.add(parent);
                parent = URLFileSystem.getParent((URL)parent);
            }
            if (URLFileSystem.isDirectoryPath((URL)currentResource)) {
                this.sortChildrenRecursively(profile, currentResource, directories, files);
                continue;
            }
            files.add(currentResource);
        }
    }

    private void sortChildrenRecursively(VCSProfile profile, URL directory, Set directories, Set files) throws Exception {
        VCSStatusFilter unaddedFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.UNADDED");
        if (unaddedFilter.accept((VCSStatus)profile.getPolicyStatusCache().get(directory))) {
            directories.add(directory);
            URL[] children = URLFileSystem.list((URL)directory);
            if (children != null && children.length > 0) {
                for (int i = 0; i < children.length; ++i) {
                    if (URLFileSystem.isDirectoryPath((URL)children[i])) {
                        this.sortChildrenRecursively(profile, children[i], directories, files);
                        continue;
                    }
                    files.add(children[i]);
                }
            }
        }
    }

    private void dumpUrls(Collection urls, Logger logger, Level level) {
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            logger.log(level, URLFileSystem.getPlatformPathName((URL)((URL)it.next())));
        }
    }

    protected DialogHeader createOperationDialogHeader(Collection nodes, CommandState commandState) {
        return null;
    }
}

