/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.GeneralStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsGitDialog;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareDialog;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNAbstractCompareCommand;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.metadata.XMLFromMapToSteramTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.cmd.GITOperationResolveConflict;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitStatus;

public class DMGITOperationResolveConflict
extends GITOperationResolveConflict {
    protected int doitImpl() throws Exception {
        Context context = ChangeListWindow.handleContext((Context)this.getContext());
        Locatable[] locs = VCSContextUtils.getContextLocatables((Context)context);
        if (locs.length == 0) {
            return 1;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (Locatable loc : locs) {
            if (!(loc instanceof Node)) continue;
            Node node = (Node)loc;
            File f = new File(loc.getURL().getPath());
            files.add(f);
        }
        if (files.size() > 0) {
            List<GitStatus> conflicts = GitClientHelper.getConflictsForFiles(files.toArray(new File[0]));
            MergeConflictsGitDialog.getInstance().processConflicts(conflicts, true);
        }
        return 0;
    }

    public static boolean isBothModified(GitConflictDescriptor descr) {
        return GitConflictDescriptor.Type.BOTH_MODIFIED.equals((Object)descr.getType());
    }

    public static boolean isBothAdded(GitConflictDescriptor descr) {
        return GitConflictDescriptor.Type.BOTH_ADDED.equals((Object)descr.getType());
    }

    public static boolean isBothDeleted(GitConflictDescriptor descr) {
        return GitConflictDescriptor.Type.BOTH_DELETED.equals((Object)descr.getType());
    }

    public static boolean isDeletedByUs(GitConflictDescriptor descr) {
        return GitConflictDescriptor.Type.DELETED_BY_US.equals((Object)descr.getType());
    }

    public static boolean isDeletedByThem(GitConflictDescriptor descr) {
        return GitConflictDescriptor.Type.DELETED_BY_THEM.equals((Object)descr.getType());
    }

    private void resolveConflict(Locatable lnode) {
        URL url = lnode.getURL();
        String path = url.getPath();
        File file = new File(path);
        if (file.exists()) {
            GitStatus stat = GitClientHelper.getStatus(file);
            DMGITOperationResolveConflict.resolveConflict(stat, url);
        } else {
            GitClientHelper.resolveConflictWithOURS(url);
        }
    }

    public static void resolveConflict(GitStatus status) {
        if (status != null && status.isConflict()) {
            File file = status.getFile();
            try {
                URL url = file.toURI().toURL();
                DMGITOperationResolveConflict.resolveConflict(status, url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void resolveConflict(GitStatus status, URL furl) {
        if (status != null && status.isConflict()) {
            GitConflictDescriptor descr;
            File file = status.getFile();
            URL url = furl;
            if (url == null) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if ((descr = status.getConflictDescriptor()) != null && !DMGITOperationResolveConflict.isBothDeleted(descr)) {
                if (DMGITOperationResolveConflict.isBothModified(descr) || DMGITOperationResolveConflict.isBothAdded(descr)) {
                    DMGITOperationResolveConflict.resolveMergeConflict(url, true, true);
                } else {
                    try {
                        if (DMGITOperationResolveConflict.isDeletedByUs(descr)) {
                            GitClientHelper.resolveConflictWithOURS(url);
                            Design design = ApplicationView.getInstance().getDesignForURL(url);
                            GeneralStorableObjectStatus st = new GeneralStorableObjectStatus(design, file, "A");
                            VersioningTreeNode node = new VersioningTreeNode(st);
                            SVNAbstractCompareCommand.reloadIfSystemFile(node);
                            ArrayList<VersioningTreeNode> nodes = new ArrayList<VersioningTreeNode>();
                            nodes.add(node);
                            VersioningTreeNode.refresh(nodes, true);
                        } else {
                            GitClientHelper.resolveConflictWithOURS(url);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean resolveMergeConflict(final URL url, boolean objectCompare, final boolean refresh) {
        boolean res = false;
        Design design = ApplicationView.getInstance().getDesignForURL(url);
        Class cl = null;
        File file = new File(url.getPath());
        final String path = file.getPath();
        GeneralStorableObjectStatus st0 = null;
        boolean useObjectCompare = false;
        if (file != null) {
            st0 = new GeneralStorableObjectStatus(design, file, "M");
            cl = st0.getObjectClass();
        }
        if (cl == null) {
            try {
                String className = GitClientHelper.getClassFromXMLFile(file);
                cl = Class.forName(className);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        final GeneralStorableObjectStatus st = st0;
        if (cl != null && (StorableObject.class.isAssignableFrom(cl) || DomainFileWrapper.class.isAssignableFrom(cl))) {
            useObjectCompare = true;
        }
        boolean bl = useObjectCompare = useObjectCompare && objectCompare;
        if (file.exists()) {
            InputStream leftFile = null;
            InputStream rightFile = null;
            try {
                leftFile = GitClientHelper.openInputStreamForConflict(url, 3);
                rightFile = GitClientHelper.openInputStreamForConflict(url, 2);
            }
            catch (GITProcessException e) {
                e.printStackTrace();
            }
            if (!useObjectCompare) {
                CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setShowCharDifferences(true);
                VCSTextCompareDialog textCompareFrame = new VCSTextCompareDialog((Window)Ide.getMainWindow(), file, leftFile, "Theirs", rightFile, "Ours", true, false){

                    @Override
                    public void afterSave() {
                        super.afterSave();
                        byte[] bytes = GitClientHelper.readBytesFromFile(path);
                        GitClientHelper.resolveMergeConflict(url, bytes);
                        if (st != null) {
                            VersioningTreeNode node = new VersioningTreeNode(st);
                            SVNAbstractCompareCommand.reloadIfSystemFile(node);
                            if (refresh) {
                                ArrayList<VersioningTreeNode> nodes = new ArrayList<VersioningTreeNode>();
                                nodes.add(node);
                                VersioningTreeNode.refresh(nodes, false);
                            }
                        }
                    }
                };
                textCompareFrame.setVisible(true);
                res = textCompareFrame.isOk();
                try {
                    leftFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    rightFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else {
                XMLMetadataComparator comparator = new XMLMetadataComparator(design, null, leftFile, "Theirs", rightFile, "Ours", true);
                Map mergedMap = comparator.showModal();
                try {
                    leftFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    rightFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (mergedMap != null) {
                    boolean compr = false;
                    if (design != null) {
                        compr = design.isCompressedDesign();
                    }
                    GitClientHelper.resolveMergeConflict(url, mergedMap, compr);
                    XMLFromMapToSteramTransformer.transformMapToXMLFileStram(mergedMap, file.getAbsolutePath(), false, null, true);
                    res = true;
                    if (st != null) {
                        VersioningTreeNode node = new VersioningTreeNode(st);
                        SVNAbstractCompareCommand.reloadIfSystemFile(node);
                        if (refresh) {
                            ArrayList<VersioningTreeNode> nodes = new ArrayList<VersioningTreeNode>();
                            nodes.add(node);
                            VersioningTreeNode.refresh(nodes, false);
                        }
                    }
                }
            }
        }
        return res;
    }
}

