/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.oracleaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.oracleaw.OracleAWExporter;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.multidimensional.CubePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.multidimensional.SlicePropertiesDialogEx;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.db.DatabaseConnections;

public class AWExportOptions
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 250;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(330, 20);
    private Dimension filePrefDimension = new Dimension(250, 20);
    private JTextField tfSchema;
    private JTextField tfAWName;
    private JTextField tfXMLFile;
    private JComboBox cbMDM;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private JComboBox cbConn;
    private JComboBox cbExpMode;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private String schema = "";
    private Connection connection;
    private String aWName;
    private JCheckBox chPopulate;
    private String exportMode = OracleAWExporter.EXPORT_RECREATE_AW;
    private JTabbedPane tabbed;
    private DBMExtractionController controller;
    private static File lastFolder = null;
    private String fileName = "";
    private static final Logger LOGGER = new Logger(AWExportOptions.class);
    URLFileChooser.URLFileChooserPanel pan;
    MultidimensionalDesign currentMDM;
    JTable selectedTable;
    private List selectedObjects = new ArrayList();

    public AWExportOptions(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        this.result = false;
        this.design = appView.getCurrentDesign();
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tabbed = new JTabbedPane();
        JPanel optionsPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder(""));
        JLabel lbFormula = new JLabel(Messages.getString("AWExportOptions.DefaultSchema"));
        lbFormula.setPreferredSize(this.prefDimension);
        lbFormula.setToolTipText(Messages.getString("AWExportOptions.UsedForDimensionalIObjectsAndTables"));
        this.tfSchema = new JTextField("");
        this.tfSchema.setPreferredSize(this.prefDimension);
        this.tfSchema.setToolTipText(Messages.getString("AWExportOptions.UsedForDimensionalObjectsAndTables"));
        JPanel row = this.newRow(lbFormula, this.tfSchema);
        optionsPanel.add(row);
        MultidimensionalDesign mdm = this.design.getMultidimensionalDesign();
        JLabel lbMDM = new JLabel(Messages.getString("AWExportOptions.DimensionalModel"));
        lbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM = new JComboBox<Object>(this.design.getMultidimensionalDesigns().toArray());
        this.cbMDM.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM.setSelectedItem(mdm);
        row = this.newRow(lbMDM, this.cbMDM);
        optionsPanel.add(row);
        this.currentMDM = mdm;
        this.buildSelected();
        this.cbMDM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = AWExportOptions.this.cbMDM.getSelectedItem();
                if (obj != AWExportOptions.this.currentMDM) {
                    AWExportOptions.this.currentMDM = (MultidimensionalDesign)obj;
                    AWExportOptions.this.buildSelected();
                }
            }
        });
        JLabel lbRelD = new JLabel(Messages.getString("AWExportOptions.RelationalModel"));
        ArrayList rlist = new ArrayList();
        rlist.add(null);
        this.design.getRelationalDesigns().addAllElementsTo(rlist);
        lbRelD.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        if (rlist.size() == 2) {
            this.cbRelDes.setSelectedItem(rlist.get(1));
        }
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        row = this.newRow(lbRelD, this.cbRelDes);
        optionsPanel.add(row);
        JLabel lbStoreD = new JLabel(Messages.getString("AWExportOptions.OracleModel"));
        lbStoreD.setPreferredSize(this.prefDimension);
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        this.cbStorage.setSelectedItem(null);
        row = this.newRow(lbStoreD, this.cbStorage);
        optionsPanel.add(row);
        if (rlist.size() == 2) {
            Object ob = this.cbRelDes.getSelectedItem();
            if (ob != null && ob instanceof RelationalDesign) {
                RelationalDesign phd = (RelationalDesign)ob;
                ArrayList<StorageDesign> rlist2 = new ArrayList<StorageDesign>();
                rlist2.add(null);
                StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < stds.length; ++i) {
                    StorageDesign sd = stds[i];
                    if (!(sd instanceof StorageDesignOraclev10g)) continue;
                    rlist2.add(sd);
                }
                this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist2.toArray()));
                if (rlist2.size() == 2) {
                    this.cbStorage.setSelectedItem(rlist2.get(1));
                }
            } else if (ob == null) {
                this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
            }
        }
        JLabel lbAWName = new JLabel(Messages.getString("AWExportOptions.OracleAWName"));
        lbAWName.setPreferredSize(this.prefDimension);
        lbAWName.setToolTipText(Messages.getString("AWExportOptions.TheNameOfOracleAW"));
        this.tfAWName = new JTextField("");
        this.tfAWName.setPreferredSize(this.prefDimension);
        this.tfAWName.setToolTipText(Messages.getString("AWExportOptions.TheNameOfOracleAW"));
        row = this.newRow(lbAWName, this.tfAWName);
        optionsPanel.add(row);
        JLabel lbExpMode = new JLabel(Messages.getString("AWExportOptions.ExportMode"));
        lbExpMode.setPreferredSize(this.prefDimension);
        this.cbExpMode = new JComboBox<String>(OracleAWExporter.EXPORT_TYPES_11);
        this.cbExpMode.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbExpMode.setPreferredSize(this.prefDimension);
        this.cbExpMode.setSelectedItem(OracleAWExporter.EXPORT_RECREATE_AW);
        row = this.newRow(lbExpMode, this.cbExpMode);
        optionsPanel.add(row);
        JLabel lbPopulate = new JLabel(Messages.getString("AWExportOptions.PopulateCreatedCubes"));
        lbPopulate.setPreferredSize(this.prefDimension);
        this.chPopulate = new JCheckBox();
        this.chPopulate.setPreferredSize(this.prefDimension);
        this.chPopulate.setSelected(false);
        this.chPopulate.setEnabled(false);
        row = this.newRow(lbPopulate, this.chPopulate);
        optionsPanel.add(row);
        this.pan = URLFileChooser.createURLFileChooserPanel((int)1, (String)"", (boolean)true, (boolean)false);
        JLabel lbfFileName2 = new JLabel(Messages.getString("AWExportOptions.OutputXMLFile"));
        lbfFileName2.setPreferredSize(this.prefDimension);
        lbfFileName2.setToolTipText(Messages.getString("AWExportOptions.OutputXMLFileForMetadataDefinitions"));
        this.pan.setPreferredSize(this.prefDimension);
        this.pan.setEnabled(true);
        this.pan.setCheckIfFileExists(false);
        this.pan.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean retVal = false;
                if (f != null) {
                    int dot;
                    if (f.isDirectory()) {
                        return false;
                    }
                    String name = f.getName();
                    String ext = null;
                    if (name != null && name.trim().length() > 0 && (dot = name.lastIndexOf(46)) >= 0) {
                        ext = name.substring(dot + 1);
                    }
                    retVal = "xml".equalsIgnoreCase(ext);
                }
                return retVal;
            }

            @Override
            public String getDescription() {
                String retVal = "XML Files *.xml";
                return retVal;
            }
        });
        this.pan.setPathContext("dataModeler_AWSaveToXML");
        this.pan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                if (URLFileChooser.URL_SELECTED == e.getActionCommand() && (file = AWExportOptions.this.pan.getSelectedFile()) != null && !file.isDirectory()) {
                    AWExportOptions.this.fileName = file.getPath();
                }
            }
        });
        row = this.newRow(lbfFileName2, (Component)this.pan);
        optionsPanel.add(row);
        JLabel lbConn = new JLabel(Messages.getString("AWExportOptions.JDBCConnection"));
        lbConn.setPreferredSize(this.prefDimension);
        this.cbConn = new JComboBox();
        this.cbConn.setRenderer(new ComboBoxRenderer());
        this.updateConnections();
        this.cbConn.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbConn.setPreferredSize(this.prefDimension);
        this.cbConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AWExportOptions.this.setSelectedColor();
            }
        });
        row = this.newRow(lbConn, this.cbConn);
        optionsPanel.add(row);
        JLabel lbNewConn = new JLabel(Messages.getString("AWExportOptions.NewJDBCConnection"));
        lbNewConn.setPreferredSize(this.prefDimension);
        JButton crebutton = new JButton(Messages.getString("AWExportOptions.Create"));
        crebutton.setPreferredSize(this.prefDimension);
        crebutton.setFont(this.cbRelDes.getFont().deriveFont(0));
        row = this.newRow(lbNewConn, crebutton);
        optionsPanel.add(row);
        crebutton.addActionListener(new AddAction());
        JLabel lbTestConn = new JLabel(Messages.getString("AWExportOptions.TestSelectedConnection"));
        lbTestConn.setPreferredSize(this.prefDimension);
        JButton testbutton = new JButton(Messages.getString("AWExportOptions.Test"));
        testbutton.setPreferredSize(this.prefDimension);
        testbutton.setFont(this.cbRelDes.getFont().deriveFont(0));
        row = this.newRow(lbTestConn, testbutton);
        optionsPanel.add(row);
        testbutton.addActionListener(new TestAction());
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ob = AWExportOptions.this.cbRelDes.getSelectedItem();
                if (ob != null && ob instanceof RelationalDesign) {
                    RelationalDesign phd = (RelationalDesign)ob;
                    ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                    rlist.add(null);
                    StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < stds.length; ++i) {
                        StorageDesign sd = stds[i];
                        if (!(sd instanceof StorageDesignOraclev10g)) continue;
                        rlist.add(sd);
                    }
                    AWExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                } else if (ob == null) {
                    AWExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        JPanel bottom = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(Messages.getString("AWExportOptions.OK"));
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AWExportOptions.this.getSelectedConnectionProperties();
                AWExportOptions.this.result = AWExportOptions.this.checkSettings();
                if (AWExportOptions.this.result) {
                    AWExportOptions.this.close();
                }
            }
        });
        bottom.add(okButton);
        JButton cancelButton = new JButton(Messages.getString("AWExportOptions.Cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AWExportOptions.this.result = false;
                AWExportOptions.this.close();
            }
        });
        bottom.add(cancelButton);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bottom.add(bnHelp);
        okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.tabbed.add(Messages.getString("AWExportOptions.General"), optionsPanel);
        this.initSelectedObjectsTab();
        jpanel.add((Component)this.tabbed, "Center");
        jpanel.add((Component)bottom, "South");
        this.add(jpanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    protected void setSelectedColor() {
        block7: {
            try {
                Object selected = this.cbConn.getSelectedItem();
                if (selected == null) break block7;
                Properties cd = (Properties)selected;
                String sColor = cd.getProperty("Connection-Color-For-Editors");
                if (sColor != null) {
                    Color color = null;
                    try {
                        color = new Color(Integer.parseInt(sColor));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (color != null) {
                        this.cbConn.setForeground(color);
                    } else {
                        this.cbConn.setForeground(UIManager.getColor("ComboBox.foreground"));
                    }
                    break block7;
                }
                this.cbConn.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("AWExportOptions.ExportToOracleAWOptions"));
            this.dialog.setModal(true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_TO_ORACLE_AW_DIALOG";
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void buildSelected() {
        this.selectedObjects.clear();
        MultidimensionalDesign obj = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        if (obj != null) {
            Iterator it = obj.getCubeSet().iterator();
            while (it.hasNext()) {
                Cube cube = (Cube)it.next();
                SelObject so = new SelObject();
                so.selected = true;
                so.object = cube;
                this.selectedObjects.add(so);
            }
        }
        if (this.selectedTable != null) {
            this.selectedTable.updateUI();
        }
    }

    private void initSelectedObjectsTab() {
        this.selectedTable = new JTable(new SelAttributesModel());
        this.selectedTable.setSelectionMode(0);
        this.selectedTable.setDefaultRenderer(Object.class, new SelAttributesRenderer());
        this.selectedTable.getTableHeader().setReorderingAllowed(false);
        this.selectedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = AWExportOptions.this.selectedTable.getSelectedRow()) != -1 && AWExportOptions.this.selectedObjects.size() > 0 && row < AWExportOptions.this.selectedObjects.size()) {
                    SelObject so = (SelObject)AWExportOptions.this.selectedObjects.get(row);
                    if (so.object instanceof Cube) {
                        CubePropertiesDialogEx cpd = new CubePropertiesDialogEx(AWExportOptions.this.getApplicationView(), so.object);
                        cpd.initProperties(so.object);
                        cpd.setModal(true);
                        cpd.setVisible(true);
                    } else if (so.object instanceof Slice) {
                        SlicePropertiesDialogEx spd = new SlicePropertiesDialogEx(AWExportOptions.this.getApplicationView(), so.object);
                        spd.initProperties(so.object);
                        spd.setModal(true);
                        spd.setVisible(true);
                    }
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.selectedTable);
        scrollpane.setPreferredSize(new Dimension(325, 410));
        JPanel pPanel = new JPanel();
        pPanel.add(scrollpane);
        this.selectedTable.setAutoResizeMode(0);
        TableColumn column = null;
        column = this.selectedTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(60);
        column = this.selectedTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(262);
        this.tabbed.addTab(Messages.getString("AWExportOptions.CubesAndSlices"), pPanel);
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                LOGGER.error("Unable to close the connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties cd = this.getSelectedConnectionProperties();
                if (cd == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(cd);
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(e.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private boolean checkSettings() {
        this.schema = this.tfSchema.getText();
        this.exportMode = (String)this.cbExpMode.getSelectedItem();
        this.aWName = this.tfAWName.getText();
        if ("".equalsIgnoreCase(this.aWName)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SetTheNameOfAnalyticalWorkspace"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        if (this.cbConn.getSelectedItem() == null && !OracleAWExporter.EXPORT_METADATA_TO_FILE.equals(this.exportMode)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SelectJDBCConnection"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        if (!this.initConnection()) {
            return false;
        }
        this.physicalDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
        if (this.physicalDesign == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SelectRelationalModel"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        this.storageDesign = (StorageDesign)this.cbStorage.getSelectedItem();
        this.multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        return true;
    }

    private JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getAWName() {
        return this.aWName;
    }

    public DBMExtractionController getController() {
        if (this.controller == null) {
            this.controller = new DBMExtractionController(this.getApplicationView());
        }
        return this.controller;
    }

    public Properties getSelectedConnectionProperties() {
        Properties cd = null;
        try {
            cd = (Properties)this.cbConn.getSelectedItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    private void updateConnections() {
        ArrayList<Properties> clist = new ArrayList<Properties>();
        List<Properties> allConnections = ConnectionInfo.getAllConnections(DatabaseConnections.getInstance(), true);
        for (Properties cd : allConnections) {
            if (ConnectionInfo.getConnectionType(cd) != 1) continue;
            clist.add(cd);
        }
        this.cbConn.setModel(new DefaultComboBoxModel<Object>(clist.toArray()));
        this.cbConn.setSelectedItem(null);
    }

    private String getOutputFileName() {
        try {
            File file;
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("AWExportOptions.XMLFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            fileChooser.setPathContext("dataModeler_AWSaveToXML");
            fileChooser.setPathContext("dataModeler_Exports");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            Object filename = this.tfXMLFile.getText();
            if (!"".equals(((String)filename).trim()) && !((String)filename).toLowerCase().endsWith(".xml") && ((String)filename).indexOf(46) < 0) {
                filename = (String)filename + ".xml";
            }
            fileChooser.setFileNameURL((String)filename);
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SaveToXMLFile"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                return file.toString();
            }
            return this.tfXMLFile.getText();
        }
        catch (Exception e) {
            LOGGER.error("Error selecting output XML file!", e);
            return "";
        }
    }

    public List getSelectedObjects() {
        return this.selectedObjects;
    }

    public boolean isPopulateCubes() {
        return this.chPopulate.isSelected();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getExportMode() {
        return this.exportMode;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Properties cd = (Properties)value;
            if (cd != null) {
                this.setText(ConnectionInfo.getConnectionName(cd));
                if (!isSelected) {
                    String sColor = cd.getProperty("Connection-Color-For-Editors");
                    if (sColor != null) {
                        Color color = null;
                        try {
                            color = new Color(Integer.parseInt(sColor));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (color != null) {
                            this.setForeground(color);
                        } else {
                            this.setForeground(UIManager.getColor("Label.foreground"));
                        }
                    } else {
                        this.setForeground(UIManager.getColor("Label.foreground"));
                    }
                }
            }
            return this;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                AWExportOptions.this.updateConnections();
            }
            catch (Exception e2) {
                LOGGER.error(e2);
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.testConnection(AWExportOptions.this.getSelectedConnectionProperties());
        }
    }

    class SelObject {
        boolean selected = false;
        DesignObject object;

        SelObject() {
        }

        String getType() {
            if (this.object instanceof Cube) {
                return "Cube";
            }
            if (this.object instanceof Slice) {
                return "Slice";
            }
            return " ";
        }
    }

    private class SelAttributesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("AWExportOptions.Selected"), Messages.getString("AWExportOptions.CubeSlice")};

        private SelAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return AWExportOptions.this.selectedObjects.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex <= 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                SelObject so = (SelObject)AWExportOptions.this.selectedObjects.get(row);
                if (value instanceof Boolean) {
                    so.selected = (Boolean)value;
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SelObject so = (SelObject)AWExportOptions.this.selectedObjects.get(row);
            if (col == 1) {
                if (so.object instanceof Slice) {
                    return "     " + so.object.getName();
                }
                return so.object.getName();
            }
            if (col == 0 && so.object instanceof Level) {
                return "level";
            }
            if (col == 0) {
                return so.selected;
            }
            return new Integer(row * col);
        }
    }

    public class SelAttributesRenderer
    extends DefaultTableCellRenderer {
        SelAttributesCBRenderer cbRenderer;

        public SelAttributesRenderer() {
            this.cbRenderer = new SelAttributesCBRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fc;
            Color bc;
            SelObject so = (SelObject)AWExportOptions.this.selectedObjects.get(row);
            Component comp = !(so.object instanceof Level) && column == 0 ? this.cbRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (so.object instanceof Slice) {
                bc = Color.LIGHT_GRAY;
                fc = Color.WHITE;
            } else {
                bc = Color.WHITE;
                fc = Color.BLACK;
            }
            comp.setBackground(bc);
            comp.setForeground(fc);
            return comp;
        }
    }

    public class SelAttributesCBRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SelObject so = (SelObject)AWExportOptions.this.selectedObjects.get(row);
            this.setSelected(so.selected);
            return this;
        }
    }
}

