/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.FunctionUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFunctionUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FunctionUDB func = (FunctionUDB)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, func);
        this.appendCreate(buffer, func);
        this.appendBody(buffer, func, prettyPrint);
        SSBFunctionUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBFunctionUDBv71.appendLineFinisherUDB(buffer, prettyPrint);
        DDLFileMaker.incrementCreateFunction();
        if (func.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, func, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, FunctionUDB func, boolean prettyPrint) {
        SSBFunctionUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBFunctionUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
        SSBFunctionUDBv71.appendStringWithSpace(buffer, "FUNCTION");
        SSBFunctionUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(func.getLongNameDDL()));
        SSBFunctionUDBv71.appendStringWithSpace(buffer, "IS");
        SSBFunctionUDBv71.appendString(buffer, '\'');
        SSBFunctionUDBv71.appendString(buffer, func.getCommentInRDBMS());
        SSBFunctionUDBv71.appendStringWithSpace(buffer, '\'');
        SSBFunctionUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBFunctionUDBv71.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreate(StringBuffer buffer, FunctionUDB func) {
        this.appendCreate(buffer);
        SSBFunctionUDBv71.appendStringWithSpace(buffer, "FUNCTION");
        if (func.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBFunctionUDBv71.appendString(buffer, this.storageDesign.getFormatedName(func.getSchema().getName()));
            SSBFunctionUDBv71.appendString(buffer, ".");
        }
        SSBFunctionUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(func.getName()));
    }

    private void appendBody(StringBuffer buffer, FunctionUDB func, boolean prettyPrint) {
        SSBFunctionUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (!func.getBody().trim().equalsIgnoreCase("")) {
            SSBFunctionUDBv71.appendStringWithSpace(buffer, func.getBody());
        } else {
            SSBFunctionUDBv71.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FunctionUDB && ((FunctionUDB)object).isMarkedGenerate();
    }
}

