/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexOnViewSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexOnViewSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        IndexOnViewSqlServerv2k index = (IndexOnViewSqlServerv2k)object;
        this.storageDesign = index.getStorageDesign();
        this.appendComment(buffer, index);
        TableView tv = (TableView)index.getView().getObject();
        if (tv.getColumns().length > 0) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "CREATE");
            this.appendUnique(buffer, index);
            this.appendClustered(buffer, index);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "INDEX");
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
            this.appendView(buffer, index, prettyPrint);
            this.appendOptions(buffer, index, prettyPrint);
            this.appendFilegroup(buffer, index, prettyPrint);
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateIndexOnView();
            if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexOnViewComment(buffer, index, prettyPrint);
            }
            this.appendExtProperties(buffer, index, prettyPrint);
        } else {
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Index ").append(index.getName()).append(" on View ").append(index.getView().getName()).append(" not created in ddl");
            DDLFileMaker.incrementErrors();
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendIndexOnViewComment(StringBuffer buffer, IndexOnViewSqlServerv2k index, boolean prettyPrint) {
        String comment = index.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, comment);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (index != null && index.getView().getUser() != null) {
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, "USER");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(index.getView().getUser().getName()));
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, "VIEW");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, "INDEX");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(index.getName()));
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k.appendString(buffer, "GO");
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendUnique(StringBuffer buffer, IndexOnViewSqlServerv2k index) {
        if (index.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer buffer, IndexOnViewSqlServerv2k index) {
        if (index.getClustered().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "CLUSTERED");
        } else {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "NONCLUSTERED");
        }
    }

    private void appendView(StringBuffer buffer, IndexOnViewSqlServerv2k index, boolean prettyPrint) {
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "ON");
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getView().getName()));
        SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '(');
        SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        TableView tv = (TableView)index.getView().getObject();
        Iterator it = index.getColSet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String sort;
            String cname = (String)it.next();
            ContainedObject obj = tv.getElementByName(cname);
            if (obj == null) continue;
            if (!first) {
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            }
            first = false;
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(((ModelObject)obj).getName()));
            if (!it.hasNext() || "ASC".equalsIgnoreCase((sort = (String)it.next()).trim())) continue;
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, sort);
        }
        SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, ')');
    }

    private void appendOptions(StringBuffer buffer, IndexOnViewSqlServerv2k index, boolean prettyPrint) {
        if ((index.getFillFactor() > 0 || index.getIgnoreDupKey().equalsIgnoreCase("YES") || index.getRecomputeStatistics().equalsIgnoreCase("NO") || index.getSortInTempDB().equalsIgnoreCase("YES")) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "WITH");
            boolean writeComma = false;
            if (index.getFillFactor() > 0) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "PAD_INDEX");
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, index.getFillFactor());
                writeComma = true;
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "PAD_INDEX");
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "0");
                writeComma = true;
            }
            if (index.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
                writeComma = true;
            }
            if (index.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
                writeComma = true;
            }
            if (index.getSortInTempDB().equalsIgnoreCase("YES")) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "SORT_IN_TEMPDB");
            }
        }
    }

    private void appendFilegroup(StringBuffer buffer, IndexOnViewSqlServerv2k index, boolean prettyPrint) {
        if (index.getFilegroup() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(buffer, index.getFilegroup().getName());
            SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "\"default\"");
        }
    }

    private void appendExtProperties(StringBuffer buffer, IndexOnViewSqlServerv2k index, boolean prettyPrint) {
        if (!index.getProps().trim().equalsIgnoreCase("") && index.getView().getUser() != null) {
            StringTokenizer st = new StringTokenizer(index.getProps().trim(), ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                String value = st.nextToken();
                SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, name.trim());
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, value.trim());
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                String user = "";
                user = this.storageDesign.getFormatedName(index.getView().getUser().getName());
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, "USER");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, user);
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, "'Schema-bound View'");
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getView().getName()));
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(buffer, "INDEX");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
                SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexOnViewSqlServerv2k.appendString(buffer, "GO");
                SSBIndexOnViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof IndexOnViewSqlServerv2k && ((IndexOnViewSqlServerv2k)object).getView().getDataBase() != null && !((IndexOnViewSqlServerv2k)object).getView().getDataBase().isNullInstance() && ((IndexOnViewSqlServerv2k)object).isMarkedGenerate();
    }
}

