/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAliasDB2v80
extends SQLStatementBuilder {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        AliasDB2 alias = (AliasDB2)object;
        if (alias != null) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
            this.appendComment(buffer, alias);
            this.appendCreate(buffer);
            SSBAliasDB2v80.appendStringWithSpace(buffer, "ALIAS");
            SSBAliasDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getLongNameDDL()));
            if (alias.getTable() != null) {
                SSBAliasDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBAliasDB2v80.appendStringWithSpace(buffer, "FOR");
                SSBAliasDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getTable().getLongNameDDL()));
            } else if (alias.getView() != null) {
                SSBAliasDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBAliasDB2v80.appendStringWithSpace(buffer, "FOR");
                SSBAliasDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getView().getLongNameDDL()));
            } else if (alias.getAnotherAlias() != null) {
                SSBAliasDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBAliasDB2v80.appendStringWithSpace(buffer, "FOR");
                SSBAliasDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getAnotherAlias().getLongNameDDL()));
            }
            SSBAliasDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBAliasDB2v80.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateAlias();
            if (alias.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOn(buffer, alias, prettyPrint);
            }
        }
    }

    private void appendCommentOn(StringBuffer buffer, AliasDB2 alias, boolean prettyPrint) {
        SSBAliasDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBAliasDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
        SSBAliasDB2v80.appendStringWithSpace(buffer, "ALIAS");
        SSBAliasDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getLongNameDDL()));
        SSBAliasDB2v80.appendStringWithSpace(buffer, "IS");
        SSBAliasDB2v80.appendString(buffer, '\'');
        SSBAliasDB2v80.appendString(buffer, alias.getCommentInRDBMS());
        SSBAliasDB2v80.appendStringWithSpace(buffer, '\'');
        SSBAliasDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBAliasDB2v80.appendLineFinisher(buffer, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AliasDB2 && ((AliasDB2)object).isMarkedGenerate();
    }
}

