/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.plsql.parser.PlSqlParserFactoryImpl;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sqlite.SQLiteBuilderHelper;
import oracle.javatools.db.sqlite.SQLiteDDLGenerator;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteTriggerValidator;
import oracle.javatools.db.validators.DBObjectValidator;

public class SQLiteDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final int MAX_NAME_LENGTH = 1000;
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "AS", "AUTOINCREMENT", "BETWEEN", "CASE", "CHECK", "COLLATE", "COMMIT", "CONSTRAINT", "CREATE", "CROSS", "DEFAULT", "DEFERRABLE", "DELETE", "DISTINCT", "DROP", "ELSE", "ESCAPE", "EXCEPT", "EXISTS", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEFT", "LIMIT", "NATURAL", "NOT", "NOTNULL", "NULL", "ON", "OR", "ORDER", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "ROLLBACK", "SELECT", "SET", "TABLE", "THEN", "TO", "TRANSACTION", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHERE", "_ROWID_", "MAIN", "OID", "ROWID", "SQLITE_MASTER", "SQLITE_SEQUENCE", "SQLITE_TEMP_MASTER", "TEMP"));
    private static final Set NON_RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("ABORT", "AFTER", "ANALYZE", "ASC", "ATTACH", "BEFORE", "BEGIN", "BY", "CASCADE", "CAST", "COLUMN", "CONFLICT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFERRED", "DESC", "DETACH", "EACH", "END", "EXCLUSIVE", "EXPLAIN", "FAIL", "FOR", "GLOB", "IF", "IGNORE", "IMMEDIATE", "INDEXED", "INITIALLY", "INSTEAD", "KEY", "LIKE", "MATCH", "OF", "OFFSET", "PLAN", "PRAGMA", "QUERY", "RAISE", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "ROW", "SAVEPOINT", "TEMP", "TEMPORARY", "TRIGGER", "VACUUM", "VIEW", "VIRTUAL"));
    private static final Set KEYWORDS = new HashSet();

    public SQLiteDatabaseDescriptor(Class<? extends SQLiteDatabase> clazz) {
        super(clazz);
    }

    @Override
    public String getDatabaseType() {
        return "SQLite";
    }

    @Override
    public int getDatabaseVersion() {
        return 30620;
    }

    @Override
    public int getCasePolicy() {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 1000;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new SQLiteDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        SQLiteDatabaseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)1000, (String)"_$@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        char c = string2.charAt(0);
        if (c != '\"' && !Character.isAlphabetic(string2.codePointAt(0)) && c != '_' && c != '@') {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("TRIGGER", (DBObjectValidator)new SQLiteTriggerValidator(dBObjectProvider));
        return map;
    }

    protected void initialiseDefaultSourceOptions(DefaultSourceOptions defaultSourceOptions) {
        defaultSourceOptions.setUseCreateOrReplace(false);
        defaultSourceOptions.setIncludeTerminators(true);
        defaultSourceOptions.setEnableTriggers(false);
    }

    @Override
    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider dBObjectProvider) {
        List<PropertyInitializer> list = super.getPropertyInitializers(dBObjectProvider);
        list.add(new SQLiteDefaultsInitializer(dBObjectProvider));
        return list;
    }

    public DBObjectLister getTriggerLister(DBObjectProvider dBObjectProvider) {
        return new SQLiteTriggerLister((SQLiteDatabase)dBObjectProvider);
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        if (this.getDatabaseVersion() == 30620) {
            dataTypeCache.registerDataType("BFILE");
            dataTypeCache.registerDataType("BINARY_DOUBLE");
            dataTypeCache.registerDataType("BINARY_FLOAT");
            dataTypeCache.registerDataType("BLOB");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("CLOB");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DOUBLE PRECISION");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("INTEGER");
            dataTypeCache.registerDataType("LONG RAW");
            dataTypeCache.registerDataType("LONG");
            dataTypeCache.registerDataType("NCHAR");
            dataTypeCache.registerDataType("NCLOB");
            dataTypeCache.registerDataType("NVARCHAR2");
            dataTypeCache.registerDataType((DataType)new OracleNumberDataType(0));
            dataTypeCache.registerDataType("RAW");
            dataTypeCache.registerDataType("REAL");
            dataTypeCache.registerDataType("ROWID");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("UROWID");
            dataTypeCache.registerDataType("VARCHAR2");
            dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
            dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
            dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
            dataTypeCache.registerDataTypeSynonym("LONG VARCHAR", "LONG");
            dataTypeCache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
            dataTypeCache.registerDataTypeSynonym("DEC", "NUMBER");
            dataTypeCache.registerDataTypeSynonym("DECIMAL", "NUMBER");
            dataTypeCache.registerDataTypeSynonym("NUMERIC", "NUMBER");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR", "NCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR2");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER", "NCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR2");
            dataTypeCache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR2");
        }
    }

    public PlSqlParserFactory getPlSqlParserFactory(DBObjectProvider dBObjectProvider) {
        return new PlSqlParserFactoryImpl(dBObjectProvider);
    }

    static {
        KEYWORDS.addAll(NON_RESERVED_KEYWORDS);
        KEYWORDS.addAll(RESERVED_WORDS);
    }

    private static class SQLiteDefaultsInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"statementLevel"};
        private static String[] s_empty = new String[0];

        SQLiteDefaultsInitializer(DBObjectProvider dBObjectProvider) {
            super(dBObjectProvider);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clazz) {
            if (Trigger.class.isAssignableFrom(clazz)) {
                return s_names;
            }
            return s_empty;
        }

        public Object getPropertyInitialValue(DBObject dBObject, String string) throws PropertyInitializer.InitializationVeto {
            Boolean bl = null;
            if (dBObject instanceof Trigger && "statementLevel".equals(string)) {
                bl = false;
            }
            return bl;
        }
    }

    private static class SQLiteTriggerLister
    extends DBObjectLister {
        public SQLiteTriggerLister(SQLiteDatabase sQLiteDatabase) {
            super((DBObjectProvider)sQLiteDatabase);
        }

        public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria dBObjectCriteria) throws DBException {
            ArrayList<DBObjectLister.ObjectInfo> arrayList = new ArrayList<DBObjectLister.ObjectInfo>();
            SQLiteBuilderHelper sQLiteBuilderHelper = new SQLiteBuilderHelper((Database)this.getProvider());
            Schema schema = this.getProvider().getSchema(dBObjectCriteria.getSchemaName());
            for (String string : sQLiteBuilderHelper.getTriggersForTable(dBObjectCriteria.getNameLike())) {
                arrayList.add(new DBObjectLister.ObjectInfo("TRIGGER", schema, string));
            }
            return arrayList;
        }
    }
}

