/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SXMLReader
extends SXMLFragmentGenerator {
    public static final String MIGRATING_BODY_SOURCE_PROP = "SXMLReader.TypeBody.Source";
    private Map<Class, Map<String, PropertyInfo>> m_infos = new HashMap<Class, Map<String, PropertyInfo>>();
    private SystemObject m_parentObject;
    private SystemObject m_currentObject;
    private DBObjectProvider m_pro;

    public SXMLReader() {
        this(null, new SXMLReaderMappings());
    }

    public SXMLReader(DBObjectProvider dBObjectProvider) {
        this(dBObjectProvider, new SXMLReaderMappings());
    }

    SXMLReader(SXMLMappings sXMLMappings) {
        this(null, sXMLMappings);
    }

    SXMLReader(DBObjectProvider dBObjectProvider, SXMLMappings sXMLMappings) {
        super.setMappings(sXMLMappings);
        this.m_pro = dBObjectProvider;
    }

    public void addMapping(String string, String string2, String string3, SXMLValueConverter sXMLValueConverter) {
        this.getMappings().cache(string, string2, string3, sXMLValueConverter);
    }

    public void removeMapping(String string, String string2, String string3) {
        this.getMappings().uncache(string, string2, string3);
    }

    public String getElementPath(String string, String string2) {
        String string3 = null;
        Iterator<SXMLMappings.Mapping> iterator = this.getMappings().getMappings(string);
        if (iterator != null) {
            while (iterator.hasNext()) {
                SXMLMappings.Mapping mapping = iterator.next();
                if (!ModelUtil.areEqual((Object)string2, (Object)mapping.getPropertyPath())) continue;
                string3 = mapping.getElementPath();
                break;
            }
        }
        return string3;
    }

    public void addGenerator(String string, Class<? extends SXMLFragmentGenerator> clazz) {
        this.getMappings().registerGen(string, clazz);
    }

    public SystemObject getObject(XMLDocument xMLDocument) {
        try {
            Element element = xMLDocument.getDocumentElement();
            return this.getObject(element);
        }
        catch (SXMLReaderException sXMLReaderException) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, sXMLReaderException.getMessage(), sXMLReaderException);
            return null;
        }
    }

    private SystemObject getObject(Node node) throws SXMLReaderException {
        SystemObject systemObject = null;
        String string = node.getLocalName();
        if ("COMPOSITE".equals(string)) {
            systemObject = this.getCompositeObject(node);
        } else if ("TYPE_SPEC".equals(string)) {
            systemObject = this.getComplexType(node, false);
        } else {
            Index index;
            if (this.isRootNameForType(string, "TABLE")) {
                systemObject = new Table();
            } else if (this.isRootNameForType(string, "VIEW")) {
                systemObject = new View();
            } else if (this.isRootNameForType(string, "MATERIALIZED VIEW")) {
                index = new MaterializedView();
                systemObject = index;
                index.setRefreshMethod(MaterializedView.RefreshMethod.FORCE);
                index.setRefreshMode(MaterializedView.RefreshMode.DEMAND);
                index.setCache(Boolean.valueOf(false));
                index.setDefaultIndex(Boolean.valueOf(true));
                index.setOnPrebuilt(MaterializedView.PrebuiltType.NONE);
                index.setQueryRewrite(Boolean.valueOf(false));
            } else if (this.isRootNameForType(string, "MATERIALIZED VIEW LOG")) {
                systemObject = new MaterializedViewLog();
                ((MaterializedViewLog)systemObject).setCache(Boolean.FALSE);
                ((MaterializedViewLog)systemObject).setNewValues(Boolean.FALSE);
                ((MaterializedViewLog)systemObject).setObjectIdLogged(Boolean.FALSE);
                ((MaterializedViewLog)systemObject).setPrimaryKeyLogged(Boolean.FALSE);
                ((MaterializedViewLog)systemObject).setRowidLogged(Boolean.FALSE);
                ((MaterializedViewLog)systemObject).setSequenceLogged(Boolean.FALSE);
            } else if (this.isRootNameForType(string, "SEQUENCE")) {
                systemObject = new Sequence();
                ((Sequence)systemObject).setOrderFlag(Boolean.FALSE);
                ((Sequence)systemObject).setCycleFlag(Boolean.FALSE);
            } else if (this.isRootNameForType(string, "SYNONYM")) {
                systemObject = new Synonym();
            } else if (this.isRootNameForType(string, "TRIGGER")) {
                systemObject = new Trigger();
            } else if (this.isRootNameForType(string, "INDEX")) {
                systemObject = new Index();
            } else if (this.isRootNameForType(string, "TYPE BODY")) {
                systemObject = new TypeBody();
            } else if (this.isRootNameForType(string, "TABLESPACE")) {
                systemObject = new Tablespace();
                ((Tablespace)systemObject).setFileType(Tablespace.FileType.SMALLFILE);
            }
            this.m_currentObject = systemObject;
            if (systemObject != null) {
                try {
                    this.fillInObject(systemObject, node, null);
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else {
                throw new UnsupportedTypeForSXMLException(string);
            }
            if (systemObject instanceof MaterializedViewLog) {
                index = (MaterializedViewLog)systemObject;
                NameBasedID nameBasedID = (NameBasedID)index.getMasterTableID();
                nameBasedID.setSchema(index.getSchema());
                if (this.getProvider() != null) {
                    try {
                        String[] stringArray = this.getProvider().listObjects("MATERIALIZED VIEW", index.getSchema(), index.getName());
                        if (stringArray != null && stringArray.length > 0) {
                            Column column = new NameBasedID("MATERIALIZED VIEW", index.getSchema().getName(), index.getName());
                            index.setMasterTableID((DBObjectID)column);
                            for (DBObjectID dBObjectID : index.getColumnIDs()) {
                                ((NameBasedID)dBObjectID).setParent((DBObjectID)column);
                            }
                        }
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
            }
            if (systemObject instanceof Index) {
                index = (Index)systemObject;
                if (index.getIndexType() == null) {
                    index.setIndexType(Index.IndexType.NORMAL);
                }
                if ((index.getIndexType() == Index.IndexType.NORMAL || index.getIndexType() == Index.IndexType.UNIQUE) && index.getReverse() == null) {
                    index.setReverse(Boolean.FALSE);
                }
            }
            if (systemObject instanceof Table) {
                this.tidyPartitions((Table)systemObject);
            }
            if ("TABLE".equals(systemObject.getType()) && this.m_pro != null) {
                try {
                    DBUtil.ensureDerivedPropertiesBuilt((DBObject)systemObject, (DBObjectProvider)this.m_pro);
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).info("Failed to build derived prop:" + dBException.getMessage());
                }
                for (Column column : ((Table)systemObject).getColumns()) {
                    DBObjectID[] dBObjectIDArray = column.getIdentityProperties();
                    if (dBObjectIDArray == null) continue;
                    if (dBObjectIDArray.getOrderFlag() == null) {
                        dBObjectIDArray.setOrderFlag(Boolean.valueOf(false));
                    }
                    if (dBObjectIDArray.getCycleFlag() != null) continue;
                    dBObjectIDArray.setCycleFlag(Boolean.valueOf(false));
                }
            }
            this.ensureKidsIDsParentID((DBObject)systemObject);
        }
        return systemObject;
    }

    private SystemObject getCompositeObject(Node node) throws SXMLReaderException {
        SchemaObject schemaObject = null;
        if (this.nodeExists(node, "BASE_OBJECT/TYPE_SPEC")) {
            schemaObject = this.getComplexType(node, true);
        } else {
            Node node2 = this.findNode(node, "BASE_OBJECT/TABLE");
            if (node2 == null) {
                node2 = this.findNode(node, "BASE_OBJECT/MATERIALIZED_VIEW");
            }
            if (node2 == null) {
                throw new SXMLReaderException("Base object node was not found");
            }
            schemaObject = this.getObject(node2);
            this.m_parentObject = schemaObject;
            Node node3 = this.findNode(node, "INDEX_LIST");
            ArrayList<Index> arrayList = new ArrayList<Index>();
            SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node3);
            while (childXMLElementIterator2.hasNext()) {
                Node node4 = (Node)childXMLElementIterator2.next();
                SystemObject systemObject = this.getObject(node4);
                if (!(systemObject instanceof Index)) {
                    throw new SXMLReaderException("Index expected but " + (String)(systemObject == null ? "none found" : systemObject.getType() + " found"));
                }
                arrayList.add((Index)systemObject);
            }
            ((Table)schemaObject).setIndexes(arrayList.toArray(new Index[arrayList.size()]));
        }
        return schemaObject;
    }

    private SchemaObject getComplexType(Node node, boolean bl) {
        Type type = new Type();
        String string = null;
        if (bl) {
            type.setName(this.nodeText(node, "BASE_OBJECT/TYPE_SPEC/NAME"));
            string = this.nodeText(node, "BASE_OBJECT/TYPE_SPEC/SCHEMA");
            type.setSource(this.nodeText(node, "BASE_OBJECT/TYPE_SPEC/CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK"));
            String string2 = this.nodeText(node, "TYPE_BODY/PLSQL_BLOCK");
            if (ModelUtil.hasLength((String)string2)) {
                type.setProperty(MIGRATING_BODY_SOURCE_PROP, (Object)string2);
            }
        } else {
            type.setName(this.nodeText(node, "NAME"));
            string = this.nodeText(node, "SCHEMA");
            type.setSource(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK"));
        }
        type.setSchema(new Schema(string));
        this.setID((DBObject)type);
        return type;
    }

    protected final void fillInObject(Object object, Node node, String string) {
        try {
            String string2 = this.getMappingType(object);
            if (string2 != null) {
                this.fillInObject(object, node, string, string2);
            }
            if (object instanceof DBObject && string == null) {
                this.setID((DBObject)object);
            }
        }
        catch (SXMLReaderException sXMLReaderException) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, sXMLReaderException.getMessage(), sXMLReaderException);
        }
    }

    void fillInObject(Object object, Node node, String string, String string2) throws SXMLReaderException {
        HashSet<String> hashSet = new HashSet<String>();
        SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node);
        while (childXMLElementIterator2.hasNext()) {
            Node node2 = (Node)childXMLElementIterator2.next();
            Iterator<SXMLMappings.Mapping> iterator = this.getMappings().getMappings(string2);
            String string3 = node2.getLocalName();
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string).append("/");
            }
            stringBuilder.append(string3);
            String string4 = stringBuilder + "/";
            String string5 = stringBuilder + "//";
            while (iterator.hasNext()) {
                Object object2;
                SXMLMappings.Mapping mapping = iterator.next();
                String string6 = mapping.getElementPath();
                String string7 = mapping.getPropertyPath();
                if (string6.startsWith(string5)) {
                    object2 = this.getPropertyInfos(object);
                    String string8 = string7;
                    if (string8.contains("/")) {
                        string8 = string8.substring(string8.indexOf("/") + 1);
                    }
                    PropertyInfo propertyInfo = object2.get(string8);
                    this.fillInArrayObject(object, node2, stringBuilder.toString(), propertyInfo);
                    continue;
                }
                if (string6.startsWith(string4)) {
                    if (hashSet.contains(string3)) continue;
                    hashSet.add(string3);
                    this.fillInObject(object, node2, stringBuilder.toString(), string2);
                    continue;
                }
                if (!string6.equals(stringBuilder.toString()) || string7 == null) continue;
                object2 = mapping.getConverter();
                this.processPropertyPath(object, node2, string7, this.getNodeText(node2), (SXMLValueConverter)object2);
            }
        }
        if (!ModelUtil.hasLength((String)string)) {
            this.fillInObjectWithReaders(node, object, string2);
        }
    }

    private void setID(DBObject dBObject) {
        NameBasedID nameBasedID = new NameBasedID();
        nameBasedID.setType(dBObject.getType());
        nameBasedID.setName(dBObject.getName());
        if (dBObject instanceof SchemaObject) {
            nameBasedID.setSchema(((SchemaObject)dBObject).getSchema());
        }
        dBObject.setID((DBObjectID)nameBasedID);
    }

    private void fillInArrayObject(Object object, Node node, String string, PropertyInfo propertyInfo) throws SXMLReaderException {
        Class clazz = propertyInfo.getPropertyClass();
        if (clazz.isArray()) {
            Object object3;
            Class<Object> clazz2 = clazz.getComponentType();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object4 = propertyInfo.getPropertyValue(object);
            if (object4 instanceof Constraint[]) {
                object3 = (Constraint[])object4;
                for (Constraint constraint : object3) {
                    arrayList.add(constraint);
                }
            }
            object3 = new SXMLFragmentGenerator.childXMLElementIterator(node);
            while (object3.hasNext()) {
                Node node2 = (Node)object3.next();
                Object object2 = null;
                if (clazz2 == DBObjectID.class) {
                    object2 = this.createIDForProp(object, propertyInfo);
                } else {
                    if (clazz2 == Constraint.class) {
                        if (node.getLocalName().equals("PRIMARY_KEY_CONSTRAINT_LIST")) {
                            clazz2 = PKConstraint.class;
                        } else if (node.getLocalName().equals("UNIQUE_KEY_CONSTRAINT_LIST")) {
                            clazz2 = UniqueConstraint.class;
                        } else if (node.getLocalName().equals("FOREIGN_KEY_CONSTRAINT_LIST")) {
                            clazz2 = FKConstraint.class;
                        } else if (node.getLocalName().equals("CHECK_CONSTRAINT_LIST")) {
                            clazz2 = CheckConstraint.class;
                        }
                    }
                    try {
                        object2 = clazz2.newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SXMLReaderException("Failed to instantiate new object ", illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SXMLReaderException("Failed to instantiate new object ", instantiationException);
                    }
                }
                arrayList.add(object2);
                this.fillInObject(object2, node2, null);
            }
            Object object5 = Array.newInstance(clazz2, arrayList.size());
            Object[] objectArray = arrayList.toArray((Object[])object5);
            try {
                propertyInfo.setPropertyValue(object, (Object)objectArray);
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + propertyInfo.getPropertyName(), exception);
            }
        } else {
            throw new SXMLReaderException("fillInArrayObject called on an object that is not an array");
        }
    }

    private void processPropertyPath(Object object, Node node, String string, String string2, SXMLValueConverter sXMLValueConverter) throws SXMLReaderException {
        String[] stringArray = string.split("/");
        Map<String, PropertyInfo> map = this.getPropertyInfos(object);
        PropertyInfo propertyInfo = map.get(stringArray[0]);
        if (propertyInfo == null) {
            throw new SXMLReaderException("failed to find PropertyInfo from the propPath " + string);
        }
        Class<SimpleSQLFragment> clazz = propertyInfo.getPropertyClass();
        Object object2 = null;
        Object object3 = null;
        if (stringArray.length == 1) {
            if (clazz == DBObjectID.class) {
                object2 = this.createIDForProp(object, propertyInfo);
                ((BaseObjectID)object2).setName(string2);
            } else {
                if ((clazz == Boolean.TYPE || clazz == Boolean.class) && sXMLValueConverter == null) {
                    sXMLValueConverter = new BooleanConverter();
                }
                if (sXMLValueConverter != null) {
                    try {
                        object2 = sXMLValueConverter.getBeanValue(object, string2);
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "SXML Converter failed to get value", exception);
                        object2 = null;
                    }
                } else {
                    object2 = string2;
                }
                if (object2 == null && node.hasChildNodes()) {
                    try {
                        object2 = clazz.newInstance();
                        if (object2 instanceof Copyable) {
                            object3 = ((Copyable)object2).copyTo(null);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SXMLReaderException("Failed to instantiate new bean value ", illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SXMLReaderException("Failed to instantiate new bean value ", instantiationException);
                    }
                }
                if (object2 instanceof String && Enum.class.isAssignableFrom(clazz) && this.getMappings().useToString(clazz)) {
                    object2 = DBUtil.findEnumFromString((String)((String)object2), clazz);
                } else if (object2 instanceof String && clazz != String.class && ToStringManager.converterAvailable(clazz)) {
                    try {
                        object2 = ToStringManager.fromString((String)((String)object2), clazz);
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to convert value from  a String", exception);
                        object2 = null;
                    }
                }
            }
            try {
                if (object2 != null && !clazz.isPrimitive()) {
                    clazz.cast(object2);
                }
                propertyInfo.setPropertyValue(object, object2);
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + propertyInfo.getPropertyName(), exception);
            }
            String string3 = this.getMappingType(object2);
            boolean bl = true;
            try {
                this.getMappings().getMappings(string3);
            }
            catch (UnsupportedTypeForSXMLException unsupportedTypeForSXMLException) {
                bl = false;
            }
            if (string3 != null) {
                this.fillInObject(object2, node, null);
                if (ModelUtil.areEqual((Object)object2, (Object)object3)) {
                    try {
                        propertyInfo.setPropertyValue(object, null);
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to clear property " + propertyInfo.getPropertyName(), exception);
                    }
                }
            }
        } else if (stringArray.length > 1) {
            Object object4 = propertyInfo.getPropertyValue(object);
            if (object4 == null) {
                if (clazz == DBObjectID.class) {
                    object4 = this.createIDForProp(object, propertyInfo);
                } else {
                    if (clazz == SQLFragment.class) {
                        clazz = SimpleSQLFragment.class;
                    }
                    try {
                        object4 = clazz.newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SXMLReaderException("Failed to instantiate new object ", illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SXMLReaderException("Failed to instantiate new object ", instantiationException);
                    }
                }
                try {
                    propertyInfo.setPropertyValue(object, object4);
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + propertyInfo.getPropertyName(), exception);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(string.substring(string.indexOf("/") + 1));
            this.processPropertyPath(object4, node, stringBuffer.toString(), string2, sXMLValueConverter);
        }
    }

    private void fillInObjectWithReaders(Node node, Object object, String string) throws SXMLReaderException {
        Iterator<Class<? extends SXMLFragmentGenerator>> iterator = this.getMappings().getGenerators(string);
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    SXMLFragmentGenerator sXMLFragmentGenerator = iterator.next().newInstance();
                    sXMLFragmentGenerator.setParentGenerator(this);
                    sXMLFragmentGenerator.readNode(node, object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SXMLReaderException("Failed to instantiate new SXMLFragmentGenerator ", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new SXMLReaderException("Failed to instantiate new SXMLFragmentGenerator ", instantiationException);
                }
            }
        }
    }

    private String getMappingType(Object object) {
        if (object == null) {
            return null;
        }
        String string = object instanceof DBObject ? ((DBObject)object).getType() : object.getClass().getSimpleName();
        try {
            this.getMappings().getMappings(string);
        }
        catch (UnsupportedTypeForSXMLException unsupportedTypeForSXMLException) {
            string = null;
        }
        return string;
    }

    private Map<String, PropertyInfo> getPropertyInfos(Object object) {
        return this.getPropertyInfos(object.getClass());
    }

    private Map<String, PropertyInfo> getPropertyInfos(Class<?> clazz) {
        if (this.m_infos.containsKey(clazz)) {
            return this.m_infos.get(clazz);
        }
        Map map = PropertyHelper.getPropertyInfos(clazz, OracleDatabase.class, null);
        this.m_infos.put(clazz, map);
        return map;
    }

    private boolean isRootNameForType(String string, String string2) {
        if (string2 != null) {
            String string3 = string2;
            if (string2.indexOf(" ") > -1) {
                string3 = string2.replaceAll(" ", "_");
            }
            return string3.equals(string);
        }
        return false;
    }

    private String getNodeText(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == 3 && (string = node.getTextContent()) != null) {
            string = string.trim();
        }
        return string;
    }

    private void tidyPartitions(Table table) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (oracleTablePartitions != null) {
            table.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
            for (TablePartition tablePartition : oracleTablePartitions.getPartitions()) {
                OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions3 == null || oracleTablePartitions2 == null) continue;
                if (oracleTablePartitions3.getPartitionType() == null) {
                    oracleTablePartitions3.setPartitionType(oracleTablePartitions2.getPartitionType());
                }
                if (oracleTablePartitions3.getPartitionColumns() != null && oracleTablePartitions3.getPartitionColumns().length != 0) continue;
            }
            this.propegateObjectAndPartitionType(oracleTablePartitions);
        }
    }

    private void propegateObjectAndPartitionType(OracleTablePartitions oracleTablePartitions) {
        for (TablePartition tablePartition : oracleTablePartitions.getPartitions()) {
            if (tablePartition.getObjectType() == null) {
                tablePartition.setObjectType(oracleTablePartitions.getObjectType());
            }
            if (tablePartition.getPartitionType() == null) {
                tablePartition.setPartitionType(oracleTablePartitions.getPartitionType());
            }
            if (tablePartition.getPartitionLevelSubpartitions() == null) continue;
            this.propegateObjectAndPartitionType(tablePartition.getPartitionLevelSubpartitions());
        }
        if (oracleTablePartitions.getSubpartitionModel() != null) {
            this.propegateObjectAndPartitionType(oracleTablePartitions.getSubpartitionModel());
        }
    }

    private void ensureKidsIDsParentID(DBObject dBObject) {
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            if (dBObject2.getID() instanceof BaseObjectID && ((BaseObjectID)dBObject2.getID()).getParent() == null) {
                BaseObjectID baseObjectID = (BaseObjectID)dBObject2.getID();
                baseObjectID.setParent(dBObject.getID());
                dBObject2.setID((DBObjectID)baseObjectID);
            }
            this.ensureKidsIDsParentID(dBObject2);
        }
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
    }

    @Override
    protected void readNode(Node node, Object object) {
    }

    final SystemObject getCurrentObject() {
        return this.m_currentObject;
    }

    final SystemObject getParentObject() {
        return this.m_parentObject;
    }

    final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    private DBObjectID createIDForProp(Object object, PropertyInfo propertyInfo) {
        ReferenceID referenceID = null;
        Class clazz = propertyInfo.getReferencedClass();
        String string = null;
        if (clazz != null) {
            String string2;
            string = Metadata.getType((Class)clazz);
            if (ModelUtil.hasLength((String)string)) {
                if (propertyInfo.isInternalReference()) {
                    SchemaObject schemaObject;
                    Schema schema;
                    string2 = this.m_currentObject.getType();
                    String string3 = this.m_currentObject.getName();
                    String string4 = null;
                    if (this.m_currentObject instanceof SchemaObject && (schema = (schemaObject = (SchemaObject)this.m_currentObject).getSchema()) != null) {
                        string4 = schema.getName();
                    }
                    schemaObject = new NameBasedID(string2, string4, string3);
                    referenceID = new NameBasedID(string, null, (DBObjectID)schemaObject);
                } else if ("COLUMN".equals(string) || this.getProvider() != null && this.getProvider().supportsObjectType(string) || this.getProvider() == null && "TABLE".equals(string)) {
                    string2 = null;
                    if (object instanceof MaterializedViewLog && propertyInfo.getPropertyName().equals("columnIDs")) {
                        string2 = ((MaterializedViewLog)object).getMasterTableID();
                    }
                    referenceID = new NameBasedID(string, null, (DBObjectID)string2);
                }
            }
            if (referenceID == null) {
                referenceID = new ReferenceID(string, (String)null, null);
                string2 = propertyInfo.getPropertyName();
                if (object instanceof Index && "domainIndextype".equals(string2)) {
                    referenceID.setType("INDEXTYPE");
                    referenceID.setSchemaName("SYS");
                } else if (object instanceof OracleExternalTableProperties && "defaultDirectory".equals(string2)) {
                    referenceID.setSchemaName("SYS");
                } else if (object instanceof OracleExternalTableProperties.LocationSpecifier && "directory".equals(string2)) {
                    referenceID.setSchemaName("SYS");
                }
                if (referenceID.getType() == null) {
                    referenceID.setType("UNSPECIFIED_TYPE");
                }
            }
        }
        return referenceID;
    }

    private static class SXMLReaderMappings
    extends SXMLMappings {
        public SXMLReaderMappings() {
            this.uncache("MATERIALIZED VIEW", "REFRESH", "refreshMode");
            this.uncache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE", new String[0]);
            this.uncache("TABLE", "GLOBAL_TEMPORARY", "TableType");
            this.uncache("TABLE", "RELATIONAL_TABLE/ON_COMMIT", "TableType");
            this.uncache("CONSTRAINT", "REFERENCES/SCHEMA", "referenceID", "relation", "schema", "name");
            this.uncache("CONSTRAINT", "REFERENCES/NAME", "referenceID", "relation", "name");
            this.uncache("CONSTRAINT", "REFERENCES/COL_LIST//COL_LIST_ITEM/NAME", "referenceID", "columnIDs");
            this.uncache("CONSTRAINT", "REFERENCES/SCHEMA", "referenceID", "parent", "schemaName");
            this.uncache("CONSTRAINT", "REFERENCES/NAME", "referenceID", "parent", "name");
            this.uncache("CONSTRAINT", "REFERENCES/COL_LIST//COL_LIST_ITEM/NAME", "referenceID", "childObjectNames");
            this.uncache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype", "schema", "name");
            this.uncache("SYNONYM", "OBJECT_SCHEMA", "reference", "schema", "name");
            this.uncache("OracleNestedTableProperties", "STORAGE_TABLE/SCHEMA", "!schema");
            this.uncache("LOB DESCRIPTOR", "SCHEMA", "!schema");
            this.uncache("OracleColumnProperties", "VARRAY_PROPERTIES/STORE_AS", "VAProperties");
            String string = NameBasedID.class.getSimpleName();
            this.cache(string, "SCHEMA", "schema", "name");
            this.cache(string, "NAME", "name");
            this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/NAME", "name");
            this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES", "indexType", new SXMLMappings.ValueCheckingConverter(Index.IndexType.DOMAIN));
            this.cache("IOT PROPERTIES", "COMPRESS", "keyCompression", new SXMLMappings.KeyCompressionConverter(true));
            this.uncache("XMLTypeColumnProperties", "XMLSCHEMA", "elementID", "parent");
            this.uncache("XMLTypeColumnProperties", "ELEMENT", "elementID");
            this.uncache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER", "OracleColumnProperties", "XMLTypeColumnProperties", "elementID", "parent", "schemaName");
            this.uncache("IdentityColumnProperties", "SCHEMA", "parent", "parent", "schema", "name");
            this.uncache("VIEW", "COL_LIST//COL_LIST_ITEM", "columns");
        }
    }

    private static class BooleanConverter
    implements SXMLValueConverter {
        private BooleanConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            throw new UnsupportedOperationException("Converter only intended for getting bean value from a noderepresenting a true boolean state");
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return Boolean.TRUE;
        }
    }
}

