/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.math.BigInteger;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.View;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.ora.sxml.ColumnSXMLGenerator;
import oracle.javatools.db.ora.sxml.ColumnSequenceSXMLGenerator;
import oracle.javatools.db.ora.sxml.ConstraintSXMLGenerator;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.InMemorySXMLGenerator;
import oracle.javatools.db.ora.sxml.IndexPartitionSXMLGenerator;
import oracle.javatools.db.ora.sxml.MatViewLogSXMLGenerator;
import oracle.javatools.db.ora.sxml.MatViewSXMLGenerator;
import oracle.javatools.db.ora.sxml.OracleTablespacePropsSXMLGenerator;
import oracle.javatools.db.ora.sxml.PartitionSXMLGenerator;
import oracle.javatools.db.ora.sxml.PhysicalPropsSXMLGenerator;
import oracle.javatools.db.ora.sxml.PlSqlMethodGenerator;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.TriggerSXMLGenerator;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;

class SXMLMappings {
    private final Map<String, List<Mapping>> m_mappings;
    private final Map<String, String> m_nameMap;
    private final Map<String, List<Class<? extends SXMLFragmentGenerator>>> m_genMap;
    private final Map<String, String> m_xsdMap = new HashMap<String, String>();
    private final Set<Class<? extends Enum>> m_toStringEnums;

    SXMLMappings() {
        this.m_mappings = new HashMap<String, List<Mapping>>();
        this.m_nameMap = new HashMap<String, String>();
        this.m_nameMap.put("TYPE", "TYPE_SPEC");
        this.m_genMap = new HashMap<String, List<Class<? extends SXMLFragmentGenerator>>>();
        this.m_toStringEnums = new HashSet<Class<? extends Enum>>();
        YNBooleanConverter yNBooleanConverter = new YNBooleanConverter();
        InverseBooleanConverter inverseBooleanConverter = new InverseBooleanConverter();
        CommaSeperatingStringArrayConverter commaSeperatingStringArrayConverter = new CommaSeperatingStringArrayConverter();
        this.registerXSD("TABLE", "kustable.xsd");
        this.registerXSD("MATERIALIZED VIEW", "kusmv.xsd");
        this.registerXSD("MATERIALIZED VIEW LOG", "kusmvl.xsd");
        this.registerXSD("SEQUENCE", "kusseq.xsd");
        this.registerXSD("SYNONYM", "kussyn.xsd");
        this.registerXSD("TRIGGER", "kustrig.xsd");
        this.registerXSD("INDEX", "kusindex.xsd");
        this.registerXSD("VIEW", "kusview.xsd");
        this.registerXSD("TYPE", "kustype.xsd");
        this.registerXSD("TYPE BODY", "kustypb.xsd");
        this.registerXSD("TABLESPACE", "kustbls.xsd");
        this.registerXSD("COMPOSITE", "kuscomp.xsd");
        this.cache("TABLE", "GLOBAL_TEMPORARY", "TableType", new ValueCheckingConverter(Table.TableType.TRANSACTION_TEMP, Table.TableType.SESSION_TEMP));
        this.cache("TABLE", "SCHEMA", "schema", "name");
        this.cache("TABLE", "NAME", "name");
        this.cache("TABLE", "RELATIONAL_TABLE/COL_LIST//COL_LIST_ITEM", "columns");
        this.cache("TABLE", "RELATIONAL_TABLE/ON_COMMIT", "TableType", new TempTableTypeConverter());
        this.registerGen("TABLE", PhysicalPropsSXMLGenerator.class);
        this.registerGen("TABLE", ColumnSXMLGenerator.class);
        this.cache("TABLE", "RELATIONAL_TABLE/TABLE_PROPERTIES/PARALLEL", Property.createPath((String[])new String[]{"OracleTableProperties", "parallelDegree"}), new ParallelConverter());
        this.cache("TABLE", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.cache("COLUMN", "NAME", "name");
        this.cache("COLUMN", "VIRTUAL", "virtualExpressionSource");
        this.cache("COLUMN", "DEFAULT", "default");
        this.cache("COLUMN", "IDENTITY_COLUMN", "identityProperties");
        this.cache("COLUMN", "NOT_NULL", "notNull", new ColumnNotNullConverter());
        this.cache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.registerGen("COLUMN", DataTypeSXMLGenerator.class);
        this.registerGen("COLUMN", ColumnSequenceSXMLGenerator.class);
        this.registerGen("TABLE", ConstraintSXMLGenerator.class);
        this.cache("CONSTRAINT", "NAME", "name");
        this.cache("CONSTRAINT", "COL_LIST//COL_LIST_ITEM/NAME", "columnIDs");
        this.cache("CONSTRAINT", "DISABLE", "enabled", inverseBooleanConverter);
        this.registerGen("TABLE", PartitionSXMLGenerator.class);
        this.registerGen("MATERIALIZED VIEW", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION MODEL", PartitionSXMLGenerator.class);
        this.cache("PARTITION MODEL", "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
        this.cache("PARTITION MODEL", "CONSTRAINT", "referenceConstraintID");
        this.cache("PARTITION MODEL", "PARTITION_LIST//PARTITION_LIST_ITEM", "partitions");
        this.cache("PARTITION", "NAME", "name");
        this.cache("PARTITION", "VALUES", "values", commaSeperatingStringArrayConverter);
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/INMEMORY", "OracleInMemoryProperties");
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES", "segmentAttributes");
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.registerGen("PARTITION", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION", ColumnSXMLGenerator.class);
        this.cache("PARTITION_HASH", "NAME", "name");
        this.cache("PARTITION_HASH", "SEGMENT_ATTRIBUTES/TABLESPACE", "segmentAttributes", "tablespaceID");
        this.cache("PARTITION_HASH", "COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.cache("PARTITION_HASH", "INMEMORY", "OracleInMemoryProperties");
        this.registerGen("PARTITION_HASH", ColumnSXMLGenerator.class);
        this.cache("PARTITION_SUB", "NAME", "name");
        this.cache("PARTITION_SUB", "VALUES", "values", commaSeperatingStringArrayConverter);
        this.cache("PARTITION_SUB", "INMEMORY", "OracleInMemoryProperties");
        this.cache("PARTITION_SUB", "TABLESPACE", "segmentAttributes", "tablespaceID");
        this.cache("PARTITION_SUB", "COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.cache("PARTITION_SUB", "COMPRESS_LEVEL", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tableCompression"}), new CompressionLevelConverter());
        this.registerGen("PARTITION_SUB", ColumnSXMLGenerator.class);
        this.cache("OracleStorageProperties", "PCTFREE", "percentFree");
        this.cache("OracleStorageProperties", "PCTUSED", "percentUsed");
        this.cache("OracleStorageProperties", "INITRANS", "initrans");
        this.cache("OracleStorageProperties", "STORAGE/INITIAL", "initialExtent");
        this.cache("OracleStorageProperties", "STORAGE/NEXT", "nextExtent");
        this.cache("OracleStorageProperties", "STORAGE/MINEXTENTS", "minExtent");
        this.cache("OracleStorageProperties", "STORAGE/MAXEXTENTS", "maxExtent", new MaxExtentConverter());
        this.cache("OracleStorageProperties", "STORAGE/PCTINCREASE", "percentIncrease");
        this.cache("OracleStorageProperties", "STORAGE/FREELISTS", "freelists");
        this.cache("OracleStorageProperties", "STORAGE/FREELIST_GROUPS", "freelistGroups");
        this.cache("OracleStorageProperties", "STORAGE/BUFFER_POOL", "bufferMode");
        this.cache("OracleStorageProperties", "TABLESPACE", "tablespaceID");
        this.cache("OracleStorageProperties", "LOGGING", "logging", yNBooleanConverter);
        this.cache("OracleColumnProperties", "LOB_PROPERTIES/STORAGE_TABLE", "LOBProperties");
        this.cache("OracleColumnProperties", "VARRAY_PROPERTIES/STORE_AS", "VAProperties", new VAAsLOBConverter());
        this.cache("OracleColumnProperties", "VARRAY_PROPERTIES/LOB_PROPERTIES/STORAGE_TABLE", "VAProperties");
        this.cache("OracleColumnProperties", "NESTED_TABLE_PROPERTIES", "nestedTableProperties");
        this.cache("OracleColumnProperties", "XMLTYPE_PROPERTIES", "XMLTypeColumnProperties");
        this.cache("OracleNestedTableProperties", "STORAGE_TABLE/SCHEMA", "!schema");
        this.cache("OracleNestedTableProperties", "STORAGE_TABLE/NAME", "tableName");
        this.cache("OracleNestedTableProperties", "RETURN_AS", "returnAs");
        HashMap<Boolean, String> hashMap = new HashMap<Boolean, String>();
        hashMap.put(true, "ENABLE");
        hashMap.put(false, "DISABLE");
        this.cache("OracleInMemoryProperties", "STATE", "inMemory", new ValueMappingConverter(hashMap));
        this.cache("OracleInMemoryProperties", "PRIORITY", "inMemoryPriority");
        this.cache("OracleInMemoryProperties", "COMPRESSION", "inMemoryCompression");
        this.cache("OracleInMemoryProperties", "DISTRIBUTE", "inMemoryDistribute");
        this.cache("OracleInMemoryProperties", "DUPLICATE", "inMemoryDuplicate");
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryCompression.class);
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryPriority.class);
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryDuplicate.class);
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryDistribute.class);
        this.registerGen("OracleInMemoryProperties", InMemorySXMLGenerator.class);
        this.cache("LOB DESCRIPTOR", "SCHEMA", "!schema");
        this.cache("LOB DESCRIPTOR", "NAME", "LOBSegName");
        this.cache("LOB DESCRIPTOR", "TABLESPACE", "storage", "tablespaceID");
        this.cache("LOB DESCRIPTOR", "STORAGE_IN_ROW", "storageInRow");
        this.cache("LOB DESCRIPTOR", "STORAGE/INITIAL", "storage", "initialExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/NEXT", "storage", "nextExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/MINEXTENTS", "storage", "minExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/MAXEXTENTS", Property.createPath((String[])new String[]{"storage", "maxExtent"}), new MaxExtentConverter());
        this.cache("LOB DESCRIPTOR", "STORAGE/PCTINCREASE", "storage", "percentIncrease");
        this.cache("LOB DESCRIPTOR", "STORAGE/LOBRETENTION", "retention", new LOBRetentionConverter());
        this.cache("LOB DESCRIPTOR", "STORAGE/FREELISTS", "storage", "freelists");
        this.cache("LOB DESCRIPTOR", "STORAGE/FREELIST_GROUPS", "storage", "freelistGroups");
        this.cache("LOB DESCRIPTOR", "STORAGE/BUFFER_POOL", "storage", "bufferMode");
        this.cache("LOB DESCRIPTOR", "CHUNK", "chunk");
        this.cache("LOB DESCRIPTOR", "PCTVERSION", "pctVersion");
        this.cache("LOB DESCRIPTOR", "CACHE", "LOBCache", new LOBCacheConverter());
        this.cache("LOB DESCRIPTOR", "LOGGING", Property.createPath((String[])new String[]{"storage", "logging"}), yNBooleanConverter);
        this.cache("XMLTypeColumnProperties", "XMLTYPE_STORAGE/STORE_AS", "storeAs", new XMLTypeColumnStoreAsConverter());
        this.cache("XMLTypeColumnProperties", "XMLSCHEMA", "elementID", "parent", "name");
        this.cache("XMLTypeColumnProperties", "ELEMENT", "elementID");
        this.cache("XMLTypeColumnProperties", "ALLOW_ANYSCHEMA", "allowAnySchema");
        this.cache("XMLTypeColumnProperties", "DISALLOW_NONSCHEMA", "allowNonSchema", inverseBooleanConverter);
        this.cache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER", "OracleColumnProperties", "XMLTypeColumnProperties", "elementID", "parent", "schemaName");
        this.cache("IOT PROPERTIES", "MAPPING_TABLE", "mapped");
        this.cache("IOT PROPERTIES", "PCTTHRESHOLD", "pctThreshold");
        this.cache("IOT PROPERTIES", "KEYCOMPRESS", "keyCompression", new KeyCompressionConverter(false));
        this.cache("IOT PROPERTIES", "OVERFLOW/INCLUDING", "includeColumn", "name");
        this.cache("IOT PROPERTIES", "OVERFLOW/SEGMENT_ATTRIBUTES", "overflowProperties");
        this.cache("EXTERNAL TABLE PROPERTIES", "ACCESS_DRIVER_TYPE", "accessDriverType");
        this.cache("EXTERNAL TABLE PROPERTIES", "DEFAULT_DIRECTORY", "defaultDirectory", "name");
        this.cache("EXTERNAL TABLE PROPERTIES", "ACCESS_PARAMETERS", "accessParameters");
        this.cache("EXTERNAL TABLE PROPERTIES", "LOCATION//LOCATION_ITEM", "locationSpecifiers");
        this.cache("EXTERNAL TABLE PROPERTIES", "REJECT_LIMIT", "rejectLimit", new ValueMappingConverter(Collections.singletonMap(-1, "UNLIMITED")));
        this.cache("LOCATION_SPECIFIER", "DIRECTORY", "directory", "name");
        this.cache("LOCATION_SPECIFIER", "NAME", "specifier");
        this.cache("INDEX", "UNIQUE", "indexType", new ValueCheckingConverter(Index.IndexType.UNIQUE));
        this.cache("INDEX", "BITMAP", "indexType", new ValueCheckingConverter(Index.IndexType.BITMAP));
        this.cache("INDEX", "SCHEMA", "schema", "name");
        this.cache("INDEX", "NAME", "name");
        this.cache("INDEX", "TABLE_INDEX/ON_TABLE/SCHEMA", "table", "schema", "name");
        this.cache("INDEX", "TABLE_INDEX/ON_TABLE/NAME", "table", "name");
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES", "OracleStorageProperties", new TempTableIndexCheckerConverter());
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/KEYCOMPRESS", "keyCompression", new KeyCompressionConverter(false));
        this.cache("INDEX", "CUSTOMER_AREA/ODB_PROPERTY_LIST/KEYCOMPRESS", "keyCompression", new KeyCompressionConverter(true));
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.INDEX));
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype", "schemaName");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype", "schema", "name");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/NAME", "domainIndextype", "name");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.DOMAIN_INDEX));
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/PARAMETERS", "domainIndextypeParameters");
        this.cache("INDEX", "CUSTOMER_AREA/ODB_PROPERTY_LIST/SYSTEM_GENERATED", "systemGenerated", new YNBooleanConverter());
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/REVERSE", "reverse");
        this.registerGen("INDEX", IndexPartitionSXMLGenerator.class);
        this.registerGen("INDEX PARTITION", IndexPartitionSXMLGenerator.class);
        this.cache("INDEX PARTITION MODEL", "PARTITION_LIST//PARTITION_LIST_ITEM", "partitions");
        this.cache("INDEX PARTITION", "NAME", "name");
        this.cache("INDEX PARTITION", "VALUES", "valuesLessThan", commaSeperatingStringArrayConverter);
        this.cache("INDEX PARTITION", "SEGMENT_ATTRIBUTES", "segmentAttributes");
        this.cache("INDEX PARTITION", "KEYCOMPRESS", "useKeyCompression", new YNBooleanConverter());
        this.cache("INDEX PARTITION", "PARAMETERS", "domainParameters");
        this.cache("VIEW", "SCHEMA", "schema", "name");
        this.cache("VIEW", "NAME", "name");
        this.cache("VIEW", "READ_ONLY", "restriction", new ValueCheckingConverter(View.Restriction.READ_ONLY));
        this.cache("VIEW", "COL_LIST//COL_LIST_ITEM", "columns");
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/FORCE_ON_CREATE", "forceOnCreate");
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/CHECK_OPTION", "restriction", new ValueCheckingConverter(View.Restriction.CHECK_OPTION));
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.cache("SEQUENCE", "SCHEMA", "schema", "name");
        this.cache("SEQUENCE", "NAME", "name");
        this.cache("SEQUENCE", "START_WITH", "startWith");
        this.cache("SEQUENCE", "INCREMENT", "incrementBy");
        this.cache("SEQUENCE", "MINVALUE", "minValue");
        this.cache("SEQUENCE", "MAXVALUE", "maxValue");
        this.cache("SEQUENCE", "CYCLE", "cycleFlag");
        this.cache("SEQUENCE", "CACHE", "cacheFlag", new CacheFlagConverter());
        this.cache("SEQUENCE", "CACHE", "cacheSize");
        this.cache("SEQUENCE", "ORDER", "orderFlag");
        this.cache("TRIGGER", "SCHEMA", "schema", "name");
        this.cache("TRIGGER", "NAME", "name");
        this.cache("TRIGGER", "TRIGGER_TYPE", "timing");
        this.cache("TRIGGER", "WHEN_CONDITION", "whenClause");
        this.cache("TRIGGER", "PLSQL_BLOCK", "code");
        this.cache("TRIGGER", "DISABLE", "enabled", inverseBooleanConverter);
        this.registerGen("TRIGGER", TriggerSXMLGenerator.class);
        this.cache("MATERIALIZED VIEW", "SCHEMA", "schema", "name");
        this.cache("MATERIALIZED VIEW", "NAME", "name");
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE", (String[])null);
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES", "OracleStorageProperties");
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/INMEMORY", "OracleInMemoryProperties");
        this.cache("MATERIALIZED VIEW", "CACHE", "cache");
        this.cache("MATERIALIZED VIEW", "PARALLEL", Property.createPath((String[])new String[]{"OracleTableProperties", "parallelDegree"}), new ParallelConverter(ParallelConverter.OwnerType.MATERIALIZED_VIEW));
        this.cache("MATERIALIZED VIEW", "BUILD", "buildType");
        this.cache("MATERIALIZED VIEW", "ON_PREBUILT_TABLE", "onPrebuilt", new ValueCheckingConverter(MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION));
        this.cache("MATERIALIZED VIEW", "ON_PREBUILT_TABLE/REDUCED_PRECISION", "onPrebuilt", new YNBooleanConverter(MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION, MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION));
        this.cache("MATERIALIZED VIEW", "USING_NO_INDEX", "defaultIndex", new InverseBooleanConverter(Boolean.FALSE));
        this.cache("MATERIALIZED VIEW", "INDEX_ATTRIBUTES", "MatViewIndexStorageProperties");
        this.cache("MATERIALIZED VIEW", "NEVER_REFRESH", "refreshMode", new ValueCheckingConverter(MaterializedView.RefreshMode.NEVER));
        this.cache("MATERIALIZED VIEW", "REFRESH", "refreshMode", new InverseValueCheckingConverter(MaterializedView.RefreshMode.NEVER));
        this.cache("MATERIALIZED VIEW", "REFRESH/FAST", "refreshMethod", new MVRefreshValueCheckingConverter(MaterializedView.RefreshMethod.FAST));
        this.cache("MATERIALIZED VIEW", "REFRESH/ON_COMMIT", "refreshMode", new ValueCheckingConverter(MaterializedView.RefreshMode.COMMIT));
        this.cache("MATERIALIZED VIEW", "REFRESH/COMPLETE", "refreshMethod", new MVRefreshValueCheckingConverter(MaterializedView.RefreshMethod.COMPLETE));
        this.cache("MATERIALIZED VIEW", "REFRESH/START_WITH", "nextRefreshDate", new MVRefreshStartWithConverter());
        this.cache("MATERIALIZED VIEW", "REFRESH/NEXT", "interval", new MVRefreshConverter());
        this.cache("MATERIALIZED VIEW", "REFRESH/WITH_PRIMARY_KEY", "keyType", new MVRefreshValueCheckingConverter(MaterializedView.RefreshWith.PRIMARY_KEY));
        this.cache("MATERIALIZED VIEW", "REFRESH/WITH_ROWID", "keyType", new MVRefreshValueCheckingConverter(MaterializedView.RefreshWith.ROWID));
        this.cache("MATERIALIZED VIEW", "REFRESH/CONSTRAINTS", "usingConstraints", new MVRefreshConverter());
        this.cache("MATERIALIZED VIEW", "QUERY_REWRITE", "queryRewrite");
        this.cache("MATERIALIZED VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.registerGen("MATERIALIZED VIEW", MatViewSXMLGenerator.class);
        this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/SCHEMA", "schema", "name");
        this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/NAME", "masterTableID");
        this.cache("MATERIALIZED VIEW LOG", "SEGMENT_ATTRIBUTES", "OracleStorageProperties");
        this.cache("MATERIALIZED VIEW LOG", "CACHE", "cache");
        this.cache("MATERIALIZED VIEW LOG", "PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.MATERIALIZED_VIEW));
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/OBJECT_ID", "objectIdLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/PRIMARY_KEY", "primaryKeyLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/ROWID", "rowidLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/SEQUENCE", "sequenceLogged");
        this.cache("MATERIALIZED VIEW LOG", "INCLUDING_NEW_VALUES", "newValues");
        this.registerGen("MATERIALIZED VIEW LOG", MatViewLogSXMLGenerator.class);
        this.cache("SYNONYM", "SCHEMA", "schema", "name");
        this.cache("SYNONYM", "NAME", "name");
        this.cache("SYNONYM", "OBJECT_SCHEMA", "reference", "schema", "name");
        this.cache("SYNONYM", "OBJECT_SCHEMA", "reference", "schemaName");
        this.cache("SYNONYM", "OBJECT_NAME", "reference", "name");
        this.cache("SYNONYM", "DB_LINK", "reference", "databaseName");
        this.registerGen("TYPE", DataTypeSXMLGenerator.class);
        this.cache("TYPE", "SCHEMA", "schema", "name");
        this.cache("TYPE", "NAME", "name");
        this.cache("TYPE", "OID", "OID");
        this.cache("TYPE", "OBJECT", "typeCode", new ValueCheckingConverter("OBJECT"));
        this.cache("TYPE", "OBJECT/AUTHID_CURRENT_USER", "authidCurrentUser", new ComplexTypeObjectConverter(true));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/NAME", "sqljExternalName");
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/SQLDATA", "sqljUsing", new ValueCheckingConverter(Type.SQLJUsingType.SQLData));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/CUSTOMDATUM", "sqljUsing", new ValueCheckingConverter(Type.SQLJUsingType.CustomDatum));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/ORADATA", "sqljUsing", new ValueCheckingConverter(Type.SQLJUsingType.OraData));
        this.cache("TYPE", "OBJECT/UNDER/SCHEMA", "underTypeReference", "schema", "name");
        this.cache("TYPE", "OBJECT/UNDER/NAME", "underTypeReference", "name");
        this.cache("TYPE", "OBJECT/ATTRIBUTE_LIST//ATTRIBUTE_LIST_ITEM", "attributes");
        this.cache("TYPE", "OBJECT/ELEMENT_LIST//ELEMENT_LIST_ITEM", "methods");
        this.cache("TYPE", "OBJECT/NOT_FINAL", "final", new ComplexTypeObjectConverter(false));
        this.cache("TYPE", "OBJECT/NOT_INSTANTIABLE", "instantiable", new ComplexTypeObjectConverter(false));
        this.cache("TYPE", "VARRAY", "collectionType", new ValueCheckingConverter("VARYING ARRAY"));
        this.cache("TYPE", "NESTED_TABLE", "collectionType", new ValueCheckingConverter("TABLE"));
        this.cache("TYPE", "CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK", "source");
        this.cache("TYPE BODY", "SCHEMA", "schema", "name");
        this.cache("TYPE BODY", "NAME", "name");
        this.cache("TYPE BODY", "PLSQL_BLOCK", "source");
        this.registerGen("TypeAttribute", DataTypeSXMLGenerator.class);
        this.cache("TypeAttribute", "NAME", "name");
        this.cache("TypeAttribute", "EXTERNAL_NAME", "sqljExternalName");
        this.registerGen("TypeMethod", PlSqlMethodGenerator.class);
        this.cache("TypeMethod", "OVERRIDING", "overriding");
        this.cache("TypeMethod", "FINAL", "final");
        this.cache("TypeMethod", "NOT_INSTANTIABLE", "instantiable", new InverseBooleanConverter());
        this.registerGen("PlSqlParameter", DataTypeSXMLGenerator.class);
        this.cache("PlSqlParameter", "NAME", "name");
        this.cache("PlSqlParameter", "OUT", "mode", new ValueCheckingConverter(PlSqlParameter.Mode.OUT));
        this.cache("PlSqlParameter", "IN_OUT", "mode", new ValueCheckingConverter(PlSqlParameter.Mode.INOUT));
        this.cache("PlSqlParameter", "NO_COPY", "noCopy");
        this.registerGen("VIEW", SQLFragmentSXMLGenerator.class);
        this.registerGen("MATERIALIZED VIEW", SQLFragmentSXMLGenerator.class);
        this.registerGen("INDEX", SQLFragmentSXMLGenerator.class);
        this.registerGen("CONSTRAINT", SQLFragmentSXMLGenerator.class);
        this.cache("IdentityColumnProperties", "SCHEMA", "parent", "parent", "schema", "name");
        this.cache("IdentityColumnProperties", "START_WITH", "startWith");
        this.cache("IdentityColumnProperties", "INCREMENT", "incrementBy");
        this.cache("IdentityColumnProperties", "MINVALUE", "minValue");
        this.cache("IdentityColumnProperties", "MAXVALUE", "maxValue");
        this.cache("IdentityColumnProperties", "CYCLE", "cycleFlag");
        this.cache("IdentityColumnProperties", "CACHE", "cacheFlag", new CacheFlagConverter());
        this.cache("IdentityColumnProperties", "CACHE", "cacheSize");
        this.cache("IdentityColumnProperties", "ORDER", "orderFlag");
        this.cache("TABLESPACE", "BIGFILE", "fileType", new ValueCheckingConverter(Tablespace.FileType.BIGFILE));
        this.cache("TABLESPACE", "TYPE", "TablespaceType");
        this.cache("TABLESPACE", "NAME", "name");
        this.cache("TABLESPACE", "DATAFILE_LIST//DATAFILE_LIST_ITEM", "fileSpecifications");
        this.registerGen("TABLESPACE", OracleTablespacePropsSXMLGenerator.class);
        this.cache("TABLESPACE", "BLOCKSIZE", "OracleTablespaceProperties", "blockSize");
        this.cache("TABLESPACE", "LOGGING", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "logging"}), new YNBooleanConverter(OracleTablespaceProperties.LoggingType.LOGGING, OracleTablespaceProperties.LoggingType.NOLOGGING));
        this.cache("TABLESPACE", "FORCE_LOGGING", "OracleTablespaceProperties", "forceLogging");
        this.cache("TABLESPACE", "DEFAULT/COMPRESS", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"}), new TableCompressionConverter());
        this.cache("TABLESPACE", "DEFAULT/COMPRESS_LEVEL", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"}), new CompressionLevelConverter());
        this.cache("TABLESPACE", "DEFAULT/STORAGE/INITIAL", "OracleTablespaceProperties", "OracleStorageProperties", "initialExtent");
        this.cache("TABLESPACE", "DEFAULT/STORAGE/NEXT", "OracleTablespaceProperties", "OracleStorageProperties", "nextExtent");
        this.cache("TABLESPACE", "DEFAULT/STORAGE/MINEXTENTS", "OracleTablespaceProperties", "OracleStorageProperties", "minExtent");
        this.cache("TABLESPACE", "DEFAULT/STORAGE/MAXEXTENTS", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties", "maxExtent"}), new MaxExtentConverter());
        this.cache("TABLESPACE", "DEFAULT/STORAGE/PCTINCREASE", "OracleTablespaceProperties", "OracleStorageProperties", "percentIncrease");
        this.cache("TABLESPACE", "DEFAULT/INMEMORY", "OracleTablespaceProperties", "OracleInMemoryProperties");
        this.cache("TABLESPACE", "OFFLINE", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "onlineStatus"}), new ValueCheckingConverter(OracleTablespaceProperties.OnlineStatus.OFFLINE, OracleTablespaceProperties.OnlineStatus.OFFLINE_NORMAL, OracleTablespaceProperties.OnlineStatus.OFFLINE_TEMPORARY, OracleTablespaceProperties.OnlineStatus.OFFLINE_IMMEDIATE));
        this.cache("TABLESPACE", "TABLESPACE_GROUP", "OracleTablespaceProperties", "tablespaceGroup");
        this.cache("TABLESPACE", "EXTENT_MANAGEMENT/TYPE", "OracleTablespaceProperties", "extentManagementType");
        this.cache("TABLESPACE", "EXTENT_MANAGEMENT/ALLOCATION_TYPE", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"}), new AutoAllocateConverter());
        this.cache("TABLESPACE", "EXTENT_MANAGEMENT/SIZE", "OracleTablespaceProperties", "uniformSize");
        this.cache("TABLESPACE", "SEGMENT_SPACE_MANAGEMENT", "OracleTablespaceProperties", "segmentManagement");
        this.cache("TABLESPACE", "RETENTION_GUARANTEE", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"}), new ValueCheckingConverter(OracleTablespaceProperties.RetentionType.GUARANTEE));
        this.cache("FILE_SPECIFICATION", "NAME", "directory", new FileNameConverter(true));
        this.cache("FILE_SPECIFICATION", "NAME", "name", new FileNameConverter(false));
        this.cache("FILE_SPECIFICATION", "SIZE", "fileSize");
        this.cache("FILE_SPECIFICATION", "REUSE", "reuse");
        this.cache("FILE_SPECIFICATION", "AUTOEXTEND/NEXT", Property.createPath((String[])new String[]{"autoExtendProperties", "nextSize"}));
        this.cache("FILE_SPECIFICATION", "AUTOEXTEND/MAXSIZE", Property.createPath((String[])new String[]{"autoExtendProperties", "maxSize"}), new MaxExtentConverter());
    }

    String getNodeName(String string) {
        if (this.m_nameMap.containsKey(string)) {
            return this.m_nameMap.get(string);
        }
        return string.replaceAll(" ", "_");
    }

    boolean hasMappings(String string) {
        return this.m_mappings.containsKey(string);
    }

    Iterator<Mapping> getMappings(String string) {
        if (!this.m_mappings.containsKey(string)) {
            if (this.m_genMap.containsKey(string)) {
                return new ArrayList().iterator();
            }
            throw new UnsupportedTypeForSXMLException(string);
        }
        return this.m_mappings.get(string).iterator();
    }

    Iterator<Class<? extends SXMLFragmentGenerator>> getGenerators(String string) {
        ArrayList<Class<? extends SXMLFragmentGenerator>> arrayList = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
        if (this.m_genMap.containsKey(string)) {
            arrayList.addAll((Collection)this.m_genMap.get(string));
        }
        arrayList.addAll(this.getAdditionalGenerators(string));
        if (arrayList.size() > 0) {
            return arrayList.iterator();
        }
        return null;
    }

    private List<Class<? extends SXMLFragmentGenerator>> getAdditionalGenerators(String string) {
        ArrayList arrayList = new ArrayList();
        DBCore.getInstance().populateFactoryList(SXMLFragmentGenerator.class, arrayList);
        ArrayList<Class<? extends SXMLFragmentGenerator>> arrayList2 = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
        for (SXMLFragmentGenerator sXMLFragmentGenerator : arrayList) {
            if (!sXMLFragmentGenerator.supportsType(string)) continue;
            arrayList2.add(sXMLFragmentGenerator.getClass());
        }
        return arrayList2;
    }

    Iterator<String> getGeneratorTypes() {
        return this.m_genMap.keySet().iterator();
    }

    private void registerXSD(String string, String string2) {
        this.m_xsdMap.put(string, string2);
    }

    XMLSchema getXSD(String string) {
        String string2 = this.m_xsdMap.get(string);
        if (string2 != null) {
            String string3 = this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/xsd/" + string2;
            URL uRL = this.getClass().getClassLoader().getResource(string3);
            try {
                XSDBuilder xSDBuilder = new XSDBuilder();
                return xSDBuilder.build(uRL);
            }
            catch (Exception exception) {
                DBLog.logStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private void registerEnumAsToString(Class<? extends Enum> clazz) {
        this.m_toStringEnums.add(clazz);
    }

    boolean useToString(Class<? extends Enum> clazz) {
        return this.m_toStringEnums.contains(clazz);
    }

    void registerGen(String string, Class<? extends SXMLFragmentGenerator> clazz) {
        List<Class<? extends SXMLFragmentGenerator>> list = this.m_genMap.get(string);
        if (list == null) {
            list = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
            this.m_genMap.put(string, list);
        }
        list.add(clazz);
    }

    protected void cache(String string, String string2, String ... stringArray) {
        String string3 = stringArray == null ? null : Property.createPath((String[])stringArray);
        this.cache(string, string2, string3, (SXMLValueConverter)null);
    }

    protected void cache(String string, String string2, String string3, SXMLValueConverter sXMLValueConverter) {
        List<Mapping> list = this.m_mappings.get(string);
        if (list == null) {
            list = new ArrayList<Mapping>();
            this.m_mappings.put(string, list);
        }
        list.add(new Mapping(string2, string3, sXMLValueConverter));
    }

    protected void uncache(String string, String string2, String ... stringArray) {
        String string3 = stringArray == null || stringArray.length == 0 ? null : Property.createPath((String[])stringArray);
        List<Mapping> list = this.m_mappings.get(string);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Mapping mapping = list.get(i);
            if (!mapping.getElementPath().equals(string2) || !ModelUtil.areEqual((Object)mapping.getPropertyPath(), (Object)string3)) continue;
            list.remove(mapping);
            break;
        }
    }

    static DBObjectProvider getProvider(DBObject dBObject, boolean bl) {
        if (dBObject.getID() instanceof BaseObjectID && ((BaseObjectID)dBObject.getID()).getProvider() != null) {
            return ((BaseObjectID)dBObject.getID()).getProvider();
        }
        if (bl && dBObject.getParent() != null) {
            return SXMLMappings.getProvider(dBObject.getParent(), true);
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            DBObjectProvider dBObjectProvider = SXMLMappings.getProvider(dBObject2, false);
            if (dBObjectProvider == null) continue;
            return dBObjectProvider;
        }
        return null;
    }

    static class YNBooleanConverter
    implements SXMLValueConverter {
        private Object m_yes;
        private Object m_no;

        public YNBooleanConverter() {
        }

        public YNBooleanConverter(Object object, Object object2) {
            this.m_yes = object;
            this.m_no = object2;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (this.m_yes != null) {
                if (ModelUtil.areEqual((Object)this.m_yes, (Object)object2)) {
                    return "Y";
                }
                if (ModelUtil.areEqual((Object)this.m_no, (Object)object2)) {
                    return "N";
                }
                return null;
            }
            return object2 == null ? null : ((Boolean)object2 != false ? "Y" : "N");
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 == null) {
                return null;
            }
            if (this.m_yes != null) {
                if (ModelUtil.areEqual((Object)"Y", (Object)object2)) {
                    return this.m_yes;
                }
                if (ModelUtil.areEqual((Object)"N", (Object)object2)) {
                    return this.m_no;
                }
                return null;
            }
            if (object2 instanceof Boolean) {
                return object2;
            }
            if (ModelUtil.areEqual((Object)"Y", (Object)object2)) {
                return true;
            }
            if (ModelUtil.areEqual((Object)"N", (Object)object2)) {
                return false;
            }
            return null;
        }
    }

    static class InverseBooleanConverter
    implements SXMLValueConverter {
        private final Boolean m_nullValue;

        InverseBooleanConverter() {
            this(null);
        }

        InverseBooleanConverter(Boolean bl) {
            this.m_nullValue = bl;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 == null) {
                return this.m_nullValue;
            }
            return Boolean.FALSE.equals(object2);
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return Boolean.FALSE;
        }
    }

    static class CommaSeperatingStringArrayConverter
    implements SXMLValueConverter {
        CommaSeperatingStringArrayConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            StringBuffer stringBuffer = new StringBuffer();
            if (object2 != null) {
                Object[] objectArray = (Object[])object2;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(objectArray[i]);
                }
            }
            return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 instanceof String) {
                PlSqlToken plSqlToken;
                PlSqlToken plSqlToken2 = plSqlToken = PlSqlTokenizer.tokenize((String)((String)object2), (String[])new String[0]);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (true) {
                    boolean bl;
                    boolean bl2 = bl = plSqlToken2.getType() == Token.Type.END_MARKER;
                    if (plSqlToken2.matches("(")) {
                        ++n;
                    } else if (plSqlToken2.matches(")")) {
                        --n;
                    } else if (bl || plSqlToken2.matches(",") && n == 0) {
                        arrayList.add(plSqlToken.getSource(false, plSqlToken2.getPrevToken()));
                        plSqlToken = (PlSqlToken)plSqlToken2.getNextToken();
                    }
                    if (bl) break;
                    plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
                }
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = ((String)arrayList.get(i)).trim();
                }
                return stringArray;
            }
            return null;
        }
    }

    class ValueCheckingConverter
    implements SXMLValueConverter {
        private Object[] m_values;

        ValueCheckingConverter(Object ... objectArray) {
            this.m_values = objectArray;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            for (Object object3 : this.m_values) {
                if (!ModelUtil.areEqual((Object)object2, (Object)object3)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 instanceof Boolean) {
                return (Boolean)object2 != false ? this.m_values[0] : null;
            }
            return this.m_values[0];
        }
    }

    static class TempTableTypeConverter
    implements SXMLValueConverter {
        TempTableTypeConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 == Table.TableType.TRANSACTION_TEMP) {
                return "DELETE";
            }
            if (object2 == Table.TableType.SESSION_TEMP) {
                return "PRESERVE";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            throw new UnsupportedOperationException("Done be PhysicalPropsSXMLGenerator.readNode()");
        }
    }

    static class ParallelConverter
    implements SXMLValueConverter {
        private OwnerType m_ownerTypeContext;

        ParallelConverter() {
            this.m_ownerTypeContext = OwnerType.TABLE;
        }

        ParallelConverter(OwnerType ownerType) {
            this.m_ownerTypeContext = ownerType;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            Object object3;
            if (object2 == null) {
                return null;
            }
            if (this.m_ownerTypeContext == OwnerType.INDEX || this.m_ownerTypeContext == OwnerType.DOMAIN_INDEX) {
                Object object4 = object3 = object instanceof Index ? (Index)object : null;
                if (object3 == null || this.m_ownerTypeContext == OwnerType.DOMAIN_INDEX && object3.getDomainIndextype() == null || this.m_ownerTypeContext == OwnerType.INDEX && object3.getDomainIndextype() != null) {
                    return null;
                }
            }
            return (Integer)(object3 = (Integer)object2) == 0 ? "AUTOMATIC" : object3;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if ("AUTOMATIC".equals(object2)) {
                return 0;
            }
            return object2;
        }

        static enum OwnerType {
            TABLE,
            MATERIALIZED_VIEW,
            INDEX,
            DOMAIN_INDEX;

        }
    }

    static class ColumnNotNullConverter
    implements SXMLValueConverter {
        ColumnNotNullConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object != null && object instanceof Column && ((Column)object).getRelation() instanceof View) {
                return false;
            }
            return object2;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return true;
        }
    }

    static class TableCompressionConverter
    implements SXMLValueConverter {
        TableCompressionConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 == null) {
                return object instanceof TablePartition ? "N" : null;
            }
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH || object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW) {
                return "ARCHIVE";
            }
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH || object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW) {
                return "QUERY";
            }
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP) {
                return "OLTP";
            }
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS) {
                return "BASIC";
            }
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS) {
                return "ALL";
            }
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS) {
                return "DIRECT_LOAD";
            }
            return "N";
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 == null) {
                return object instanceof TablePartition ? "NOCOMPRESS" : null;
            }
            if ("N".equals(object2)) {
                return OracleTableProperties.OracleTableCompression.NOCOMPRESS;
            }
            if ("OLTP".equals(object2)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP;
            }
            if ("ALL".equals(object2)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS;
            }
            if ("OLTP".equals(object2)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP;
            }
            if ("ARCHIVE".equals(object2)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH;
            }
            if ("QUERY".equals(object2)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH;
            }
            return "COMPRESS";
        }
    }

    private static class CompressionLevelConverter
    implements SXMLValueConverter {
        private static final String LOW = "LOW";

        private CompressionLevelConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW || object2 == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW) {
                return LOW;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            OracleTableProperties.OracleTableCompression oracleTableCompression = null;
            if (object instanceof OracleTablespaceProperties) {
                oracleTableCompression = ((OracleTablespaceProperties)object).getDefaultTableCompression();
            } else if (object instanceof OracleTableProperties) {
                oracleTableCompression = ((OracleTableProperties)object).getTableCompression();
            }
            if (LOW.equals(object2)) {
                if (oracleTableCompression == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH) {
                    oracleTableCompression = OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW;
                } else if (oracleTableCompression == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH) {
                    oracleTableCompression = OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW;
                }
            }
            return oracleTableCompression;
        }
    }

    static class MaxExtentConverter
    implements SXMLValueConverter {
        MaxExtentConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)object2;
                return bigInteger.min(OracleTableBuilder.MAXEXTENTS_UNLIMITED);
            }
            return object2;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            BigInteger bigInteger = null;
            if (object2 instanceof BigInteger) {
                bigInteger = (BigInteger)object2;
            } else if (object2 instanceof String) {
                try {
                    bigInteger = new BigInteger((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    bigInteger = null;
                }
            }
            if (bigInteger != null) {
                return bigInteger.min(OracleTableBuilder.MAXEXTENTS_UNLIMITED);
            }
            return object2;
        }
    }

    static class VAAsLOBConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 != null) {
                return "LOB";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return object2 != null;
        }
    }

    static class ValueMappingConverter
    implements SXMLValueConverter {
        private final Map<?, ?> m_map;

        public ValueMappingConverter(Map<?, ?> map) {
            this.m_map = map;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            Object object3 = this.m_map.containsKey(object2) ? this.m_map.get(object2) : object2;
            return object3;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            Object object3 = object2;
            for (Map.Entry<?, ?> entry : this.m_map.entrySet()) {
                if (!ModelUtil.areEqual(entry.getValue(), (Object)object2)) continue;
                object3 = entry.getKey();
                break;
            }
            return object3;
        }
    }

    static class LOBRetentionConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (((Boolean)object2).booleanValue()) {
                return "AUTO";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return object2 != null;
        }
    }

    static class LOBCacheConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (ModelUtil.areEqual((Object)LOBDescriptor.LOBCache.CACHE, (Object)object2)) {
                return "Y";
            }
            if (ModelUtil.areEqual((Object)LOBDescriptor.LOBCache.NOCACHE, (Object)object2)) {
                return "N";
            }
            if (ModelUtil.areEqual((Object)LOBDescriptor.LOBCache.CACHE_READS, (Object)object2)) {
                return "READS";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (ModelUtil.areEqual((Object)"Y", (Object)object2)) {
                return LOBDescriptor.LOBCache.CACHE;
            }
            if (ModelUtil.areEqual((Object)"N", (Object)object2)) {
                return LOBDescriptor.LOBCache.NOCACHE;
            }
            if (ModelUtil.areEqual((Object)"READS", (Object)object2)) {
                return LOBDescriptor.LOBCache.CACHE_READS;
            }
            return null;
        }
    }

    static class XMLTypeColumnStoreAsConverter
    implements SXMLValueConverter {
        XMLTypeColumnStoreAsConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (XMLTypeColumnProperties.StoreAs.CLOB.equals(object2)) {
                return "LOB";
            }
            if (XMLTypeColumnProperties.StoreAs.BINARY_XML.equals(object2)) {
                return "BINARY_XML";
            }
            return "OBJECT_RELATIONAL";
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if ("LOB".equals(object2)) {
                return XMLTypeColumnProperties.StoreAs.CLOB;
            }
            if ("BINARY_XML".equals(object2)) {
                return XMLTypeColumnProperties.StoreAs.BINARY_XML;
            }
            return XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL;
        }
    }

    static class KeyCompressionConverter
    implements SXMLValueConverter {
        private boolean m_retainZero;

        public KeyCompressionConverter(boolean bl) {
            this.m_retainZero = bl;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 instanceof Integer) {
                if (!this.m_retainZero && Integer.valueOf(0).equals(object2)) {
                    OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties;
                    Index index = null;
                    if (object instanceof OracleIndexOrganizedTableProperties) {
                        oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)object;
                        DBObject dBObject = oracleIndexOrganizedTableProperties.getParent();
                        if (dBObject instanceof Table) {
                            for (Constraint constraint : ((Table)dBObject).getConstraints()) {
                                if (!(constraint instanceof PKConstraint)) continue;
                                DBObjectID dBObjectID = ((PKConstraint)constraint).getIndexID();
                                try {
                                    index = (Index)dBObjectID.resolveID();
                                }
                                catch (DBException dBException) {}
                                break;
                            }
                        }
                    } else {
                        index = object instanceof Index ? (Index)object : null;
                    }
                    if (index != null) {
                        int n;
                        oracleIndexOrganizedTableProperties = index.getIndexType();
                        int n2 = index.getColumnExpressions().length;
                        if (n2 - (n = Index.IndexType.NORMAL.equals((Object)oracleIndexOrganizedTableProperties) ? 0 : (Index.IndexType.UNIQUE.equals((Object)oracleIndexOrganizedTableProperties) ? 1 : n2)) > 0) {
                            return n2 - n;
                        }
                    }
                }
                return object2;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 instanceof String) {
                if ("Y".equals(object2)) {
                    return 0;
                }
                if ("N".equals(object2)) {
                    return null;
                }
                return object2;
            }
            return null;
        }
    }

    static class TempTableIndexCheckerConverter
    implements SXMLValueConverter {
        TempTableIndexCheckerConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            Table.TableType tableType;
            if (object instanceof Index && ((Index)object).getTable() != null && ((tableType = (Table.TableType)((Index)object).getTable().getProperty("TableType")) == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP)) {
                return null;
            }
            return object2;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return object2;
        }
    }

    static class CacheFlagConverter
    implements SXMLValueConverter {
        CacheFlagConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 != null && !((Boolean)object2).booleanValue()) {
                return 0;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 != null && object2.equals("0")) {
                return false;
            }
            return object2 != null;
        }
    }

    class InverseValueCheckingConverter
    implements SXMLValueConverter {
        private Object m_value;

        InverseValueCheckingConverter(Object object) {
            this.m_value = object;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            return !ModelUtil.areEqual((Object)object2, (Object)this.m_value);
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 instanceof Boolean) {
                return (Boolean)object2 != false ? null : this.m_value;
            }
            return object2 == null ? this.m_value : null;
        }
    }

    class MVRefreshValueCheckingConverter
    extends ValueCheckingConverter {
        MVRefreshValueCheckingConverter(Object ... objectArray) {
            super(objectArray);
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object instanceof MaterializedView && ((MaterializedView)object).getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
                return false;
            }
            return super.getXMLValue(object, object2);
        }
    }

    static class MVRefreshStartWithConverter
    implements SXMLValueConverter {
        private static final String PREFIX = "GREATEST(SYSDATE,TO_DATE('";
        private static final String SUFFIX = "','YYYY.MM.DD.HH24.MI.SS'))";
        private static final String FORMAT_MASK = "yyyy.MM.dd.HH.mm.ss";
        private static final String OLD_FORMAT_MASK = "EEE MMM dd HH:mm:ss zzz yyyy";

        MVRefreshStartWithConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 instanceof Date) {
                StringBuilder stringBuilder = new StringBuilder();
                Date date = (Date)object2;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_MASK);
                stringBuilder.append(PREFIX);
                stringBuilder.append(simpleDateFormat.format(date));
                stringBuilder.append(SUFFIX);
                return stringBuilder.toString();
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 instanceof String) {
                SimpleDateFormat simpleDateFormat;
                String string = (String)object2;
                if (string.startsWith(PREFIX) && string.endsWith(SUFFIX)) {
                    string = string.substring(PREFIX.length(), string.length() - SUFFIX.length());
                    simpleDateFormat = new SimpleDateFormat(FORMAT_MASK);
                } else {
                    simpleDateFormat = new SimpleDateFormat(OLD_FORMAT_MASK);
                }
                try {
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static class MVRefreshConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object instanceof MaterializedView && ((MaterializedView)object).getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
                return false;
            }
            return object2;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return object2;
        }
    }

    static class ComplexTypeObjectConverter
    implements SXMLValueConverter {
        private Boolean m_val;

        public ComplexTypeObjectConverter(Boolean bl) {
            this.m_val = bl;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object instanceof Type && object2 instanceof Boolean && this.m_val.equals(object2) && "OBJECT".equals(((Type)object).getTypeCode())) {
                return true;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object instanceof Type && "OBJECT".equals(((Type)object).getTypeCode())) {
                return this.m_val;
            }
            return this.m_val == false;
        }
    }

    private static class AutoAllocateConverter
    implements SXMLValueConverter {
        private AutoAllocateConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            OracleTablespaceProperties oracleTablespaceProperties;
            if (object instanceof Tablespace && (oracleTablespaceProperties = (OracleTablespaceProperties)((Tablespace)object).getProperty("OracleTablespaceProperties")) != null && oracleTablespaceProperties.getExtentManagementType() != null) {
                if (Boolean.TRUE.equals(object2)) {
                    return "AUTOALLOCATE";
                }
                return "UNIFORM";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2.equals("AUTOALLOCATE")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private static class FileNameConverter
    implements SXMLValueConverter {
        private boolean m_isDirectory;

        public FileNameConverter(boolean bl) {
            this.m_isDirectory = bl;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (!this.m_isDirectory && object instanceof FileSpecification && ModelUtil.hasLength((String)((FileSpecification)object).getDirectory())) {
                return ((FileSpecification)object).getDirectory() + "/" + object2;
            }
            return object2 == null ? null : object2;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            int n = 47;
            String string = null;
            if (object2 instanceof String) {
                string = (String)object2;
            }
            if (string != null) {
                if (string.indexOf(n) == -1) {
                    n = 92;
                }
                if (this.m_isDirectory) {
                    string = string.indexOf(n) != -1 ? string.substring(0, string.lastIndexOf(n)) : null;
                } else if (string.indexOf(n) != -1) {
                    string = string.substring(string.lastIndexOf(n) + 1, string.length());
                }
            }
            return string;
        }
    }

    static class Mapping {
        private String m_elemPath;
        private String m_propPath;
        private SXMLValueConverter m_con;

        Mapping(String string, String string2, SXMLValueConverter sXMLValueConverter) {
            this.m_elemPath = string;
            this.m_propPath = string2;
            this.m_con = sXMLValueConverter;
        }

        String getElementPath() {
            return this.m_elemPath;
        }

        String getPropertyPath() {
            return this.m_propPath;
        }

        SXMLValueConverter getConverter() {
            return this.m_con;
        }
    }
}

